const { DataTypes } = require('sequelize');
const bcrypt = require('bcryptjs');
const db = require('../config/db.config');
const Transactions = require('./Transactions');
const Creation = require('./Creation');
const RaffleWins = db.define('RaffleWins', {
    id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
    },
    userid: {
        type: DataTypes.STRING,
        allowNull: true
    },
    name: {
        type: DataTypes.STRING,
        allowNull: true
    },
    amount: {
        type: DataTypes.STRING,
        allowNull: true
    },
    raffle_amount: {
        type: DataTypes.STRING,
        allowNull: true
    },
    entry_count: {
        type: DataTypes.STRING,
        allowNull: true
    },
    profilephoto: {
        type: DataTypes.STRING,
        allowNull: true
    }

}, {
    tableName: 'rafflewins',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at'
});



module.exports = RaffleWins;