const { DataTypes } = require('sequelize');
const bcrypt = require('bcryptjs');
const db = require('../config/db.config');
const User = require('./User')
const Redeems = db.define('Redeems', {
    id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
    },

    userid: {
        type: DataTypes.STRING,
        allowNull: false
    },
    date: {
        type: DataTypes.DATE,
        allowNull: true
    },
    email: {
        type: DataTypes.STRING,
        allowNull: false
    },
    amount: {
        type: DataTypes.DECIMAL,
        allowNull: false
    },
    game: {
        type: DataTypes.STRING,
        allowNull: true
    },
    gameuser: {
        type: DataTypes.STRING,
        allowNull: true
    },

    cashier: {
        type: DataTypes.STRING,
        allowNull: true
    },
    status: {
        type: DataTypes.STRING,
        allowNull: true
    },

    cbalance: {
        type: DataTypes.FLOAT,
        allowNull: true
    },
    ubalance: {
        type: DataTypes.FLOAT,
        allowNull: true
    },
    crebalance: {
        type: DataTypes.FLOAT,
        allowNull: true
    },
    urebalance: {
        type: DataTypes.FLOAT,
        allowNull: true
    },

}, {
    tableName: 'redeem',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at'
});
Redeems.belongsTo(User, { foreignKey: 'userid' });

module.exports = Redeems;