const { DataTypes } = require('sequelize');
const bcrypt = require('bcryptjs');
const db = require('../config/db.config');
const Transactions = require('./Transactions');
const Creation = require('./Creation');
const Referrals = db.define('Referrals', {
    id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
    },
    userid: {
        type: DataTypes.STRING,
        allowNull: true
    },
    refcode: {
        type: DataTypes.STRING,
        allowNull: true
    },
    first_txn: {
        type: DataTypes.STRING,
        allowNull: true
    },
    txn_amount: {
        type: DataTypes.STRING,
        allowNull: true
    },
    txn_id: {
        type: DataTypes.STRING,
        allowNull: true
    },
    status: {
        type: DataTypes.STRING,
        allowNull: true
    }

}, {
    tableName: 'refs',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at'
});



module.exports = Referrals;