const { DataTypes } = require('sequelize');
const bcrypt = require('bcryptjs');
const db = require('../config/db.config');
const SavedCards = db.define('SavedCards', {
    id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
    },
    userid: {
        type: DataTypes.STRING,
        allowNull: true
    },
    card_holder: {
        type: DataTypes.TEXT,
        allowNull: true
    },
    card_number: {
        type: DataTypes.TEXT,
        allowNull: true
    },
    bin: {
        type: DataTypes.TEXT,
        allowNull: true
    },
    last4: {
        type: DataTypes.TEXT,
        allowNull: true
    },
    expiry: {
        type: DataTypes.TEXT,
        allowNull: true
    },
    pnm_method_id: {
        type: DataTypes.TEXT,
        allowNull: true
    },
    cfToken: {
        type: DataTypes.TEXT,
        allowNull: true
    }

}, {
    tableName: 'saved_cards',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at'
});



module.exports = SavedCards;