const { DataTypes } = require('sequelize');
const bcrypt = require('bcryptjs');
const db = require('../config/db.config');

const User = db.define('User', {
    id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
    },
    first: {
        type: DataTypes.STRING,
        allowNull: false
    },
    last: {
        type: DataTypes.STRING,
        allowNull: false
    },
    email: {
        type: DataTypes.STRING,
        allowNull: false
    },
    password: {
        type: DataTypes.STRING,
        allowNull: false
    },
    phone: {
        type: DataTypes.STRING,
        allowNull: false
    },
    pidv: {
        type: DataTypes.STRING,
        allowNull: true
    },
    namev: {
        type: DataTypes.STRING,
        allowNull: true
    },
    status: {
        type: DataTypes.STRING,
        allowNull: true
    },
    cname: {
        type: DataTypes.STRING,
        allowNull: true
    },
    is_duplicate: {
        type: DataTypes.STRING,
        allowNull: true
    },
    prev_account: {
        type: DataTypes.STRING,
        allowNull: true
    },
    verified: {
        type: DataTypes.STRING,
        allowNull: true
    },
    balance: {
        type: DataTypes.DECIMAL,
        allowNull: true
    },
    rebalance: {
        type: DataTypes.DECIMAL,
        allowNull: true
    },
    bonusbal: {
        type: DataTypes.DECIMAL,
        allowNull: true
    },
    wheelallowed: {
        type: DataTypes.STRING,
        allowNull: true
    },
    giftallowed: {
        type: DataTypes.STRING,
        allowNull: true
    },
    cardallowed: {
        type: DataTypes.STRING,
        allowNull: true
    },
    card2allowed: {
        type: DataTypes.STRING,
        allowNull: true
    },
    gtallowed: {
        type: DataTypes.STRING,
        allowNull: true
    },
    apallowed: {
        type: DataTypes.STRING,
        allowNull: true
    },
    gpallowed: {
        type: DataTypes.STRING,
        allowNull: true
    },
    fpallowed: {
        type: DataTypes.STRING,
        allowNull: true
    },
    cryptoallowed: {
        type: DataTypes.STRING,
        allowNull: true
    },
    crypto2allowed: {
        type: DataTypes.STRING,
        allowNull: true
    },
    note: {
        type: DataTypes.STRING,
        allowNull: true
    },
    avsstatus: {
        type: DataTypes.STRING,
        allowNull: true
    },
    breason: {
        type: DataTypes.STRING,
        allowNull: true
    },
    paypal: {
        type: DataTypes.STRING,
        allowNull: true
    },
    venmo: {
        type: DataTypes.STRING,
        allowNull: true
    },

    account_number: {
        type: DataTypes.STRING,
        allowNull: true
    },
    routing_number: {
        type: DataTypes.STRING,
        allowNull: true
    },
    pidno: {
        type: DataTypes.STRING,
        allowNull: true
    },
    photoid: {
        type: DataTypes.STRING,
        allowNull: true
    },
    profilephoto: {
        type: DataTypes.STRING,
        allowNull: true
    },
    propic: {
        type: DataTypes.STRING,
        allowNull: true
    },
    tickets: {
        type: DataTypes.STRING,
        allowNull: true
    },
    address_1: {
        type: DataTypes.STRING,
        allowNull: true
    },
    address_2: {
        type: DataTypes.STRING,
        allowNull: true
    },
    city: {
        type: DataTypes.STRING,
        allowNull: true
    },
    state: {
        type: DataTypes.STRING,
        allowNull: true
    },
    pincode: {
        type: DataTypes.STRING,
        allowNull: true
    },
    country: {
        type: DataTypes.STRING,
        allowNull: true
    },
    vid: {
        type: DataTypes.STRING,
        allowNull: true
    },
    vcode: {
        type: DataTypes.STRING,
        allowNull: true
    },
    vcode2: {
        type: DataTypes.STRING,
        allowNull: true
    },
    vcode3: {
        type: DataTypes.STRING,
        allowNull: true
    },
    autoverify: {
        type: DataTypes.STRING,
        allowNull: true
    },
    autoverauth: {
        type: DataTypes.STRING,
        allowNull: true
    },
    autoverref: {
        type: DataTypes.STRING,
        allowNull: true
    },
    idenfy_webhook: {
        type: DataTypes.STRING,
        allowNull: true
    },
    cpass: {
        type: DataTypes.STRING,
        allowNull: true
    },
    isVerified: {
        type: DataTypes.STRING,
        allowNull: true
    },
    isEmailVerified: {
        type: DataTypes.STRING,
        allowNull: true
    },
    isBanned: {
        type: DataTypes.STRING,
        allowNull: true
    },
    payoutach: {
        type: DataTypes.STRING,
        allowNull: true
    },
    payoutgtw: {
        type: DataTypes.STRING,
        allowNull: true
    },
    pnm_order_id: {
        type: DataTypes.STRING,
        allowNull: true
    },
    pnm_push_order_id: {
        type: DataTypes.STRING,
        allowNull: true
    },
    pnm_ach_id: {
        type: DataTypes.STRING,
        allowNull: true
    },
    pnm_ach_payout: {
        type: DataTypes.STRING,
        allowNull: true
    },
    pnm_card_payout: {
        type: DataTypes.STRING,
        allowNull: true
    },
    cfAccountToken: {
        type: DataTypes.STRING,
        allowNull: true
    },
    cfallowed: {
        type: DataTypes.STRING,
        allowNull: true
    },
    payoutcf: {
        type: DataTypes.STRING,
        allowNull: true
    },
}, {
    tableName: 'users',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at'
});

module.exports = User;