const { DataTypes } = require('sequelize');
const bcrypt = require('bcryptjs');
const db = require('../config/db.config');

const Webhook = db.define('Webhook', {
    txn_id: {
        type: DataTypes.STRING,
        allowNull: false
    },
    webhook: {
        type: DataTypes.STRING,
        allowNull: false
    },
    sent: {
        type: DataTypes.STRING,
        allowNull: false
    },
}, {
    tableName: 'webhooks',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at'
});

module.exports = Webhook;