const { DataTypes } = require('sequelize');
const bcrypt = require('bcryptjs');
const db = require('../config/db.config');
const User = require('./User')
const WithdrawData = db.define('WithdrawData', {
    id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
    },

    wid: {
        type: DataTypes.STRING,
        allowNull: false
    },
    cname: {
        type: DataTypes.STRING,
        allowNull: true
    },
    amount: {
        type: DataTypes.STRING,
        allowNull: false
    },
    ctag: {
        type: DataTypes.STRING,
        allowNull: true
    },
    pmethod: {
        type: DataTypes.STRING,
        allowNull: true
    },

    paypal: {
        type: DataTypes.STRING,
        allowNull: true
    },
    status: {
        type: DataTypes.STRING,
        allowNull: true
    },
    pnstatus: {
        type: DataTypes.STRING,
        allowNull: true
    },

    pnresponse: {
        type: DataTypes.STRING,
        allowNull: true
    }

}, {
    tableName: 'withdrawdata',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at'
});

module.exports = WithdrawData;