const { DataTypes } = require('sequelize');
const db = require('../config/db.config');

const createBonusModel = (tableName) => {
    return db.define(`Bonus_${tableName}`, {
        id: {
            type: DataTypes.INTEGER,
            allowNull: false,
            autoIncrement: true,
            primaryKey: true
        },
        userid: {
            type: DataTypes.STRING,
            allowNull: true
        },
        status: {
            type: DataTypes.STRING,
            allowNull: true
        },
        txn_id: {
            type: DataTypes.STRING,
            allowNull: true
        }
    }, {
        tableName: tableName, // dynamic table name
        timestamps: true,
        createdAt: 'created_at',
        updatedAt: 'updated_at'
    });
};

module.exports = createBonusModel;
