const express = require('express');
const router = express.Router();
const multer = require('multer');

const userController = require('../controllers/Users');
const txnController = require('../controllers/Transactions');
const coinflowController = require('../controllers/CoinFlow');

const rateLimit = require('express-rate-limit');

const ipLock = require('../middleware/ipLockMiddleware');
const ipLockWare = ipLock.ipLockMiddleware;

const excludedRoutes = [
    '/getWheelUserStat',
    '/updateTickets',
    // '/saveScore',
    '/getPublicGames',
    '/raffleWinCron',
    '/exportReport',
    '/updateUser',
    '/appleLogin',
    '/appleSignup',
    '/appleLoginSuccess',
    '/checkEmail',
    '/gameLinksWeb',
    '/applePay',
    '/googlePay',
    '/createPNMPaymentMethod',
    '/verifyTokenOld',
    '/verifyTokenNew'
];

// router.use((req, res, next) => {
//     console.log(req.path)

//     if (excludedRoutes.includes(req.path)) {
//         return next();
//     }
//     ipLockWare(req, res, next);
// });

const upload = multer();

const otpLoginLimiter = rateLimit({
    windowMs: 1 * 60 * 1000, // 1 minutes
    max: 5, // Limit each IP to 1 requests per windowMs
    message: 'Too many requests from this IP, please try again later.',
});
const otpLoginLimiter2 = rateLimit({
    windowMs: 1 * 60 * 1000, // 1 minutes
    max: 1, // Limit each IP to 1 requests per windowMs
    message: 'Too many requests from this IP, please try again later.',
});
// Route to get all admins
// router.get('/admins', authController.getAllAdmins);

// // Route to get an admin by ID
// router.get('/admins/:id', authController.getAdminById);

// router.post('/Login', authController.login);


//NEW
router.post('/ostarsStatus', userController.ostarsStatus);

//Users
router.get('/gameLinksWeb', userController.gameLinksWeb);



router.post('/login', userController.login);
router.post('/register', userController.register);
router.post('/checkPhoneEmail', userController.checkPhoneEmail);
router.post('/checkEmail', userController.checkEmail);
router.post('/verifyUser', userController.verifyUser);
router.post('/updateUser', userController.updateUser);
router.post('/verifyTokenOld', userController.verifyTokenOld);
router.post('/verifyTokenNew', userController.verifyTokenNew);
router.post('/generateIdenfyToken', userController.generateIdenfyToken);
router.post('/checkIdenfyToken', userController.checkIdenfyToken);
router.post('/setUserIP', userController.setUserIP);

router.post('/appleLogin', userController.appleLogin);
router.post('/loginAppleSuccess', userController.loginAppleSuccess);
router.get('/getGames', userController.getGames);
router.get('/getPublicGames', userController.getPublicGames);
router.post('/linkedGames', userController.linkedGames);
router.post('/linkedGamesReset', userController.linkedGamesReset);
router.post('/requestGame', userController.requestGame);
router.post('/cashoutMethods', userController.cashoutMethods);
router.post('/referrals', userController.referrals);
router.post('/createRefCode', userController.createRefCode);
router.post('/requestGamePassword', userController.requestGamePassword);
router.post('/getUserEmail', userController.getUserEmail);
router.post('/sendMoney', userController.sendMoney);
router.post('/resendSignupEmail', userController.resendSignupEmail);
router.post('/saveCard', userController.saveCard);
router.post('/getCards', userController.getCards);
router.post('/removeCard', userController.removeCard);
router.post('/cardUsed', userController.cardUsed);
router.post('/wheel', userController.wheel);
router.post('/wheelShare', userController.wheelShare);
router.get('/wheelSharer', userController.wheelSharer);
router.post('/getWheelUserStat', userController.getWheelUserStat);
router.post('/updateTickets', userController.updateTickets);
router.post('/saveScore', userController.saveScore);
router.post('/forgotPassword', otpLoginLimiter2, userController.forgotPassword);
router.post('/resetPassword', otpLoginLimiter, userController.resetPassword);
router.post('/updatePassword', userController.updatePassword);
router.post('/updateEmail', userController.updateEmail);
router.post('/setNewEmail', userController.setNewEmail);
router.post('/resendNewEmail', userController.resendNewEmail);
router.post('/getUserIP', userController.getUserIP);
router.get('/getUser/:id', userController.getUser);
router.post('/decryptData', userController.decryptData);
router.post('/encryptData', txnController.encryptData);

router.post('/depositCash', txnController.depositCash);
router.post('/depositCashInit', txnController.depositCashInit);
router.post('/depositCashComplete', txnController.depositCashComplete);

router.post('/requestBonus', userController.requestBonus);
router.post('/bonusStatus', userController.bonusStatus);
router.post('/requestRiverSweepsBonus', userController.requestRiverSweepsBonus);
router.post('/riverSweepsBonusStatus', userController.riverSweepsBonusStatus);
router.post('/requestUPBonus', userController.requestUPBonus);
router.post('/upBonusStatus', userController.upBonusStatus);
router.post('/requestFKBonus', userController.requestFKBonus);
router.post('/fkBonusStatus', userController.fkBonusStatus);
router.post('/requestVBBonus', userController.requestVBBonus);
router.post('/vbBonusStatus', userController.vbBonusStatus);
router.post('/requestVXBonus', userController.requestVXBonus);
router.post('/vxBonusStatus', userController.vxBonusStatus);

router.post('/requestVB2Bonus', userController.requestVB2Bonus);
router.post('/vb2BonusStatus', userController.vb2BonusStatus);
router.post('/requestGSBonus', userController.requestGSBonus);
router.post('/gsBonusStatus', userController.gsBonusStatus);
router.post('/requestCCBonus', userController.requestCCBonus);
router.post('/ccBonusStatus', userController.ccBonusStatus);

router.post('/requestTREXBonus', userController.requestTREXBonus);
router.post('/trexBonusStatus', userController.trexBonusStatus);

router.post('/requestBMBonus', userController.requestBMBonus);
router.post('/bmBonusStatus', userController.bmBonusStatus);

router.post('/requestRSBonus', userController.requestRSBonus);
router.post('/rsBonusStatus', userController.rsBonusStatus);

router.post('/requestFKXBonus', userController.requestFKXBonus);
router.post('/fkxBonusStatus', userController.fkxBonusStatus);

router.get('/allBonuses', userController.allBonuses);

//pnm
router.post('/updateBankDetailsAndPushOrder', userController.updateBankDetailsAndPushOrder)
router.post('/createPnmPaymentMethod', userController.createPnmPaymentMethod)
//Transactions
router.post('/paymentMethods', txnController.paymentMethods);
router.post('/latestStatus', txnController.latestStatus);
router.post('/getLatestStatus', txnController.getLatestStatus);
router.post('/recentAnnouncements', txnController.recentAnnouncements);

router.post('/getSessionKey', coinflowController.getSessionKey);

router.post('/tokenizeCardEndpoint', txnController.tokenizeCardEndpoint);

router.post('/createCoinFlowTransaction', txnController.createCoinFlowTransaction);
router.post('/completeCoinFlowTransaction', txnController.completeCoinFlowTransaction);
router.post('/registerCoinFlowUser', txnController.registerCoinFlowUser);
router.post('/getCoinFlowRedirectUrl', txnController.getCoinFlowRedirectUrl);
router.post('/storeCoinFlowBankToken', txnController.storeCoinFlowBankToken);
router.post('/createCoinFlowPayout', txnController.createCoinFlowPayout);
router.post('/getCoinFlowWithdrawer', txnController.getCoinFlowWithdrawer);

router.post('/applePay', txnController.applePay);
router.post('/googlePay', txnController.googlePay);
router.post('/getBonuses', txnController.getBonuses);
router.get('/blockedBins', txnController.getBlockedBins);
router.get('/blockedCards', txnController.getBlockedCards);
router.post('/paymentStatus', txnController.paymentStatus);
router.post('/nmi2', txnController.nmi2);
router.post('/nmi', txnController.nmi2);

router.post('/gtwCheck', txnController.gtwCheck);
router.post('/forumPayCheck', txnController.forumPayCheck);

router.post('/allTxns', txnController.allTxns);
router.post('/exportReport', txnController.exportReport);
router.get('/raffleWins', txnController.raffleWins);
router.get('/raffleWinCron', txnController.raffleWinCron);
router.post('/requestRedeem', txnController.requestRedeem);
router.post('/redeemFromGame', txnController.redeemFromGame);

router.post('/depositGame', txnController.depositGame);
router.post('/depositToGame', txnController.depositToGame);

router.post('/depositWallet', txnController.depositWallet);
router.post('/cashout', txnController.cashout);

router.post('/cashoutCancel', txnController.cashoutCancel);
router.post('/enterRaffle', txnController.insertRaffle);
router.post('/getBonusEntries', txnController.getBonusEntries);

router.post('/withdrawalTxns', txnController.withdrawalTxns);
router.post('/gameDepositTxns', txnController.gameDepositTxns);
router.post('/reportCashout', txnController.reportCashout);

router.post('/reportDeposit', txnController.reportDeposit);

router.post('/bStatus/:bonus', userController.bStatus)
router.post('/requestB/:bonus', userController.requestB)

//END NEW

module.exports = router;