// if (process.env.NODE_ENV !== 'development') {
//     console.log = function () { };
//     console.error = function () { };
//     console.warn = function () { };
// }

const express = require('express');
const cors = require('cors');
const helmet = require('helmet');
const db = require('./config/db.config');

require('dotenv').config()

const routes = require('./routes/routes');

const app = express();

// Use CORS and Helmet middleware
app.use(cors());
app.use(helmet());
app.use(express.json());
app.use(express.urlencoded({ extended: true }));
app.set('trust proxy', 1);

// Define a simple route
app.get('/', (req, res) => {
    res.send('Hello World!');
});
app.use('/api', routes);
app.use('/', routes);

// Start the server
const PORT = process.env.PORT || 3000;
app.listen(PORT, () => {
    console.log(`Server is running on port ${PORT}`);
});
