"use client";

import React from "react";
import { Slider } from "@mui/material";
import ChildCard from "@/app/components/shared/ChildCard";
import { IconVolume, IconVolume2 } from "@tabler/icons-react";
import { Stack } from "@mui/system";

import VolumesliderCode from "@/app/components/forms/form-elements/slider/code/VolumesliderCode";

const VolumeSlider = () => {
  const [value, setValue] = React.useState(30);
  const handleChange = (event: any, newValue: React.SetStateAction<number>) => {
    setValue(newValue);
  };

  return (
    <ChildCard title="Volume" codeModel={<VolumesliderCode />}>
      <Stack direction="row" spacing={1}>
        <IconVolume2 width={20} />
        <Slider aria-label="Volume" value={value} onChange={handleChange} />
        <IconVolume width={20} />
      </Stack>
    </ChildCard>
  );
};

export default VolumeSlider;
