import React from "react";
import MyApp from "./app";
import NextTopLoader from 'nextjs-toploader';
import "./global.css";
import { CustomizerContextProvider } from "./context/customizerContext";
import { GoogleReCaptchaProvider } from "react-google-recaptcha-v3";
import ClientProviders from "./ClientProviders";
export const metadata = {
  title: "Emanage",
  description: "Emanage Admin Dashboard",
};

export default function RootLayout({
  children,
}: {
  children: React.ReactNode;
}) {
  return (
    <html lang="en" suppressHydrationWarning>
      <body>
        <NextTopLoader color="#5D87FF" />
        <CustomizerContextProvider>

          <MyApp>
            {children}
          </MyApp>

        </CustomizerContextProvider>
      </body>
    </html>
  );
}
