/** @type {import('next').NextConfig} */
const nextConfig = {
  productionBrowserSourceMaps: false,
  reactStrictMode: false,
  images: {
    unoptimized: true,
  },
  typescript: {
    ignoreBuildErrors: true, // ✅ Skip TypeScript errors on build
  },
  eslint: {
    ignoreDuringBuilds: true, // ✅ Skip ESLint errors on build
  },
  swcMinify: false // optional: reduces memory usage during build
};

export default nextConfig;
