import CodeDialog from '@/app/components/shared/CodeDialog'
import React from 'react'
const InputVariantsCode = () => {
  return (
    <>
      <CodeDialog>
        {`
"use client";
import React from 'react';
import { FormControl } from '@mui/material';
import { styled } from '@mui/material/styles';
import { Typography } from '@mui/material';
import { TextField } from '@mui/material';

const CustomTextField = styled((props) => <TextField {...props} />)(({ theme }) => ({
  '& .MuiOutlinedInput-input::-webkit-input-placeholder': {
    color: theme.palette.text.secondary,
    opacity: '0.8',
  },
  '& .MuiOutlinedInput-input.Mui-disabled::-webkit-input-placeholder': {
    color: theme.palette.text.secondary,
    opacity: '1',
  },
  '& .Mui-disabled .MuiOutlinedInput-notchedOutline': {
    borderColor: theme.palette.grey[200],
  },
}));

const CustomFormLabel = styled((props) => (
  <Typography
    variant="subtitle1"
    fontWeight={600}
    {...props}
    component="label"
    htmlFor={props.htmlFor}
  />
))(() => ({
  marginBottom: '5px',
  marginTop: '25px',
  display: 'block',
}));

<form>
    <CustomFormLabel
        sx={{
            mt: 0,
        }}
        htmlFor="success-input"
    >
        Success Input
    </CustomFormLabel>
    <CustomTextField
        id="success-input"
        variant="outlined"
        defaultValue="Success value"
        fullWidth
        required
        sx={{
            '& input:valid + fieldset': {
              borderColor: '#39cb7f',
            },
            '& input:invalid + fieldset': {
              borderColor: '#fc4b6c',
            },
        }}
    />
    <CustomFormLabel htmlFor="error-input">Error Input</CustomFormLabel>
    <CustomTextField
        id="error-input"
        variant="outlined"
        fullWidth
        required
        error
    />
    <FormControl fullWidth error>
        <CustomFormLabel htmlFor="error-text-input">Input with Error text</CustomFormLabel>
        <CustomTextField
            id="error-text-input"
            variant="outlined"
            fullWidth
            required
            error
            helperText="Incorrect entry."
        />
    </FormControl>
</form>
`}
      </CodeDialog>
    </>
  )
}

export default InputVariantsCode
