const { DataTypes } = require('sequelize');
const bcrypt = require('bcryptjs');
const db = require('../config/db.config');
const KioskCreation = db.define('KioskCreation', {
    id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
    },
    kioskid: {
        type: DataTypes.STRING,
        allowNull: true
    },
    phone: {
        type: DataTypes.STRING,
        allowNull: true
    },
    gameid: {
        type: DataTypes.STRING,
        allowNull: true
    },
    gameuser: {
        type: DataTypes.STRING,
        allowNull: true
    },
    gameuserid: {
        type: DataTypes.STRING,
        allowNull: true
    },
    gamepass: {
        type: DataTypes.STRING,
        allowNull: true
    },
    status: {
        type: DataTypes.STRING,
        allowNull: true
    }

}, {
    tableName: 'kiosk_creations',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at'
});



module.exports = KioskCreation;