
import { Fragment, useState } from "react";
import { Button, Form, Modal, Table, } from "react-bootstrap";
import { nanoid } from "nanoid";
import { useTable, useGlobalFilter, useSortBy, usePagination } from "react-table";

//1Basic datatables
function timeAgo(dateInput: string | number | Date) {
    const date = new Date(dateInput);  // This will now work correctly
    const seconds = Math.floor((new Date().getTime() - date.getTime()) / 1000); // getTime() for accurate comparisons
    const intervals = [
        { label: 'year', seconds: 31536000 },
        { label: 'month', seconds: 2592000 },
        { label: 'week', seconds: 604800 },
        { label: 'day', seconds: 86400 },
        { label: 'hour', seconds: 3600 },
        { label: 'minute', seconds: 60 },
        { label: 'second', seconds: 1 },
    ];

    for (const interval of intervals) {
        const count = Math.floor(seconds / interval.seconds);
        if (count >= 1) {
            return `${count} ${interval.label}${count > 1 ? 's' : ''} ago`;
        }
    }

    return 'just now';
}
export const COLUMNS: any = [
    {
        Header: "Sl No.",
        accessor: "id",
        Cell: ({ row }: any) => row.index + 1,
    },
    {
        Header: "Time",
        accessor: "created_at",
        Cell: ({ value }: any) => timeAgo(value),

    },
    {
        Header: "Cashier",
        accessor: "username",
        Cell: ({ row }: any) => row.original.Admin?.username,

    },
    {
        Header: "Initial Balance",
        accessor: "initial_balance",
        Cell: ({ value }: any) => `$${value}`,
    },
    {
        Header: "Withdraw Balance",
        accessor: "withdraw_balance",
        Cell: ({ value }: any) =>
            value > 0 ? (
                <span style={{ color: "crimson" }}>${value}</span>
            ) : (
                "---"
            ),
    },
    {
        Header: "Withdraw Reason",
        accessor: "withdraw_reason",
        Cell: ({ value }: any) => value || "---",
    },
    {
        Header: "Withdraw Manager",
        accessor: "withdraw_manager",
        Cell: ({ value }: any) => value || "---",
    },
    {
        Header: "Fill Balance",
        accessor: "fill_balance",
        Cell: ({ value }: any) =>
            value > 0 ? (
                <span style={{ color: "green" }}>${value}</span>
            ) : (
                "---"
            ),
    },
    {
        Header: "Prev Balance",
        accessor: "prev_balance",
        Cell: ({ value }: any) => `$${value}`,
    },
    {
        Header: "New Balance",
        accessor: "new_balance",
        Cell: ({ row }: any) => {
            const { new_balance, prev_balance } = row.original;
            const isPositive = parseFloat(new_balance) > parseFloat(prev_balance);
            return (
                <span style={{ color: isPositive ? "green" : "crimson" }}>
                    {isPositive ? `+ $${new_balance}` : `- $${new_balance}`}
                </span>
            );
        },
    },
    {
        Header: "GD Final",
        accessor: "gdfb",
        Cell: ({ value }: any) => `$${value}`,
    },
    {
        Header: "FS Final",
        accessor: "fsfb",
        Cell: ({ value }: any) => `$${value}`,
    },
    {
        Header: "RS Final",
        accessor: "rsfb",
        Cell: ({ value }: any) => `$${value}`,
    },
    {
        Header: "GD Evidence",
        accessor: "gdimage",
        Cell: ({ value }: any) =>
            value ? (
                <a
                    href={`${process.env.NEXT_PUBLIC_FILE_BASE_URL}/public/evidence/${value}`}
                    target="_blank"
                    rel="noopener noreferrer"
                >
                    <Button variant="primary" size="sm" className="w-100">
                        Download
                    </Button>
                </a>
            ) : (
                "---"
            ),
    },
    {
        Header: "FS Evidence",
        accessor: "fsimage",
        Cell: ({ value }: any) =>
            value ? (
                <a
                    href={`${process.env.NEXT_PUBLIC_FILE_BASE_URL}/public/evidence/${value}`}
                    target="_blank"
                    rel="noopener noreferrer"
                >
                    <Button variant="primary" size="sm" className="w-100">
                        Download
                    </Button>
                </a>
            ) : (
                "---"
            ),
    },
    {
        Header: "RS Evidence",
        accessor: "rsimage",
        Cell: ({ value }: any) =>
            value ? (
                <a
                    href={`${process.env.NEXT_PUBLIC_FILE_BASE_URL}/public/evidence/${value}`}
                    target="_blank"
                    rel="noopener noreferrer"
                >
                    <Button variant="primary" size="sm" className="w-100">
                        Download
                    </Button>
                </a>
            ) : (
                "---"
            ),
    },
    {
        Header: "Withdraw Evidence",
        accessor: "withdraw_document",
        Cell: ({ value }: any) =>
            value ? (
                <a
                    href={`${process.env.NEXT_PUBLIC_FILE_BASE_URL}/public/evidence/${value}`}
                    target="_blank"
                    rel="noopener noreferrer"
                >
                    <Button variant="primary" size="sm" className="w-100">
                        Download
                    </Button>
                </a>
            ) : (
                "---"
            ),
    },
];



export const GlobalFilter = ({ filter, setFilter }: any) => {
    return (
        <span className="d-flex ms-auto">
            <input
                value={filter || ""}
                onChange={(e) => setFilter(e.target.value)}
                className="form-control mb-4"
                placeholder="Search..."
            />
        </span>
    );
};
export const BasicTable = ({ data }: { data: any[] }) => {
    const tableInstance = useTable(
        {
            columns: COLUMNS,
            data: data,
        },
        useGlobalFilter,
        useSortBy,
        usePagination
    );

    const {
        getTableProps, // table props from react-table
        headerGroups, // headerGroups, if your table has groupings
        getTableBodyProps, // table body props from react-table
        prepareRow, // Prepare the row (this function needs to be called for each row before getting the row props)
        state,
        setGlobalFilter,
        page, // use, page or rows
        nextPage,
        previousPage,
        canNextPage,
        canPreviousPage,
        pageOptions,
        gotoPage,
        pageCount,
        setPageSize,
    }: any = tableInstance;

    const { globalFilter, pageIndex, pageSize } = state;

    return (
        <>
            <div className="  d-flex">
                <div className="form-group">
                    <label className="me-2">Show</label>
                    <select
                        className="  selectpage  border me-1"
                        value={pageSize}
                        onChange={(e) => setPageSize(Number(e.target.value))}
                    >
                        {[10, 25, 50].map((pageSize) => (
                            <option key={pageSize} value={pageSize}>
                                {pageSize}
                            </option>
                        ))}
                    </select>  entries
                </div>

                <GlobalFilter filter={globalFilter} setFilter={setGlobalFilter} />
            </div>
            <table
                {...getTableProps()}
                className="table table-hover mb-0 table-bordered text-nowrap"
            >
                <thead>
                    {headerGroups.map((headerGroup: any, index: any) => (
                        <tr {...headerGroup.getHeaderGroupProps()} key={index}>
                            {headerGroup.headers.map((column: any) => (
                                <th
                                    {...column.getHeaderProps(column.getSortByToggleProps())}
                                    className={column.className}
                                    key={column.id}
                                >

                                    <span className="tabletitle">{column.render("Header")}</span>
                                    <span>
                                        {column.isSorted ? (
                                            column.isSortedDesc ? (
                                                <i className="fa fa-angle-down  float-end"></i>
                                            ) : (
                                                <i className="fa fa-angle-up float-end"></i>
                                            )
                                        ) : (
                                            ""
                                        )}
                                    </span>

                                </th>
                            ))}
                        </tr>
                    ))}
                </thead>
                <tbody {...getTableBodyProps()}>
                    {page.map((row: any) => {
                        prepareRow(row);
                        return (
                            <tr {...row.getRowProps()} key={row.id}>
                                {row.cells.map((cell: any) => {
                                    return (
                                        <td
                                            className="borderrigth"
                                            {...cell.getCellProps()}
                                            key={cell.column.id}
                                        >
                                            {cell.render("Cell")}
                                        </td>
                                    );
                                })}
                            </tr>
                        );
                    })}
                </tbody>
            </table>
            <div className="d-block d-sm-flex mt-4 ">
                {/* <span className="">
                    Showing 1 to 10 of 57 entries

                </span> */}
                <span className="ms-sm-auto ">
                    <Button
                        variant=""
                        className="btn-outline-light tablebutton me-2 d-sm-inline d-block my-1"
                        onClick={() => gotoPage(0)}
                        disabled={!canPreviousPage}
                    >
                        {" Previous "}
                    </Button>
                    <Button
                        variant=""
                        className="btn-outline-light tablebutton me-2 my-1"
                        onClick={() => {
                            previousPage();
                        }}
                        disabled={!canPreviousPage}
                    >
                        {" << "}
                    </Button>
                    <Button
                        variant=""
                        className="btn-outline-light tablebutton me-2 my-1"
                        onClick={() => {
                            previousPage();
                        }}
                        disabled={!canPreviousPage}
                    >
                        {" < "}
                    </Button>
                    <Button
                        variant=""
                        className="btn-outline-light tablebutton me-2 my-1"
                        onClick={() => {
                            nextPage();
                        }}
                        disabled={!canNextPage}
                    >
                        {" > "}
                    </Button>
                    <Button
                        variant=""
                        className="btn-outline-light tablebutton me-2 my-1"
                        onClick={() => {
                            nextPage();
                        }}
                        disabled={!canNextPage}
                    >
                        {" >> "}
                    </Button>
                    <Button
                        variant=""
                        className="btn-outline-light tablebutton me-2 d-sm-inline d-block my-1"
                        onClick={() => gotoPage(pageCount - 1)}
                        disabled={!canNextPage}
                    >
                        {" Next "}
                    </Button>
                </span>
            </div>
        </>
    );
};
//

