"use client";
import React, { memo } from 'react'
import { connect } from 'react-redux';
import { ThemeChanger } from '../../shared/redux/actions';

function Layout({ children, local_varaiable, ThemeChanger }: any) {

  const customstyles: any =
  {
    ...(local_varaiable.colorPrimaryRgb !== "" && { '--primary-rgb': local_varaiable.colorPrimaryRgb }),
    ...(local_varaiable.bodyBg != "" && { '--body-bg-rgb': local_varaiable.bodyBg }),
    ...(local_varaiable.bodyBg1 !== "" && { '--body-bg-rgb2': local_varaiable.bodyBg1 }),
    ...(local_varaiable.Light !== "" && { '--light-rgb': local_varaiable.Light }),
    ...(local_varaiable.darkBg !== "" && { '--form-control-bg': `rgb(${local_varaiable.darkBg})` }),
    ...(local_varaiable.sidemenuActiveBgcolor !== '' && { '--sidemenu-active-bgcolor': `rgb(${local_varaiable.sidemenuActiveBgcolor})` }),
    ...(local_varaiable.inputBorder !== "" && { '--input-border': `rgb(${local_varaiable.inputBorder})` }),

  };

  return (
    <>
      <html
        lang="en"
        suppressHydrationWarning={true}
        dir={local_varaiable.dir}
        data-theme-mode={local_varaiable.dataThemeMode}
        data-header-styles={local_varaiable.dataHeaderStyles}
        data-vertical-style={local_varaiable.dataVerticalStyle}
        data-nav-layout={local_varaiable.dataNavLayout}
        data-menu-styles={local_varaiable.dataMenuStyles}
        data-toggled={local_varaiable.toggled}
        data-nav-style={local_varaiable.dataNavStyle}
        data-page-style={local_varaiable.dataPageStyle}
        data-width={local_varaiable.dataWidth}
        data-menu-position={local_varaiable.dataMenuPosition}
        data-header-position={local_varaiable.dataHeaderPosition}
        data-icon-overlay={local_varaiable.iconOverlay}
        data-bg-img={local_varaiable.bgImg}
        data-icon-text={local_varaiable.iconText}

        //Styles
        style={customstyles}>
        <head>
          <link href="https://cdn.jsdelivr.net/npm/dragula@3.7.3/dist/dragula.min.css" rel="stylesheet" />
          <meta name="keywords" content="typescript,ts script,next js typescript,nextjs dashboard,admin,nextjs template,dashboard,next js react,next js app,nextjs dashboard template,typescript,nextjs typescript,firebase nextjs,nextjs bootstrap,router app," />
        </head>
        <body className={`${local_varaiable.body ? local_varaiable.body : ""}`}>
          {children}
          <script src="https://cdn.jsdelivr.net/npm/dragula@3.7.3/dist/dragula.min.js"></script>
        </body>
      </html>
    </>
  );
}

const mapStateToProps = (state: any) => ({
  local_varaiable: state
});

export default memo(connect(mapStateToProps, { ThemeChanger })(Layout));
