import { NextResponse } from "next/server";
import axios from "axios";

export async function POST(request) {
  try {
    const body = await request.json();

    const headers = { Authorization: `Bearer ${body.token}` };
    const loginRes = await axios.post(
      `${process.env.NEXT_PUBLIC_API_BASE_URL}/deleteCashier`,
      body,
      { headers }
    );

    console.log("Login response:", loginRes.data);


    return NextResponse.json(loginRes.data);
  } catch (error) {

    console.error(
      "Login Error:",
      error?.response?.data || error.message || error
    );
    return NextResponse.json(
      { error: "Something went wrong", detail: error.message },
      { status: error.status }
    );
  }
}
