import { NextResponse } from 'next/server';
import axios from 'axios';
import FormData from 'form-data';
import fs from 'fs';
import path from 'path';

export async function POST(req) {
  try {

    const formData = await req.formData();

    const token = formData.get('token');
    const gdimage = formData.get('gdimage');
    const rsimage = formData.get('rsimage');
    const fsimage = formData.get('fsimage');
    const values = formData.get('values');

    if (!gdimage) {
      return NextResponse.json({ status: 'error', message: 'GD Image is required' }, { status: 400 });
    }
    if (!rsimage) {
      return NextResponse.json({ status: 'error', message: 'RS Image is required' }, { status: 400 });
    }
    if (!fsimage) {
      return NextResponse.json({ status: 'error', message: 'FS Image is required' }, { status: 400 });
    }
    const gdImageBuffer = gdimage instanceof Buffer ? gdimage : Buffer.from(await gdimage.arrayBuffer());
    const rsImageBuffer = rsimage instanceof Buffer ? rsimage : Buffer.from(await rsimage.arrayBuffer());
    const fsImageBuffer = fsimage instanceof Buffer ? fsimage : Buffer.from(await fsimage.arrayBuffer());

    const backendFormData = new FormData();
    // console.log(values)
    for (const [key, val] of Object.entries(JSON.parse(values))) {
      backendFormData.append(key, val);
    }
    // backendFormData.append('values', values);

    // backendFormData.append('values', imageBuffer, image.name);
    backendFormData.append('gdimage', gdImageBuffer, gdimage.name);
    backendFormData.append('fsimage', fsImageBuffer, fsimage.name);
    backendFormData.append('rsimage', rsImageBuffer, rsimage.name);
    backendFormData.append('token', token);

    const response = await axios.post(
      `${process.env.NEXT_PUBLIC_API_BASE_URL}/saveEndShift`,
      backendFormData,
      {
        headers: {
          'Content-Type': 'multipart/form-data',
          'Authorization': `Bearer ${token}`
        },
      }
    );


    return NextResponse.json(response.data);
  } catch (error) {
    console.error('Error in saving withdrawal:', error);
    return NextResponse.json({ status: 'error', message: 'Failed to process the request' }, { status: 500 });
  }
}

export const config = {
  api: {
    bodyParser: false,
  },
  maxBodySize: '20mb', // 📢 increase to 20MB or more
};