import store from "../../redux/store";

const SwithcerClass = (selector:any) => document.getElementsByClassName(selector);

const setMargin = (className:any) => {
    const elements:any = SwithcerClass(className);
    for (let element of elements) {
        element.style.marginInline = "0px";
    }
};

export const updateTheme = (themeType:any, actionfunction:any,clicked?:any) => {
    const theme = store.getState();

    const newTheme = {
        ...theme,
        "dataThemeMode": themeType === "dark" ? "dark" : "light",
		"dataHeaderStyles": themeType === "dark" ? "dark" : "light",
		"dataMenuStyles": "dark",
		"bodyBg1": "",
		"bodyBg": "",
		"darkBg": "",
		"Light": "",
        "bgImg": "",
		"inputBorder": "",
		"formControl":"",
		"lightRgb":"",
		"sidemenuActiveBgcolor":""
    };

    localStorage.setItem(`spruha${themeType}theme`, themeType);
	localStorage.removeItem(`spruha${themeType === "dark" ? "light" : "dark"}theme`);
	localStorage.removeItem("sidemenuActiveBgcolor");
	
    if (clicked) {
        //console.log("Clicked is true. Removing additional localStorage items.");

        localStorage.removeItem("darkBgRGB1");
        localStorage.removeItem("darkBgRGB2");
        localStorage.removeItem("darkBgRGB3");
        localStorage.removeItem("darkBgRGB4");
        localStorage.removeItem("spruhaHeader");
        localStorage.removeItem("spruhaMenu");
        localStorage.removeItem("bgImg");
    } 
    //else {
    //    console.log("Clicked is false or undefined.");
    //}
    actionfunction(newTheme);
};

export const DirectionTheme = (directionType:any, actionfunction:any) => {
    const theme = store.getState();

    const dirtectionTheme = {
        ...theme,
        "dir": directionType,
    };

    localStorage.setItem(`spruha${directionType}`, directionType);
    localStorage.removeItem(`spruha${directionType === "ltr" ? "rtl" : "ltr"}`);

    actionfunction(dirtectionTheme);
};

export const updateLayout = (layoutType:any, actionfunction:any) => {

    const theme = store.getState();

    let updatedTheme = {
        ...theme,
        "dataNavLayout": layoutType === "horizontal" ? "horizontal" : "vertical",
        "dataVerticalStyle": layoutType === "vertical" ? "overlay" : "",
        "dataNavStyle": localStorage.spruhanavstyles ? localStorage.spruhanavstyles : "menu-click",
        "toggled": layoutType === "vertical" ? "" : undefined
    };

    localStorage.setItem("spruhalayout", layoutType);
    if (layoutType === "vertical") {
        localStorage.removeItem("spruhaverticalstyles");
    } else {
        localStorage.removeItem("spruhaverticalstyles");
    }

    setMargin("main-menu");

    actionfunction(updatedTheme);
};

export const updateNavStyle = (actionType:any, toggledState:any, actionfunction:any) => {
    const theme = store.getState();
    actionfunction({
        ...theme,
        "dataNavStyle": actionType,
        "dataVerticalStyle": "",
        "toggled": toggledState,
    });

    localStorage.setItem("spruhanavstyles", actionType);
    localStorage.removeItem("spruhaverticalstyles");

    setMargin("main-menu");

};

export const updateWidthStyle = (widthType:any, actionfunction:any) => {
    const theme = store.getState();
    actionfunction({
        ...theme,
        "dataWidth": widthType,
    });

    localStorage.setItem(`spruha${widthType}`, widthType);
    localStorage.removeItem(`spruha${widthType === "fullwidth" ? "boxed" : "fullwidth"}`);
};

export const updateMenuPosition = (menuPosition:any, actionfunction:any) => {
    const theme = store.getState();
    actionfunction({
        ...theme,
        "dataMenuPosition": menuPosition,
    });

    localStorage.setItem(`spruhamenu${menuPosition}`, `${menuPosition}Menu`);
    localStorage.removeItem(`spruhamenu${menuPosition === "fixed" ? "scrollable" : "fixed"}`);
};

export const updateHeaderPosition = (headerPosition:any, actionfunction:any) => {
    const theme = store.getState();
    actionfunction({
        ...theme,
        "dataHeaderPosition": headerPosition,
    });

    localStorage.setItem(`spruhaheader${headerPosition}`, `${headerPosition}Header`);
    localStorage.removeItem(`spruhaheader${headerPosition === "fixed" ? "scrollable" : "fixed"}`);
};

export const updatePageStyle = (pageStyle:any, actionfunction:any) => {
    const theme = store.getState();
    actionfunction({
        ...theme,
        "dataPageStyle": pageStyle,
    });

    localStorage.setItem(`spruha${pageStyle}`, pageStyle.charAt(0).toUpperCase() + pageStyle.slice(1));
    ["regular", "classic", "modern"].forEach(style => {
        if (style !== pageStyle) {
            localStorage.removeItem(`spruha${style}`);
        }
    });
};



export const updateBgImage = (imageKey:any, actionfunction:any) => {
    const theme = store.getState();
    actionfunction({
        ...theme,
        "bgImg": imageKey
    });

    localStorage.setItem(imageKey, imageKey);
    for (let i = 1; i <= 5; i++) {
        if (`bgimage${i}` !== imageKey) {
            localStorage.removeItem(`bgimage${i}`);
        }
    }
};

export const updateMenuStyle = (menuStyle:any,removeStyle:any, actionfunction:any) => {
    const theme = store.getState();
    actionfunction({
        ...theme,
        "dataMenuStyles": menuStyle,
    });
    localStorage.setItem("spruhaMenu", menuStyle);
    localStorage.removeItem(removeStyle);
};

export const updateHeaderStyle = (headerStyle:any,removeStyle:any, actionfunction:any) => {
    const theme = store.getState();
    actionfunction({
        ...theme,
        "dataHeaderStyles": headerStyle,
    });
    localStorage.setItem("spruhaHeader", headerStyle);
    localStorage.removeItem(removeStyle);
};

export const updatePrimaryColor = (colorRgb:any, actionfunction:any) => {
    const theme = store.getState();
    actionfunction({
        ...theme,
        "colorPrimaryRgb": colorRgb,
    });
    localStorage.setItem("primaryRGB", colorRgb);
};

export const updateBackgroundColor = (bgColor1:any, bgColor2:any,_clicked:string, actionfunction:any) => {
    const theme = store.getState();
    actionfunction({
        ...theme,

        "bodyBg": bgColor1,
		"Light": bgColor2,
		"bodyBg1":bgColor2,
		"darkBg": bgColor2,
		"inputBorder": "255, 255, 255, 0.1",
		"sidemenuActiveBgcolor":bgColor2,
		"dataThemeMode": "dark",
		"dataMenuStyles": "dark",
		"dataHeaderStyles": "dark",
    });

    localStorage.setItem("darkBgRGB1", bgColor1);
	localStorage.setItem("darkBgRGB2", bgColor2);
	localStorage.setItem("darkBgRGB3", bgColor2,);
	localStorage.setItem("LightRGB", bgColor2);
	localStorage.setItem("darkBgRGB4", "255, 255, 255, 0.1");
};



//element.style {
//    --body-bg-rgb: 8, 78, 115;
//    --body-bg-rgb2: 13, 86, 120;
//    --light-rgb: 13, 86, 120;
//    --form-control-bg: rgb(13, 86, 120);
//    --sidemenu-active-bgcolor: rgb(13, 86, 120);
//    --input-border: rgb(255, 255, 255, 0.1);

//    --body-bg-rgb: 8, 78, 115;
//    --body-bg-rgb2: 32, 95, 128;
//    --light-rgb: 32, 95, 128;
//    --form-control-bg: rgb(32, 95, 128);
//    --sidemenu-active-bgcolor: rgb(32, 95, 128);
//    --input-border: rgb(255, 255, 255, 0.1);