"use client";
import { useState } from "react";
import store from "../../redux/store";
import { MENUITEMS } from "../../../shared/layouts-components/sidebar/nav";
import { updateTheme, DirectionTheme, updateLayout, updateNavStyle, updateWidthStyle, updateMenuPosition, updateHeaderPosition, updatePageStyle, updateBgImage, updateMenuStyle, updateHeaderStyle, updatePrimaryColor, updateBackgroundColor } from './switcher-reusable';

const slidesArrow = (selector: any) => document.querySelector(selector);
const switcherDoucmentIdSelector = (selector: any) => document.getElementById(selector)

export const Dark = (actionfunction: any, _clicked?: any) => updateTheme("dark", actionfunction, _clicked);

export const Light = (actionfunction: any, _clicked?: any) => updateTheme("light", actionfunction, _clicked);

export const Ltr = (actionfunction: any) => DirectionTheme("ltr", actionfunction);

export const Rtl = (actionfunction: any) => DirectionTheme("rtl", actionfunction);

export const HorizontalClick = (actionfunction: any) => updateLayout("horizontal", actionfunction);

export const Vertical = (actionfunction: any) => updateLayout("vertical", actionfunction);

export const Menuclick = (actionfunction: any) => updateNavStyle("menu-click", "menu-click-closed", actionfunction);

export const MenuHover = (actionfunction: any) => updateNavStyle("menu-hover", "menu-hover-closed", actionfunction);

export const IconClick = (actionfunction: any) => updateNavStyle("icon-click", "icon-click-closed", actionfunction);

export const IconHover = (actionfunction: any) => updateNavStyle("icon-hover", "icon-hover-closed", actionfunction);

export const Fullwidth = (actionfunction: any) => updateWidthStyle("fullwidth", actionfunction);

export const Boxed = (actionfunction: any) => updateWidthStyle("boxed", actionfunction);

export const FixedMenu = (actionfunction: any) => updateMenuPosition("fixed", actionfunction);

export const scrollMenu = (actionfunction: any) => updateMenuPosition("scrollable", actionfunction);

export const Headerpostionfixed = (actionfunction: any) => updateHeaderPosition("fixed", actionfunction);

export const Headerpostionscroll = (actionfunction: any) => updateHeaderPosition("scrollable", actionfunction);

export const Regular = (actionfunction: any) => updatePageStyle("regular", actionfunction);

export const Classic = (actionfunction: any) => updatePageStyle("classic", actionfunction);

export const Modern = (actionfunction: any) => updatePageStyle("modern", actionfunction);

//export const bgImage1 = (actionfunction:any) => updateBgImage("bgimg1", actionfunction);

//export const bgImage2 = (actionfunction:any) => updateBgImage("bgimg2", actionfunction);

//export const bgImage3 = (actionfunction:any) => updateBgImage("bgimg3", actionfunction);

//export const bgImage4 = (actionfunction:any) =>  updateBgImage("bgimg4", actionfunction);

//export const bgImage5 = (actionfunction:any) => updateBgImage("bgimg5", actionfunction);

export const lightMenu = (actionfunction: any, _clicked: string) => updateMenuStyle("light", "light", actionfunction);

export const darkMenu = (actionfunction: any, _clicked: string) => updateMenuStyle("dark", "light", actionfunction);

export const gradientMenu = (actionfunction: any, _clicked: string) => updateMenuStyle("gradient", "color", actionfunction);

export const colorMenu = (actionfunction: any, _clicked: string) => updateMenuStyle("color", "gradient", actionfunction);

export const transparentMenu = (actionfunction: any, _clicked: string) => updateMenuStyle("transparent", "gradient", actionfunction);

export const lightHeader = (actionfunction: any, _clicked: string) => updateHeaderStyle("light", "dark", actionfunction);

export const darkHeader = (actionfunction: any, _clicked: string) => updateHeaderStyle("dark", "light", actionfunction);

export const colorHeader = (actionfunction: any, _clicked: string) => updateHeaderStyle("color", "dark", actionfunction);

export const gradientHeader = (actionfunction: any, _clicked: string) => updateHeaderStyle("gradient", "transparent", actionfunction);

export const transparentHeader = (actionfunction: any, _clicked: string) => updateHeaderStyle("transparent", "gradient", actionfunction);

export const primaryColor1 = (actionfunction: any) => updatePrimaryColor("58, 88, 146", actionfunction);

export const primaryColor2 = (actionfunction: any) => updatePrimaryColor("92, 144, 163", actionfunction);

export const primaryColor3 = (actionfunction: any) => updatePrimaryColor("161, 90, 223", actionfunction);

export const primaryColor4 = (actionfunction: any) => updatePrimaryColor("78, 172, 76", actionfunction);

export const primaryColor5 = (actionfunction: any) => updatePrimaryColor("223, 90, 90", actionfunction);

export const backgroundColor1 = (actionfunction: any, _clicked: string) => updateBackgroundColor("20, 30, 96", "25, 38, 101", "25, 38, 101", actionfunction);

export const backgroundColor2 = (actionfunction: any, _clicked: string) => updateBackgroundColor("8, 78, 115", "13, 86, 120", "13, 86, 120", actionfunction);

export const backgroundColor3 = (actionfunction: any, _clicked: string) => updateBackgroundColor("90, 37, 135", "95, 45, 140", "95, 45, 140", actionfunction);

export const backgroundColor4 = (actionfunction: any, _clicked: string) => updateBackgroundColor("24, 101, 51", "29, 109, 56", "29, 109, 56", actionfunction);

export const backgroundColor5 = (actionfunction: any, _clicked: string) => updateBackgroundColor("120, 66, 20", "125, 74, 25", "125, 74, 25", actionfunction);

export const bgImage = (actionfunction: any, img: string | null) => {
	const theme = store.getState()
	actionfunction({
		...theme,
		"bgImg": img,

	})
	localStorage.setItem("bgImg", img ?? '');
};

const addClickListenerToClass = (className: any, callback: any) => {
	const elements = document.getElementsByClassName(className);
	for (let element of elements) {
		element.addEventListener("click", callback);
	}
};

export const Defaultmenu = (actionfunction: any) => {
	const theme = store.getState();
	actionfunction({
		...theme,
		"dataVerticalStyle": "overlay",
		"dataNavLayout": "vertical",
		"toggled": ""
	});
	localStorage.setItem("spruhaverticalstyles", "default");

	localStorage.removeItem("spruhanavstyles");

};
export const Closedmenu = (actionfunction: any) => {
	const theme = store.getState();
	actionfunction({
		...theme,
		"dataNavLayout": "vertical",
		"dataVerticalStyle": "closed",
		"toggled": "close-menu-close"
	});
	localStorage.setItem("spruhaverticalstyles", "closed");
	localStorage.removeItem("spruhanavstyles");

};


function icontextOpenFn() {
	let html = document.documentElement
	if (html.getAttribute("data-toggled") === "icon-text-close") {
		html.setAttribute("data-icon-text", "open");
	}
}
function icontextCloseFn() {
	let html = document.documentElement
	if (html.getAttribute("data-toggled") === "icon-text-close") {
		html.removeAttribute("data-icon-text");
	}
}
export const iconTextfn = (actionfunction: any) => {
	const theme = store.getState();
	actionfunction({
		...theme,
		"dataNavLayout": "vertical",
		"dataVerticalStyle": "icontext",
		"toggled": "icon-text-close",
		"dataNavStyle": "",
	});
	localStorage.setItem("spruhaverticalstyles", "icontext");


	addClickListenerToClass("app-sidebar", icontextOpenFn);
	addClickListenerToClass("main-content", icontextCloseFn);

};
export const iconOverayFn = (actionfunction: any) => {
	const theme = store.getState();
	actionfunction({
		...theme,
		"dataNavLayout": "vertical",
		"dataVerticalStyle": "overlay",
		"toggled": "icon-overlay-close",

	});
	localStorage.setItem("spruhaverticalstyles", "overlay");
	localStorage.removeItem("spruhanavstyles");
	const icon: any = switcherDoucmentIdSelector("switcher-icon-overlay");
	if (icon) {
		icon.checked = true;
	}
	addClickListenerToClass("app-sidebar", DetachedOpenFn);
	addClickListenerToClass("main-content", DetachedCloseFn);


};

function DetachedOpenFn() {
	if (window.innerWidth > 992) {

		let html = document.documentElement
		if (html.getAttribute("data-toggled") === "detached-close" || html.getAttribute("data-toggled") === "icon-overlay-close") {
			html.setAttribute("data-icon-overlay", "open");
		}
	}
}
function DetachedCloseFn() {
	if (window.innerWidth > 992) {
		let html = document.documentElement

		if (html.getAttribute("data-toggled") === "detached-close" || html.getAttribute("data-toggled") === "icon-overlay-close") {
			html.removeAttribute("data-icon-overlay");
		}
	}
}
export const DetachedFn = (actionfunction: any) => {
	const theme = store.getState();
	actionfunction({
		...theme,
		"dataNavLayout": "vertical",
		"dataVerticalStyle": "detached",
		"toggled": "detached-close",
	});
	localStorage.setItem("spruhaverticalstyles", "detached");
	localStorage.removeItem("spruhanavstyles");

	addClickListenerToClass("app-sidebar", DetachedOpenFn);
	addClickListenerToClass("main-content", DetachedCloseFn);
};

export const DoubletFn = (actionfunction: any) => {

	const theme = store.getState();
	actionfunction({
		...theme,
		"dataNavLayout": "vertical",
		"dataVerticalStyle": "doublemenu",
		"dataNavStyle": "",
		"toggled": "double-menu-open",
	});
	localStorage.setItem("spruhaverticalstyles", "doublemenu");
	localStorage.removeItem("spruhanavstyles");

	setTimeout(() => {
		if (!document.querySelectorAll(".main-menu .slide.active")[0]?.querySelector("ul")) {
			const theme = store.getState();
			actionfunction(
				{
					...theme,
					"toggled": "double-menu-close",
				}
			);
		}
	}, 100);
};

const ColorPicker = (props: any) => {
	return (
		<div className="color-picker-input">
			<input type="color" {...props} />
		</div>
	);
};

function hexToRgb(hex: any) {
	const result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
	return result ? {
		r: parseInt(result[1], 16),
		g: parseInt(result[2], 16),
		b: parseInt(result[3], 16)
	} : null;
}
const Themeprimarycolor = ({ actionfunction }: any) => {
	const theme = store.getState();
	const [state, updateState] = useState("#FFFFFF");

	const handleInput = (e: any) => {
		const rgb = hexToRgb(e.target.value);

		if (rgb !== null) {
			const { r, g, b } = rgb;
			updateState(e.target.value);
			actionfunction({
				...theme,
				"colorPrimaryRgb": `${r} , ${g} , ${b}`,
			});
			localStorage.setItem("dynamiccolor", `${r}, ${g}, ${b}`);
		}
	};

	return (
		<div className="Themeprimarycolor theme-container-primary pickr-container-primary">
			<ColorPicker onChange={handleInput} value={state} />
		</div>
	);
};
export default Themeprimarycolor;

//themeBackground
export const Themebackgroundcolor = ({ actionfunction }: any) => {
	const theme = store.getState();
	const [state, updateState] = useState("#FFFFFF");
	const handleInput = (e: any) => {
		const { r, g, b }: any = hexToRgb(e.target.value);
		updateState(e.target.value);
		actionfunction({
			...theme,
			"bodyBg": `${r}, ${g}, ${b}`,
			"bodyBg1": `${r + 19}, ${g + 19}, ${b + 19}`,
			"Light": `${r + 19}, ${g + 19}, ${b + 19}`,
			"darkBg": `${r + 19}, ${g + 19}, ${b + 19}`,
			"sidemenuActiveBgcolor": `${r + 19} ${g + 19} ${b + 19}`,
			"inputBorder": "255, 255, 255, 0.1",
			"dataThemeMode": "dark",
			"dataHeaderStyles": localStorage.spruhaHeader ? localStorage.spruhaHeader : localStorage.spruhadarktheme ? "dark" : "dark",
			"dataMenuStyles": "dark"
		});
		localStorage.setItem("darkBgRGB1", `${r}, ${g}, ${b}`);
		localStorage.setItem("darkBgRGB2", `${r + 19}, ${g + 19}, ${b + 19}`);
		localStorage.setItem("LightRGB", `${r + 19}, ${g + 19}, ${b + 19}`);
		localStorage.setItem("darkBgRGB3", `${r + 19}, ${g + 19}, ${b + 19}`);
		localStorage.setItem("darkBgRGB4", "255, 255, 255, 0.1");
		localStorage.removeItem("spruhaMenu");
		localStorage.removeItem("spruhaHeader");

	};
	return (
		<div className="Themebackgroundcolor">
			<ColorPicker onChange={handleInput} value={state} />
		</div>
	);
};

export const Reset = (actionfunction: any) => {
	const theme = store.getState();
	Vertical(actionfunction);
	actionfunction({
		...theme,
		lang: "en",
		dir: "ltr",
		dataThemeMode: "light",
		dataMenuStyles: "dark",
		dataNavLayout: "vertical",
		dataHeaderStyles: "light",
		dataVerticalStyle: "overlay",
		StylebodyBg: "107 64 64",
		StyleDarkBg: "93 50 50",
		toggled: "",
		dataNavStyle: "",
		horStyle: "",
		dataPageStyle: "regular",
		dataWidth: "fullwidth",
		dataMenuPosition: "fixed",
		dataHeaderPosition: "fixed",
		loader: "disable",
		iconOverlay: "",
		colorPrimaryRgb: "",
		bodyBg1: "",
		bodyBg: "",
		Light: "",
		darkBg: "",
		sidemenuActiveBgcolor: "",
		inputBorder: "",
		bgImg: "",
		iconText: "",
		body: {
			class: ""
		}

	});
	localStorage.clear();
	const icon: any = switcherDoucmentIdSelector("switcher-default-menu");
	if (icon) {
		icon.checked = true;
	}
};


export const LocalStorageBackup = (actionfunction: any) => {
	(localStorage.spruhaltr) ? Ltr(actionfunction) : "";
	(localStorage.spruhartl) ? Rtl(actionfunction) : "";
	(localStorage.spruhadarktheme) ? Dark(actionfunction) : "";
	(localStorage.spruhalighttheme) ? Light(actionfunction) : "";
	(localStorage.spruharegular) ? Regular(actionfunction) : "";
	(localStorage.spruhaclassic) ? Classic(actionfunction) : "";
	(localStorage.spruhamodern) ? Modern(actionfunction) : "";
	(localStorage.spruhafullwidth) ? Fullwidth(actionfunction) : "";
	(localStorage.spruhaboxed) ? Boxed(actionfunction) : "";
	(localStorage.spruhamenufixed) ? FixedMenu(actionfunction) : "";
	(localStorage.spruhamenuscrollable) ? scrollMenu(actionfunction) : "";
	(localStorage.spruhaheaderfixed) ? Headerpostionfixed(actionfunction) : "";
	(localStorage.spruhaheaderscrollable) ? Headerpostionscroll(actionfunction) : "";

	(localStorage.spruhanavstyles === "menu-click") ? Menuclick(actionfunction) : "";
	(localStorage.spruhanavstyles === "menu-hover") ? MenuHover(actionfunction) : "";
	(localStorage.spruhanavstyles === "icon-click") ? IconClick(actionfunction) : "";
	(localStorage.spruhanavstyles === "icon-hover") ? IconHover(actionfunction) : "";
	(localStorage.bgImg) ? bgImage(actionfunction, localStorage.bgImg) : '';

	//(localStorage.bgimage1) ? bgImage1(actionfunction) : "";
	//(localStorage.bgimage2) ? bgImage2(actionfunction) : "";
	//(localStorage.bgimage3) ? bgImage3(actionfunction) : "";
	//(localStorage.bgimage4) ? bgImage4(actionfunction) : "";
	//(localStorage.bgimage5) ? bgImage5(actionfunction) : "";
	(localStorage.spruhalayout == "horizontal") && HorizontalClick(actionfunction);
	(localStorage.spruhalayout == "vertical") && Vertical(actionfunction);
	//primitive 
	if (
		localStorage.getItem("spruhaltr") == null ||
		localStorage.getItem("spruhaltr") == "ltr"
	)
		if (localStorage.getItem("spruhartl") == "rtl") {
			slidesArrow("body")?.classList.add("rtl");
			slidesArrow("html[lang=en]")?.setAttribute("dir", "rtl");
		}

	// Theme Primary: Colors: Start
	switch (localStorage.primaryRGB) {
		case "58, 88, 146":
			primaryColor1(actionfunction);

			break;
		case "92, 144, 163":
			primaryColor2(actionfunction);

			break;
		case "161, 90, 223":
			primaryColor3(actionfunction);

			break;
		case "78, 172, 76":
			primaryColor4(actionfunction);

			break;
		case "223, 90, 90":
			primaryColor5(actionfunction);

			break;
		default:
			break;
	}
	// Theme Primary: Colors: End

	switch (localStorage.darkBgRGB1) {
		case "20, 30, 96":
			backgroundColor1(actionfunction, "clicked");

			break;
		case "8, 78, 115":
			backgroundColor2(actionfunction, "clicked");

			break;
		case "90, 37, 135":
			backgroundColor3(actionfunction, "clicked");

			break;
		case "24, 101, 51":
			backgroundColor4(actionfunction, "clicked");

			break;
		case "120, 66, 20":
			backgroundColor5(actionfunction, "clicked");

			break;
		default:
			break;
	}

	//layout
	if (localStorage.spruhaverticalstyles) {
		const verticalStyles = localStorage.getItem("spruhaverticalstyles");

		switch (verticalStyles) {
			case "default":
				Defaultmenu(actionfunction);
				break;
			case "closed":
				Closedmenu(actionfunction);
				break;
			case "icontext":
				iconTextfn(actionfunction);
				break;
			case "overlay":
				iconOverayFn(actionfunction);
				break;
			case "detached":
				DetachedFn(actionfunction);
				break;
			case "doublemenu":
				DoubletFn(actionfunction);
				break;
		}
	}

	//Theme Primary:
	if (localStorage.dynamiccolor) {
		const theme = store.getState();
		actionfunction({
			...theme,
			"colorPrimaryRgb": localStorage.dynamiccolor,
			"colorPrimary": localStorage.dynamiccolor
		});
	}
	//Theme BAckground:
	if (localStorage.darkBgRGB1) {
		const theme = store.getState();
		actionfunction({
			...theme,
			"bodyBg": localStorage.darkBgRGB1,
			"bodyBg1": localStorage.darkBgRGB2,
			"Light": localStorage.LightRGB,
			"darkBg": localStorage.darkBgRGB3,
			"inputBorder": localStorage.darkBgRGB4,
			"sidemenuActiveBgcolor": localStorage.darkBgRGB2,
			"dataThemeMode": "dark",
			"dataHeaderStyles": localStorage.spruhaHeader ? localStorage.spruhaHeader : localStorage.spruhadarktheme ? "dark" : "dark",
			"dataMenuStyles": "dark",
		});
	}
	// ThemeColor MenuColor Start
	switch (localStorage.spruhaMenu) {
		case "light":
			lightMenu(actionfunction, "clicked");
			break;
		case "dark":
			darkMenu(actionfunction, "clicked");

			break;
		case "color":
			colorMenu(actionfunction, "clicked");

			break;
		case "gradient":
			gradientMenu(actionfunction, "clicked");

			break;
		case "transparent":
			transparentMenu(actionfunction, "clicked");

			break;
		default:
			break;
	}
	// ThemeColor Header Colors: start
	switch (localStorage.spruhaHeader) {
		case "light":
			lightHeader(actionfunction, "clicked");

			break;
		case "dark":
			darkHeader(actionfunction, "clicked");

			break;
		case "color":
			colorHeader(actionfunction, "clicked");

			break;
		case "gradient":
			gradientHeader(actionfunction, "clicked");

			break;
		case "transparent":
			transparentHeader(actionfunction, "clicked");

			break;
		default:
			break;
	}
};
