"use client";
import { Fragment, useEffect } from "react";
const Sidenavbar = () => {
    

    const SelectorAll = (selector: any) => document.querySelectorAll(selector);


    const handleClick = (e:any) => {
        e.preventDefault();
        const target = e.currentTarget.getAttribute("href");
        const location = document.getElementById(target.substring(1))?.offsetTop;
        if (location !== undefined) {
            window.scrollTo({
                left: 0,
                top: location - 64,
                behavior: "smooth",
            });
        }
    };

    useEffect(() => {
        const pageLinks = SelectorAll(".side-menu__item");
        pageLinks.forEach((elem) => {
            elem.addEventListener("click", handleClick);
        });

        

        return () => {
            // Clean up event listeners when the component unmounts
            pageLinks.forEach((elem) => {
                elem.removeEventListener("click", handleClick);
            });

            
        };
    }, []);

    

    return (
        <Fragment>
            <ul className="main-menu">
                <li className="slide"><a className="side-menu__item" href="#home"> <span className="side-menu__label">Home</span></a></li>
                <li className="slide"><a href="#features" className="side-menu__item"><span className="side-menu__label">Features</span></a></li>
                <li className="slide"><a href="#about" className="side-menu__item"><span className="side-menu__label">About</span></a></li>
                <li className="slide"><a href="#highlights" className="side-menu__item"><span className="side-menu__label">Highlights</span></a></li>
                <li className="slide"><a href="#faq" className="side-menu__item"><span className="side-menu__label">Faq's</span></a></li>
                <li className="slide"><a href="#Clients" className="side-menu__item"><span className="side-menu__label">Clients</span></a></li>
                <li className="slide"><a href="#contact" className="side-menu__item"><span className="side-menu__label">Contact</span></a></li>
            </ul>
        </Fragment>
    );
};

export default Sidenavbar;
