const multer = require('multer');
const path = require('path');

const storage = multer.memoryStorage(); // We'll use memory for processing with sharp
const upload = multer({
    storage,
    fileFilter: (req, file, cb) => {
        const ext = path.extname(file.originalname).toLowerCase();
        if (['.jpg', '.jpeg', '.png'].includes(ext)) cb(null, true);
        else cb(new Error('Only JPG, PNG images allowed'), false);
    }
});

module.exports = upload;
