const { DataTypes } = require('sequelize');
const bcrypt = require('bcryptjs');
const db = require('../config/db.config');
const RefreshToken = db.define('RefreshToken', {
    id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
    },
    admin_id: {
        type: DataTypes.STRING,
        allowNull: true
    },
    token: {
        type: DataTypes.TEXT,
        allowNull: true
    },
    token_expiry: {
        type: DataTypes.TEXT,
        allowNull: true
    }

}, {
    tableName: 'refresh_token',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at'
});

module.exports = RefreshToken;