const { DataTypes } = require('sequelize');
const bcrypt = require('bcryptjs');
const db = require('../config/db.config');

const ShortShift = db.define('ShortShift', {
    id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
    },
    current_admin: {
        type: DataTypes.STRING,
        allowNull: true
    },
    last_admin: {
        type: DataTypes.STRING,
        allowNull: true
    },
    amount: {
        type: DataTypes.STRING,
        allowNull: true
    }
}, {
    tableName: 'shortshifts',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at'
});

module.exports = ShortShift;