"use client";
import * as React from "react";
import {
  TableContainer,
  Table,
  TableRow,
  TableCell,
  TableBody,
  Avatar,
  Typography,
  TableHead,
  Chip,
  Box,
  AvatarGroup,
  Grid,
  Button,
} from "@mui/material";
import { Stack } from "@mui/system";

import BaseCard from "@/app/components/shared/BaseCard";
import {
  basicsTableData,
  EnTableType,
  TableType,
} from "@/app/components/tables/tableData";

import {
  createColumnHelper,
  flexRender,
  getCoreRowModel,
  useReactTable,
} from "@tanstack/react-table";

const basics = basicsTableData;

const columnHelper = createColumnHelper<EnTableType>();

const columns = [
  columnHelper.accessor("id", {
    header: () => "ID",
    cell: ({ row }) => (
      <Typography
        variant="h6"
        fontWeight={400}
      > {row.index + 1}</Typography>

    ),
  }),
  columnHelper.accessor("phone", {
    header: () => "Phone",
    cell: ({ row }) => (
      <Typography
        variant="h6"
        fontWeight={400}
      > {row.original.phone}</Typography>

    ),
  }),
  columnHelper.accessor("gameuser", {
    header: () => "Username",
    cell: ({ row }) => (
      <Typography
        variant="h6"
        fontWeight={400}
      > {row.original.gameuser}</Typography>
    ),
  }),
  {
    accessorKey: 'id',
    header: 'View',
    Cell: ({ row }: any) => (
      <Button
        color="primary"
        variant="contained"
        onClick={() => {
          // setSelectedRow(row.original);
          // setOpenDialog(true);
        }}
      >
        View
      </Button>
    )
  }
];

const TableBasicReact = ({ games }: any) => {
  // const [data, _setData] = React.useState<any>(() => [...basics]);

  const table = useReactTable({
    data: games,
    columns,
    getCoreRowModel: getCoreRowModel(),
  });


  return (
    (
    <BaseCard title="Creations">
      <Grid container spacing={3}>
        <Grid size={12}>
          <Box>
            <TableContainer>
              <Table
                sx={{
                  whiteSpace: "nowrap",
                }}
              >
                <TableHead>
                  {table.getHeaderGroups().map((headerGroup) => (
                    <TableRow key={headerGroup.id}>
                      {headerGroup.headers.map((header) => (
                        <TableCell key={header.id}>
                          <Typography variant="h6">
                            {header.isPlaceholder
                              ? null
                              : flexRender(
                                header.column.columnDef.header,
                                header.getContext()
                              )}
                          </Typography>
                        </TableCell>
                      ))}
                    </TableRow>
                  ))}
                </TableHead>
                <TableBody>
                  {table.getRowModel().rows.map((row) => (
                    <TableRow key={row.id}>
                      {row.getVisibleCells().map((cell) => (
                        <TableCell key={cell.id}>
                          {flexRender(
                            cell.column.columnDef.cell,
                            cell.getContext()
                          )}
                        </TableCell>
                      ))}
                    </TableRow>
                  ))}
                </TableBody>
              </Table>
            </TableContainer>
          </Box>
        </Grid>
      </Grid>
    </BaseCard>
    )
  );
};

export default TableBasicReact;
