// "use client";
// import Box from "@mui/material/Box";
// import Container from "@mui/material/Container";
// import { styled, useTheme } from "@mui/material/styles";
// import React, { useContext } from "react";
// import Header from "../layout/vertical/header/Header";
// import Sidebar from "../layout/vertical/sidebar/Sidebar";
// import Customizer from "../layout/shared/customizer/Customizer";
// import Navigation from "../layout/horizontal/navbar/Navigation";
// import HorizontalHeader from "../layout/horizontal/header/Header";
// import { CustomizerContext } from "@/app/context/customizerContext";
// import config from "@/app/context/config";

// const MainWrapper = styled("div")(() => ({
//   display: "flex",
//   minHeight: "100vh",
//   width: "100%",
// }));

// const PageWrapper = styled("div")(() => ({
//   display: "flex",
//   flexGrow: 1,
//   paddingBottom: "60px",
//   flexDirection: "column",
//   zIndex: 1,
//   width: "100%",
//   backgroundColor: "transparent",
// }));

// interface Props {
//   children: React.ReactNode;
// }

// export default function RootLayout({
//   children,
// }: {
//   children: React.ReactNode;
// }) {

//   const { activeLayout, isLayout, activeMode, isCollapse } = useContext(CustomizerContext);
//   const theme = useTheme();
//   const MiniSidebarWidth = config.miniSidebarWidth;
//   return (
//     <MainWrapper className={activeMode === 'dark' ? 'darkbg mainwrapper' : 'mainwrapper'}>
//       <title>Kiosk Admin</title>
//       {/* ------------------------------------------- */}
//       {/* Sidebar */}
//       {/* ------------------------------------------- */}
//       {activeLayout === 'horizontal' ? "" : <Sidebar />}
//       {/* ------------------------------------------- */}
//       {/* Main Wrapper */}
//       {/* ------------------------------------------- */}
//       <PageWrapper
//         className="page-wrapper"
//         sx={{
//           ...(isCollapse === "mini-sidebar" && {
//             [theme.breakpoints.up("lg")]: {
//               ml: `87px`,
//             },
//           }),
//         }}
//       >
//         {/* ------------------------------------------- */}
//         {/* Header */}
//         {/* ------------------------------------------- */}
//         {activeLayout === 'horizontal' ? <HorizontalHeader /> : <Header />}
//         {/* PageContent */}
//         {/* {activeLayout === 'horizontal' ? <Navigation /> : ""} */}
//         <Container
//           sx={{
//             pt: '30px',
//             maxWidth: isLayout === "boxed" ? "lg" : "100%!important",
//           }}
//         >
//           {/* ------------------------------------------- */}
//           {/* PageContent */}
//           {/* ------------------------------------------- */}

//           <Box sx={{ minHeight: "calc(100vh - 170px)" }}>
//             {/* <Outlet /> */}
//             {children}
//             {/* <Index /> */}
//           </Box>

//           {/* ------------------------------------------- */}
//           {/* End Page */}
//           {/* ------------------------------------------- */}
//         </Container>
//         <Customizer />
//       </PageWrapper>
//     </MainWrapper>
//   );
// }

"use client";
import Box from "@mui/material/Box";
import Container from "@mui/material/Container";
import { styled, useTheme } from "@mui/material/styles";
import React, { useContext } from "react";
import Header from "../layout/vertical/header/Header";
import Sidebar from "../layout/vertical/sidebar/Sidebar";
import Customizer from "../layout/shared/customizer/Customizer";
import Navigation from "../layout/horizontal/navbar/Navigation";
import HorizontalHeader from "../layout/horizontal/header/Header";
import { CustomizerContext } from "@/app/context/customizerContext";
import config from "@/app/context/config";
import { useSearchParams } from "next/navigation";

const MainWrapper = styled("div")(() => ({
  display: "flex",
  minHeight: "100vh",
  width: "100%",
}));

const PageWrapper = styled("div")(() => ({
  display: "flex",
  flexGrow: 1,
  paddingBottom: "60px",
  flexDirection: "column",
  zIndex: 1,
  width: "100%",
  backgroundColor: "transparent",
}));

export default function RootLayout({ children }: { children: React.ReactNode; }) {
  const { activeLayout, isLayout, activeMode, isCollapse } = useContext(CustomizerContext);
  const theme = useTheme();
  const searchParams = useSearchParams();
  const kioskId = searchParams?.get("kioskId") || searchParams?.get("kiosk_id"); // null if not present

  return (
    <MainWrapper className={activeMode === 'dark' ? 'darkbg mainwrapper' : 'mainwrapper'}>
      <title>Kiosk Admin</title>

      {/* Only render Sidebar when kioskId exists (a kiosk is selected) */}
      {activeLayout === 'horizontal' ? "" : (kioskId ? <Sidebar /> : null)}

      <PageWrapper
        className="page-wrapper"
        sx={{
          ...(isCollapse === "mini-sidebar" && {
            [theme.breakpoints.up("lg")]: {
              ml: `87px`,
            },
          }),
        }}
      >
        {activeLayout === 'horizontal' ? <HorizontalHeader /> : <Header />}

        <Container
          sx={{
            pt: '30px',
            maxWidth: isLayout === "boxed" ? "lg" : "100%!important",
          }}
        >
          <Box sx={{ minHeight: "calc(100vh - 170px)" }}>
            {children}
          </Box>
        </Container>

        <Customizer />
      </PageWrapper>
    </MainWrapper>
  );
}

