// middleware/apiLogger.js
const ApiLogs = require('../models/ApiLogs');

module.exports = function apiLogger(req, res, next) {
    const originalJson = res.json.bind(res);
    const originalSend = res.send.bind(res);

    let responseBody;

    res.json = function (body) {
        responseBody = body;
        return originalJson(body);
    };

    res.send = function (body) {
        responseBody = body;
        return originalSend(body);
    };

    res.on('finish', async () => {
        try {
            let clientIp =
                (req.headers['x-forwarded-for'] && req.headers['x-forwarded-for'].split(',')[0].trim()) ||
                req.headers['x-real-ip'] ||
                req.ip ||                          // uses trust proxy
                req.socket?.remoteAddress ||
                req.connection?.remoteAddress ||
                null;

            // Normalize IPv6 localhost (::1) to 127.0.0.1
            if (clientIp === '::1') {
                clientIp = '127.0.0.1';
            }
            if (clientIp && clientIp.startsWith('::ffff:')) {
                clientIp = clientIp.replace('::ffff:', '');
            }

            const requestData = {
                query: req.query,
                params: req.params,
                body: req.body,
            };

            let respToStore;
            try {
                if (Buffer.isBuffer(responseBody)) {
                    respToStore = responseBody.toString('utf8');
                } else if (typeof responseBody === 'string') {
                    respToStore = responseBody;
                } else {
                    respToStore = JSON.stringify(responseBody);
                }
            } catch (e) {
                respToStore = '[Unable to stringify response]';
            }

            // ------------------------------------
            // 🔥 Detect transaction ID automatically
            // ------------------------------------
            let txnId = null;
            const txnRoutes = [
                '/api/kiosk/deposit',
                '/api/kiosk/redeem',
                '/api/kiosk/cashout',
                '/api/kiosk/creation',
                '/api/kiosk/requestCreation',
                '/api/kiosk/approveCreation',
                '/api/kiosk/requestDeposit',
                '/api/kiosk/approveDeposit',
                '/api/kiosk/requestRedeem',
                '/api/kiosk/approveRedeem'
            ];
            // console.log(req.originalUrl)
            if (txnRoutes.includes(req.originalUrl)) {
                console.log("here")
                // if (txnRoutes.some(route => {
                //     req.originalUrl.startsWith(route),
                //         console.log("route", route)
                // })) {
                try {
                    // If response is JSON object → check for transaction id fields
                    console.log("txnid", responseBody)
                    if (responseBody) {
                        responseBody = JSON.parse(responseBody)
                        txnId =
                            responseBody.txn_id ||
                            responseBody.transactionId ||
                            responseBody.id ||
                            null;
                        console.log("nTxnId", txnId)

                    }
                } catch (e) {
                    txnId = null;
                }
            }

            await ApiLogs.create({
                ip: clientIp,
                method: req.method,
                name: req.originalUrl,
                request: JSON.stringify(requestData),
                response: respToStore,
                txn_id: txnId   // <--- now saves txn id
            });

        } catch (err) {
            console.error('Error saving API log:', err);
        }
    });

    next();
};
