const { DataTypes } = require('sequelize');
const bcrypt = require('bcryptjs');
const db = require('../config/db.config');
const KioskReceipts = db.define('KioskReceipts', {
    id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
    },
    receiptId: {
        type: DataTypes.STRING,
        allowNull: true
    },
    receiptType: {
        type: DataTypes.STRING,
        allowNull: true
    },
    storeName: {
        type: DataTypes.STRING,
        allowNull: true
    },
    storeAddress: {
        type: DataTypes.STRING,
        allowNull: true
    },
    items: {
        type: DataTypes.TEXT,
        allowNull: true
    },
    qr: {
        type: DataTypes.TEXT,
        allowNull: true
    },
    total: {
        type: DataTypes.STRING,
        allowNull: true
    },
    cardType: {
        type: DataTypes.STRING,
        allowNull: true
    },
    date: {
        type: DataTypes.STRING,
        allowNull: true
    },
    url: {
        type: DataTypes.STRING,
        allowNull: true
    },
   
}, {
    tableName: 'kiosk_receipts',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at'
});



module.exports = KioskReceipts;