const { DataTypes } = require('sequelize');
const bcrypt = require('bcryptjs');
const db = require('../config/db.config');
const KioskUser = db.define('KioskUser', {
    id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
    },
    swps_userid: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    phone: {
        type: DataTypes.STRING,
        allowNull: true
    },
    otp: {
        type: DataTypes.STRING,
        allowNull: true
    },
    balance: {
        type: DataTypes.STRING,
        allowNull: true
    },
    firstName: {
        type: DataTypes.STRING,
        allowNull: true
    },
    lastName: {
        type: DataTypes.STRING,
        allowNull: true
    },
    idenfy_authToken: {
        type: DataTypes.STRING,
        allowNull: true
    },
    idenfy_scanRef: {
        type: DataTypes.STRING,
        allowNull: true
    },
    idenfy_url: {
        type: DataTypes.STRING,
        allowNull: true
    },
    idenfy_url: {
        type: DataTypes.STRING,
        allowNull: true
    },
    idenfy_verified: {
        type: DataTypes.STRING,
        allowNull: true
    },
    idenfy_response: {
        type: DataTypes.STRING,
        allowNull: true
    },
    verifymobi_token: {
        type: DataTypes.STRING,
        allowNull: true
    },
    verifymobi_url: {
        type: DataTypes.STRING,
        allowNull: true
    },
}, {
    tableName: 'kiosk_user',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at'
});



module.exports = KioskUser;