const Admin = require('../models/Admin')
const {
    Game,
    KioskCreation,
    KioskTxns,
    Kiosks,
    KioskCashout,
    KioskUser,
    StackingNoteLog,
    ApiLogs
} = require('../models/Associations');
const { Op, where, fn, col, literal } = require('sequelize');
const bcrypt = require('bcryptjs');
const jwt = require('jsonwebtoken');
const axios = require('axios');
const path = require('path')
const date = require('date-and-time');
const moment = require('moment-timezone');
const crypto = require('crypto');
const qs = require('qs');
const fs = require('fs');

const FormData = require('form-data');
const db = require('../config/db.config')
const AutoIDs = require('../models/AutoIDs');
// const KioskUser = require('../models/KioskUser');
const { uuid } = require('uuid')
const QRCode = require('qrcode');
const KioskLoginToken = require('../models/KioskLoginToken');
const SweepLoginToken = require('../models/SweepLoginToken');
const F53Cassettes = require('../models/F53Cassettes');
// const Kiosks = require('../models/Kiosks');
const KioskNotes = require('../models/KioskNotes');
const StackingStats = require('../models/StackingStats');
const KioskReceipts = require('../models/KioskReceipts');

const mysql = require('mysql2');

require('dotenv').config()
const sendEmail = async (email, first, txn, game) => {
    const payload = {
        subject: 'Deposit info!',
        email: email,
        name: first,
        mail: `<!DOCTYPE html>
            <html lang="en" dir="ltr" xmlns:v="urn:schemas-microsoft-com:vml">
            <head>
              <meta charset="utf-8">
              <meta name="x-apple-disable-message-reformatting">
              <meta name="viewport" content="width=device-width, initial-scale=1">
              <meta name="format-detection" content="telephone=no, date=no, address=no, email=no, url=no">
              <title>Deposit info!</title>
              <style>
                .hover-bg-brand-600:hover {
                  background-color: #0047C3 !important;
                }
                .hover-text-brand-700:hover {
                  color: #003CA5 !important;
                }
                .hover-text-decoration-underline:hover {
                  text-decoration: underline !important;
                }
                @media (max-width: 640px) {
                  .sm-mt-4 {
                    margin-top: 16px !important;
                  }
                  .sm-block {
                    display: block !important;
                  }
                  .sm-w-full {
                    width: 100% !important;
                  }
                  .sm-px-4 {
                    padding-left: 16px !important;
                    padding-right: 16px !important;
                  }
                  .sm-py-6 {
                    padding-top: 24px !important;
                    padding-bottom: 24px !important;
                  }
                }
              </style>
            </head>
            <body style="margin: 0; width: 100%; background-color: #fff; padding: 0; -webkit-font-smoothing: antialiased; word-break: break-word">
              <div style="display: none">Deposit info!</div>
              <div role="article" aria-roledescription="email" aria-label="Please confirm your email address" lang="en">
                <table style="width: 100%; font-family: ui-sans-serif, system-ui, -apple-system, 'Segoe UI', sans-serif" cellpadding="0" cellspacing="0" role="none">
                  <tr>
                    <td align="center" style="background-color: #fff;">
                      <table class="sm-w-full" style="width: 768px;margin:0 auto" cellpadding="0" cellspacing="0" role="none">
                        <tr>
                          <td class="sm-px-4 sm-py-6" style="background-color: #fff; padding: 48px 40px; text-align: center">
                            <div style="margin-bottom: 24px">
                              <a href="https://wallet.sweepstake.mobi" style="text-decoration: none; color: #0047C3">
                                <p>SweepStake Mobi</p>
                              </a>
                            </div>
                            <p style="margin: 0; font-size: 21px; line-height: 28px; color: #4A5566">
                              Hi <b>${first}</b>,
                            </p>
                            <br>
                            <p style="margin: 0; font-size: 21px; line-height: 28px; color: #4A5566">
                            Your deposit of <b>$${txn.amount}</b> to <b>${game}</b> has been processed!
                            </p>
                            <br>
                            <br>
                            <p style="margin: 0; font-size: 21px; line-height: 28px; color: #4A5566;">
                            Thank you for choosing SweepStake Mobi!
                            </p>
                            <div role="separator" style="line-height: 16px">&zwj;</div> 
                            <div style="text-align: center;">
                              <div role="separator"
                                style="background-color: #E1E1EA; height: 1px; line-height: 1px; margin: 64px 0 16px">&zwj;</div>
                              <p style="margin: 0 0 16px; font-size: 12px; line-height: 16px; color: #8492A6">
                                This email was sent to you as a registered member of
                                <a href="https://sweepstake.mobi" class="hover-text-brand-700 hover-text-decoration-underline"
                                  style="text-decoration: none; color: #0047C3; display: inline-block;">SweepStake Mobi</a>. <span
                                  class="sm-block sm-mt-4">
                                  Use of the service and website is subject to our
                                  <a href="https://sweepstake.mobi/tnc.php" class="hover-text-brand-700 hover-text-decoration-underline"
                                    style="text-decoration: none; color: #0047C3; display: inline-block;">Terms of Use</a>
                                  and
                                  <a href="https://sweepstake.mobi/privacy-policy.php" class="hover-text-brand-700 hover-text-decoration-underline"
                                    style="text-decoration: none; color: #0047C3; display: inline-block;">Privacy Statement</a>.
                                </span>
                              </p>
                              <p style="margin: 0; font-size: 12px; line-height: 16px; color: #8492A6;">&copy; 2024 SweepStake Mobi. All
                                rights reserved.</p>
                            </div>
                          </td>
                        </tr>
                      </table>
                    </td>
                  </tr>
                </table>
              </div>
            </body>
            </html>`
    };

    try {
        const response = await axios.post('https://swback.logiclane.tech/api/email', payload, {
            headers: {
                'Content-Type': 'application/json',
                'Authorization': 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61'
            }
        });
        console.log(response.data);
    } catch (error) {
        console.error('Error sending email:', error.response ? error.response.data : error.message);
    }
};
const sendSMS = async (phone, otp) => {
    const url = 'https://swback.logiclane.tech/api/sms';
    const payload = {
        phone: phone,
        message: 'Your SweepStake Mobi verification code is: ' + otp
    };

    try {
        const response = await axios.post(url, payload, {
            headers: {
                'Content-Type': 'application/json',
                'Authorization': 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61'
            }
        });
        console.log('SMS sent successfully:', response.data);
    } catch (error) {
        console.error('Error sending SMS:', error.response ? error.response.data : error.message);
    }
};
const sendCreationSMS = async (phone, game, account, password) => {
    const url = 'https://swback.logiclane.tech/api/sms';
    const payload = {
        phone: phone,
        message: `Your ${game} Account: ${account}, Password: ${password}`
    };

    try {
        const response = await axios.post(url, payload, {
            headers: {
                'Content-Type': 'application/json',
                'Authorization': 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61'
            }
        });
        console.log('SMS sent successfully:', response.data);
    } catch (error) {
        console.error('Error sending SMS:', error.response ? error.response.data : error.message);
    }
};
exports.getAutoGameList = async (req, res) => {
    const ids = await AutoIDs.findAll({
        order: [['id', 'desc']],
    });
    const gameIds = ids.map(item => parseInt(item.gameid, 10)).sort((a, b) => a - b);
    const games = await Game.findAll({ where: { id: { [Op.in]: gameIds } }, attributes: ['id', 'name', 'enabled', 'isShow', 'image'] })
    if (!games) {
        return res.json({ status: 'error', message: 'Games not found' })
    }
    return res.json({ status: 'success', games })

}
exports.getAutoGameLists = async (req, res) => {
    try {
        const { phone } = req.body;

        if (!phone) {
            return res.status(400).json({ status: 'error', message: 'Phone is required' });
        }

        // 🧩 Step 1: Fetch AutoIDs and local games
        const ids = await AutoIDs.findAll({ order: [['id', 'desc']] });
        const gameIds = ids.map(item => parseInt(item.gameid, 10)).sort((a, b) => a - b);

        const games = await Game.findAll({
            where: { id: { [Op.in]: gameIds } },
            attributes: ['id', 'name', 'enabled', 'isShow', 'image']
        });

        if (!games || games.length === 0) {
            return res.json({ status: 'error', message: 'Games not found' });
        }

        // 🧩 Step 2: Fetch public games from external API
        let publicGames = [];
        try {
            const response = await axios.get('https://nodewall.logiclane.tech/api/getPublicGames');
            const json = JSON.parse(response?.data)
            // const json = typeof response.data === 'string' ? JSON.parse(response.data) : response.data;
            if (json?.status === 'success') {
                const games = json?.data
                publicGames = games;
            }
        } catch (error) {
            console.error('⚠️ Error fetching public games:', error.message);
            // Fallback: continue with local games only if external API fails
        }

        // 🧩 Step 3: Build a Set of enabled public game IDs
        const enabledPublicGameIDs = new Set(
            publicGames.filter(g => g.enabled === 1 || g.enabled === '1').map(g => g.id)
        );

        // 🧩 Step 4: Filter local games based on public games availability
        const filteredGames = games.filter(g => enabledPublicGameIDs.has(g.id));

        if (!filteredGames.length) {
            return res.json({ status: 'error', message: 'No enabled public games available' });
        }

        // 🧩 Step 5: Fetch linked accounts for these filtered games
        const linkedAccounts = await KioskCreation.findAll({
            where: {
                phone,
                gameid: { [Op.in]: filteredGames.map(g => g.id) }
            }
        });

        const linkedMap = {};
        linkedAccounts.forEach(account => {
            linkedMap[account.gameid] = account;
        });

        // 🧩 Step 6: Enrich game data
        const enrichedGames = filteredGames.map(game => {
            const linked = linkedMap[game.id];
            return {
                ...game.toJSON(),
                isAccount: linked && linked.status == '1' ? 1 : 0,
                isRequested: linked && linked.status == '0' ? 1 : 0,
                account: linked ? linked.toJSON() : {}
            };
        });

        return res.json({ status: 'success', games: enrichedGames });
    } catch (err) {
        console.error('❌ getAutoGameLists error:', err);
        return res.status(500).json({ status: 'error', message: 'Server error' });
    }
};
// exports.getAutoGameLists = async (req, res) => {
//     try {
//         const { phone } = req.body;

//         if (!phone) {
//             return res.status(400).json({ status: 'error', message: 'Phone is required' });
//         }

//         const ids = await AutoIDs.findAll({ order: [['id', 'desc']] });
//         const gameIds = ids.map(item => parseInt(item.gameid, 10)).sort((a, b) => a - b);

//         const games = await Game.findAll({
//             where: { id: { [Op.in]: gameIds } },
//             attributes: ['id', 'name', 'enabled', 'isShow', 'image']
//         });

//         if (!games || games.length === 0) {
//             return res.json({ status: 'error', message: 'Games not found' });
//         }

//         // Fetch all linked accounts for this user and these games
//         const linkedAccounts = await KioskCreation.findAll({
//             where: {
//                 phone,
//                 gameid: { [Op.in]: gameIds }
//             }
//         });

//         // Map linked game IDs to their creation data
//         const linkedMap = {};
//         linkedAccounts.forEach(account => {
//             linkedMap[account.gameid] = account;
//         });

//         // Build final game list
//         const enrichedGames = games.map(game => {
//             const linked = linkedMap[game.id];
//             return {
//                 ...game.toJSON(),
//                 // isAccount: linked ? 1 : 0,
//                 isAccount: linked && linked.status == '1' ? 1 : 0,
//                 // ✅ if linked account exists and status = 0 → requested = 1
//                 isRequested: linked && linked.status == '0' ? 1 : 0,
//                 account: linked ? linked.toJSON() : {}
//             };
//         });

//         return res.json({ status: 'success', games: enrichedGames });
//     } catch (err) {
//         console.error(err);
//         return res.status(500).json({ status: 'error', message: 'Server error' });
//     }
// };
// exports.getAutoGameLists = async (req, res) => {
//     try {
//         const { phone } = req.body; // assuming you get the user’s phone from the query

//         if (!phone) {
//             return res.status(400).json({ status: 'error', message: 'Phone is required' });
//         }

//         const ids = await AutoIDs.findAll({ order: [['id', 'desc']] });
//         const gameIds = ids.map(item => parseInt(item.gameid, 10)).sort((a, b) => a - b);

//         const games = await Game.findAll({
//             where: { id: { [Op.in]: gameIds } },
//             attributes: ['id', 'name', 'enabled', 'isShow', 'image']
//         });

//         if (!games || games.length === 0) {
//             return res.json({ status: 'error', message: 'Games not found' });
//         }

//         // fetch all linked accounts for this user and these games
//         const linkedAccounts = await KioskCreation.findAll({
//             where: {
//                 phone,
//                 gameid: { [Op.in]: gameIds }
//             }
//         });

//         // Create a map of linked gameids to their data
//         const linkedMap = {};
//         linkedAccounts.forEach(account => {
//             linkedMap[account.gameid] = account;
//         });

//         // build final list with `isAccount` flag and optional linked data
//         const enrichedGames = games.map(game => {
//             const linked = linkedMap[game.id];
//             return {
//                 ...game.toJSON(),
//                 isAccount: linked ? 1 : 0,
//                 isRequested: 1,
//                 account: linked ? linked.toJSON() : {}
//             };
//         });

//         return res.json({ status: 'success', games: enrichedGames });
//     } catch (err) {
//         console.error(err);
//         return res.status(500).json({ status: 'error', message: 'Server error' });
//     }
// };
exports.getCreationsByGame = async (req, res) => {
    try {
        const { id: gameid, page = 1, limit = 10, search = '' } = req.body;

        const authHeader = req.headers['authorization'] || req.headers['Authorization'];
        if (!authHeader) return res.status(401).send('Authorization header is missing');

        const token = authHeader.split(' ')[1];
        if (!token) return res.status(401).send('Token is missing');

        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        const adminId = decoded.id;

        const admin = await Admin.findOne({
            where: { id: adminId },
            attributes: { exclude: ['password', 'otp'] }
        });
        if (!admin) return res.status(404).send('Admin not found');

        const offset = (parseInt(page) - 1) * parseInt(limit);

        // Search condition
        const searchCondition = search
            ? {
                [Op.or]: [
                    { gameuser: { [Op.like]: `%${search}%` } },
                    { '$Game.name$': { [Op.like]: `%${search}%` } },
                    { '$KioskUser.phone$': { [Op.like]: `%${search}%` } },
                    { '$KioskUser.firstName$': { [Op.like]: `%${search}%` } },
                    { '$KioskUser.lastName$': { [Op.like]: `%${search}%` } }

                ]
            }
            : {};

        // ✅ Only include creations where status is 1 or 2
        const creations = await KioskCreation.findAndCountAll({
            where: {
                gameid,
                status: { [Op.in]: [1, 2] }, // Only 1 or 2
                ...searchCondition
            },
            include: [
                {
                    model: Game,
                    attributes: ['id', 'name'],
                    required: false
                },
                {
                    model: KioskUser,
                    attributes: ['id', 'phone', 'firstName', 'lastName'],
                    required: false
                }
            ],
            offset,
            limit: parseInt(limit),
            order: [['id', 'DESC']]
        });

        const game = await Game.findOne({
            where: { id: gameid },
            attributes: ['id', 'name']
        });

        return res.json({
            creations: creations.rows,
            totalCount: creations.count,
            totalPages: Math.ceil(creations.count / limit),
            currentPage: parseInt(page),
            game
        });

    } catch (error) {
        if (error.name === 'JsonWebTokenError' || error.name === 'TokenExpiredError') {
            return res.status(401).json({ error: 'Token is invalid or has expired' });
        }
        console.error(error);
        res.status(500).send('Internal server error');
    }
};
exports.getPendingCreationsByGame = async (req, res) => {
    try {
        const { id: gameid, page = 1, limit = 10, search = '' } = req.body;

        const authHeader = req.headers['authorization'] || req.headers['Authorization'];
        if (!authHeader) return res.status(401).send('Authorization header is missing');

        const token = authHeader.split(' ')[1];
        if (!token) return res.status(401).send('Token is missing');

        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        const adminId = decoded.id;

        const admin = await Admin.findOne({
            where: { id: adminId },
            attributes: { exclude: ['password', 'otp'] }
        });
        if (!admin) return res.status(404).send('Admin not found');

        const offset = (parseInt(page) - 1) * parseInt(limit);

        // Search condition
        const searchCondition = search
            ? {
                [Op.or]: [
                    { gameuser: { [Op.like]: `%${search}%` } },
                    { '$Game.name$': { [Op.like]: `%${search}%` } },
                    { '$KioskUser.phone$': { [Op.like]: `%${search}%` } },
                    { '$KioskUser.firstName$': { [Op.like]: `%${search}%` } },
                    { '$KioskUser.lastName$': { [Op.like]: `%${search}%` } },

                ]
            }
            : {};

        // Only pending creations (status = 0)
        const creations = await KioskCreation.findAndCountAll({
            where: {
                gameid,
                status: 0,
                ...searchCondition
            },
            include: [
                {
                    model: Game,
                    attributes: ['id', 'name'],
                    required: false
                },
                {
                    model: KioskUser,
                    attributes: ['id', 'phone', 'firstName', 'lastName'],
                    required: false
                }
            ],
            offset,
            limit: parseInt(limit),
            order: [['id', 'DESC']]
        });

        const game = await Game.findOne({
            where: { id: gameid },
            attributes: ['id', 'name']
        });

        return res.json({
            creations: creations.rows,
            totalCount: creations.count,
            totalPages: Math.ceil(creations.count / limit),
            currentPage: parseInt(page),
            game
        });

    } catch (error) {
        if (error.name === 'JsonWebTokenError' || error.name === 'TokenExpiredError') {
            return res.status(401).json({ error: 'Token is invalid or has expired' });
        }
        console.error(error);
        res.status(500).send('Internal server error');
    }
};
exports.getUsers = async (req, res) => {
    try {
        const { page = 1, limit = 10, search = '' } = req.body;
        const authHeader = req.headers['authorization'] || req.headers['Authorization'];
        if (!authHeader) return res.status(401).send('Authorization header is missing');

        const token = authHeader.split(' ')[1];
        if (!token) return res.status(401).send('Token is missing');

        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        const adminId = decoded.id;

        const admin = await Admin.findOne({
            where: { id: adminId },
            attributes: { exclude: ['password', 'otp'] }
        });
        if (!admin) return res.status(404).send('Admin not found');

        const offset = (parseInt(page) - 1) * parseInt(limit);
        // Search condition
        const searchCondition = search
            ? {
                [Op.or]: [
                    { firstName: { [Op.like]: `%${search}%` } },
                    { lastName: { [Op.like]: `%${search}%` } },
                    { phone: { [Op.like]: `%${search}%` } },
                    { phone: { [Op.like]: `%${search}%` } },
                ]
            }
            : {};

        const users = await KioskUser.findAndCountAll({
            where: {
                ...searchCondition
            },

            offset,
            limit: parseInt(limit),
            order: [['id', 'DESC']]
        });

        return res.json({
            users: users.rows,
            totalCount: users.count,
            totalPages: Math.ceil(users.count / limit),
            currentPage: parseInt(page)
        });
    } catch (error) {
        if (error.name === 'JsonWebTokenError' || error.name === 'TokenExpiredError') {
            return res.status(401).json({ error: 'Token is invalid or has expired' });
        }
        console.error(error);
        res.status(500).send('Internal server error');
    }
}

exports.viewUser = async (req, res) => {
    try {
        const { userId } = req.body;
        const authHeader = req.headers['authorization'] || req.headers['Authorization'];
        if (!authHeader) return res.status(401).send('Authorization header is missing');

        const token = authHeader.split(' ')[1];
        if (!token) return res.status(401).send('Token is missing');

        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        const adminId = decoded.id;

        const admin = await Admin.findOne({
            where: { id: adminId },
            attributes: { exclude: ['password', 'otp'] }
        });
        if (!admin) return res.status(404).send('Admin not found');

        const user = await KioskUser.findOne({
            where: { id: userId },
            include: [
                {
                    model: KioskCreation,
                    include: [{ model: Game }]
                },
                { model: KioskTxns },
                { model: KioskCashout }
            ]
        });
        if (!user) {
            return res.status(404).send('User not found');
        }
        res.json({ status: 'success', data: user })
    } catch (error) {
        if (error.name === 'JsonWebTokenError' || error.name === 'TokenExpiredError') {
            return res.status(401).json({ error: 'Token is invalid or has expired' });
        }
        console.error(error);
        res.status(500).send('Internal server error');
    }
}

exports.getDeposits = async (req, res) => {
    try {
        const { page = 1, limit = 10, search = '' } = req.body;
        const authHeader = req.headers['authorization'] || req.headers['Authorization'];
        if (!authHeader) return res.status(401).send('Authorization header is missing');

        const token = authHeader.split(' ')[1];
        if (!token) return res.status(401).send('Token is missing');

        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        const adminId = decoded.id;

        const admin = await Admin.findOne({
            where: { id: adminId },
            attributes: { exclude: ['password', 'otp'] }
        });
        if (!admin) return res.status(404).send('Admin not found');

        const offset = (parseInt(page) - 1) * parseInt(limit);

        // Search condition
        const searchCondition = search
            ? {
                [Op.or]: [
                    { gameuser: { [Op.like]: `%${search}%` } },
                    { '$Game.name$': { [Op.like]: `%${search}%` } },
                    { '$KioskUser.phone$': { [Op.like]: `%${search}%` } },
                    { '$KioskUser.firstName$': { [Op.like]: `%${search}%` } },
                    { '$KioskUser.lastName$': { [Op.like]: `%${search}%` } }


                ]
            }
            : {};

        const txns = await KioskTxns.findAndCountAll({
            where: {
                type: '1',
                ...searchCondition
            },
            include: [
                {
                    model: KioskUser,
                    attributes: ['id', 'phone', 'firstName', 'lastName'],
                    required: true
                },
                {
                    model: Game,
                    attributes: ['id', 'name'],
                    required: false
                }
            ],
            offset,
            limit: parseInt(limit),
            order: [['id', 'DESC']]
        });

        return res.json({
            txns: txns.rows,
            totalCount: txns.count,
            totalPages: Math.ceil(txns.count / limit),
            currentPage: parseInt(page)
        });

    } catch (error) {
        if (error.name === 'JsonWebTokenError' || error.name === 'TokenExpiredError') {
            return res.status(401).json({ error: 'Token is invalid or has expired' });
        }
        console.error(error);
        res.status(500).send('Internal server error');
    }
};
exports.getCashouts = async (req, res) => {
    try {
        const { page = 1, limit = 10, search = '' } = req.body;
        const authHeader = req.headers['authorization'] || req.headers['Authorization'];
        if (!authHeader) return res.status(401).send('Authorization header is missing');

        const token = authHeader.split(' ')[1];
        if (!token) return res.status(401).send('Token is missing');

        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        const adminId = decoded.id;

        const admin = await Admin.findOne({
            where: { id: adminId },
            attributes: { exclude: ['password', 'otp'] }
        });
        if (!admin) return res.status(404).send('Admin not found');

        const offset = (parseInt(page) - 1) * parseInt(limit);

        // Search condition
        const searchCondition = search
            ? {
                [Op.or]: [
                    { phone: { [Op.like]: `%${search}%` } },
                    { code: { [Op.like]: `%${search}%` } },
                ]
            }
            : {};

        const txns = await KioskCashout.findAndCountAll({
            where: {
                // type: '1',
                ...searchCondition
            },
            include: [
                {
                    model: KioskUser,
                    attributes: ['id', 'phone'],
                    required: true,
                    on: db.literal('CONVERT(`KioskCashout`.`phone` USING utf8mb4) = CONVERT(`KioskUser`.`phone` USING utf8mb4)')

                }

            ],
            offset,
            limit: parseInt(limit),
            order: [['id', 'DESC']]
        });

        return res.json({
            txns: txns.rows,
            totalCount: txns.count,
            totalPages: Math.ceil(txns.count / limit),
            currentPage: parseInt(page)
        });

    } catch (error) {
        if (error.name === 'JsonWebTokenError' || error.name === 'TokenExpiredError') {
            return res.status(401).json({ error: 'Token is invalid or has expired' });
        }
        console.error(error);
        res.status(500).send('Internal server error');
    }
};
// exports.getRedeems = async (req, res) => {
//     try {
//         const { page = 1, limit = 10 } = req.body;
//         const authHeader = req.headers['authorization'] || req.headers['Authorization'];
//         if (!authHeader) return res.status(401).send('Authorization header is missing');

//         const token = authHeader.split(' ')[1];
//         if (!token) return res.status(401).send('Token is missing');

//         const decoded = jwt.verify(token, process.env.JWT_SECRET);
//         const adminId = decoded.id;

//         const admin = await Admin.findOne({
//             where: { id: adminId },
//             attributes: { exclude: ['password', 'otp'] }
//         });
//         if (!admin) return res.status(404).send('Admin not found');

//         const offset = (parseInt(page) - 1) * parseInt(limit);
//         const txns = await KioskTxns.findAndCountAll({
//             where: { type: '2' },
//             include:
//                 [
//                     {
//                         model: KioskUser,
//                         attributes: ['id', 'phone'],
//                         required: true
//                     },
//                     {
//                         model: Game,
//                         attributes: ['id', 'name'],
//                         required: false
//                     }
//                 ]
//             ,
//             offset,
//             limit: parseInt(limit),
//             order: [['id', 'DESC']],
//         });


//         return res.json({
//             txns: txns.rows,
//             totalCount: txns.count,
//             totalPages: Math.ceil(txns.count / limit),
//             currentPage: parseInt(page),

//         });

//     } catch (error) {
//         if (error.name === 'JsonWebTokenError' || error.name === 'TokenExpiredError') {
//             return res.status(401).json({ error: 'Token is invalid or has expired' });
//         }
//         console.error(error);
//         res.status(500).send('Internal server error');
//     }
// }
exports.getRedeems = async (req, res) => {
    try {
        const { page = 1, limit = 10, search = '' } = req.body;
        const authHeader = req.headers['authorization'] || req.headers['Authorization'];
        if (!authHeader) return res.status(401).send('Authorization header is missing');

        const token = authHeader.split(' ')[1];
        if (!token) return res.status(401).send('Token is missing');

        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        const adminId = decoded.id;

        const admin = await Admin.findOne({
            where: { id: adminId },
            attributes: { exclude: ['password', 'otp'] }
        });
        if (!admin) return res.status(404).send('Admin not found');

        const offset = (parseInt(page) - 1) * parseInt(limit);

        // Search condition
        const searchCondition = search
            ? {
                [Op.or]: [
                    { gameuser: { [Op.like]: `%${search}%` } },
                    { '$Game.name$': { [Op.like]: `%${search}%` } },
                    { '$KioskUser.phone$': { [Op.like]: `%${search}%` } }
                ]
            }
            : {};

        const txns = await KioskTxns.findAndCountAll({
            where: {
                type: '2',
                ...searchCondition
            },
            include: [
                {
                    model: KioskUser,
                    attributes: ['id', 'phone'],
                    required: true
                },
                {
                    model: Game,
                    attributes: ['id', 'name'],
                    required: false
                }
            ],
            offset,
            limit: parseInt(limit),
            order: [['id', 'DESC']]
        });

        return res.json({
            txns: txns.rows,
            totalCount: txns.count,
            totalPages: Math.ceil(txns.count / limit),
            currentPage: parseInt(page)
        });

    } catch (error) {
        if (error.name === 'JsonWebTokenError' || error.name === 'TokenExpiredError') {
            return res.status(401).json({ error: 'Token is invalid or has expired' });
        }
        console.error(error);
        res.status(500).send('Internal server error');
    }
};
exports.deposit = async (req, res) => {

    const { gameid, gameuser, amount, phone, balanceAmount, combination } = req.body;
    if (Number(balanceAmount) > 100) {
        return res.status(200).json({
            error: 'Maximum allowed deposit amount is 100'
        });
    }

    if (Number(balanceAmount) > 0) {
        const user = await KioskUser.findOne({ where: { phone } });

        if (!user) {
            return res.status(200).json({ error: 'User not found' });
        }

        if (Number(balanceAmount) > Number(user.balance)) {
            return res.status(200).json({ error: 'Insufficient Balance' });
        }
    }
    if (balanceAmount > 0) {
        const user = await KioskUser.findOne({ where: { phone: phone } })
        if (user) {
            await user.decrement('balance', { by: balanceAmount });
        }
    }
    if (gameid == '38') {
        const fpuserid = gameuser;
        const timestamp = Math.floor(Date.now() / 1000);
        const hash = crypto.createHash('md5')
            .update(`ramon1kUfpv2qECNZkYsg3hcu7${timestamp}`)
            .digest('hex')
            .toUpperCase();

        const payload = {
            action: 'setUserScore',
            keyAgent: 'ramon1',
            account: fpuserid,
            time: timestamp,
            token: hash,
            scoreNum: amount,
            ts: 0.7216318002132696
        };

        try {
            const response = await axios.post(
                'https://api.fpc-mob.com/ashx/CheckAccount.ashx',
                qs.stringify(payload),
                { headers: { 'Content-Type': 'application/x-www-form-urlencoded' } }
            );

            const resultJson = response.data;

            if (resultJson && resultJson.success === true) {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '1'
                })

                // if (balanceAmount > 0) {
                //     const user = await KioskUser.findOne({ where: { phone: phone } })
                //     if (user) {
                //         await user.decrement('balance', { by: balanceAmount });
                //     }
                // }
                return res.status(200).json({ id: txn?.id, message: 'Transaction approved' });
            } else {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '2', // failed
                    failure_reason: resultJson?.msg ?? 'Game not operational'
                });
                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txn?.id, error: "Game is currently not operational" ?? 'Unknown error' });
            }
        } catch (error) {
            const user = await KioskUser.findOne({ where: { phone: phone } })
            if (user) {
                await user.increment('balance', { by: amount });
            }
            return res.status(200).json({ error: error.message });
        }
    }
    else if (gameid == '29') {
        const amt = amount + ".00";
        const data = {
            account: gameuser,
            setScore: amt
        };

        const secret = '7378ae5ce34d408587ceae38ad3dabca';
        const key = 'A1asd4fhu4E45Gdmk';
        const hash = getHash(JSON.stringify(data), secret, key);

        const url = `https://swback.logiclane.tech/api/mjb/depositwithdraw?hash=${hash}&account=${gameuser}&amount=${amt}&type=deposit`;

        try {
            const response = await axios.get(url, {
                headers: { 'Content-Type': 'application/json' },
                data
            });

            const resultJson = response.data;

            if (resultJson && resultJson.status === 'success') {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '1'
                })
                // if (balanceAmount > 0) {
                //     const user = await KioskUser.findOne({ where: { phone: phone } })
                //     if (user) {
                //         await user.decrement('balance', { by: balanceAmount });
                //     }
                // }

                return res.status(200).json({ id: txn?.id, message: 'Transaction approved' });
            } else {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '2', // failed
                    failure_reason: resultJson?.msg ?? 'Game not operational'
                });
                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txn?.id, error: "Game is currently not operational" ?? 'Unknown error' });

            }
        } catch (error) {
            const user = await KioskUser.findOne({ where: { phone: phone } })
            if (user) {
                await user.increment('balance', { by: amount });
            }
            return res.status(200).json({ error: error.message });
        }
    }
    else if (gameid == '20') {
        const galaxyuser = await KioskCreation.findOne({
            where: { gameuser: gameuser }
        });

        const timestamp = Math.floor(Date.now() / 1000);
        const signatureString = `52277:${timestamp}:d620176e98baec2c8a3e5b5fcc24d47c`;
        const signature = crypto.createHash('md5').update(signatureString).digest('hex');
        let guser = galaxyuser?.gameuserid;
        // let guser = gameuser

        try {

            const depositForm = new FormData();
            depositForm.append('agent_id', '52277');
            depositForm.append('timestamp', timestamp);
            depositForm.append('token', signature);
            depositForm.append('amount', amount);
            depositForm.append('user_id', guser);

            const depositRes = await axios.post(
                'https://swback.logiclane.tech/api/galaxy/deposit',
                depositForm,
                { headers: depositForm.getHeaders() }
            );

            const resultJson = depositRes.data;
            if (resultJson && resultJson.msg === 'Success') {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '1'
                })

                // if (balanceAmount > 0) {
                //     const user = await KioskUser.findOne({ where: { phone: phone } })
                //     if (user) {
                //         await user.decrement('balance', { by: balanceAmount });
                //     }
                // }
                return res.status(200).json({ id: txn?.id, message: 'Transaction approved' });
            } else {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '2', // failed
                    failure_reason: resultJson?.msg ?? 'Game not operational'
                });
                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txn?.id, error: "Game is currently not operational" ?? 'Unknown error' });
            }
        } catch (error) {
            const user = await KioskUser.findOne({ where: { phone: phone } })
            if (user) {
                await user.increment('balance', { by: amount });
            }
            return res.status(200).json({ error: error.message });
        }
    }
    else if (gameid == '3') {
        const guser = gameuser;
        // const url = https://gvmck6p5yqtfagp.riversweeps.game/public/apis/rs/depositAccount.php?code=${guser}&amount=${amount}&bounce=1;
        const url = `https://swback.logiclane.tech/api/rs/depositAccount?code=${guser}&amount=${amount}&bounce=1`;


        axios({
            method: 'get',
            url: url,
            headers: {
                'Content-Type': 'application/json',
                'Authorization': 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61'
            }
        }).then(async (response) => {
            const resultJson = response.data;
            // console.log(resultJson);
            if (resultJson && resultJson.STATUS == '0') {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '1'
                })
                // if (balanceAmount > 0) {
                //     const user = await KioskUser.findOne({ where: { phone: phone } })
                //     if (user) {
                //         await user.decrement('balance', { by: balanceAmount });
                //     }
                // }
                return res.status(200).json({ id: txn?.id, message: 'Transaction approved' });
            } else if (resultJson && resultJson.STATUS == '1') {
                const guser = gameuser;
                // const url = https://gvmck6p5yqtfagp.riversweeps.game/public/apis/rs/depositAccount.php?code=${guser}&amount=${amount};
                const url = `https://swback.logiclane.tech/api/rs/depositAccount?code=${guser}&amount=${amount}`;
                axios({
                    method: 'get',
                    url: url,
                    headers: {
                        'Content-Type': 'application/json',
                        'Authorization': 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61'
                    }
                }).then(async (response) => {
                    const resultJson = response.data;
                    // console.log(resultJson);
                    if (resultJson && resultJson.STATUS == '0') {
                        const txnCreate = await KioskTxns.create({
                            phone: phone,
                            gameuser: gameuser,
                            gameid: gameid,
                            amount: amount,
                            type: '1',
                            status: '1'
                        })

                        // if (balanceAmount > 0) {
                        //     const user = await KioskUser.findOne({ where: { phone: phone } })
                        //     if (user) {
                        //         await user.decrement('balance', { by: amount });
                        //     }
                        // }
                        return res.status(200).json({ id: txnCreate?.id, message: 'Transaction approved' });
                    }
                }).catch(async (error) => {
                    const txn = await KioskTxns.create({
                        phone: phone,
                        gameuser: gameuser,
                        gameid: gameid,
                        amount: amount,
                        type: '1',
                        combination: JSON.stringify(combination) ?? '',
                        status: '2', // failed
                        failure_reason: resultJson?.msg ?? 'Game not operational'
                    });
                    const user = await KioskUser.findOne({ where: { phone: phone } })
                    if (user) {
                        await user.increment('balance', { by: amount });
                    }
                    return res.status(200).json({ id: txn?.id, error: "Game is currently not operational" ?? 'Unknown error' });
                    // const user = await KioskUser.findOne({ where: { phone: phone } })
                    // if (user) {
                    //     await user.increment('balance', { by: amount });
                    // }
                    // return res.status(200).json({ error: error.message });
                })
            } else {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '2', // failed
                    failure_reason: resultJson?.msg ?? 'Game not operational'
                });
                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txn?.id, error: "Game is currently not operational" ?? 'Unknown error' });
                // const user = await KioskUser.findOne({ where: { phone: phone } })
                // if (user) {
                //     await user.increment('balance', { by: amount });
                // }
                // return res.status(200).json({ error: resultJson?.message ?? '' });

            }
        }).catch(async (error) => {
            const user = await KioskUser.findOne({ where: { phone: phone } })
            if (user) {
                await user.increment('balance', { by: amount });
            }
            console.error('Error: ', error.message);
            return res.status(200).json({ error: error.message });
        })

    }
    else if (gameid == '49') {
        const account = gameuser;
        let amount = amount;
        const nowDenver = moment.tz('America/Denver').format('YYYY-MM-DD');

        try {


            const url = `https://swback.logiclane.tech/api/fp/depositAccount?account=${account}&amount=${amount}`;
            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

            const response = await axios.get(url, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            });

            const resultJson = response.data;
            if (resultJson && resultJson.code == '200') {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '1'
                })
                // if (balanceAmount > 0) {
                //     const user = await KioskUser.findOne({ where: { phone: phone } })
                //     if (user) {
                //         await user.decrement('balance', { by: balanceAmount });
                //     }
                // }

                return res.status(200).json({ id: txn?.id, message: 'Transaction approved' });
            } else {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '2', // failed
                    failure_reason: resultJson?.msg ?? 'Game not operational'
                });
                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txn?.id, error: "Game is currently not operational" ?? 'Unknown error' });
            }
        } catch (error) {
            const user = await KioskUser.findOne({ where: { phone: phone } })
            if (user) {
                await user.increment('balance', { by: amount });
            }
            return res.status(200).json({ error: error.message });
        }
    }
    else if (gameid == '7') {
        const account = gameuser;
        // const amount = amount;

        try {
            const url = `https://swback.logiclane.tech/api/bd/depositWithdraw?account=${account}&amount=${amount}&type=deposit`;
            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

            const response = await axios.get(url, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            });

            const resultJson = response.data;
            if (resultJson && resultJson.code == '0') {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '1'
                })
                // if (balanceAmount > 0) {
                //     const user = await KioskUser.findOne({ where: { phone: phone } })
                //     if (user) {
                //         await user.decrement('balance', { by: balanceAmount });
                //     }
                // }

                return res.status(200).json({ id: txn?.id, message: 'Transaction approved' });
            } else {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '2', // failed
                    failure_reason: resultJson?.msg ?? 'Game not operational'
                });
                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txn?.id, error: "Game is currently not operational" ?? 'Unknown error' });
            }
        } catch (error) {
            const user = await KioskUser.findOne({ where: { phone: phone } })
            if (user) {
                await user.increment('balance', { by: amount });
            }
            return res.status(200).json({ error: error.message });
        }
    }
    else if (gameid == '45') {
        try {
            const account = gameuser;
            // const amount = amount;

            const url = `https://swback.logiclane.tech/api/fd/depositWithdraw?account=${account}&amount=${amount}&type=deposit`;

            const response = await axios.get(url, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61'
                }
            });

            const resultJson = response.data;

            // txn.txn_type = 'auto';
            // txn.api_response = JSON.stringify(resultJson);

            if (resultJson && resultJson.code == '0') {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '1'
                })

                // if (balanceAmount > 0) {
                //     const user = await KioskUser.findOne({ where: { phone: phone } })
                //     if (user) {
                //         await user.decrement('balance', { by: balanceAmount });
                //     }
                // }
                return res.status(200).json({ id: txn?.id, message: 'Transaction approved' });
            } else {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '2', // failed
                    failure_reason: resultJson?.msg ?? 'Game not operational'
                });
                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txn?.id, error: "Game is currently not operational" ?? 'Unknown error' });
            }

        } catch (error) {
            const user = await KioskUser.findOne({ where: { phone: phone } })
            if (user) {
                await user.increment('balance', { by: amount });
            }
            return res.status(200).json({ error: error.message });
        }
    }
    else if (gameid == '47') {
        try {
            const account = gameuser;
            // const amount = amount;
            const timestamp = Math.floor(Date.now() / 1000);
            const order_id = Math.floor(Date.now() / 1000);

            const secretKey = "L2K8GV89R9H92MY4YCY4DTL6U4RYGA8R";
            const auth_code = "PQEH73ZS53QDGUPF4W9JBJGAHV3UBGVX";

            const sign = crypto
                .createHash('sha1')
                .update(`${account}${timestamp}${secretKey}`)
                .digest('hex');

            const postData = {
                order_id,
                username: account,
                amount,
                timestamp,
                sign,
                auth_code
            };

            const url = "https://swback.logiclane.tech/api/es/deposit";
            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

            const response = await axios.post(url, postData, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            });

            const resultJson = response.data;

            // txn.txn_type = 'auto';
            // txn.api_response = JSON.stringify(resultJson);

            if (resultJson && resultJson.status === 'OK') {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '1'
                })

                // if (balanceAmount > 0) {
                //     const user = await KioskUser.findOne({ where: { phone: phone } })
                //     if (user) {
                //         await user.decrement('balance', { by: balanceAmount });
                //     }
                // }
                return res.status(200).json({ id: txn?.id, message: 'Transaction approved' });
            } else {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '2', // failed
                    failure_reason: resultJson?.msg ?? 'Game not operational'
                });
                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txn?.id, error: "Game is currently not operational" ?? 'Unknown error' });
            }

        } catch (error) {
            const user = await KioskUser.findOne({ where: { phone: phone } })
            if (user) {
                await user.increment('balance', { by: amount });
            }
            return res.status(200).json({ error: error.message });
        }
    }
    else if (gameid == '48') {
        try {
            const account = gameuser;
            // const amount = amount;
            const timestamp = Math.floor(Date.now() / 1000);
            const order_id = timestamp;

            const secretKey = "D8R6BRLGMXUL6VT52LMQJRM8QRU5RPDR";
            const auth_code = "VVKYHAFHKWRWSS8KY2XE6AE3XUNVEVUD";

            const sign = crypto
                .createHash('sha1')
                .update(`${account}${timestamp}${secretKey}`)
                .digest('hex');

            const postData = {
                order_id,
                username: account,
                amount,
                timestamp,
                sign,
                auth_code
            };

            const url = "https://swback.logiclane.tech/api/ml/deposit";
            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

            const response = await axios.post(url, postData, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            });

            const resultJson = response.data;

            if (resultJson && resultJson.status === 'OK') {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '1'
                })

                // if (balanceAmount > 0) {
                //     const user = await KioskUser.findOne({ where: { phone: phone } })
                //     if (user) {
                //         await user.decrement('balance', { by: balanceAmount });
                //     }
                // }
                return res.status(200).json({ id: txn?.id, message: 'Transaction approved' });
            } else {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '2', // failed
                    failure_reason: resultJson?.msg ?? 'Game not operational'
                });
                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txn?.id, error: "Game is currently not operational" ?? 'Unknown error' });
            }
        } catch (error) {
            const user = await KioskUser.findOne({ where: { phone: phone } })
            if (user) {
                await user.increment('balance', { by: amount });
            }
            return res.status(200).json({ error: error.message });
        }
    }
    else if (gameid == '14') {
        try {
            const account = gameuser;
            // const amount = amount;
            const order_id = Math.floor(Date.now() / 1000);
            const timestamp = Date.now();

            const secretKey = "YHJGHFVMNFZF3YUAQGL6HWDRKWKUGVSB";
            const agent_key = "HCFYPWXYQFVKUQ2X8MXWKTT86EKLY2FG";

            const sign_string = `${agent_key}${timestamp}${secretKey}`;
            const sign = crypto.createHash('md5').update(sign_string, 'utf8').digest('hex');

            const postData = {
                order_id,
                username: account,
                amount,
                timestamp,
                sign,
                agent_key
            };

            const url = "https://swback.logiclane.tech/api/ostars/deposit";
            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

            const response = await axios.post(url, postData, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            });

            const resultJson = response.data;

            if (resultJson && resultJson.status === 'OK') {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '1'
                })
                // if (balanceAmount > 0) {
                //     const user = await KioskUser.findOne({ where: { phone: phone } })
                //     if (user) {
                //         await user.decrement('balance', { by: balanceAmount });
                //     }
                // }

                return res.status(200).json({ id: txn?.id, message: 'Transaction approved' });
            } else {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '2', // failed
                    failure_reason: resultJson?.msg ?? 'Game not operational'
                });
                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txn?.id, error: "Game is currently not operational" ?? 'Unknown error' });
            }
        } catch (error) {
            const user = await KioskUser.findOne({ where: { phone: phone } })
            if (user) {
                await user.increment('balance', { by: amount });
            }
            return res.status(200).json({ error: error.message });
        }
    }
    else if (gameid == '6') {
        try {
            const account = gameuser;
            const amountx = amount * 100; // Convert to smallest unit if needed
            const url = `https://swback.logiclane.tech/api/stx/depositAccount?login=${account}&amount=${amountx}`;

            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

            const response = await axios.get(url, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            });

            const resultJson = response.data;

            if (resultJson && (resultJson.status === '1' || resultJson.status === 1)) {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '1'
                })

                // if (balanceAmount > 0) {
                //     const user = await KioskUser.findOne({ where: { phone: phone } })
                //     if (user) {
                //         await user.decrement('balance', { by: balanceAmount });
                //     }
                // }
                return res.status(200).json({ id: txn?.id, message: 'Transaction approved' });
            } else {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '2', // failed
                    failure_reason: resultJson?.msg ?? 'Game not operational'
                });
                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txn?.id, error: "Game is currently not operational" ?? 'Unknown error' });
            }
        } catch (error) {
            const user = await KioskUser.findOne({ where: { phone: phone } })
            if (user) {
                await user.increment('balance', { by: amount });
            }
            return res.status(200).json({ error: error.message });
        }
    }
    else if (gameid == '50') {
        try {
            const account = gameuser;
            // const amount = amount;
            const url = `https://swback.logiclane.tech/api/dg/depositAccount?account=${account}&amount=${amount}`;
            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

            const response = await axios.get(url, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            });

            const resultJson = response.data;

            if (resultJson?.status === 'OK') {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '1'
                })

                // if (balanceAmount > 0) {
                //     const user = await KioskUser.findOne({ where: { phone: phone } })
                //     if (user) {
                //         await user.decrement('balance', { by: balanceAmount });
                //     }
                // }
                return res.status(200).json({ id: txn?.id, message: 'Transaction approved' });
            } else {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '2', // failed
                    failure_reason: resultJson?.msg ?? 'Game not operational'
                });
                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txn?.id, error: "Game is currently not operational" ?? 'Unknown error' });
            }
        } catch (error) {
            const user = await KioskUser.findOne({ where: { phone: phone } })
            if (user) {
                await user.increment('balance', { by: amount });
            }
            return res.status(200).json({ error: error.message });
        }
    }

    else if (gameid == '51') {
        try {
            const account = gameuser;
            // const amount = amount;

            const jack2user = await Creation.findOne({ where: { gdid: account } });

            if (!jack2user) {
                return res.status(404).json({ error: 'Game user not found in Creation table' });
            }

            const jack2userid = jack2user.gdid;
            const url = `https://swback.logiclane.tech/api/jwin/depositWithdraw?account=${jack2userid}&amount=${amount}&type=deposit`;
            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

            const response = await axios.get(url, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            });

            const resultJson = response.data;

            if (resultJson?.code === '0' || resultJson?.code === 0) {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '1'
                })
                // if (balanceAmount > 0) {
                //     const user = await KioskUser.findOne({ where: { phone: phone } })
                //     if (user) {
                //         await user.decrement('balance', { by: balanceAmount });
                //     }
                // }

                return res.status(200).json({ id: txn?.id, message: 'Transaction approved' });
            } else {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '2', // failed
                    failure_reason: resultJson?.msg ?? 'Game not operational'
                });
                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txn?.id, error: "Game is currently not operational" ?? 'Unknown error' });
            }
        } catch (error) {
            const user = await KioskUser.findOne({ where: { phone: phone } })
            if (user) {
                await user.increment('balance', { by: amount });
            }
            return res.status(200).json({ error: error.message });
        }
    }

    else if (gameid == '2') {

        const account = gameuser;
        // const amount = amount;
        const url = `https://swback.logiclane.tech/api/fk/depositAccount?account=${account}&amount=${amount}`;
        const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

        try {
            const response = await axios.get(url, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            });

            const resultJson = response.data;

            if (resultJson?.code === '200' || resultJson?.code === 200) {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '1'
                })

                // if (balanceAmount > 0) {
                //     const user = await KioskUser.findOne({ where: { phone: phone } })
                //     if (user) {
                //         await user.decrement('balance', { by: balanceAmount });
                //     }
                // }

                return res.status(200).json({ id: txn?.id, message: 'Transaction approved' });
            } else {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '2', // failed
                    failure_reason: resultJson?.msg ?? 'Game not operational'
                });
                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txn?.id, error: "Game is currently not operational" ?? 'Unknown error' });
            }

        } catch (error) {
            const user = await KioskUser.findOne({ where: { phone: phone } })
            if (user) {
                await user.increment('balance', { by: amount });
            }
            console.error('Error: ', error.message);
            return res.status(200).json({ error: error.message });
        }
    }
    else if (gameid == '18') {
        const account = gameuser;
        // const amount = amount;
        const url = `https://swback.logiclane.tech/api/pm/depositAccount?account=${account}&amount=${amount}`;
        const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

        try {
            const response = await axios.get(url, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            });

            const resultJson = response.data;

            if (resultJson?.code === '200' || resultJson?.code === 200) {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '1'
                })

                // if (balanceAmount > 0) {
                //     const user = await KioskUser.findOne({ where: { phone: phone } })
                //     if (user) {
                //         await user.decrement('balance', { by: balanceAmount });
                //     }
                // }
                return res.status(200).json({ id: txn?.id, message: 'Transaction approved' });
            } else {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '2', // failed
                    failure_reason: resultJson?.msg ?? 'Game not operational'
                });
                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txn?.id, error: "Game is currently not operational" ?? 'Unknown error' });
            }
        } catch (error) {
            const user = await KioskUser.findOne({ where: { phone: phone } })
            if (user) {
                await user.increment('balance', { by: amount });
            }
            return res.status(200).json({ error: error.message });
        }
    }
    else if (gameid == '10') {
        const account = gameuser;
        // const amount = amount;
        const url = `https://swback.logiclane.tech/api/kr/depositAccount?account=${account}&amount=${amount}`;
        // const url = `http://localhost/api/kr/depositAccount?account=${account}&amount=${amount}`;

        const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

        try {
            const response = await axios.get(url, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            });

            const resultJson = response.data;

            if (resultJson?.code === '200' || resultJson?.code === 200) {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '1'
                })

                // if (balanceAmount > 0) {
                //     const user = await KioskUser.findOne({ where: { phone: phone } })
                //     if (user) {
                //         await user.decrement('balance', { by: balanceAmount });
                //     }
                // }
                return res.status(200).json({ id: txn?.id, message: 'Transaction approved' });
            } else {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '2', // failed
                    failure_reason: resultJson?.msg ?? 'Game not operational'
                });
                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txn?.id, error: "Game is currently not operational" ?? 'Unknown error' });
            }
        } catch (error) {
            const user = await KioskUser.findOne({ where: { phone: phone } })
            if (user) {
                await user.increment('balance', { by: amount });
            }
            return res.status(200).json({ error: error.message });
        }
    }
    else if (gameid == '53') {
        try {
            const account = gameuser;
            // const amount = amount;

            const url = `https://swback.logiclane.tech/api/gs/depositUser`;
            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

            const data = {
                userName: account,
                amount: amount
            }

            const response = await axios.post(url, data, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            });

            const resultJson = response.data;

            if (resultJson?.code === '200' || resultJson?.code === 200) {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '1'
                })
                // if (balanceAmount > 0) {
                //     const user = await KioskUser.findOne({ where: { phone: phone } })
                //     if (user) {
                //         await user.decrement('balance', { by: balanceAmount });
                //     }
                // }

                return res.status(200).json({ id: txn?.id, message: 'Transaction approved' });
            } else {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '2', // failed
                    failure_reason: resultJson?.msg ?? 'Game not operational'
                });
                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txn?.id, error: "Game is currently not operational" ?? 'Unknown error' });
            }
        } catch (error) {
            const user = await KioskUser.findOne({ where: { phone: phone } })
            if (user) {
                await user.increment('balance', { by: amount });
            }
            return res.status(200).json({ error: error.message });
        }
    }
    else if (gameid == '54') {
        try {
            const account = gameuser;
            // const amount = amount;

            const url = `https://swback.logiclane.tech/api/cc/depositUser`;
            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

            const data = {
                userName: account,
                amount: amount
            }

            const response = await axios.post(url, data, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            });

            const resultJson = response.data;

            if (resultJson?.code === '200' || resultJson?.code === 200) {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '1'
                })
                // if (balanceAmount > 0) {
                //     const user = await KioskUser.findOne({ where: { phone: phone } })
                //     if (user) {
                //         await user.decrement('balance', { by: balanceAmount });
                //     }
                // }

                return res.status(200).json({ id: txn?.id, message: 'Transaction approved' });
            } else {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '2', // failed
                    failure_reason: resultJson?.msg ?? 'Game not operational'
                });
                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txn?.id, error: "Game is currently not operational" ?? 'Unknown error' });
            }
        } catch (error) {
            const user = await KioskUser.findOne({ where: { phone: phone } })
            if (user) {
                await user.increment('balance', { by: amount });
            }
            return res.status(200).json({ error: error.message });
        }
    }
    else if (gameid == '56') {
        try {
            const account = gameuser;
            // const amount = amount;

            const url = `https://swback.logiclane.tech/api/vj/depositUser`;
            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

            const data = {
                userName: account,
                amount: amount
            }

            const response = await axios.post(url, data, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            });

            const resultJson = response.data;

            if (resultJson?.code === '200' || resultJson?.code === 200) {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '1'
                })

                // if (balanceAmount > 0) {
                //     const user = await KioskUser.findOne({ where: { phone: phone } })
                //     if (user) {
                //         await user.decrement('balance', { by: balanceAmount });
                //     }
                // }
                return res.status(200).json({ id: txn?.id, message: 'Transaction approved' });
            } else {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '2', // failed
                    failure_reason: resultJson?.msg ?? 'Game not operational'
                });
                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txn?.id, error: "Game is currently not operational" ?? 'Unknown error' });
            }
        } catch (error) {
            const user = await KioskUser.findOne({ where: { phone: phone } })
            if (user) {
                await user.increment('balance', { by: amount });
            }
            return res.status(200).json({ error: error.message });
        }
    }
    else if (gameid == '57') {
        try {
            const account = gameuser;
            // const amount = amount;

            const url = `https://swback.logiclane.tech/api/os2/depositUser`;
            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

            const data = {
                userName: account,
                amount: amount
            }

            const response = await axios.post(url, data, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            });

            const resultJson = response.data;

            if (resultJson?.code === '200' || resultJson?.code === 200) {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '1'
                })

                // if (balanceAmount > 0) {
                //     const user = await KioskUser.findOne({ where: { phone: phone } })
                //     if (user) {
                //         await user.decrement('balance', { by: balanceAmount });
                //     }
                // }
                return res.status(200).json({ id: txn?.id, message: 'Transaction approved' });
            } else {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '2', // failed
                    failure_reason: resultJson?.msg ?? 'Game not operational'
                });
                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txn?.id, error: "Game is currently not operational" ?? 'Unknown error' });
            }
        } catch (error) {
            const user = await KioskUser.findOne({ where: { phone: phone } })
            if (user) {
                await user.increment('balance', { by: amount });
            }
            return res.status(200).json({ error: error.message });
        }
    }
    else if (gameid == '55') {
        const fpuserid = gameuser;

        try {
            const response = await axios.get(
                `https://swback.logiclane.tech/api/bm/depositAccount?account=${fpuserid}&amount=${amount}`,

                { headers: { 'Content-Type': 'application/json' } }
            );

            const resultJson = response.data;

            if (resultJson && resultJson.success === true) {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '1'
                })

                // if (balanceAmount > 0) {
                //     const user = await KioskUser.findOne({ where: { phone: phone } })
                //     if (user) {
                //         await user.decrement('balance', { by: balanceAmount });
                //     }
                // }
                return res.status(200).json({ id: txn?.id, message: 'Transaction approved' });
            } else {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '2', // failed
                    failure_reason: resultJson?.msg ?? 'Game not operational'
                });
                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txn?.id, error: "Game is currently not operational" ?? 'Unknown error' });
            }
        } catch (error) {
            const user = await KioskUser.findOne({ where: { phone: phone } })
            if (user) {
                await user.increment('balance', { by: amount });
            }

            return res.status(200).json({ error: error.message });
        }
    }
    else if (gameid == '19') {
        const account = gameuser;
        const gtaccount = await KioskCreation.findOne({ where: { gameuser: account } });

        if (!gtaccount) {
            return res.status(404).json({ error: 'Game user not found in Creation table' });
        }

        const gtuserid = gtaccount.gameuserid;
        try {
            const response = await axios.get(
                `https://swback.logiclane.tech/api/gt/depositAccount?account=${gtuserid}&amount=${amount}`,
                // `http://localhost/api/gt/depositAccount?account=${gtuserid}&amount=${txn.amount}`,

                { headers: { 'Content-Type': 'application/json' } }
            );

            const resultJson = response.data;

            if (resultJson && resultJson.code == '200') {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '1'
                })
                // if (balanceAmount > 0) {
                //     const user = await KioskUser.findOne({ where: { phone: phone } })
                //     if (user) {
                //         await user.decrement('balance', { by: balanceAmount });
                //     }
                // }

                return res.status(200).json({ id: txn?.id, message: 'Transaction approved' });
            } else {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '2', // failed
                    failure_reason: resultJson?.msg ?? 'Game not operational'
                });
                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txn?.id, error: "Game is currently not operational" ?? 'Unknown error' });
            }
        } catch (error) {
            const user = await KioskUser.findOne({ where: { phone: phone } })
            if (user) {
                await user.increment('balance', { by: amount });
            }
            return res.status(200).json({ error: error.message });
        }
    }
    else if (gameid == '8') {
        const account = gameuser;
        const gtaccount = await KioskCreation.findOne({ where: { gameuser: account } });

        if (!gtaccount) {
            return res.status(404).json({ error: 'Game user not found in Creation table' });
        }

        const gtuserid = gtaccount.gameuserid;
        try {
            const response = await axios.get(
                `https://swback.logiclane.tech/api/eg/depositAccount?account=${gtuserid}&amount=${amount}`,
                // `http://localhost/api/gt/depositAccount?account=${gtuserid}&amount=${txn.amount}`,

                { headers: { 'Content-Type': 'application/json' } }
            );

            const resultJson = response.data;

            if (resultJson && resultJson.code == '200') {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '1'
                })
                // if (balanceAmount > 0) {
                //     const user = await KioskUser.findOne({ where: { phone: phone } })
                //     if (user) {
                //         await user.decrement('balance', { by: balanceAmount });
                //     }
                // }
                return res.status(200).json({ id: txn?.id, message: 'Transaction approved' });
            } else {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '2', // failed
                    failure_reason: resultJson?.msg ?? 'Game not operational'
                });
                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txn?.id, error: "Game is currently not operational" ?? 'Unknown error' });

            }
        } catch (error) {
            const user = await KioskUser.findOne({ where: { phone: phone } })
            if (user) {
                await user.increment('balance', { by: amount });
            }
            return res.status(200).json({ error: error.message });
        }
    }
    else if (gameid == '4') {
        const account = gameuser;
        const gtaccount = await KioskCreation.findOne({ where: { gameuser: account } });

        if (!gtaccount) {
            return res.status(404).json({ error: 'Game user not found in Creation table' });
        }

        const gtuserid = gtaccount.gameuserid;
        try {
            const response = await axios.get(
                `https://swback.logiclane.tech/api/vb/depositAccount?account=${gtuserid}&amount=${amount}`,
                // `http://localhost/api/gt/depositAccount?account=${gtuserid}&amount=${txn.amount}`,

                { headers: { 'Content-Type': 'application/json' } }
            );

            const resultJson = response.data;

            if (resultJson && resultJson.code == '200') {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '1'
                })
                // if (balanceAmount > 0) {
                //     const user = await KioskUser.findOne({ where: { phone: phone } })
                //     if (user) {
                //         await user.decrement('balance', { by: balanceAmount });
                //     }
                // }
                return res.status(200).json({ id: txn?.id, message: 'Transaction approved' });
            } else {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '2', // failed
                    failure_reason: resultJson?.msg ?? 'Game not operational'
                });
                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txn?.id, error: "Game is currently not operational" ?? 'Unknown error' });
            }
        } catch (error) {
            const user = await KioskUser.findOne({ where: { phone: phone } })
            if (user) {
                await user.increment('balance', { by: amount });
            }
            return res.status(200).json({ error: error.message });
        }
    }
    else if (gameid == '9') {
        const account = gameuser;
        const gtaccount = await KioskCreation.findOne({ where: { gameuser: account } });

        if (!gtaccount) {
            return res.status(404).json({ error: 'Game user not found in Creation table' });
        }

        const gtuserid = gtaccount.gameuserid;
        try {
            const response = await axios.get(
                `https://swback.logiclane.tech/api/up/depositAccount?account=${gtuserid}&amount=${amount}`,
                // `http://localhost/api/gt/depositAccount?account=${gtuserid}&amount=${txn.amount}`,

                { headers: { 'Content-Type': 'application/json' } }
            );

            const resultJson = response.data;

            if (resultJson && resultJson.code == '200') {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '1'
                })
                // if (balanceAmount > 0) {
                //     const user = await KioskUser.findOne({ where: { phone: phone } })
                //     if (user) {
                //         await user.decrement('balance', { by: balanceAmount });
                //     }
                // }
                return res.status(200).json({ id: txn?.id, message: 'Transaction approved' });
            } else {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '2', // failed
                    failure_reason: resultJson?.msg ?? 'Game not operational'
                });
                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txn?.id, error: "Game is currently not operational" ?? 'Unknown error' });


            }
        } catch (error) {
            const user = await KioskUser.findOne({ where: { phone: phone } })
            if (user) {
                await user.increment('balance', { by: amount });
            }
            return res.status(200).json({ error: error.message });
        }
    }
    else if (gameid == '39') {
        const account = gameuser;
        const gtaccount = await KioskCreation.findOne({ where: { gameuser: account } });

        if (!gtaccount) {
            return res.status(404).json({ error: 'Game user not found in Creation table' });
        }

        // const gtuserid = gtaccount.gameuserid;
        const gtuserid = gtaccount.gameuserid;
        const data = {
            account: gtuserid,
            phone: phone,
            amount: amount
        }
        try {
            console.log(data)

            const response = await axios.post(
                `https://swback.logiclane.tech/api/trx/depositUser`,
                // `http://localhost/api/gt/depositAccount?account=${gtuserid}&amount=${txn.amount}`,
                data,
                { headers: { 'Content-Type': 'application/json' } }
            );

            const resultJson = response.data;
            console.log(resultJson)
            if (resultJson && resultJson.status == 'success') {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '1'
                })
                // if (balanceAmount > 0) {
                //     const user = await KioskUser.findOne({ where: { phone: phone } })
                //     if (user) {
                //         await user.decrement('balance', { by: balanceAmount });
                //     }
                // }
                return res.status(200).json({ id: txn?.id, message: 'Transaction approved' });
            } else {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '2', // failed
                    failure_reason: resultJson?.msg ?? 'Game not operational'
                });
                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txn?.id, error: "Game is currently not operational" ?? 'Unknown error' });
            }
        } catch (error) {
            const user = await KioskUser.findOne({ where: { phone: phone } })
            if (user) {
                await user.increment('balance', { by: amount });
            }
            return res.status(200).json({ error: 'Unknown error' });

            return res.status(409).json({ error: error });
        }
    }
    else if (gameid == '58') {
        try {
            const account = gameuser;
            // const amount = amount;

            const url = `https://swback.logiclane.tech/api/ss2/depositUser`;
            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

            const data = {
                userName: account,
                amount: amount
            }

            const response = await axios.post(url, data, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            });

            const resultJson = response.data;

            if (resultJson?.code === '200' || resultJson?.code === 200) {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '1'
                })

                // if (balanceAmount > 0) {
                //     const user = await KioskUser.findOne({ where: { phone: phone } })
                //     if (user) {
                //         await user.decrement('balance', { by: balanceAmount });
                //     }
                // }
                return res.status(200).json({ id: txn?.id, message: 'Transaction approved' });
            } else {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '2', // failed
                    failure_reason: resultJson?.msg ?? 'Game not operational'
                });
                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txn?.id, error: "Game is currently not operational" ?? 'Unknown error' });
            }
        } catch (error) {
            const user = await KioskUser.findOne({ where: { phone: phone } })
            if (user) {
                await user.increment('balance', { by: amount });
            }
            return res.status(200).json({ error: error.message });
        }
    }
    else if (gameid == '59') {
        try {
            const account = gameuser;
            // const amount = amount;

            const url = `https://swback.logiclane.tech/api/gdog/depositUser`;
            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

            const data = {
                userName: account,
                amount: amount
            }

            const response = await axios.post(url, data, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            });

            const resultJson = response.data;

            if (resultJson?.code === '200' || resultJson?.code === 200) {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '1'
                })

                // if (balanceAmount > 0) {
                //     const user = await KioskUser.findOne({ where: { phone: phone } })
                //     if (user) {
                //         await user.decrement('balance', { by: balanceAmount });
                //     }
                // }
                return res.status(200).json({ id: txn?.id, message: 'Transaction approved' });
            } else {
                const txn = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '1',
                    combination: JSON.stringify(combination) ?? '',
                    status: '2', // failed
                    failure_reason: resultJson?.msg ?? 'Game not operational'
                });
                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txn?.id, error: "Game is currently not operational" ?? 'Unknown error' });
            }
        } catch (error) {
            const user = await KioskUser.findOne({ where: { phone: phone } })
            if (user) {
                await user.increment('balance', { by: amount });
            }
            return res.status(200).json({ error: error.message });
        }
    }
}
exports.redeem = async (req, res) => {
    const { phone, gameid, gameuser, amount } = req.body;
    const game = await Game.findOne({ where: { id: gameid } });
    if (!game) {
        return res.json({ status: 'error', message: 'Game not found' })
    }
    const txn = {
        game: game.name,
        gameuser: gameuser,
        amount: amount
    }
    let currentDate = new Date();
    const formattedDate = date.format(currentDate, 'YYYY-MM-DD');
    if (txn.game == 'Fire Phoenix') {
        try {
            const fpuserid = txn.gameuser
            const timestamp = Math.floor(Date.now() / 1000);
            const hash = crypto.createHash('md5').update(`ramon1kUfpv2qECNZkYsg3hcu7${timestamp}`).digest('hex').toUpperCase();

            const payload = {
                action: 'setUserScore',
                keyAgent: 'ramon1',
                account: fpuserid,
                time: timestamp,
                token: hash,
                scoreNum: -txn.amount,
                ts: 0.7216318002132696
            };

            const formData = qs.stringify(payload);

            const url = "https://api.fpc-mob.com/ashx/CheckAccount.ashx";

            const response = await axios.post(url, formData, {
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded'
                }
            })
            const resultJson = response.data;
            if (resultJson && resultJson.success == true) {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '1'
                })

                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txnCreate?.id, message: 'Redeem approved' });
            } else {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '2'
                })
                return res.status(409).json({ id: txnCreate?.id, error: 'Unable to complete the redeem, user doesnt have sufficient winnings.' });
            }
        } catch (error) {
            console.error('Error:', error.message);
            return res.status(409).json({ error: error.message });
        }
    } else if (txn.game == 'Majik Bonus') {
        try {
            const amt = -txn.amount + ".00"
            const data = {
                account: txn.gameuser,
                setScore: amt
            };
            const secret = '7378ae5ce34d408587ceae38ad3dabca';
            const key = 'A1asd4fhu4E45Gdmk';
            const hash = getHash(JSON.stringify(data), secret, key);

            // const url = `https://opx.logiclane.tech/public/apis/mjb/depositwithdraw.php?hash=${hash}&account=${txn.gameuser}&amount=${amt}&type=redeem`;
            const url = `https://swback.logiclane.tech/api/mjb/depositwithdraw?hash=${hash}&account=${txn.gameuser}&amount=${amt}&type=redeem`;


            const response = await axios.get(url, {
                headers: { 'Content-Type': 'application/json' },

            })
            const resultJson = response.data;
            // let trimmedJson = resultJson.slice(0, -1);
            // let result = JSON.parse(trimmedJson);
            if (resultJson && resultJson.status == 'success') {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '1'
                })

                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txnCreate?.id, message: 'Redeem approved' });
            } else {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '2'
                })
                return res.status(409).json({ id: txnCreate?.id, error: 'Unable to complete the redeem, user doesnt have sufficient winnings.' });
            }
        } catch (error) {
            console.error('Error:', error.message);
            return res.status(409).json({ error: error.message });
        }
    } else if (txn.game == 'Galaxy') {
        try {
            const timestamp = Math.floor(Date.now() / 1000);
            const signatureString = `52277:${timestamp}:d620176e98baec2c8a3e5b5fcc24d47c`;
            const signature = crypto.createHash('md5').update(signatureString).digest('hex');
            const guser = txn.gameuser
            const formData = new FormData();
            formData.append('agent_id', '52277');
            formData.append('timestamp', timestamp);
            formData.append('token', signature);
            formData.append('amount', txn.amount);
            formData.append('user_id', guser);
            const url = 'https://swback.logiclane.tech/api/galaxy/redeem'
            const response = await axios.post(url, formData, {
                headers: {
                    ...formData.getHeaders()
                },
                // data: formData
            })

            const resultJson = response.data;
            // console.log(resultJson);
            if (resultJson && resultJson.msg == 'Success') {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '1'
                })

                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txnCreate?.id, message: 'Redeem approved' });
            } else {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '2'
                })
                return res.status(409).json({ id: txnCreate?.id, error: 'Unable to complete the redeem, user doesnt have sufficient winnings.' });
            }
        } catch (error) {
            console.error('Error:', error.message);
            return res.status(409).json({ error: error.message });
        }

    }
    else if (txn.game === 'River Sweeps') {
        const redeemAmount = Number(txn.amount);

        if (!redeemAmount || redeemAmount <= 0) {
            return res.status(400).json({ error: 'Invalid redeem amount' });
        }

        const sequelize = KioskUser.sequelize;
        const t = await sequelize.transaction();

        try {
            // 🔒 STEP 1: Lock user row
            const user = await KioskUser.findOne({
                where: { phone },
                transaction: t,
                lock: t.LOCK.UPDATE // SELECT ... FOR UPDATE
            });

            if (!user) {
                throw new Error('User not found');
            }

            // 🔁 STEP 2: Call River Sweeps API
            const response = await axios.get(
                'https://swback.logiclane.tech/api/rs/withdrawAccount',
                {
                    params: {
                        code: txn.gameuser,
                        amount: redeemAmount
                    },
                    headers: {
                        'Authorization': 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61'
                    },
                    timeout: 8000
                }
            );

            const resultJson = response.data;

            // ❌ API NOT APPROVED → rollback
            if (!resultJson || String(resultJson.STATUS) !== '0') {
                await KioskTxns.create({
                    phone,
                    gameuser,
                    gameid,
                    amount: redeemAmount,
                    type: '2',
                    status: '2'
                }, { transaction: t });

                await t.rollback();

                return res.status(409).json({
                    error: 'Unable to complete the redeem, insufficient winnings'
                });
            }

            // ✅ STEP 3: Create transaction record
            const txnCreate = await KioskTxns.create({
                phone,
                gameuser,
                gameid,
                amount: redeemAmount,
                type: '2',
                status: '1'
            }, { transaction: t });

            // ✅ STEP 4: Increment balance (LOCKED ROW)
            await user.increment('balance', {
                by: redeemAmount,
                transaction: t
            });

            // ✅ STEP 5: Commit everything
            await t.commit();

            return res.status(200).json({
                id: txnCreate.id,
                message: 'Redeem approved'
            });

        } catch (error) {
            await t.rollback();
            console.error('River Sweeps redeem error:', error.message);

            return res.status(500).json({
                error: 'Redeem failed, please try again'
            });
        }
    }
    else if (txn.game == 'Fortune Panda') {
        try {
            const account = txn.gameuser;
            const amount = txn.amount;
            // const url = `https://gvmck6p5yqtfagp.riversweeps.game/public/apis/fp/redeemAccount.php?account=${account}&amount=${amount}`;
            const url = `https://swback.logiclane.tech/api/fp/withdrawAccount?account=${account}&amount=${amount}`;

            const response = await axios.get(url, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61'
                }
            })
            const resultJson = response.data;
            // console.log(resultJson);
            if (resultJson && resultJson.code == '200') {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '1'
                })

                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txnCreate?.id, message: 'Redeem approved' });
            } else {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '2'
                })
                return res.status(409).json({ id: txnCreate?.id, error: resultJson.msg });
            }

        } catch (error) {
            console.error('Error:', error.message);
            return res.status(409).json({ error: error.message });
        }
    } else if (txn.game === 'Blue Dragon') {
        const redeemAmount = Number(txn.amount);

        if (!redeemAmount || redeemAmount <= 0) {
            return res.status(400).json({ error: 'Invalid redeem amount' });
        }

        const account = txn.gameuser;

        const sequelize = KioskUser.sequelize;
        const t = await sequelize.transaction();

        try {
            /* 🔒 STEP 1: Lock user row */
            const user = await KioskUser.findOne({
                where: { phone },
                transaction: t,
                lock: t.LOCK.UPDATE
            });

            if (!user) {
                throw new Error('User not found');
            }

            /* 🔁 STEP 2: Call Blue Dragon API */
            const response = await axios.get(
                'https://swback.logiclane.tech/api/bd/depositWithdraw',
                {
                    params: {
                        account,
                        amount: redeemAmount,
                        type: 'withdraw'
                    },
                    headers: {
                        'Authorization': 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61'
                    },
                    timeout: 8000
                }
            );

            const resultJson = response.data;

            /* ❌ NOT APPROVED → rollback */
            if (!resultJson || String(resultJson.code) !== '0') {
                await KioskTxns.create({
                    phone,
                    gameuser,
                    gameid,
                    amount: redeemAmount,
                    type: '2',
                    status: '2'
                }, { transaction: t });

                await t.rollback();

                return res.status(409).json({
                    error: resultJson?.msg || 'Unable to complete redeem'
                });
            }

            /* ✅ STEP 3: Create txn */
            const txnCreate = await KioskTxns.create({
                phone,
                gameuser,
                gameid,
                amount: redeemAmount,
                type: '2',
                status: '1'
            }, { transaction: t });

            /* ✅ STEP 4: Increment balance (LOCKED) */
            await user.increment('balance', {
                by: redeemAmount,
                transaction: t
            });

            /* ✅ STEP 5: Commit */
            await t.commit();

            return res.status(200).json({
                id: txnCreate.id,
                message: 'Redeem approved'
            });

        } catch (error) {
            await t.rollback();
            console.error('Blue Dragon redeem error:', error.message);

            return res.status(500).json({
                error: 'Redeem failed, please try again'
            });
        }
    } else if (txn.game == 'Fire Dragon') {
        try {
            const account = txn.gameuser;
            const amount = txn.amount;
            // const url = `https://gvmck6p5yqtfagp.riversweeps.game/public/apis/fd/depositWithdraw.php?account=${account}&amount=${amount}&type=withdraw`;
            const url = `https://swback.logiclane.tech/api/fd/depositWithdraw?account=${account}&amount=${amount}&type=withdraw`;

            const response = await axios.get(url, {

                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61'
                }
            })
            const resultJson = response.data;
            // console.log(resultJson);
            if (resultJson && resultJson.code == '0') {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '1'
                })

                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txnCreate?.id, message: 'Redeem approved' });
            } else {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '2'
                })
                return res.status(409).json({ id: txnCreate?.id, error: resultJson.msg });
            }
        }
        catch (error) {
            console.log(console.error)
            return res.status(401).json({ error: error.message });

        }
    } else if (txn.game == 'EasyStreet') {
        try {
            const account = txn.gameuser;
            const amount = txn.amount;
            const timestamp = Math.floor(Date.now() / 1000);
            const order_id = Math.floor(Date.now() / 1000);

            const secretKey = "L2K8GV89R9H92MY4YCY4DTL6U4RYGA8R";
            const auth_code = "PQEH73ZS53QDGUPF4W9JBJGAHV3UBGVX";

            const sign = crypto
                .createHash('sha1')
                .update(`${account}${timestamp}${secretKey}`)
                .digest('hex');

            const post = JSON.stringify({
                order_id: order_id,
                username: account,
                amount: amount,
                timestamp: timestamp,
                sign: sign,
                auth_code: auth_code
            });
            // const url = "https://opx.logiclane.tech/public/apis/es/withdraw.php";
            const url = "https://swback.logiclane.tech/api/es/withdraw";

            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

            const postData = JSON.parse(post);

            const response = await axios.post(url, postData, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            })

            const resultJson = response.data;
            // console.log(resultJson); 

            if (resultJson && resultJson.status === 'OK') {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '1'
                })

                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txnCreate?.id, message: 'Redeem approved' });
            } else {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '2'
                })
                return res.status(409).json({ id: txnCreate?.id, error: resultJson.msg });
            }
        } catch (error) {
            console.log(console.error)
            return res.status(401).json({ error: error.message });

        }
    } else if (txn.game == 'Mega Link') {
        try {
            const account = txn.gameuser;
            const amount = txn.amount;
            const timestamp = Math.floor(Date.now() / 1000);
            const order_id = Math.floor(Date.now() / 1000);

            const secretKey = "D8R6BRLGMXUL6VT52LMQJRM8QRU5RPDR";
            const auth_code = "VVKYHAFHKWRWSS8KY2XE6AE3XUNVEVUD";

            const sign = crypto
                .createHash('sha1')
                .update(`${account}${timestamp}${secretKey}`)
                .digest('hex');

            const post = JSON.stringify({
                order_id: order_id,
                username: account,
                amount: amount,
                timestamp: timestamp,
                sign: sign,
                auth_code: auth_code
            });
            // const url = "https://opx.logiclane.tech/public/apis/ml/withdraw.php";
            const url = "https://swback.logiclane.tech/api/ml/withdraw";

            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

            const postData = JSON.parse(post);

            const response = await axios.post(url, postData, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            })

            const resultJson = response.data;
            // console.log(resultJson); 

            if (resultJson && resultJson.status === 'OK') {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '1'
                })

                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txnCreate?.id, message: 'Redeem approved' });
            } else {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '2'
                })
                return res.status(409).json({ id: txnCreate?.id, error: resultJson.message });
            }
        } catch (error) {
            console.log(console.error)
            return res.status(401).json({ error: error.message });
        }
    } else if (txn.game == 'Orion Stars') {
        try {
            const account = txn.gameuser;
            const amount = txn.amount;
            // const timestamp = Math.floor(Date.now() / 1000);
            const order_id = Math.floor(Date.now() / 1000);

            const secretKey = "YHJGHFVMNFZF3YUAQGL6HWDRKWKUGVSB";
            const auth_code = "HCFYPWXYQFVKUQ2X8MXWKTT86EKLY2FG";
            const timestamp = Date.now(); // Equivalent to (int) (microtime(true) * 1000)

            const agent_key = "HCFYPWXYQFVKUQ2X8MXWKTT86EKLY2FG";
            const sign_string = `${agent_key}${timestamp}YHJGHFVMNFZF3YUAQGL6HWDRKWKUGVSB`;

            const sign = crypto.createHash('md5').update(sign_string, 'utf8').digest('hex');

            const post = JSON.stringify({
                order_id: order_id,
                username: account,
                amount: amount,
                timestamp: timestamp,
                sign: sign,
                agent_key: auth_code
            });
            // const url = "https://opx.logiclane.tech/public/apis/ostars/withdraw.php";
            const url = "https://swback.logiclane.tech/api/ostars/withdraw";

            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

            const postData = JSON.parse(post);
            // console.log(postData)
            const response = await axios.post(url, postData, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            })

            const resultJson = response.data;
            // console.log(resultJson);
            // return res.json(resultJson);
            if (resultJson && resultJson.status == 'OK') {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '1'
                })

                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txnCreate?.id, message: 'Redeem approved' });
            } else {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '2'
                })
                return res.status(409).json({ id: txnCreate?.id, error: resultJson.msg });
            }
        } catch (error) {
            console.log(console.error)
            return res.status(401).json({ error: error.message });
        }
    }
    else if (txn.game === 'Skill TX') {
        const baseAmount = Number(txn.amount);   // wallet units
        const apiAmount = baseAmount * 100;     // Skill TX expects cents

        if (!baseAmount || baseAmount <= 0) {
            return res.status(400).json({ error: 'Invalid redeem amount' });
        }

        const sequelize = KioskUser.sequelize;
        const t = await sequelize.transaction();

        try {
            /* 🔒 STEP 1: Lock user row */
            const user = await KioskUser.findOne({
                where: { phone },
                transaction: t,
                lock: t.LOCK.UPDATE
            });

            if (!user) {
                throw new Error('User not found');
            }

            /* 🔁 STEP 2: Call Skill TX API */
            const response = await axios.get(
                'https://swback.logiclane.tech/api/stx/withdrawAccount',
                {
                    params: {
                        login: txn.gameuser,
                        amount: apiAmount
                    },
                    headers: {
                        'Authorization': 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61'
                    },
                    timeout: 8000
                }
            );

            const resultJson = response.data;

            /* ❌ NOT APPROVED → rollback */
            if (!resultJson || String(resultJson.status) !== '1') {
                await KioskTxns.create({
                    phone,
                    gameuser,
                    gameid,
                    amount: baseAmount,   // store wallet amount, not cents
                    type: '2',
                    status: '2'
                }, { transaction: t });

                await t.rollback();

                return res.status(409).json({
                    error: 'Unable to complete the redeem, insufficient winnings.'
                });
            }

            /* ✅ STEP 3: Create txn */
            const txnCreate = await KioskTxns.create({
                phone,
                gameuser,
                gameid,
                amount: baseAmount,
                type: '2',
                status: '1'
            }, { transaction: t });

            /* ✅ STEP 4: Increment balance (LOCKED) */
            await user.increment('balance', {
                by: baseAmount,
                transaction: t
            });

            /* ✅ STEP 5: Commit */
            await t.commit();

            return res.status(200).json({
                id: txnCreate.id,
                message: 'Redeem approved'
            });

        } catch (error) {
            await t.rollback();
            console.error('Skill TX redeem error:', error.message);

            return res.status(500).json({
                error: 'Redeem failed, please try again'
            });
        }
    }
    else if (txn.game == 'Jack2Win') {
        try {
            const account = txn.gameuser;
            const amount = txn.amount;

            const jack2user = await Creation.findOne({ where: { gdid: account } });
            if (jack2user) {
                const jack2userid = jack2user.gdid;

                // const url = `https://gvmck6p5yqtfagp.riversweeps.game/public/apis/fd/depositWithdraw.php?account=${account}&amount=${amount}&type=withdraw`;
                // const url = `https://opx.logiclane.tech/public/apis/jwin/depositWithdraw.php?account=${jack2userid}&amount=${amount}&type=withdraw`;
                const url = `https://swback.logiclane.tech/api/jwin/depositWithdraw?account=${jack2userid}&amount=${amount}&type=withdraw`;


                const response = await axios.get(url, {

                    headers: {
                        'Content-Type': 'application/json',
                        'Authorization': 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61'
                    }
                })
                const resultJson = response.data;
                // console.log(resultJson);
                if (resultJson && resultJson.code == '0') {
                    const txnCreate = await KioskTxns.create({
                        phone: phone,
                        gameuser: gameuser,
                        gameid: gameid,
                        amount: amount,
                        type: '2',
                        status: '1'
                    })

                    const user = await KioskUser.findOne({ where: { phone: phone } })
                    if (user) {
                        await user.increment('balance', { by: amount });
                    }
                    return res.status(200).json({ id: txnCreate?.id, message: 'Redeem approved' });
                } else {
                    const txnCreate = await KioskTxns.create({
                        phone: phone,
                        gameuser: gameuser,
                        gameid: gameid,
                        amount: amount,
                        type: '2',
                        status: '2'
                    })
                    return res.status(409).json({ id: txnCreate?.id, error: resultJson.msg });
                }
            }
        } catch (error) {
            console.log(console.error)
            return res.status(401).json({ error: error.message });
        }
    } else if (txn.game == 'Dragon Game') {
        try {
            const account = txn.gameuser;
            const amount = txn.amount;

            // const jack2user = await Creation.findOne({ where: { guserid: account } });
            // if (jack2user) {
            //     const jack2userid = jack2user.gdid;

            // const url = `https://gvmck6p5yqtfagp.riversweeps.game/public/apis/fd/depositWithdraw.php?account=${account}&amount=${amount}&type=withdraw`;
            const url = `https://swback.logiclane.tech/api/dg/withdrawAccount?account=${account}&amount=${amount}`;

            const response = await axios.get(url, {

                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61'
                }
            })
            const resultJson = response.data;
            // console.log(resultJson);
            if (resultJson && resultJson.status == 'OK') {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '1'
                })

                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txnCreate?.id, message: 'Redeem approved' });
            } else {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '2'
                })
                return res.status(409).json({ id: txnCreate?.id, error: resultJson.msg });
            }
        } catch (error) {
            console.log(console.error)
            return res.status(401).json({ error: error.message });
        }
        // }
    }
    else if (txn.game == 'Fire Kirin') {
        try {
            const account = txn.gameuser;
            const amount = txn.amount;

            // const jack2user = await Creation.findOne({ where: { guserid: account } });
            // if (jack2user) {
            //     const jack2userid = jack2user.gdid;

            // const url = `https://gvmck6p5yqtfagp.riversweeps.game/public/apis/fd/depositWithdraw.php?account=${account}&amount=${amount}&type=withdraw`;
            const url = `https://swback.logiclane.tech/api/fk/withdrawAccount?account=${account}&amount=${amount}`;

            const response = await axios.get(url, {

                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61'
                }
            })
            const resultJson = response.data;
            // console.log(resultJson);
            if (resultJson && resultJson.code == '200') {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '1'
                })

                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txnCreate?.id, message: 'Redeem approved' });
            } else {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '2'
                })
                return res.status(409).json({ id: txnCreate?.id, error: resultJson.msg });
            }
        } catch (error) {
            console.log(console.error)
            return res.status(401).json({ error: error.message });
        }
        // }
    }
    else if (txn.game == 'Panda Master') {
        try {
            const account = txn.gameuser;
            const amount = txn.amount;

            // const jack2user = await Creation.findOne({ where: { guserid: account } });
            // if (jack2user) {
            //     const jack2userid = jack2user.gdid;

            // const url = `https://gvmck6p5yqtfagp.riversweeps.game/public/apis/fd/depositWithdraw.php?account=${account}&amount=${amount}&type=withdraw`;
            const url = `https://swback.logiclane.tech/api/pm/withdrawAccount?account=${account}&amount=${amount}`;

            const response = await axios.get(url, {

                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61'
                }
            })
            const resultJson = response.data;
            // console.log(resultJson);
            if (resultJson && resultJson.code == '200') {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '1'
                })

                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txnCreate?.id, message: 'Redeem approved' });
            } else {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '2'
                })
                return res.status(409).json({ id: txnCreate?.id, error: resultJson.msg });
            }
        } catch (error) {
            console.log(console.error)
            return res.status(401).json({ error: error.message });
        }
        // }
    }
    else if (txn.game == 'Kraken') {
        try {
            const account = txn.gameuser;
            const amount = txn.amount;

            // const jack2user = await Creation.findOne({ where: { guserid: account } });
            // if (jack2user) {
            //     const jack2userid = jack2user.gdid;

            // const url = `https://gvmck6p5yqtfagp.riversweeps.game/public/apis/fd/depositWithdraw.php?account=${account}&amount=${amount}&type=withdraw`;
            const url = `https://swback.logiclane.tech/api/kr/withdrawAccount?account=${account}&amount=${amount}`;

            const response = await axios.get(url, {

                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61'
                }
            })
            const resultJson = response.data;
            // console.log(resultJson);
            if (resultJson && resultJson.code == '200') {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '1'
                })

                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txnCreate?.id, message: 'Redeem approved' });
            } else {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '2'
                })
                return res.status(409).json({ id: txnCreate?.id, error: resultJson.msg });
            }
        } catch (error) {
            console.log(console.error)
            return res.status(401).json({ error: error.message });
        }
        // }
    }
    else if (txn.game == 'Golden Spin') {
        try {
            const account = txn.gameuser;
            const amount = txn.amount;

            const url = `https://swback.logiclane.tech/api/gs/withdrawUser`;
            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

            const data = {
                userName: account,
                amount: amount
            }

            const response = await axios.post(url, data, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            });

            const resultJson = response.data;

            if (resultJson?.code === '200' || resultJson?.code === 200) {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '1'
                })

                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txnCreate?.id, message: 'Redeem approved' });
            } else {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '2'
                })
                return res.status(409).json({ id: txnCreate?.id, error: resultJson.msg });
            }
        } catch (error) {

            const txnCreate = await KioskTxns.create({
                phone: phone,
                gameuser: gameuser,
                gameid: gameid,
                amount: amount,
                type: '2',
                status: '2'
            })
            return res.status(401).json({ id: txnCreate?.id, error: error.message });
        }
    }
    else if (txn.game == 'Clover Crown') {
        try {
            const account = txn.gameuser;
            const amount = txn.amount;

            const url = `https://swback.logiclane.tech/api/cc/withdrawUser`;
            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

            const data = {
                userName: account,
                amount: amount
            }

            const response = await axios.post(url, data, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            });

            const resultJson = response.data;

            if (resultJson?.code === '200' || resultJson?.code === 200) {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '1'
                })

                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txnCreate?.id, message: 'Redeem approved' });
            } else {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '2'
                })
                return res.status(409).json({ id: txnCreate?.id, error: resultJson.msg });
            }
        } catch (error) {


            return res.status(401).json({ error: error.message });
        }
    }
    else if (txn.game == 'Vegas Jackpots') {
        try {
            const account = txn.gameuser;
            const amount = txn.amount;

            const url = `https://swback.logiclane.tech/api/vj/withdrawUser`;
            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

            const data = {
                userName: account,
                amount: amount
            }

            const response = await axios.post(url, data, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            });

            const resultJson = response.data;

            if (resultJson?.code === '200' || resultJson?.code === 200) {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '1'
                })

                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txnCreate?.id, message: 'Redeem approved' });
            } else {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '2'
                })
                return res.status(409).json({ id: txnCreate?.id, error: resultJson.msg });
            }
        } catch (error) {


            return res.status(401).json({ error: error.message });
        }
    }
    else if (txn.game == 'Orion Stars 2') {
        try {
            const account = txn.gameuser;
            const amount = txn.amount;

            const url = `https://swback.logiclane.tech/api/os2/withdrawUser`;
            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

            const data = {
                userName: account,
                amount: amount
            }

            const response = await axios.post(url, data, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            });

            const resultJson = response.data;

            if (resultJson?.code === '200' || resultJson?.code === 200) {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '1'
                })

                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txnCreate?.id, message: 'Redeem approved' });
            } else {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '2'
                })
                return res.status(409).json({ id: txnCreate?.id, error: resultJson.msg });
            }
        } catch (error) {


            return res.status(401).json({ error: error.message });
        }
    }
    else if (txn.game == 'Black Mamba') {
        const fpuserid = txn.gameuser;

        try {
            const response = await axios.get(
                `https://swback.logiclane.tech/api/bm/withdrawAccount?account=${fpuserid}&amount=${txn.amount}`,

                { headers: { 'Content-Type': 'application/json' } }
            );

            const resultJson = response.data;

            if (resultJson && resultJson.success == true) {

                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '1'
                })

                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txnCreate?.id, message: 'Redeem approved' });
            } else {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '2'
                })
                return res.status(409).json({ id: txnCreate?.id, error: 'Unable to complete the redeem, user doesnt have sufficient winnings.' });
            }

        } catch (e) {
            console.log(e.message)
            return res.status(409).json({ error: 'Unable to complete the redeem, user doesnt have sufficient winnings.' });
        }
    }
    else if (txn.game == 'Golden Treasure') {
        const account = txn.gameuser;

        // const account = txn.gameuser;
        const gtaccount = await KioskCashout.findOne({ where: { gameuser: account } });

        if (!gtaccount) {
            return res.status(404).json({ error: 'Game user not found in Creation table' });
        }

        const gtuserid = gtaccount.gameuserid;

        try {
            const response = await axios.get(
                `https://swback.logiclane.tech/api/gt/withdrawAccount?account=${gtuserid}&amount=${txn.amount}`,
                // `http://localhost/api/gt/withdrawAccount?account=${gtuserid}&amount=${txn.amount}`,


                { headers: { 'Content-Type': 'application/json' } }
            );

            const resultJson = response.data;

            if (resultJson && resultJson.code == '200') {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '1'
                })

                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txnCreate?.id, message: 'Redeem approved' });
            } else {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '2'
                })
                return res.status(409).json({ id: txnCreate?.id, error: 'Unable to complete the redeem, user doesnt have sufficient winnings.' });
            }

        } catch (e) {
            console.log(e.message)
            return res.status(409).json({ error: 'Unable to complete the redeem, user doesnt have sufficient winnings.' });
        }
    }
    else if (txn.game == 'EGame') {
        const account = txn.gameuser;
        const gtaccount = await KioskCreation.findOne({ where: { gameuser: account } });

        if (!gtaccount) {
            return res.status(404).json({ error: 'Game user not found in Creation table' });
        }

        const gtuserid = gtaccount.gameuserid;

        try {
            const response = await axios.get(
                `https://swback.logiclane.tech/api/eg/withdrawAccount?account=${gtuserid}&amount=${txn.amount}`,
                // `http://localhost/api/gt/withdrawAccount?account=${gtuserid}&amount=${txn.amount}`,


                { headers: { 'Content-Type': 'application/json' } }
            );

            const resultJson = response.data;

            if (resultJson && resultJson.code == '200') {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '1'
                })

                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txnCreate?.id, message: 'Redeem approved' });
            } else {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '2'
                })
                return res.status(409).json({ id: txnCreate?.id, error: 'Unable to complete the redeem, user doesnt have sufficient winnings.' });
            }

        } catch (e) {
            console.log(e.message)
            return res.status(409).json({ error: 'Unable to complete the redeem, user doesnt have sufficient winnings.' });
        }
    }
    else if (txn.game === 'VBlink') {
        const redeemAmount = Number(txn.amount);

        if (!redeemAmount || redeemAmount <= 0) {
            return res.status(400).json({ error: 'Invalid redeem amount' });
        }

        const account = txn.gameuser;
        const gtaccount = await KioskCreation.findOne({ where: { gameuser: account } });

        if (!gtaccount) {
            return res.status(404).json({ error: 'Game user not found in Creation table' });
        }

        const gtuserid = gtaccount.gameuserid;

        const sequelize = KioskUser.sequelize;
        const t = await sequelize.transaction();

        try {
            /* 🔒 STEP 1: Lock user row */
            const user = await KioskUser.findOne({
                where: { phone },
                transaction: t,
                lock: t.LOCK.UPDATE
            });

            if (!user) {
                throw new Error('User not found');
            }

            /* 🔁 STEP 2: Call VBlink API */
            const response = await axios.get(
                'https://swback.logiclane.tech/api/vb/withdrawAccount',
                {
                    params: {
                        account: gtuserid,
                        amount: redeemAmount
                    },
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    timeout: 8000
                }
            );

            const resultJson = response.data;

            /* ❌ NOT APPROVED → rollback */
            if (!resultJson || String(resultJson.code) !== '200') {
                await KioskTxns.create({
                    phone,
                    gameuser,
                    gameid,
                    amount: redeemAmount,
                    type: '2',
                    status: '2'
                }, { transaction: t });

                await t.rollback();

                return res.status(409).json({
                    error: 'Unable to complete the redeem, insufficient winnings.'
                });
            }

            /* ✅ STEP 3: Create txn */
            const txnCreate = await KioskTxns.create({
                phone,
                gameuser,
                gameid,
                amount: redeemAmount,
                type: '2',
                status: '1'
            }, { transaction: t });

            /* ✅ STEP 4: Increment balance (LOCKED) */
            await user.increment('balance', {
                by: redeemAmount,
                transaction: t
            });

            /* ✅ STEP 5: Commit */
            await t.commit();

            return res.status(200).json({
                id: txnCreate.id,
                message: 'Redeem approved'
            });

        } catch (e) {
            await t.rollback();
            console.error('VBlink redeem error:', e.message);

            return res.status(500).json({
                error: 'Redeem failed, please try again'
            });
        }
    }
    // else if (txn.game == 'VBlink') {
    //     const account = txn.gameuser;
    //     const gtaccount = await KioskCreation.findOne({ where: { gameuser: account } });

    //     if (!gtaccount) {
    //         return res.status(404).json({ error: 'Game user not found in Creation table' });
    //     }

    //     const gtuserid = gtaccount.gameuserid;

    //     try {
    //         const response = await axios.get(
    //             `https://swback.logiclane.tech/api/vb/withdrawAccount?account=${gtuserid}&amount=${txn.amount}`,
    //             // `http://localhost/api/gt/withdrawAccount?account=${gtuserid}&amount=${txn.amount}`,


    //             { headers: { 'Content-Type': 'application/json' } }
    //         );

    //         const resultJson = response.data;

    //         if (resultJson && resultJson.code == '200') {
    //             const txnCreate = await KioskTxns.create({
    //                 phone: phone,
    //                 gameuser: gameuser,
    //                 gameid: gameid,
    //                 amount: amount,
    //                 type: '2',
    //                 status: '1'
    //             })

    //             const user = await KioskUser.findOne({ where: { phone: phone } })
    //             if (user) {
    //                 await user.increment('balance', { by: amount });
    //             }
    //             return res.status(200).json({ id: txnCreate?.id, message: 'Redeem approved' });
    //         } else {
    //             const txnCreate = await KioskTxns.create({
    //                 phone: phone,
    //                 gameuser: gameuser,
    //                 gameid: gameid,
    //                 amount: amount,
    //                 type: '2',
    //                 status: '2'
    //             })
    //             return res.status(409).json({ id: txnCreate?.id, error: 'Unable to complete the redeem, user doesnt have sufficient winnings.' });
    //         }
    //     } catch (e) {
    //         console.log(e.message)
    //         return res.status(409).json({ error: 'Unable to complete the redeem, user doesnt have sufficient winnings.' });
    //     }
    // }
    else if (txn.game === 'Ultra Panda') {
        const redeemAmount = Number(txn.amount);

        if (!redeemAmount || redeemAmount <= 0) {
            return res.status(400).json({ error: 'Invalid redeem amount' });
        }

        const account = txn.gameuser;
        const gtaccount = await KioskCreation.findOne({ where: { gameuser: account } });

        if (!gtaccount) {
            return res.status(404).json({ error: 'Game user not found in Creation table' });
        }

        const gtuserid = gtaccount.gameuserid;

        const sequelize = KioskUser.sequelize;
        const t = await sequelize.transaction();

        try {
            /* 🔒 STEP 1: Lock user row */
            const user = await KioskUser.findOne({
                where: { phone },
                transaction: t,
                lock: t.LOCK.UPDATE
            });

            if (!user) {
                throw new Error('User not found');
            }

            /* 🔁 STEP 2: Call Ultra Panda API */
            const response = await axios.get(
                'https://swback.logiclane.tech/api/up/withdrawAccount',
                {
                    params: {
                        account: gtuserid,
                        amount: redeemAmount
                    },
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    timeout: 8000
                }
            );

            const resultJson = response.data;

            /* ❌ NOT APPROVED → rollback */
            if (!resultJson || String(resultJson.code) !== '200') {
                await KioskTxns.create({
                    phone,
                    gameuser,
                    gameid,
                    amount: redeemAmount,
                    type: '2',
                    status: '2'
                }, { transaction: t });

                await t.rollback();

                return res.status(409).json({
                    error: 'Unable to complete the redeem, insufficient winnings.'
                });
            }

            /* ✅ STEP 3: Create txn */
            const txnCreate = await KioskTxns.create({
                phone,
                gameuser,
                gameid,
                amount: redeemAmount,
                type: '2',
                status: '1'
            }, { transaction: t });

            /* ✅ STEP 4: Increment balance (LOCKED) */
            await user.increment('balance', {
                by: redeemAmount,
                transaction: t
            });

            /* ✅ STEP 5: Commit */
            await t.commit();

            return res.status(200).json({
                id: txnCreate.id,
                message: 'Redeem approved'
            });

        } catch (e) {
            await t.rollback();
            console.error('Ultra Panda redeem error:', e.message);

            return res.status(500).json({
                error: 'Redeem failed, please try again'
            });
        }
    }
    else if (txn.game == 'Trex') {
        const account = gameuser;
        const gtaccount = await KioskCreation.findOne({ where: { gameuser: account } });

        if (!gtaccount) {
            return res.status(404).json({ error: 'Game user not found in Creation table' });
        }

        // const gtuserid = gtaccount.gameuserid;
        const gtuserid = gtaccount.gameuserid;
        const data = {
            account: gtuserid,
            phone: phone,
            amount: txn.amount
        }
        try {
            const response = await axios.post(
                `https://swback.logiclane.tech/api/trx/withdrawUser`,
                // `http://localhost/api/gt/depositAccount?account=${gtuserid}&amount=${txn.amount}`,
                data,
                { headers: { 'Content-Type': 'application/json' } }
            );

            const resultJson = response.data;

            if (resultJson && resultJson.status == 'success') {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '1'
                })

                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txnCreate?.id, message: 'Redeem approved' });
            } else {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '2'
                })
                return res.status(409).json({ id: txnCreate?.id, error: 'Unable to complete the redeem, user doesnt have sufficient winnings.' });
            }
        } catch (error) {

            return res.status(409).json({ error: error.message });
        }
    }
    else if (txn.game == 'Shark Secret 2') {
        try {
            const account = txn.gameuser;
            const amount = txn.amount;

            const url = `https://swback.logiclane.tech/api/ss2/withdrawUser`;
            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

            const data = {
                userName: account,
                amount: amount
            }

            const response = await axios.post(url, data, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            });

            const resultJson = response.data;

            if (resultJson?.code === '200' || resultJson?.code === 200) {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '1'
                })

                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txnCreate?.id, message: 'Redeem approved' });
            } else {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '2'
                })
                return res.status(409).json({ id: txnCreate?.id, error: resultJson.msg });
            }
        } catch (error) {


            return res.status(401).json({ error: error.message });
        }
    }
    else if (txn.game == 'Golden Doge') {
        try {
            const account = txn.gameuser;
            const amount = txn.amount;

            const url = `https://swback.logiclane.tech/api/gdog/withdrawUser`;
            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

            const data = {
                userName: account,
                amount: amount
            }

            const response = await axios.post(url, data, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            });

            const resultJson = response.data;

            if (resultJson?.code === '200' || resultJson?.code === 200) {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '1'
                })

                const user = await KioskUser.findOne({ where: { phone: phone } })
                if (user) {
                    await user.increment('balance', { by: amount });
                }
                return res.status(200).json({ id: txnCreate?.id, message: 'Redeem approved' });
            } else {
                const txnCreate = await KioskTxns.create({
                    phone: phone,
                    gameuser: gameuser,
                    gameid: gameid,
                    amount: amount,
                    type: '2',
                    status: '2'
                })
                return res.status(409).json({ id: txnCreate?.id, error: resultJson.msg });
            }
        } catch (error) {


            return res.status(401).json({ error: error.message });
        }
    }
}
function getHash(param, APIAuthorizationCode, secretkey) {
    const key = APIAuthorizationCode + secretkey;
    const message = param;
    const hash = crypto.createHmac('sha256', key).update(message).digest('hex');
    return hash;
}
exports.creation = async (req, res) => {
    const { game, phone } = req.body
    const game_id = game.id
    const creation = {
        phone: phone,
        Game: {
            name: game.name,
            id: game.id
        }
    }
    if (game_id == 38 && creation.Game.name == 'Fire Phoenix') {
        const linked_games = await KioskCreation.findOne({
            where: { phone: creation.phone, gameid: game_id }
        })
        if (linked_games) {
            return res.status(200).json({ status: 'error', message: 'Account already created' });
        }
        const timestamp = Math.floor(Date.now() / 1000);
        const hash = crypto.createHash('md5').update(`ramon1kUfpv2qECNZkYsg3hcu7${timestamp}`).digest('hex').toUpperCase();

        const payload = {
            action: 'addUser',
            keyAgent: 'ramon1',
            agent: 'Sweepstakes7',
            time: timestamp,
            token: hash,
            ts: 0.7216318002132696
        };

        const formData = qs.stringify(payload);
        try {
            const url = "https://api.fpc-mob.com/ashx/CheckAccount.ashx";

            const response = await axios.post(url, formData, {
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded'
                }
            })

            const resultJson = response.data;

            // console.log(resultJson);
            if (resultJson && resultJson.success == true) {
                const account = resultJson.account;
                const password = resultJson.password;

                // creation.guserid = account;
                // creation.cdate = cdate;
                const link_game = new KioskCreation({
                    gameid: creation.Game.id,
                    gameuser: account,
                    gamepass: password,
                    phone: creation.phone,
                    status: '1'
                })
                await link_game.save();
                await sendCreationSMS(`1${phone}`, creation.Game.name, account, password)
                // await creation.save();
                // const imageUrl = creation.Game.image + ".jpg";
                // await sendEmail(creation.User, creation.Game, account, password);
                // const log = new ActivityLog({
                //     admin: admin.username,
                //     activity: creation.Game.name + ' Creation approved',
                //     userid: creation.User.id
                // });
                // await log.save();
                return res.status(200).json({ status: 'success', message: 'Account created successfully', data: { account: account, password: password } });
            } else {
                return res.status(200).json({ status: 'error', message: 'Unable to create account' });
            }

        } catch (e) {
            console.log(e.message)
            return res.status(200).json({ status: 'error', message: 'Unable to create user' });
        }
    } else if (game_id == 29 && creation.Game.name == 'Majik Bonus') {
        const linked_games = await KioskCreation.findOne({
            where: { phone: creation.phone, gameid: game_id }
        })
        if (linked_games) {
            return res.status(200).json({ status: 'error', message: 'Account already created' });
        }
        const login = Date.now().toString() + Math.floor(11111111 + Math.random() * 88888888);
        const password = Math.floor(11111111 + Math.random() * 88888888);

        const data = {
            type: "player",
            account: login,
            password: password.toString(),
            name: login,
            tel: login,
            desc: login,
            lang: "en"
        };
        // const secret = '7378ae5ce34d408587ceae38ad3dabca';
        // const key = 'A1asd4fhu4E45Gdmk';
        // const hash = getHash(JSON.stringify(data), secret, key);

        const secret = '7378ae5ce34d408587ceae38ad3dabca';
        const key = 'A1asd4fhu4E45Gdmk';
        const hash = getHash(JSON.stringify(data), secret, key);

        // const url = `https://opx.logiclane.tech/public/apis/mjb/createaccount.php?hash=${hash}&account=${login}&password=${password}&phone=`;
        try {
            const url = `https://swback.logiclane.tech/api/mjb/createaccount?hash=${hash}&account=${login}&password=${password}&phone=${login}`;


            const response = await axios.get(url, {
                headers: {
                    'Content-Type': 'application/json'
                },

            })

            let resultJson = response.data;
            console.log(resultJson);
            // const trimmedJson = resultJson.slice(0, -1);
            // resultJson = trimmedJson
            // resultJson = JSON.parse(resultJson)
            // console.log(resultJson);
            if (resultJson && resultJson.status == 'success') {
                const account = resultJson.account;
                const password = resultJson.password;

                // creation.guserid = account;
                // creation.cdate = cdate;
                const link_game = new KioskCreation({
                    gameid: creation.Game.id,
                    gameuser: account,
                    gamepass: password,
                    phone: creation.phone,
                    status: '1'
                })
                await link_game.save();
                await sendCreationSMS(`1${phone}`, creation.Game.name, account, password)

                return res.status(200).json({ status: 'success', message: 'Account created successfully', data: { account: account, password: password } });
            } else {
                // console.log(resultJson);

                return res.status(200).json({ status: 'error', message: 'Unable to create account' });
            }


        } catch (e) {
            console.log(e.message)
            return res.status(200).json({ status: 'error', message: 'Unable to create user' });
        }
    } else if (game_id == 20 && creation.Game.name == 'Galaxy') {
        const linked_games = await KioskCreation.findOne({
            where: { phone: creation.phone, gameid: game_id }
        })
        if (linked_games) {
            return res.status(200).json({ status: 'error', message: 'Account already created' });
        }
        const timestamp = Math.floor(Date.now() / 1000);
        const signatureString = `52277:${timestamp}:d620176e98baec2c8a3e5b5fcc24d47c`;
        const signature = crypto.createHash('md5').update(signatureString).digest('hex');
        const account = creation.Game.name.substring(0, 4) + Math.floor(11111111 + Math.random() * 88888888);
        const login_pwd = Math.floor(11111111 + Math.random() * 88888888);

        const formData = new FormData();
        formData.append('agent_id', '52277');
        formData.append('timestamp', timestamp);
        formData.append('token', signature);
        formData.append('account', account);
        formData.append('login_pwd', login_pwd);
        try {
            const response = await axios.post('https://swback.logiclane.tech/api/galaxy/addAccount', formData, {
                headers: {
                    ...formData.getHeaders()
                },
            })
            const resultJson = response.data;
            console.log(resultJson);
            if (resultJson && resultJson.msg == 'Success') {

                const account = resultJson.data.user_id;
                const gameuserid = resultJson.data.account_name
                const password = login_pwd;

                // creation.guserid = account;
                // creation.cdate = cdate;
                const link_game = new KioskCreation({
                    gameid: creation.Game.id,
                    gameuser: gameuserid,
                    gameuserid: account,
                    gamepass: password,
                    phone: creation.phone,
                    status: '1'
                })
                await link_game.save();
                await sendCreationSMS(`1${phone}`, creation.Game.name, account, login_pwd)

                return res.status(200).json({ status: 'success', message: 'Account created successfully', data: { account: account, password: login_pwd } });
            } else {
                return res.status(200).json({ status: 'error', message: 'Unable to create account' });
            }

        } catch (e) {
            console.log(e.message)
            return res.status(200).json({ status: 'error', message: 'Unable to create user' });
        }
    } else if (game_id == 3 && creation.Game.name == 'River Sweeps') {
        const linked_games = await KioskCreation.findOne({
            where: { phone: creation.phone, gameid: game_id }
        })
        if (linked_games) {
            return res.status(200).json({ status: 'error', message: 'Account already created' });
        }
        // const url = `https://gvmck6p5yqtfagp.riversweeps.game/public/apis/rs/createAccount.php`;
        try {
            const url = 'https://swback.logiclane.tech/api/rs/createAccount'

            const response = await axios.get(url, {

                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61'
                }
            })

            const resultJson = response.data;
            // console.log(resultJson);
            if (resultJson && resultJson.STATUS == '0') {

                const account = resultJson.data.code;
                const password = resultJson.data.code;

                // creation.guserid = account;
                // creation.cdate = cdate;
                const link_game = new KioskCreation({
                    gameid: creation.Game.id,
                    gameuser: account,
                    gamepass: password,
                    phone: creation.phone,
                    status: '1'
                })
                await link_game.save();

                await sendCreationSMS(`1${phone}`, creation.Game.name, account, password)

                return res.status(200).json({ status: 'success', message: 'Account created successfully', data: { account: account, password: password } });
            } else {
                return res.status(200).json({ status: 'error', message: 'Unable to create account' });

            }


        } catch (e) {
            console.log(e.message)
            return res.status(200).json({ status: 'error', message: 'Unable to create user' });
        }
    } else if (game_id == 49 && creation.Game.name == 'Fortune Panda') {
        const linked_games = await KioskCreation.findOne({
            where: { phone: creation.phone, gameid: game_id }
        })
        if (linked_games) {
            return res.status(200).json({ status: 'error', message: 'Account already created' });
        }
        const prefix = creation.Game.name.substring(0, 4).toLowerCase();
        const randomNumbers = Math.floor(1000 + Math.random() * 9000);
        const newString = `${prefix}${randomNumbers}`;

        const account = newString;
        const passwd = newString;
        // const url = `https://gvmck6p5yqtfagp.riversweeps.game/public/apis/fp/createAccount.php?account=${account}&passwd=${passwd}`;
        try {
            const url = `https://swback.logiclane.tech/api/fp/createAccount?account=${account}&passwd=${passwd}`

            const response = await axios.get(url, {

                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61'
                }
            })

            const resultJson = response.data;
            // console.log(resultJson);
            if (resultJson && resultJson.code == '200') {

                // creation.guserid = account;
                // creation.cdate = cdate;
                const link_game = new KioskCreation({
                    gameid: creation.Game.id,
                    gameuser: account,
                    gamepass: passwd,
                    phone: creation.phone,
                    status: '1'
                })
                await link_game.save();
                await sendCreationSMS(`1${phone}`, creation.Game.name, account, passwd)

                return res.status(200).json({ status: 'success', message: 'Account created successfully', data: { account: account, password: passwd } });
            } else {
                return res.status(200).json({ status: 'error', message: resultJson.msg ?? 'Unable to create account' });

            }


        } catch (e) {
            console.log(e.message)
            return res.status(200).json({ status: 'error', message: 'Unable to create user' });
        }
    } else if (game_id == 7 && creation.Game.name == 'Blue Dragon') {
        const linked_games = await KioskCreation.findOne({
            where: { phone: creation.phone, gameid: game_id }
        })
        if (linked_games) {
            return res.status(200).json({ status: 'error', message: 'Account already created' });
        }
        const prefix = creation.Game.name.substring(0, 4).toLowerCase();
        const randomNumbers = Math.floor(1000 + Math.random() * 9000);
        const newString = `${prefix}${randomNumbers}`;

        const account = newString;
        const passwd = newString;
        // const url = `https://gvmck6p5yqtfagp.riversweeps.game/public/apis/bd/createAccount.php?account=${account}&passwd=${passwd}`;
        try {
            const url = `https://swback.logiclane.tech/api/bd/createAccount?account=${account}&passwd=${passwd}`;

            const response = await axios.get(url, {

                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61'
                }
            })

            const resultJson = response.data;
            // console.log(resultJson);
            if (resultJson && resultJson.code == '0') {

                // creation.guserid = account;
                // creation.cdate = cdate;
                const link_game = new KioskCreation({
                    gameid: creation.Game.id,
                    gameuser: account,
                    gamepass: passwd,
                    phone: creation.phone,
                    status: '1'
                })
                await link_game.save();
                await sendCreationSMS(`1${phone}`, creation.Game.name, account, passwd)

                return res.status(200).json({ status: 'success', message: 'Account created successfully', data: { account: account, password: passwd } });
            } else {
                return res.status(200).json({ status: 'error', message: resultJson.msg ?? 'Unable to create account' });
            }

        } catch (e) {
            console.log(e.message)
            return res.status(200).json({ status: 'error', message: 'Unable to create user' });
        }
    } else if (game_id == 45 && creation.Game.name == 'Fire Dragon') {
        const linked_games = await KioskCreation.findOne({
            where: { phone: creation.phone, gameid: game_id }
        })
        if (linked_games) {
            return res.status(200).json({ status: 'error', message: 'Account already created' });
        }
        const prefix = creation.Game.name.substring(0, 4).toLowerCase();
        const randomNumbers = Math.floor(1000 + Math.random() * 9000);
        const newString = `${prefix}${randomNumbers}`;

        const account = newString;
        const passwd = newString;
        // const url = `https://gvmck6p5yqtfagp.riversweeps.game/public/apis/fd/createAccount.php?account=${account}&passwd=${passwd}`;
        try {
            const url = `https://swback.logiclane.tech/api/fd/createAccount?account=${account}&passwd=${passwd}`;

            const response = await axios.get(url, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61'
                }
            })

            const resultJson = response.data;
            // console.log(resultJson);
            if (resultJson && resultJson.code == '0') {


                // creation.guserid = account;
                // creation.cdate = cdate;
                const link_game = new KioskCreation({
                    gameid: creation.Game.id,
                    gameuser: account,
                    gamepass: passwd,
                    phone: creation.phone,
                    status: '1'
                })
                await link_game.save();

                await sendCreationSMS(`1${phone}`, creation.Game.name, account, passwd)

                return res.status(200).json({ status: 'success', message: 'Account created successfully', data: { account: account, password: passwd } });
            } else {
                return res.status(200).json({ status: 'error', message: resultJson.msg ?? 'Unable to create account' });

            }

        } catch (e) {
            console.log(e.message)
            return res.status(200).json({ status: 'error', message: 'Unable to create user' });
        }
    } else if (game_id == 47 && creation.Game.name == 'EasyStreet') {
        const linked_games = await KioskCreation.findOne({
            where: { phone: creation.phone, gameid: game_id }
        })
        if (linked_games) {
            return res.status(200).json({ status: 'error', message: 'Account already created' });
        }

        const prefix = creation.Game.name.substring(0, 4).toLowerCase();
        const randomNumbers = Math.floor(1000 + Math.random() * 9000);
        const newString = `${prefix}${randomNumbers}`;

        const account = newString;
        const passwd = newString;

        const timestamp = Math.floor(Date.now() / 1000);
        const secretKey = "L2K8GV89R9H92MY4YCY4DTL6U4RYGA8R";
        const auth_code = "PQEH73ZS53QDGUPF4W9JBJGAHV3UBGVX";

        const sign = crypto
            .createHash('sha1')
            .update(`${account}${timestamp}${secretKey}`)
            .digest('hex');

        const post = JSON.stringify({
            name: account,
            email: account,
            username: account,
            password: passwd,
            timestamp: timestamp,
            sign: sign,
            auth_code: auth_code
        });
        try {
            // const url = "https://opx.logiclane.tech/public/apis/es/createUser.php";
            const url = "https://swback.logiclane.tech/api/es/createUser";

            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";


            const postData = JSON.parse(post);

            const response = await axios.post(url, postData, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            })

            const resultJson = response.data;
            // console.log(resultJson); 

            if (resultJson && resultJson.status === 'OK') {

                // creation.guserid = account;
                // creation.cdate = cdate;
                const link_game = new KioskCreation({
                    gameid: creation.Game.id,
                    gameuser: account,
                    gamepass: passwd,
                    phone: creation.phone,
                    status: '1'
                })
                await link_game.save();

                await sendCreationSMS(`1${phone}`, creation.Game.name, account, passwd)

                return res.status(200).json({ status: 'success', message: 'Account created successfully', data: { account: account, password: passwd } });
            } else {
                return res.status(200).json({ status: 'success', message: resultJson.message ?? 'Unable to create account' });

            }


        } catch (e) {
            console.log(e.message)
            return res.status(200).json({ status: 'error', message: 'Unable to create user' });
        }
    } else if (game_id == 48 && creation.Game.name == 'Mega Link') {
        const linked_games = await KioskCreation.findOne({
            where: { phone: creation.phone, gameid: game_id }
        })
        if (linked_games) {
            return res.status(200).json({ status: 'error', message: 'Account already created' });
        }
        const rawName = creation.Game.name.trim();
        const noSpaces = rawName.replace(/\s+/g, ''); // Remove all whitespace
        const prefix = noSpaces.substring(0, 4).toLowerCase().padEnd(4, 'x');
        const randomNumbers = Math.floor(Math.random() * 10000).toString().padStart(4, '0');
        const newString = `${prefix}${randomNumbers}`; // Always 8 characters

        const account = newString;
        const passwd = newString;

        const timestamp = Math.floor(Date.now() / 1000);
        const secretKey = "D8R6BRLGMXUL6VT52LMQJRM8QRU5RPDR";
        const auth_code = "VVKYHAFHKWRWSS8KY2XE6AE3XUNVEVUD";

        const sign = crypto
            .createHash('sha1')
            .update(`${account}${timestamp}${secretKey}`)
            .digest('hex');

        const post = JSON.stringify({
            name: account,
            email: creation.User.email,
            username: account,
            password: passwd,
            timestamp: timestamp,
            sign: sign,
            auth_code: auth_code
        });
        // const url = "https://opx.logiclane.tech/public/apis/ml/createUser.php";
        try {
            const url = "https://swback.logiclane.tech/api/ml/createUser";

            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";


            const postData = JSON.parse(post);

            const response = await axios.post(url, postData, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            })

            const resultJson = response.data;
            // console.log(resultJson); 

            if (resultJson && resultJson.status === 'OK') {



                // creation.guserid = account;
                // creation.cdate = cdate;
                const link_game = new KioskCreation({
                    gameid: creation.Game.id,
                    gameuser: account,
                    gamepass: passwd,
                    phone: creation.phone,
                    status: '1'
                })
                await link_game.save();

                await sendCreationSMS(`1${phone}`, creation.Game.name, account, passwd)

                return res.status(200).json({ status: 'success', message: 'Account created successfully', data: { account: account, password: passwd } });
            } else {
                return res.status(200).json({ status: 'success', message: resultJson.message ?? 'Unable to create account' });

            }


        } catch (e) {
            console.log(e.message)
            return res.status(200).json({ status: 'error', message: 'Unable to create user' });
        }
    } else if (game_id == 14 && creation.Game.name == 'Orion Stars') {
        const linked_games = await KioskCreation.findOne({
            where: { phone: creation.phone, gameid: game_id }
        })
        if (linked_games) {
            return res.status(200).json({ status: 'error', message: 'Account already created' });
        }
        const prefix = creation.Game.name.substring(0, 4).toLowerCase();
        const randomNumbers = Math.floor(1000 + Math.random() * 9000);
        const newString = `${prefix}${randomNumbers}`;

        const account = newString;
        const passwd = newString;

        // const timestamp = Math.floor(Date.now() / 1000);
        const secretKey = "YHJGHFVMNFZF3YUAQGL6HWDRKWKUGVSB";
        const auth_code = "HCFYPWXYQFVKUQ2X8MXWKTT86EKLY2FG";

        const timestamp = Date.now(); // Equivalent to (int) (microtime(true) * 1000)

        const agent_key = "HCFYPWXYQFVKUQ2X8MXWKTT86EKLY2FG";
        const sign_string = `${agent_key}${timestamp}YHJGHFVMNFZF3YUAQGL6HWDRKWKUGVSB`;

        const sign = crypto.createHash('md5').update(sign_string, 'utf8').digest('hex');

        const post = JSON.stringify({
            name: account,
            // email: creation.User.email,
            username: account,
            password: passwd,
            timestamp: timestamp,
            sign: sign,
            agent_key: auth_code
        });
        // const url = "https://opx.logiclane.tech/public/apis/ostars/add_user.php";
        try {
            const url = "https://swback.logiclane.tech/api/ostars/add_user";

            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";


            const postData = JSON.parse(post);

            const response = await axios.post(url, postData, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            })

            const resultJson = response.data;
            // console.log(resultJson); 

            if (resultJson && resultJson.status == 'OK') {

                // creation.guserid = account;
                // creation.cdate = cdate;
                const link_game = new KioskCreation({
                    gameid: creation.Game.id,
                    gameuser: account,
                    gamepass: passwd,
                    phone: creation.phone,
                    status: '1'
                })
                await link_game.save();
                await sendCreationSMS(`1${phone}`, creation.Game.name, account, passwd)

                return res.status(200).json({ status: 'success', message: 'Account created successfully', data: { account: account, password: passwd } });
            } else {
                return res.status(200).json({ status: 'success', message: resultJson.message ?? 'Unable to create account' });

            }


        } catch (e) {
            console.log(e.message)
            return res.status(200).json({ status: 'error', message: 'Unable to create user' });
        }
    } else if (game_id == 6 && creation.Game.name == 'Skill TX') {
        const linked_games = await KioskCreation.findOne({
            where: { phone: creation.phone, gameid: game_id }
        })
        if (linked_games) {
            return res.status(200).json({ status: 'error', message: 'Account already created' });
        }

        // const url = `https://gvmck6p5yqtfagp.riversweeps.game/public/apis/rs/createAccount.php`;
        // const url = 'https://opx.logiclane.tech/public/apis/stx/createAccount.php'

        try {
            const url = 'https://swback.logiclane.tech/api/stx/createAccount'
            const response = await axios.get(url, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61'
                }
            })

            const resultJson = response.data;
            // console.log(resultJson);
            if (resultJson && resultJson.status == '1' ||
                resultJson && resultJson.status == 1
            ) {

                const account = resultJson.login;
                const password = resultJson.password;

                // creation.guserid = account;
                // creation.cdate = cdate;
                const link_game = new KioskCreation({
                    gameid: creation.Game.id,
                    gameuser: account,
                    gamepass: password,
                    phone: creation.phone,
                    status: '1'
                })
                await link_game.save();
                await sendCreationSMS(`1${phone}`, creation.Game.name, account, password)

                return res.status(200).json({ status: 'success', message: 'Account created successfully', data: { account: account, password: password } });
            } else {
                return res.status(200).json({ status: 'error', message: 'Unable to create account' });
            }

        } catch (e) {
            console.log(e.message)
            return res.status(200).json({ status: 'error', message: 'Unable to create user' });
        }
    } else if (game_id == 51 && creation.Game.name == 'Jack2Win') {
        const linked_games = await KioskCreation.findOne({
            where: { phone: creation.phone, gameid: game_id }
        })
        if (linked_games) {
            return res.status(200).json({ status: 'error', message: 'Account already created' });
        }
        const prefix = creation.Game.name.substring(0, 2).toLowerCase();
        const randomNumbers = Math.floor(1000 + Math.random() * 9000);
        const newString = `${prefix}${randomNumbers}`;
        const accountMain = `LKY${newString}`;
        const account = newString;
        const passwd = newString;

        const timestamp = Math.floor(Date.now() / 1000);
        const secretKey = "L2K8GV89R9H92MY4YCY4DTL6U4RYGA8R";
        const auth_code = "PQEH73ZS53QDGUPF4W9JBJGAHV3UBGVX";

        const sign = crypto
            .createHash('sha1')
            .update(`${account}${timestamp}${secretKey}`)
            .digest('hex');

        // const post = JSON.stringify({
        //     name: account,
        //     email: creation.User.email,
        //     username: account,
        //     password: passwd,
        //     timestamp: timestamp,
        //     sign: sign,
        //     auth_code: auth_code
        // });
        // const url = `https://opx.logiclane.tech/public/apis/jwin/createAccount.php?account=${account}&passwd=${passwd}`;
        try {
            const url = `https://swback.logiclane.tech/api/jwin/createAccount?account=${account}&passwd=${passwd}`;

            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";


            // const postData = JSON.parse(post);

            const response = await axios.get(url, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            })

            const resultJson = response.data;
            // console.log(resultJson); 

            if (resultJson && resultJson.code == '0' ||
                resultJson && resultJson.code == 0
            ) {

                // creation.guserid = account;
                // creation.cdate = cdate;
                const link_game = new KioskCreation({
                    gameid: creation.Game.id,
                    gameuser: account,
                    gamepass: passwd,
                    phone: creation.phone,
                    status: '1'
                })
                await link_game.save();
                await sendCreationSMS(`1${phone}`, creation.Game.name, account, passwd)

                return res.status(200).json({ status: 'success', message: 'Account created successfully', data: { account: account, password: passwd } });
            } else {
                return res.status(200).json({ status: 'error', message: resultJson.message ?? 'Unable to create account' });

            }

        } catch (e) {
            console.log(e.message)
            return res.status(200).json({ status: 'error', message: 'Unable to create user' });
        }
    } else if (game_id == 50 && creation.Game.name == 'Dragon Game') {
        const linked_games = await KioskCreation.findOne({
            where: { phone: creation.phone, gameid: game_id }
        })
        if (linked_games) {
            return res.status(200).json({ status: 'error', message: 'Account already created' });
        }
        const prefix = creation.Game.name.substring(0, 4).toLowerCase();
        const randomNumbers = Math.floor(1000 + Math.random() * 9000);
        const newString = `${prefix}${randomNumbers}`;
        // const accountMain = `LKY${newString}`;
        const account = newString;
        const passwd = newString;

        // const timestamp = Math.floor(Date.now() / 1000);
        // const secretKey = "L2K8GV89R9H92MY4YCY4DTL6U4RYGA8R";
        // const auth_code = "PQEH73ZS53QDGUPF4W9JBJGAHV3UBGVX";

        // const sign = crypto
        //     .createHash('sha1')
        //     .update(`${account}${timestamp}${secretKey}`)
        //     .digest('hex');

        // const post = JSON.stringify({
        //     name: account,
        //     email: creation.User.email,
        //     username: account,
        //     password: passwd,
        //     timestamp: timestamp,
        //     sign: sign,
        //     auth_code: auth_code
        // });
        try {
            const url = `https://swback.logiclane.tech/api/dg/createAccount?account=${account}&passwd=${passwd}`;
            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";


            // const postData = JSON.parse(post);

            const response = await axios.get(url, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            })

            const resultJson = response.data;
            // console.log(resultJson); 

            if (resultJson && resultJson.status == 'OK') {


                // creation.guserid = account;
                // creation.cdate = cdate;
                const link_game = new KioskCreation({
                    gameid: creation.Game.id,
                    gameuser: account,
                    gamepass: passwd,
                    gameuserid: resultJson.user_id,
                    phone: creation.phone,
                    status: '1'
                })
                await link_game.save();

                await sendCreationSMS(`1${phone}`, creation.Game.name, account, passwd)

                return res.status(200).json({ status: 'success', message: 'Account created successfully', data: { account: account, password: passwd } });
            } else {
                return res.status(200).json({ status: 'error', message: resultJson.message });

            }


        } catch (e) {
            console.log(e.message)
            return res.status(200).json({ status: 'error', message: 'Unable to create user' });
        }
    }
    else if (game_id == 2 && creation.Game.name == 'Fire Kirin') {
        const linked_games = await KioskCreation.findOne({
            where: { phone: creation.phone, gameid: game_id }
        })
        if (linked_games) {
            return res.status(200).json({ status: 'error', message: 'Account already created' });
        }
        const prefix = creation.Game.name.substring(0, 4).toLowerCase();
        const randomNumbers = Math.floor(1000 + Math.random() * 9000);
        const newString = `${prefix}${randomNumbers}`;
        // const accountMain = `LKY${newString}`;
        const account = newString;
        const passwd = newString;
        try {

            const url = `https://swback.logiclane.tech/api/fk/createAccount?account=${account}&passwd=${passwd}`;
            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";


            // const postData = JSON.parse(post);

            const response = await axios.get(url, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            })

            const resultJson = response.data;
            console.log(resultJson);

            if (resultJson && resultJson.code == '200') {

                // creation.guserid = account;
                // creation.cdate = cdate;
                const link_game = new KioskCreation({
                    gameid: creation.Game.id,
                    gameuser: account,
                    gamepass: passwd,
                    phone: creation.phone,
                    status: '1'
                })
                await link_game.save();
                await sendCreationSMS(`1${phone}`, creation.Game.name, account, passwd)


                return res.status(200).json({ status: 'success', message: 'Account created successfully', data: { account: account, password: passwd } });
            } else {
                return res.status(200).json({ status: 'error', message: resultJson?.msg ?? 'Unable to create account' });

            }

        } catch (e) {
            console.log(e.message)
            return res.status(200).json({ status: 'error', message: 'Unable to create user' });
        }
    }
    else if (game_id == 18 && creation.Game.name == 'Panda Master') {
        const linked_games = await KioskCreation.findOne({
            where: { phone: creation.phone, gameid: game_id }
        })
        if (linked_games) {
            return res.status(200).json({ status: 'error', message: 'Account already created' });
        }
        const prefix = creation.Game.name.substring(0, 4).toLowerCase();
        const randomNumbers = Math.floor(1000 + Math.random() * 9000);
        const newString = `${prefix}${randomNumbers}`;
        // const accountMain = `LKY${newString}`;
        const account = newString;
        const passwd = newString;
        try {

            const url = `https://swback.logiclane.tech/api/pm/createAccount?account=${account}&passwd=${passwd}`;
            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";


            // const postData = JSON.parse(post);

            const response = await axios.get(url, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            })

            const resultJson = response.data;
            // console.log(resultJson); 

            if (resultJson && resultJson.code == '200') {

                // creation.guserid = account;
                // creation.cdate = cdate;
                const link_game = new KioskCreation({
                    gameid: creation.Game.id,
                    gameuser: account,
                    gamepass: passwd,
                    phone: creation.phone,
                    status: '1'
                })
                await link_game.save();
                await sendCreationSMS(`1${phone}`, creation.Game.name, account, passwd)


                return res.status(200).json({ status: 'success', message: 'Account created successfully', data: { account: account, password: passwd } });
            } else {
                return res.status(200).json({ status: 'success', message: resultJson?.msg ?? 'Unable to create account' });

            }

        } catch (e) {
            console.log(e.message)
            return res.status(200).json({ status: 'error', message: 'Unable to create user' });
        }
    }
    else if (game_id == 10 && creation.Game.name == 'Kraken') {
        const linked_games = await KioskCreation.findOne({
            where: { phone: creation.phone, gameid: game_id }
        })
        if (linked_games) {
            return res.status(200).json({ status: 'error', message: 'Account already created' });
        }
        const prefix = creation.Game.name.substring(0, 4).toLowerCase();
        const randomNumbers = Math.floor(1000 + Math.random() * 9000);
        const newString = `${prefix}${randomNumbers}`;
        // const accountMain = `LKY${newString}`;
        const account = newString;
        const passwd = newString;
        try {

            const url = `https://swback.logiclane.tech/api/kr/createAccount?account=${account}&passwd=${passwd}`;
            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";


            // const postData = JSON.parse(post);

            const response = await axios.get(url, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            })

            const resultJson = response.data;
            // console.log(resultJson); 

            if (resultJson && resultJson.code == '200') {


                const link_game = new KioskCreation({
                    gameid: creation.Game.id,
                    gameuser: account,
                    gamepass: passwd,
                    phone: creation.phone,
                    status: '1'
                })
                await link_game.save();
                await sendCreationSMS(`1${phone}`, creation.Game.name, account, passwd)


                return res.status(200).json({ status: 'success', message: 'Account created successfully', data: { account: account, password: passwd } });
            } else {
                return res.status(200).json({ status: 'error', message: resultJson.msg ?? 'Unable to create account' });

            }
        } catch (e) {
            console.log(e.message)
            return res.status(200).json({ status: 'error', message: 'Unable to create user' });
        }
    }
    else if (game_id == 53 && creation.Game.name == 'Golden Spin') {
        const linked_games = await KioskCreation.findOne({
            where: { phone: creation.phone, gameid: game_id }
        })
        if (linked_games) {
            return res.status(200).json({ status: 'error', message: 'Account already created' });
        }
        const prefix = creation.Game.name.substring(0, 4).toLowerCase();
        const randomNumbers = Math.floor(1000 + Math.random() * 9000);
        const newString = `${prefix}${randomNumbers}`;
        // const accountMain = `LKY${newString}`;
        const account = newString;
        const passwd = newString;
        try {

            const url = `https://swback.logiclane.tech/api/gs/createUser`;
            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

            const data = {
                userName: account,
                password: passwd
            }

            // const url = `https://swback.logiclane.tech/api/pm/createAccount?account=${account}&passwd=${passwd}`;
            // const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";


            // const postData = JSON.parse(post);

            const response = await axios.post(url, data, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            })

            const resultJson = response.data;
            // console.log(resultJson); 

            if (resultJson && resultJson.code == '200') {


                const link_game = new KioskCreation({
                    gameid: creation.Game.id,
                    gameuser: account,
                    gamepass: passwd,
                    phone: creation.phone,
                    status: '1'
                })
                await link_game.save();
                await sendCreationSMS(`1${phone}`, creation.Game.name, account, passwd)


                return res.status(200).json({ status: 'success', message: 'Account created successfully', data: { account: account, password: passwd } });
            } else {
                return res.status(200).json({ status: 'error', message: resultJson.msg ?? 'Unable to create account' });

            }

        } catch (e) {
            console.log(e.message)
            return res.status(200).json({ status: 'error', message: 'Unable to create user' });
        }
    }
    else if (game_id == 54 && creation.Game.name == 'Clover Crown') {
        const linked_games = await KioskCreation.findOne({
            where: { phone: creation.phone, gameid: game_id }
        })
        if (linked_games) {
            return res.status(200).json({ status: 'error', message: 'Account already created' });
        }
        const prefix = creation.Game.name.substring(0, 4).toLowerCase();
        const randomNumbers = Math.floor(1000 + Math.random() * 9000);
        const newString = `${prefix}${randomNumbers}`;
        // const accountMain = `LKY${newString}`;
        const account = newString;
        const passwd = newString;
        try {


            const url = `https://swback.logiclane.tech/api/cc/createUser`;
            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

            const data = {
                userName: account,
                password: passwd
            }

            // const url = `https://swback.logiclane.tech/api/pm/createAccount?account=${account}&passwd=${passwd}`;
            // const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";


            // const postData = JSON.parse(post);

            const response = await axios.post(url, data, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            })

            const resultJson = response.data;
            // console.log(resultJson); 

            if (resultJson && resultJson.code == '200') {

                const link_game = new KioskCreation({
                    gameid: creation.Game.id,
                    gameuser: account,
                    gamepass: passwd,
                    phone: creation.phone,
                    status: '1'
                })
                await link_game.save();

                await sendCreationSMS(`1${phone}`, creation.Game.name, account, passwd)

                return res.status(200).json({ status: 'success', message: 'Account created successfully', data: { account: account, password: passwd } });
            } else {
                return res.status(200).json({ status: 'error', message: resultJson.msg ?? 'Unable to create account' });

            }


        } catch (e) {
            console.log(e.message)
            return res.status(200).json({ status: 'error', message: 'Unable to create user' });
        }
    }
    else if (game_id == 56 && creation.Game.name == 'Vegas Jackpots') {
        const linked_games = await KioskCreation.findOne({
            where: { phone: creation.phone, gameid: game_id }
        })
        if (linked_games) {
            return res.status(200).json({ status: 'error', message: 'Account already created' });
        }

        try {
            const prefix = creation.Game.name.substring(0, 4).toLowerCase();
            const randomNumbers = Math.floor(1000 + Math.random() * 9000);
            const newString = `${prefix}${randomNumbers}`;
            // const accountMain = `LKY${newString}`;
            const account = newString;
            const passwd = newString;

            const url = `https://swback.logiclane.tech/api/vj/createUser`;
            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

            const data = {
                userName: account,
                password: passwd
            }
            const response = await axios.post(url, data, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            })

            const resultJson = response.data;
            // console.log(resultJson); 

            if (resultJson && resultJson.code == '200') {

                const link_game = new KioskCreation({
                    gameid: creation.Game.id,
                    gameuser: account,
                    gamepass: passwd,
                    phone: creation.phone,
                    status: '1'
                })
                await link_game.save();

                await sendCreationSMS(`1${phone}`, creation.Game.name, account, passwd)

                return res.status(200).json({ status: 'success', message: 'Account created successfully', data: { account: account, password: passwd } });
            } else {
                return res.status(200).json({ status: 'error', message: resultJson.msg ?? 'Unable to create account' });

            }
        } catch (error) {
            console.error('Error: ', error.message);
            //  res.json({ error: error.message });
            return res.status(200).json({ status: 'error', message: 'Unable to create user' });
        }
    }
    else if (game_id == 57 && creation.Game.name == 'Orion Stars 2') {
        const linked_games = await KioskCreation.findOne({
            where: { phone: creation.phone, gameid: game_id }
        })
        if (linked_games) {
            return res.status(200).json({ status: 'error', message: 'Account already created' });
        }
        try {
            const prefix = creation.Game.name.substring(0, 4).toLowerCase();
            const randomNumbers = Math.floor(1000 + Math.random() * 9000);
            const newString = `${prefix}${randomNumbers}`;
            // const accountMain = `LKY${newString}`;
            const account = newString;
            const passwd = newString;

            const url = `https://swback.logiclane.tech/api/os2/createUser`;
            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

            const data = {
                userName: account,
                password: passwd
            }
            const response = await axios.post(url, data, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            })

            const resultJson = response.data;
            // console.log(resultJson); 

            if (resultJson && resultJson.code == '200') {


                const link_game = new KioskCreation({
                    gameid: creation.Game.id,
                    gameuser: account,
                    gamepass: passwd,
                    phone: creation.phone,
                    status: '1'
                })
                await link_game.save();
                await sendCreationSMS(`1${phone}`, creation.Game.name, account, passwd)

                return res.status(200).json({ status: 'success', message: 'Account created successfully', data: { account: account, password: passwd } });
            } else {
                return res.status(200).json({ status: 'error', message: resultJson.msg ?? 'Unable to create account' });

            }
        } catch (error) {
            console.error('Error: ', error.message);
            return res.status(200).json({ status: 'error', message: 'Unable to create user' });
            //  res.json({ error: error.message });
        }
    }
    else if (game_id == 55 && creation.Game.name == 'Black Mamba') {
        const linked_games = await KioskCreation.findOne({
            where: { phone: creation.phone, gameid: game_id }
        })
        if (linked_games) {
            return res.status(200).json({ status: 'error', message: 'Account already created' });
        }

        try {
            const url = "https://swback.logiclane.tech/api/bm/createAccount";
            // const url = "http://localhost/api/bm/createAccount";

            const response = await axios.get(url, {
                headers: {
                    'Content-Type': 'application/json'
                }
            })
            console.log("bm", response)
            const resultJson = response.data;

            // console.log(resultJson);
            if (resultJson && resultJson.success == true) {


                const account = resultJson.account;
                const password = resultJson.password;

                // creation.guserid = account;
                // creation.cdate = cdate;
                const link_game = new KioskCreation({
                    gameid: creation.Game.id,
                    gameuser: account,
                    gamepass: password,
                    phone: creation.phone,
                    status: '1'
                })
                await link_game.save();

                await sendCreationSMS(`1${phone}`, creation.Game.name, account, password)

                return res.status(200).json({ status: 'success', message: 'Account created successfully', data: { account: account, password: password } });
            } else {
                return res.status(200).json({ status: 'error', message: 'Unable to create account' });
            }
        } catch (e) {
            console.log(e)
            return res.json({ error: 'Unable to create account' });
        }
    }
    else if (game_id == 19 && creation.Game.name == 'Golden Treasure') {
        try {
            const linked_games = await KioskCreation.findOne({
                where: { phone: creation.phone, gameid: game_id }
            })
            if (linked_games) {
                return res.status(200).json({ status: 'error', message: 'Account already created' });
            }
            const prefix = creation.Game.name.substring(0, 4).toLowerCase();
            const randomNumbers = Math.floor(1000 + Math.random() * 9000);
            const newString = `${prefix}${randomNumbers}`;
            // const accountMain = `LKY${newString}`;
            const account = newString;
            const passwd = newString;

            const url = `https://swback.logiclane.tech/api/gt/createAccount?account=${account}&passwd=${passwd}`;
            // const url = `http://localhost/api/gt/createAccount?account=${account}&passwd=${passwd}`;
            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

            const fullAccount = `SWS${account}`
            // const postData = JSON.parse(post);

            const response = await axios.get(url, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            })

            const resultJson = response.data;
            // console.log(resultJson); 

            if (resultJson && resultJson.code == '1') {


                // creation.guserid = account;
                // creation.cdate = cdate;
                const link_game = new KioskCreation({
                    gameid: creation.Game.id,
                    gameuser: fullAccount,
                    gamepass: passwd,
                    gameuserid: account,
                    phone: creation.phone,
                    status: '1'
                })
                await link_game.save();

                await sendCreationSMS(`1${phone}`, creation.Game.name, fullAccount, passwd)

                return res.status(200).json({ status: 'success', message: 'Account created successfully', data: { account: fullAccount, password: passwd } });
            } else {
                return res.status(200).json({ status: 'error', message: 'Unable to create user' });
            }
        }
        catch (e) {
            console.log(e.message)
            return res.status(200).json({ status: 'error', message: 'Unable to create user' });
        }
    }
    else if (game_id == 8 && creation.Game.name == 'EGame') {
        try {
            const linked_games = await KioskCreation.findOne({
                where: { phone: creation.phone, gameid: game_id }
            })
            if (linked_games) {
                return res.status(200).json({ status: 'error', message: 'Account already created' });
            }
            const prefix = creation.Game.name.substring(0, 4).toLowerCase();
            const randomNumbers = Math.floor(1000 + Math.random() * 9000);
            const newString = `${prefix}${randomNumbers}`;
            // const accountMain = `LKY${newString}`;
            const account = newString;
            const passwd = newString;

            const url = `https://swback.logiclane.tech/api/eg/createAccount?account=${account}&passwd=${passwd}`;
            // const url = `http://localhost/api/gt/createAccount?account=${account}&passwd=${passwd}`;
            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

            const fullAccount = `SWS${account}`
            // const postData = JSON.parse(post);

            const response = await axios.get(url, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            })

            const resultJson = response.data;
            // console.log(resultJson); 

            if (resultJson && resultJson.code == '1') {

                const link_game = new KioskCreation({
                    gameid: creation.Game.id,
                    gameuser: fullAccount,
                    gamepass: passwd,
                    gameuserid: account,
                    phone: creation.phone,
                    status: '1'
                })
                await link_game.save();

                await sendCreationSMS(`1${phone}`, creation.Game.name, fullAccount, passwd)

                return res.status(200).json({ status: 'success', message: 'Account created successfully', data: { account: fullAccount, password: passwd } });
            } else {
                return res.status(200).json({ status: 'error', message: 'Unable to create user' });
            }
        }
        catch (e) {
            console.log(e.message)
            // return res.status(200).json({ status: 'error', message: 'Unable to create user' });
            return res.status(200).json({ status: 'error', message: 'Unable to create user' });

        }
    }
    else if (game_id == 4 && creation.Game.name == 'VBlink') {
        try {
            const linked_games = await KioskCreation.findOne({
                where: { phone: creation.phone, gameid: game_id }
            })
            if (linked_games) {
                return res.status(200).json({ status: 'error', message: 'Account already created' });
            }
            const prefix = creation.Game.name.substring(0, 4).toLowerCase();
            const randomNumbers = Math.floor(1000 + Math.random() * 9000);
            const newString = `${prefix}${randomNumbers}`;
            // const accountMain = `LKY${newString}`;
            const account = newString;
            const passwd = newString;

            const url = `https://swback.logiclane.tech/api/vb/createAccount?account=${account}&passwd=${passwd}`;
            // const url = `http://localhost/api/gt/createAccount?account=${account}&passwd=${passwd}`;
            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

            const fullAccount = `SWS${account}`
            // const postData = JSON.parse(post);

            const response = await axios.get(url, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            })

            const resultJson = response.data;
            // console.log(resultJson); 

            if (resultJson && resultJson.code == '1') {


                // creation.guserid = account;
                // creation.cdate = cdate;
                const link_game = new KioskCreation({
                    gameid: creation.Game.id,
                    gameuser: fullAccount,
                    gamepass: passwd,
                    gameuserid: account,
                    phone: creation.phone,
                    status: '1'
                })
                await link_game.save();
                await sendCreationSMS(`1${phone}`, creation.Game.name, fullAccount, passwd)


                return res.status(200).json({ status: 'success', message: 'Account created successfully', data: { account: fullAccount, password: passwd } });
            } else {
                return res.status(200).json({ status: 'error', message: 'Unable to create user' });
            }
        }
        catch (e) {
            console.log(e.message)
            return res.status(200).json({ status: 'error', message: 'Unable to create user' });
        }
    }
    else if (game_id == 9 && creation.Game.name == 'Ultra Panda') {
        try {
            const linked_games = await KioskCreation.findOne({
                where: { phone: creation.phone, gameid: game_id }
            })
            if (linked_games) {
                return res.status(200).json({ status: 'error', message: 'Account already created' });
            }
            const prefix = creation.Game.name.substring(0, 4).toLowerCase();
            const randomNumbers = Math.floor(1000 + Math.random() * 9000);
            const newString = `${prefix}${randomNumbers}`;
            // const accountMain = `LKY${newString}`;
            const account = newString;
            const passwd = newString;

            const url = `https://swback.logiclane.tech/api/up/createAccount?account=${account}&passwd=${passwd}`;
            // const url = `http://localhost/api/gt/createAccount?account=${account}&passwd=${passwd}`;
            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

            const fullAccount = `SWS${account}`
            // const postData = JSON.parse(post);

            const response = await axios.get(url, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            })

            const resultJson = response.data;
            // console.log(resultJson); 

            if (resultJson && resultJson.code == '1') {

                const link_game = new KioskCreation({
                    gameid: creation.Game.id,
                    gameuser: fullAccount,
                    gamepass: passwd,
                    gameuserid: account,
                    phone: creation.phone,
                    status: '1'
                })
                await link_game.save();

                await sendCreationSMS(`1${phone}`, creation.Game.name, fullAccount, passwd)

                return res.status(200).json({ status: 'success', message: 'Account created successfully', data: { account: fullAccount, password: passwd } });
            } else {
                return res.status(200).json({ status: 'error', message: 'Unable to create user' });
            }
        }
        catch (e) {
            console.log(e.message)
            return res.status(200).json({ status: 'error', message: 'Unable to create user' });
        }
    }
    else if (game_id == 39 && creation.Game.name == 'Trex') {
        try {
            const linked_games = await KioskCreation.findOne({
                where: { phone: creation.phone, gameid: game_id }
            })
            if (linked_games) {
                return res.status(200).json({ status: 'error', message: 'Account already created' });
            }
            const prefix = creation.Game.name.substring(0, 4).toLowerCase();
            const randomNumbers = Math.floor(1000 + Math.random() * 9000);
            const newString = `${prefix}${randomNumbers}`;
            // const accountMain = `LKY${newString}`;

            const account = newString;
            const passwd = newString;
            const data = {
                phone: creation.phone,
                email: `${prefix}@gmail.com`,
                name: account
            }
            const url = `https://swback.logiclane.tech/api/trx/createUser`;
            // const url = `http://localhost/api/gt/createAccount?account=${account}&passwd=${passwd}`;
            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

            const fullAccount = `SWS${account}`
            // const postData = JSON.parse(post);

            const response = await axios.post(url, data, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            })

            const resultJson = response.data;
            // console.log(resultJson); 

            if (resultJson && resultJson?.player_id) {
                const link_game = new KioskCreation({

                    gameid: creation.Game.id,
                    gameuser: resultJson.player_id,
                    gamepass: resultJson.player_id,
                    gameuserid: resultJson.player_id,
                    phone: creation.phone,
                    status: '1'
                })
                await link_game.save();

                await sendCreationSMS(`1${phone}`, creation.Game.name, resultJson.player_id, resultJson.player_id)

                return res.status(200).json({ status: 'success', message: 'Account created successfully', data: { account: resultJson.player_id, password: resultJson.player_id } });
            } else {
                return res.status(200).json({ status: 'error', message: 'Unable to create user' });
            }
        }
        catch (e) {
            console.log(e.message)
            return res.status(200).json({ status: 'error', message: 'Unable to create user' });
        }
    }
    else if (game_id == 58 && creation.Game.name == 'Shark Secret 2') {
        const linked_games = await KioskCreation.findOne({
            where: { phone: creation.phone, gameid: game_id }
        })
        if (linked_games) {
            return res.status(200).json({ status: 'error', message: 'Account already created' });
        }
        try {
            const prefix = creation.Game.name.substring(0, 4).toLowerCase();
            const randomNumbers = Math.floor(1000 + Math.random() * 9000);
            const newString = `${prefix}${randomNumbers}`;
            // const accountMain = `LKY${newString}`;
            const account = newString;
            const passwd = newString;

            const url = `https://swback.logiclane.tech/api/ss2/createUser`;
            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

            const data = {
                userName: account,
                password: passwd
            }
            const response = await axios.post(url, data, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            })

            const resultJson = response.data;
            // console.log(resultJson); 

            if (resultJson && resultJson.code == '200') {


                const link_game = new KioskCreation({
                    gameid: creation.Game.id,
                    gameuser: account,
                    gamepass: passwd,
                    phone: creation.phone,
                    status: '1'
                })
                await link_game.save();
                await sendCreationSMS(`1${phone}`, creation.Game.name, account, passwd)

                return res.status(200).json({ status: 'success', message: 'Account created successfully', data: { account: account, password: passwd } });
            } else {
                return res.status(200).json({ status: 'error', message: resultJson.msg ?? 'Unable to create account' });

            }
        } catch (error) {
            console.error('Error: ', error.message);
            return res.status(200).json({ status: 'error', message: 'Unable to create user' });
            //  res.json({ error: error.message });
        }
    }
    else if (game_id == 59 && creation.Game.name == 'Golden Doge') {
        const linked_games = await KioskCreation.findOne({
            where: { phone: creation.phone, gameid: game_id }
        })
        if (linked_games) {
            return res.status(200).json({ status: 'error', message: 'Account already created' });
        }
        try {
            const prefix = creation.Game.name.substring(0, 4).toLowerCase();
            const randomNumbers = Math.floor(1000 + Math.random() * 9000);
            const newString = `${prefix}${randomNumbers}`;
            // const accountMain = `LKY${newString}`;
            const account = newString;
            const passwd = newString;

            const url = `https://swback.logiclane.tech/api/gdog/createUser`;
            const authToken = "4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61";

            const data = {
                userName: account,
                password: passwd
            }
            const response = await axios.post(url, data, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${authToken}`
                }
            })

            const resultJson = response.data;
            // console.log(resultJson); 

            if (resultJson && resultJson.code == '200') {


                const link_game = new KioskCreation({
                    gameid: creation.Game.id,
                    gameuser: account,
                    gamepass: passwd,
                    phone: creation.phone,
                    status: '1'
                })
                await link_game.save();
                await sendCreationSMS(`1${phone}`, creation.Game.name, account, passwd)

                return res.status(200).json({ status: 'success', message: 'Account created successfully', data: { account: account, password: passwd } });
            } else {
                return res.status(200).json({ status: 'error', message: resultJson.msg ?? 'Unable to create account' });

            }
        } catch (error) {
            console.error('Error: ', error.message);
            return res.status(200).json({ status: 'error', message: 'Unable to create user' });
            //  res.json({ error: error.message });
        }
    } else {
        const linked_games = await KioskCreation.findOne({
            where: { phone: creation.phone, gameid: game_id }
        })
        if (linked_games) {
            return res.status(200).json({ status: 'error', message: 'Account already created' });
        }
        const link_game = new KioskCreation({
            gameid: creation.Game.id,
            phone: creation.phone,
            status: '0'
        })
        await link_game.save();
        return res.status(200).json({ status: 'success', message: 'Account creation request successful', data: { requested: '1' } });
    }
}
exports.login = async (req, res) => {
    try {
        const { phone } = req.body
        if (!phone) {
            res.json({ status: 'error', message: 'Phone no is required' })
        }

        const otp = Math.floor(100000 + Math.random() * 900000).toString();

        const user = await KioskUser.findOne({ where: { phone: phone } })
        if (!user) {
            return res.json({ status: 'error', message: 'User does not exists! Please signup.' })


        } else {

            user.otp = otp;
            await user.save();

            await sendSMS("1" + phone, otp);
            return res.json({ status: 'success', message: 'OTP sent to phone no' })
        }

    } catch (e) {
        console.log("error", e.message)
    }
}
exports.resendLoginOTP = async (req, res) => {
    try {
        const { phone } = req.body
        if (!phone) {
            res.json({ status: 'error', message: 'Phone no is required' })
        }

        const user = await KioskUser.findOne({ where: { phone: phone } })
        if (!user) {
            return res.json({ status: 'error', message: 'User does not exists! Please signup.' })
        }
        await sendSMS("1" + phone, user?.otp);
        return res.json({ status: 'success', message: 'OTP sent to phone no' })
    } catch (e) {
        console.log("error", e.message)
    }
}
exports.verifyOTP = async (req, res) => {
    try {
        console.log('🟢 verifyOTP() called with body:', req.body);

        const { phone, otp } = req.body;
        if (!phone || !otp) {
            console.log('❌ Missing phone or OTP');
            return res.json({ status: 'error', message: 'Phone no / OTP is required' });
        }

        const user = await KioskUser.findOne({ where: { phone } });
        if (!user) {
            console.log('❌ User not found for phone:', phone);
            return res.json({ status: 'error', message: 'User not found!' });
        }

        console.log('👤 Found user:', {
            id: user.id,
            firstName: user.firstName,
            lastName: user.lastName,
            verified: user.idenfy_verified,
            verifymobi_token: user.verifymobi_token
        });

        // ✅ Validate OTP
        if (user.otp.toString() !== otp.toString()) {
            return res.json({ status: 'error', message: 'Incorrect OTP!' });
        }

        // 🚫 BAN CHECK — ALWAYS FIRST
        if (user.ban == 1) {
            return res.json({
                status: 'error',
                message: 'User is banned',
                isBanned: 1
            });
        }

        console.log('✅ OTP verified successfully for user:', user.id);

        // ✅ If already verified → issue token
        if (user.idenfy_verified === '1') {
            console.log('🎉 User already verified. Generating access token...');
            user.otp = '';
            await user.save();

            const token = jwt.sign({ id: user.id, phone: user.phone }, process.env.JWT_SECRET);
            return res.status(200).json({ status: 'success', accessToken: token });
        }

        // ⚙️ STEP 1 — Check if existing VerifyMobi token exists
        if (user.verifymobi_token) {
            console.log('🔍 Existing VerifyMobi token found, checking current status...');

            try {
                const verifyCheck = await axios.post('https://verifymobi.com/check_verification', {
                    token: user.verifymobi_token
                });

                const data = verifyCheck?.data;
                const statusCode = data?.data?.status_code;
                const statusText = (data?.data?.verification_status || '').toUpperCase();

                console.log('📋 Current VerifyMobi Status:', statusCode, statusText);

                // ✅ Case 1: Verified → Login immediately
                if (statusCode === 5 || statusText === 'VERIFIED') {
                    console.log('🎉 User verification complete on VerifyMobi. Logging in...');
                    user.idenfy_verified = '1';
                    user.otp = '';
                    await user.save();

                    const token = jwt.sign({ id: user.id, phone: user.phone }, process.env.JWT_SECRET);
                    return res.status(200).json({
                        status: 'success',
                        message: 'Verification complete. Login successful.',
                        accessToken: token
                    });
                }

                // ⚠️ Case 2: Still in progress → reuse existing token
                if ([0, 1, 2, 3, 4].includes(statusCode)) {
                    console.log('⏳ Verification still in progress, reusing existing VerifyMobi session.');
                    const payload = { phone: user.phone, token: user.verifymobi_token };
                    const encoded = Buffer.from(JSON.stringify(payload)).toString('base64');
                    const verify_url = `https://verifymobi.com?data=${encoded}`;
                    const qrDataUrl = await QRCode.toDataURL(verify_url);

                    return res.json({
                        status: 'success',
                        message: 'Verification still in progress.',
                        redirect_url: '/verifyLoginQR',
                        data: {
                            qr_data: qrDataUrl,
                            verify_url,
                            verifymobi_token: user.verifymobi_token
                        }
                    });
                }

                // ❌ Case 3: Rejected / Expired / Suspected → create a new session
                if ([6, 7, 8].includes(statusCode) || ['REJECTED', 'DENIED', 'EXPIRED', 'SUSPECTED'].includes(statusText)) {
                    console.log('⚠️ Old verification invalid. Creating new token...');
                }
            } catch (err) {
                console.error('⚠️ VerifyMobi check_verification failed:', err.message);
            }
        }

        // ⚙️ STEP 2 — Create new verification session
        console.log('🆕 Creating new VerifyMobi verification session...');
        const token = crypto.randomBytes(16).toString('hex');
        const verify = await axios.post('https://verifymobi.com/create_verification', { token });

        if (verify?.data?.status === 'success') {
            const payload = { phone: user.phone, token };
            const encoded = Buffer.from(JSON.stringify(payload)).toString('base64');
            const verify_url = `https://verifymobi.com?data=${encoded}`;
            const qrDataUrl = await QRCode.toDataURL(verify_url);

            user.verifymobi_token = token;
            user.verifymobi_url = verify_url;
            user.otp = '';
            await user.save();

            console.log('🚀 New verification started.');
            return res.json({
                status: 'success',
                message: 'Verification pending — please complete identity verification',
                redirect_url: '/verifyLoginQR',
                data: {
                    qr_data: qrDataUrl,
                    verify_url,
                    verifymobi_token: token
                }
            });
        }

        console.log('❌ Unable to create new verification session.');
        return res.json({
            status: 'error',
            message: verify?.data?.message || 'Unable to create verification session.'
        });

    } catch (e) {
        console.error('💥 verifyOTP error:', e);
        return res.status(500).json({
            status: 'error',
            message: 'Internal server error',
            error: e.message
        });
    }
};
// exports.verifyOTP = async (req, res) => {
//     try {
//         console.log('🟢 verifyOTP() called with body:', req.body);

//         const { phone, otp } = req.body;
//         if (!phone || !otp) {
//             console.log('❌ Missing phone or OTP');
//             return res.json({ status: 'error', message: 'Phone no / OTP is required' });
//         }

//         console.log(`🔍 Searching user with phone: ${phone}`);
//         const user = await KioskUser.findOne({ where: { phone } });

//         if (!user) {
//             console.log('❌ User not found for phone:', phone);
//             return res.json({ status: 'error', message: 'User not found!' });
//         }

//         console.log('👤 Found user:', {
//             id: user.id,
//             firstName: user.firstName,
//             lastName: user.lastName,
//             verified: user.idenfy_verified
//         });

//         // ✅ Check OTP
//         if (user.otp.toString() !== otp.toString()) {
//             console.log(`❌ Incorrect OTP: expected ${user.otp}, got ${otp}`);
//             return res.json({ status: 'error', message: 'Incorrect OTP!' });
//         }

//         console.log('✅ OTP verified successfully for user ID:', user.id);

//         // ✅ If user already verified, return access token
//         if (user.idenfy_verified === '1') {
//             console.log('🎉 User already verified. Generating access token...');
//             user.otp = '';
//             await user.save();

//             const token = jwt.sign(
//                 { id: user.id, phone: user.phone },
//                 process.env.JWT_SECRET
//             );

//             console.log('🔑 JWT generated successfully for verified user:', user.id);
//             return res.status(200).json({ status: 'success', accessToken: token });
//         }

//         // ⚠️ If not verified → start VerifyMobi verification flow
//         console.log('⚠️ User not verified yet. Starting VerifyMobi verification flow...');

//         // Generate a new verification token
//         const token = crypto.randomBytes(16).toString('hex');
//         console.log('🔑 Generated new verification token:', token);

//         // Call VerifyMobi to create verification entry
//         const verify = await axios.post('https://verifymobi.com/create_verification', { token });
//         console.log('📥 VerifyMobi create_verification response:', verify.data);

//         if (verify?.data?.status === 'success') {
//             // Build encoded payload and verify URL
//             const payload = { phone: user.phone, token };
//             const encoded = Buffer.from(JSON.stringify(payload)).toString('base64');
//             const verify_url = `https://verifymobi.com?data=${encoded}`;
//             const qrDataUrl = await QRCode.toDataURL(verify_url);

//             // Update user with verification info
//             user.verifymobi_token = token;
//             user.verifymobi_url = verify_url;
//             user.otp = '';
//             await user.save();

//             console.log('🚀 Verification started. Returning QR code and URL.');
//             return res.json({
//                 status: 'success',
//                 message: 'Verification pending — please complete identity verification',
//                 redirect_url: '/verifyLoginQR',
//                 data: {
//                     qr_data: qrDataUrl,
//                     verify_url,
//                     verifymobi_token: token
//                 }
//             });
//         }

//         // ❌ VerifyMobi call failed
//         console.log('❌ Unable to create verification session.');
//         return res.json({
//             status: 'error',
//             message: verify?.data?.message || 'Unable to create verification session.'
//         });

//     } catch (e) {
//         console.error('💥 verifyOTP error:', e);
//         return res.status(500).json({
//             status: 'error',
//             message: 'Internal server error',
//             error: e.message
//         });
//     }
// };
// exports.verifyOTP = async (req, res) => {
//     try {
//         console.log('🟢 verifyOTP() called with body:', req.body);

//         const { phone, otp } = req.body;
//         if (!phone || !otp) {
//             console.log('❌ Missing phone or OTP');
//             return res.json({ status: 'error', message: 'Phone no / OTP is required' });
//         }

//         console.log(`🔍 Searching user with phone: ${phone}`);
//         const user = await KioskUser.findOne({ where: { phone } });

//         if (!user) {
//             console.log('❌ User not found for phone:', phone);
//             return res.json({ status: 'error', message: 'User not found!' });
//         }

//         console.log('👤 Found user:', {
//             id: user.id,
//             firstName: user.firstName,
//             lastName: user.lastName,
//             idenfy_verified: user.idenfy_verified,
//             idenfy_scanRef: user.idenfy_scanRef
//         });

//         if (user.otp.toString() !== otp.toString()) {
//             console.log(`❌ Incorrect OTP: expected ${user.otp}, got ${otp}`);
//             return res.json({ status: 'error', message: 'Incorrect OTP!' });
//         }

//         // ✅ User exists and OTP is correct
//         console.log('✅ OTP verified successfully for user ID:', user.id);

//         // If not verified via iDenfy yet
//         if (user.idenfy_verified !== '1') {
//             console.log('⚠️ User not verified yet. Starting iDenfy verification flow...');
//             let scanRef = null;
//             let data = null;

//             // Case 1: No scanRef yet → create new token
//             if (!user?.idenfy_scanRef) {
//                 console.log('🆕 No existing scanRef. Generating new iDenfy token...');
//                 const iToken = {
//                     clientId: user.id,
//                     firstName: user.firstName,
//                     lastName: user.lastName,
//                     country: 'US',
//                     successUrl: `https://verifymobi.com/verifySuccess`,
//                     errorUrl: `https://verifymobi.com/verifyError`,
//                     unverifiedUrl: `https://verifymobi.com/unverified`
//                 };
//                 console.log('📤 iDenfy Token Request Payload:', iToken);

//                 const response = await axios.post(
//                     "https://ivs.idenfy.com/api/v2/token",
//                     iToken,
//                     {
//                         auth: {
//                             username: "zRf88d0uCAk",
//                             password: "2IK73MlssycZlXhkKb10"
//                         }
//                     }
//                 );

//                 console.log('📥 iDenfy Token API Response:', response?.data);

//                 if (response?.data) {
//                     const redirect_url = `https://ivs.idenfy.com/api/v2/redirect?authToken=${response.data.authToken}`;
//                     const payload = {
//                         authToken: response.data.authToken,
//                         scanRef: response.data.scanRef
//                     };
//                     const encoded_url = btoa(JSON.stringify(payload));
//                     const verify_url = `https://verifymobi.com?data=${encoded_url}`;
//                     const qrDataUrl = await QRCode.toDataURL(verify_url);

//                     user.otp = '';
//                     user.idenfy_authToken = response.data.authToken;
//                     user.idenfy_scanRef = response.data.scanRef;
//                     user.idenfy_url = redirect_url;
//                     await user.save();

//                     console.log('💾 User updated with new iDenfy token:', {
//                         idenfy_authToken: user.idenfy_authToken,
//                         idenfy_scanRef: user.idenfy_scanRef,
//                         idenfy_url: user.idenfy_url
//                     });

//                     scanRef = response.data.scanRef;
//                     data = { qr_data: qrDataUrl, verify_url, scanRef };
//                 }
//             } else {
//                 // Case 2: Existing scanRef → check current status
//                 scanRef = user.idenfy_scanRef;
//                 console.log(`🔁 Checking existing iDenfy status for scanRef: ${scanRef}`);

//                 const response = await axios.post(
//                     "https://ivs.idenfy.com/api/v2/status",
//                     { scanRef },
//                     {
//                         auth: {
//                             username: "zRf88d0uCAk",
//                             password: "2IK73MlssycZlXhkKb10"
//                         }
//                     }
//                 );

//                 console.log('📥 iDenfy Status API Response:', response?.data);

//                 if (!response?.data) {
//                     console.log('❌ iDenfy status check failed');
//                     return res.json({ status: 'error', message: 'Unable to check iDenfy token' });
//                 }

//                 const status = response.data.status;
//                 console.log('📊 Current iDenfy Status:', status);

//                 // If expired, denied, or suspected — regenerate a new token
//                 if (['EXPIRED', 'SUSPECTED', 'DENIED'].includes(status)) {
//                     console.log('⚠️ iDenfy status is invalid, regenerating token...');

//                     const iToken = {
//                         clientId: user.id,
//                         firstName: user.firstName,
//                         lastName: user.lastName,
//                         country: 'US',
//                         successUrl: `https://verifymobi.com/verifySuccess`,
//                         errorUrl: `https://verifymobi.com/verifyError`,
//                         unverifiedUrl: `https://verifymobi.com/unverified`
//                     };

//                     console.log('📤 iDenfy Token Recreate Request:', iToken);

//                     const newTokenResponse = await axios.post(
//                         "https://ivs.idenfy.com/api/v2/token",
//                         iToken,
//                         {
//                             auth: {
//                                 username: "zRf88d0uCAk",
//                                 password: "2IK73MlssycZlXhkKb10"
//                             }
//                         }
//                     );

//                     console.log('📥 New iDenfy Token Response:', newTokenResponse?.data);

//                     if (newTokenResponse?.data) {
//                         const redirect_url = `https://ivs.idenfy.com/api/v2/redirect?authToken=${newTokenResponse.data.authToken}`;
//                         const payload = {
//                             authToken: newTokenResponse.data.authToken,
//                             scanRef: newTokenResponse.data.scanRef
//                         };
//                         const encoded_url = btoa(JSON.stringify(payload));
//                         const verify_url = `https://verifymobi.com?data=${encoded_url}`;
//                         const qrDataUrl = await QRCode.toDataURL(verify_url);

//                         user.otp = '';
//                         user.idenfy_authToken = newTokenResponse.data.authToken;
//                         user.idenfy_scanRef = newTokenResponse.data.scanRef;
//                         user.idenfy_url = redirect_url;
//                         await user.save();

//                         console.log('💾 User updated with regenerated iDenfy token');
//                         scanRef = newTokenResponse.data.scanRef;
//                         data = { qr_data: qrDataUrl, verify_url, scanRef };
//                     }
//                 } else if (status == 'APPROVED') {
//                     console.log('🎉 User already verified from iDenfy updating user and Generating access token...');
//                     user.idenfy_verified = '1'
//                     user.otp = '';
//                     user.idenfy_response = JSON.stringify(response?.data)
//                     await user.save();

//                     const token = jwt.sign(
//                         { id: user.id, phone: user.phone },
//                         process.env.JWT_SECRET
//                     );

//                     console.log('🔑 JWT Token generated successfully for user:', user.id);
//                     return res.status(200).json({ status: 'success', accessToken: token });

//                 } else {
//                     // Keep existing verification link active
//                     console.log('✅ iDenfy status still active. Using existing verification link...');
//                     const payload = {
//                         authToken: user.idenfy_authToken,
//                         scanRef: user.idenfy_scanRef
//                     };
//                     const encoded_url = btoa(JSON.stringify(payload));
//                     const verify_url = `https://verifymobi.com?data=${encoded_url}`;
//                     const qrDataUrl = await QRCode.toDataURL(verify_url);
//                     data = { qr_data: qrDataUrl, verify_url, scanRef: user.idenfy_scanRef };
//                 }
//             }

//             // ✅ Always return QR data when verification is pending
//             console.log('🚀 Returning verification pending response with data:', data);
//             return res.json({
//                 status: 'success',
//                 message: 'Verification pending',
//                 redirect_url: '/verifyLoginQR',
//                 data
//             });
//         }

//         // ✅ If user is verified
//         console.log('🎉 User already verified. Generating access token...');
//         user.otp = '';
//         await user.save();

//         const token = jwt.sign(
//             { id: user.id, phone: user.phone },
//             process.env.JWT_SECRET
//         );

//         console.log('🔑 JWT Token generated successfully for user:', user.id);
//         return res.status(200).json({ status: 'success', accessToken: token });

//     } catch (e) {
//         console.error('💥 verifyOTP error:', e);
//         return res.status(500).json({ status: 'error', message: 'Internal server error', error: e.message });
//     }
// };
exports.getUser = async (req, res) => {
    try {

        const authHeader = req.headers['authorization'] || req.headers['Authorization'];
        if (!authHeader) return res.status(401).send('Authorization header is missing');

        const token = authHeader.split(' ')[1];
        if (!token) return res.status(401).send('Token is missing');


        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        const userId = decoded.id;


        const user = await KioskUser.findOne({
            where: { id: userId },
            attributes: { exclude: ['created_at', 'updated_at', 'otp'] }
        });
        if (!user) return res.status(404).send('User not found');

        res.status(200).json(user);
    } catch (error) {
        if (error.name === 'JsonWebTokenError' || error.name === 'TokenExpiredError') {
            return res.status(401).json({ error: 'Token is invalid or has expired' });
        }
        console.error(error);
        res.status(500).send('Internal server error');
    }
}
exports.adminLogin = async (req, res) => {
    try {
        const { username, password } = req.body
        if (!username || !password) {
            return res.json({ status: 'error', message: 'Username / Password is required' })
        }
        const admin = await Admin.findOne({
            where: { username: username },
            attributes: ['id', 'first', 'last', 'username', 'password', 'email', 'phone', 'role', 'reason', 'ban']
        })
        if (!admin) {
            return res.json({ status: 'error', message: 'Admin not found' })
        }
        bcrypt.compare(password, admin.password, async (err, isMatch) => {
            if (err) {
                return res.status(200).json({ status: 'error', message: err.message });
            }

            if (!isMatch) {
                return res.status(200).json({ status: 'error', message: 'Invalid password' });
            }
            if (admin.ban !== 0) {
                // return res.status(200).json({ message: 'Admin is banned', reason: admin.reason });
                return res.status(200).json({ status: 'error', message: `Admin is banned! ${admin.reason}`, reason: admin.reason });
            }
            const token = jwt.sign(
                { id: admin.id, username: admin.username },
                process.env.JWT_SECRET,
                // { expiresIn: '24h' }
                // { expiresIn: '15m' }
            );
            return res.status(200).json({ status: 'success', admin_id: admin.id, token: token, role: admin.role, username: admin.username });

        })
    } catch (e) {
        console.log(e.message)
    }
}
exports.getAdmin = async (req, res) => {
    try {

        const authHeader = req.headers['authorization'] || req.headers['Authorization'];
        if (!authHeader) return res.status(401).send('Authorization header is missing');

        const token = authHeader.split(' ')[1];
        if (!token) return res.status(401).send('Token is missing');


        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        const adminId = decoded.id;


        const admin = await Admin.findOne({
            where: { id: adminId },
            attributes: { exclude: ['password', 'otp'] }
        });
        if (!admin) return res.status(404).send('Admin not found');

        res.status(200).json(admin);
    } catch (error) {
        if (error.name === 'JsonWebTokenError' || error.name === 'TokenExpiredError') {
            return res.status(401).json({ error: 'Token is invalid or has expired' });
        }
        console.error(error);
        res.status(500).send('Internal server error');
    }
}
exports.getDashboardData = async (req, res) => {
    try {
        const { kiosk_id } = req.query || {};

        const authHeader = req.headers['authorization'] || req.headers['Authorization'];
        if (!authHeader) return res.status(401).send('Authorization header is missing');

        const token = authHeader.split(' ')[1];
        if (!token) return res.status(401).send('Token is missing');


        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        const adminId = decoded.id;


        const admin = await Admin.findOne({
            where: { id: adminId },
            attributes: { exclude: ['password', 'otp'] }
        });
        if (!admin) return res.status(404).send('Admin not found');
        const kiosk = await Kiosks.findOne({ where: { id: kiosk_id } })

        const sum = await KioskTxns.sum('amount', {
            where: { type: 1, kiosk_id: kiosk_id }
        });

        const nv200 = await StackingStats.findOne({ where: { kiosk_name: kiosk.kiosk_name } })

        const kioskData = {
            totalDeposit: sum ?? 0,
            nv200_balance: nv200.total_amount ?? 0,
            bill_count: nv200.stacked_notes ?? 0

        }
        res.json({ status: 'success', data: kioskData })

    } catch (error) {
        if (error.name === 'JsonWebTokenError' || error.name === 'TokenExpiredError') {
            return res.status(401).json({ error: 'Token is invalid or has expired' });
        }
        console.error(error);
        res.status(500).send('Internal server error');
    }
}
exports.getTodayDeposits = async (req, res) => {
    try {
        const { kiosk_name } = req.query || {};

        // Get start & end of the day in America/Denver
        const startOfDayDenver = moment.tz("America/Denver").startOf("day");
        const endOfDayDenver = moment.tz("America/Denver").endOf("day");

        // Convert to UTC (DB stores UTC)
        const startUtc = startOfDayDenver.clone().utc().toDate();
        const endUtc = endOfDayDenver.clone().utc().toDate();

        // Raw rows
        const nv200 = await StackingNoteLog.findAll({
            where: {
                kiosk_name,
                created_at: { [Op.between]: [startUtc, endUtc] },
            },
            order: [["created_at", "ASC"]],
        });

        const dataWithDenverTime = nv200.map((row) => {
            const plain = row.get({ plain: true });
            return {
                ...plain,
                created_at_local: moment
                    .utc(plain.created_at)
                    .tz("America/Denver")
                    .format("YYYY-MM-DD HH:mm:ss"),
            };
        });

        const rows = await StackingNoteLog.findAll({
            attributes: ["denomination", "note_count", "created_at"],
            where: {
                kiosk_name,
                created_at: { [Op.between]: [startUtc, endUtc] },
            },
            order: [[col("created_at"), "ASC"]],
            raw: true,
        });

        const data2 = [];
        let total = 0; // global running total

        for (const row of rows) {
            const amount = row.denomination * row.note_count;
            total += amount;

            data2.push({
                denomination: row.denomination,
                created_at: row.created_at,
                amount,
                total_amount: total,
            });
        }
        const data3 = await StackingNoteLog.findOne({
            attributes: [
                [fn("SUM", col("denomination")), "total_denomination"],
            ],
            where: {
                kiosk_name,
                created_at: { [Op.between]: [startUtc, endUtc] },
            },
            raw: true,
        });
        return res.json({
            status: "success",
            data: dataWithDenverTime, // raw rows with local time
            data2, // aggregated totals
            data3
        });
    } catch (error) {
        console.error(error);
        return res.json({ status: "error", message: error?.message });
    }
};
exports.getDayWiseDeposits = async (req, res) => {
    try {
        let { kiosk_name, startUtc, endUtc } = req.query || {};
        const tz = "America/Denver";

        if (!startUtc || !endUtc) {
            const endOfToday = moment.tz(tz).endOf("day");
            const startOfRange = endOfToday.clone().subtract(6, "days").startOf("day");

            startUtc = startOfRange.utc().format();
            endUtc = endOfToday.utc().format();
        }

        const deposits = await StackingNoteLog.findAll({
            attributes: [
                [fn("DATE", col("created_at")), "date"],
                [fn("SUM", literal("denomination * note_count")), "total_amount"],
            ],
            where: {
                kiosk_name,
                created_at: { [Op.between]: [startUtc, endUtc] },
            },
            group: [fn("DATE", col("created_at"))],
            order: [[fn("DATE", col("created_at")), "ASC"]],
            raw: true,
        });

        const depositMap = {};
        deposits.forEach((d) => {
            depositMap[d.date] = Number(d.total_amount);
        });

        const labels = [];
        const values = [];
        let current = moment.utc(startUtc).tz(tz).startOf("day");
        const endDate = moment.utc(endUtc).tz(tz).startOf("day");

        while (current.isSameOrBefore(endDate)) {
            const dateStr = current.format("YYYY-MM-DD");
            labels.push(dateStr);
            values.push(depositMap[dateStr] || 0);
            current.add(1, "day");
        }

        // 🚨 Remove the first day if you always see an "extra" one
        if (labels.length > 0) {
            labels.shift();
            values.shift();
        }

        return res.json({
            status: "success",
            data: { labels, values, range: { startUtc, endUtc, tz } },
        });
    } catch (error) {
        console.error(error);
        return res.status(500).json({ status: "error", message: error.message });
    }
};
exports.getTodayCashouts = async (req, res) => {
    try {
        const { kiosk_name } = req.query || {};

        // Get start & end of the day in America/Denver
        const startOfDayDenver = moment.tz("America/Denver").startOf("day");
        const endOfDayDenver = moment.tz("America/Denver").endOf("day");

        // Convert to UTC (DB stores UTC)
        const startUtc = startOfDayDenver.clone().utc().toDate();
        const endUtc = endOfDayDenver.clone().utc().toDate();
        const data3 = await KioskCashout.findOne({
            attributes: [
                [fn("SUM", col("amount")), "total_amount"],
            ],
            where: {
                kiosk_name,
                created_at: { [Op.between]: [startUtc, endUtc] },
            },
            raw: true,
        });
        res.json({ status: 'success', data: data3 })
    } catch (error) {
        console.error(error);
        return res.json({ status: "error", message: error?.message });
    }
};
exports.getDayWiseCashouts = async (req, res) => {
    try {
        let { kiosk_name, startUtc, endUtc } = req.query || {};
        const tz = "America/Denver";

        if (!startUtc || !endUtc) {
            const endOfToday = moment.tz(tz).endOf("day");
            const startOfRange = endOfToday.clone().subtract(6, "days").startOf("day");

            startUtc = startOfRange.utc().format();
            endUtc = endOfToday.utc().format();
        }

        const deposits = await KioskCashout.findAll({
            attributes: [
                [fn("DATE", col("created_at")), "date"],
                [fn("SUM", col("amount")), "total_amount"],

            ],
            where: {
                kiosk_name,
                created_at: { [Op.between]: [startUtc, endUtc] },
            },
            group: [fn("DATE", col("created_at"))],
            order: [[fn("DATE", col("created_at")), "ASC"]],
            raw: true,
        });

        const depositMap = {};
        deposits.forEach((d) => {
            depositMap[d.date] = Number(d.total_amount);
        });

        const labels = [];
        const values = [];
        let current = moment.utc(startUtc).tz(tz).startOf("day");
        const endDate = moment.utc(endUtc).tz(tz).startOf("day");

        while (current.isSameOrBefore(endDate)) {
            const dateStr = current.format("YYYY-MM-DD");
            labels.push(dateStr);
            values.push(depositMap[dateStr] || 0);
            current.add(1, "day");
        }

        // 🚨 Remove the first day if you always see an "extra" one
        if (labels.length > 0) {
            labels.shift();
            values.shift();
        }

        return res.json({
            status: "success",
            data: { labels, values, range: { startUtc, endUtc, tz } },
        });
    } catch (error) {
        console.error(error);
        return res.status(500).json({ status: "error", message: error.message });
    }
};
exports.getKioskNotes = async (req, res) => {
    try {
        const { kiosk_name } = req.query || {}
        if (!kiosk_name) {
            return res.json({ status: 'error', message: 'Kiosk Name is required' })
        }
        const kioskNotes = await KioskNotes.findAll({ where: { kiosk_name: kiosk_name } })
        res.json({ status: 'success', kioskNotes })
    } catch (error) {
        return res.json({ status: 'error', message: error?.message })

    }
}
exports.setKioskNotes = async (req, res) => {
    try {
        const { kioskName, denomination, note_count } = req.body;
        if (!kioskName || !denomination || !note_count) {
            return res.json({ status: 'error', message: 'Data required' })
        }
        const kioskNotes = await KioskNotes.findOne({ where: { kiosk_name: kioskName, denomination: parseFloat(denomination) } })
        kioskNotes.note_count = note_count;
        if (await kioskNotes.save()) {
            res.json({ status: 'success', message: 'notes updated' })
        } else {
            return res.json({ status: 'error', message: 'unable to update notes' })
        }

    } catch (error) {
        return res.json({ status: 'error', message: error?.message })

    }
}
exports.resetKioskNotes = async (req, res) => {
    try {
        const { kioskName } = req.body;
        if (!kioskName) {
            return res.json({ status: 'error', message: 'Data required' })
        }
        await KioskNotes.update(
            { note_count: 0 }, // set note_count to 0
            { where: { kiosk_name: kioskName } }
        );
        res.json({ status: 'success', message: 'Kiosk notes reset successfully' });

    } catch (error) {
        return res.json({ status: 'error', message: error?.message })
    }
}
exports.cashout = async (req, res) => {
    try {
        const { phone, amount } = req.body;
        const code = crypto.randomUUID();

        const user = await KioskUser.findOne({ where: { phone: phone } });
        if (!user) {
            return res.json({ status: 'error', message: 'User not found' });
        }

        if (parseFloat(amount) > parseFloat(user.balance)) {
            return res.json({ status: 'error', message: 'Amount cannot be more than balance!' });
        }

        // await KioskCashout.create({ phone, amount, code });
        // await user.decrement('balance', { by: amount });

        const qrText = `code:${code};amount:${amount}`;
        const qrDataURL = await QRCode.toDataURL(qrText);

        const receiptHTML = `
            <html>
            <head>
                <title>Cashout Receipt</title>
                <style>
                    body { font-family: Arial, sans-serif; text-align: center; padding: 20px; }
                    .receipt-box { border: 1px solid #000; display: inline-block; padding: 20px; }
                    .heading { font-size: 20px; font-weight: bold; margin-bottom: 10px; }
                    .info { margin-bottom: 10px; }
                    .qr { margin-top: 10px; }
                </style>
            </head>
            <body>
                <div class="receipt-box">
                    <div class="heading">SweepStake Mobi Kiosk</div>
                    <div class="info"><strong>Phone:</strong> ${phone}</div>
                    <div class="info"><strong>Amount:</strong> $${parseFloat(amount).toFixed(2)}</div>
                    <div class="info"><strong>Code:</strong> ${code}</div>
                    <div class="qr"><img src="${qrDataURL}" alt="QR Code" /></div>
                </div>
            </body>
            </html>
        `;

        res.send(receiptHTML);
    } catch (e) {
        console.log(e.message);
        res.status(500).json({ status: 'error', message: 'Internal server error' });
    }
};

const JWT_SECRET = process.env.JWT_SECRET || 'replace_this_with_real_secret';

exports.cashDepositQR = async (req, res) => {
    try {
        // generate a random login_id
        const login_id = crypto.randomBytes(12).toString('hex'); // 24-char hex string

        // create jwt payload
        const payload = {
            login_id,
            purpose: 'login_qr',
        };

        // sign without expiry
        const token = jwt.sign(payload, JWT_SECRET);

        // generate QR containing the JWT
        const qrDataUrl = await QRCode.toDataURL(token);
        await KioskLoginToken.create({
            token: login_id,
            status: 'pending'
        })
        // respond
        res.json({
            ok: true,
            login_id,
            jwt: token,   // same JWT encoded in the QR
            qrDataUrl,    // you can <img src="qrDataUrl">
        });
    } catch (err) {
        console.error('cashDepositQR error:', err);
        res.status(500).json({ ok: false, error: 'internal_error' });
    }
};
exports.QRLoginResponse = async (req, res) => {
    const { login_id, pending = 'pending' } = req.body;

    const token = await KioskLoginToken.findOne({ where: { token: login_id } });

    if (!token) {
        return res.status(401).json({ message: 'Invalid token' });
    }
    if (token.status == 'pending') {
        if (pending == 'success') {
            token.status = 'success';
            token.login = '1';
            await token.save();
            res.json({
                status: token.status, message: "processed",
                login_id, login: token.login, logout: token.logout, deposit_amount: token.deposit_amount, deposit_done: token.deposit_done
            });
        }
        return res.json({
            status: token.status, message: "processing",
            login_id, login: token.login, logout: token.logout, deposit_amount: token.deposit_amount, deposit_done: token.deposit_done
        });
    }
    return res.json({
        status: token.status, message: "processed",
        login_id, login: token.login, logout: token.logout, deposit_amount: token.deposit_amount, deposit_done: token.deposit_done
    });
}

exports.depositCash = async (req, res) => {
    const { login_id, amount } = req.body;
    const token = await KioskLoginToken.findOne({ where: { token: login_id } });

    if (!token) {
        return res.status(401).json({ message: 'Invalid token' });
    }
    try {
        token.deposit_amount = parseFloat(amount)
        token.logout = '1';

        await token.save();
        res.json({ status: 'success' })
    } catch (error) {
        console.log(error?.message)
    }
}
exports.depositDone = async (req, res) => {
    const { login_id } = req.body;
    const token = await KioskLoginToken.findOne({ where: { token: login_id } });

    if (!token) {
        return res.status(401).json({ message: 'Invalid token' });
    }
    try {
        token.deposit_done = '1'
        // token.logout = '1';
        await token.save();
        res.json({ status: 'success' })
    } catch (error) {
        console.log(error?.message)
    }
}

exports.cashDepositWebhook = async (req, res) => {
    try {
        const tokens = await KioskLoginToken.findAll({ where: { deposit_done: '1', webhook_sent: '0' } });
        tokens.forEach(async (token) => {
            try {
                const response = await axios.post('https://swback.logiclane.tech/api/cashWebhook', token, {
                    headers: {
                        'Accept': "application/json",
                        'Content-Type': 'application/json'
                    }
                })
                token.webhook_sent = '1'
                await token.save();
            } catch (error) {
                console.log(error)

                console.log(error?.message)
            }

        })

        res.json(tokens)
        // console.log(tokens)
    } catch (error) {
        console.log(error?.message)

    }

}
exports.cashWithdraw = async (req, res) => {
    try {
        const { amount, phone, kiosk_name = "Kiosk 1" } = req.body;
        if (!amount || !phone) {
            return res.json({ status: 'error', message: 'Amount / Phone / Kiosk Name is required' })
        }
        const user = await KioskUser.findOne({ where: { phone: phone } })
        if (!user) {
            return res.json({ status: 'error', message: 'User not found' })
        }
        // const kiosk = await Kiosks.findOne({ where: { kiosk_name: kiosk_name } });
        // if (!kiosk) {
        //     return res.json({ status: 'error', message: 'Kiosk not found' })
        // }
        let apiUrl = '';
        if (kiosk_name == 'Kiosk 1') {
            apiUrl = `https://api8000.logiclane.tech`;
        } else if (kiosk_name == 'Kiosk 2') {
            apiUrl = `https://api18000.logiclane.tech`;
        }
        const response1 = await axios.post(`${apiUrl}/connect`,
            {
                headers: {
                    'Accept': "application/json",
                    'Content-Type': "application/json"
                }
            }
        )
        if (response1?.data) {
            const payload = {
                amount: amount
            }
            const response = await axios.post(`${apiUrl}/dispense`, payload,
                {
                    headers: {
                        'Accept': "application/json",
                        'Content-Type': "application/json"
                    }
                }
            )
            if (response?.data) {
                // await user.save()
                if (response?.data?.success == 'False' || response?.data?.success == 'false' || response?.data?.success == false) {
                    const response3 = await axios.post(`${apiUrl}/disconnect`,
                        {
                            headers: {
                                'Accept': "application/json",
                                'Content-Type': "application/json"
                            }
                        }
                    )
                    return res.json({ status: 'error', message: 'Unable to complete withdrawal' })
                }

                const new_balance = parseFloat(user.balance) - parseFloat(amount);
                const combination = response?.data?.combination ?? '';
                await KioskCashout.create({
                    kiosk_name: "Kiosk 1",
                    phone: phone,
                    amount: amount,
                    combination: JSON.stringify(combination),
                    previous_balance: user.balance,
                    new_balance: new_balance
                })
                user.balance = new_balance;
                await user.save();
                // await user.decrement('balance', amount)
                const response3 = await axios.post(`${apiUrl}/disconnect`,
                    {
                        headers: {
                            'Accept': "application/json",
                            'Content-Type': "application/json"
                        }
                    }
                )
                res.json({ status: 'success', message: 'Withdrawal successful' })
            } else {
                const response3 = await axios.post(`${apiUrl}/disconnect`,
                    {
                        headers: {
                            'Accept': "application/json",
                            'Content-Type': "application/json"
                        }
                    }
                )
                return res.json({ status: 'error', message: 'Unable to complete withdrawal' })
            }
        } else {
            const response3 = await axios.post(`${apiUrl}/disconnect`,
                {
                    headers: {
                        'Accept': "application/json",
                        'Content-Type': "application/json"
                    }
                }
            )
            return res.json({ status: 'error', message: 'Unable to connect to f53' })

        }
    } catch (error) {
        const response3 = await axios.post(`${apiUrl}/disconnect`,
            {
                headers: {
                    'Accept': "application/json",
                    'Content-Type': "application/json"
                }
            }
        )
        return res.json({ status: 'error', message: error?.message })
    }
}
function base64UrlDecode(input) {
    try {
        let base64 = input.replace(/-/g, "+").replace(/_/g, "/");
        const pad = base64.length % 4;
        if (pad) base64 += "=".repeat(4 - pad);
        return atob(base64);
    } catch (err) {
        console.error("base64UrlDecode failed", err);
        return null;
    }
}

function decodeJwt(token) {
    if (!token || typeof token !== "string") return null;
    const parts = token.split(".");
    if (parts.length !== 3) return null;
    try {
        const payloadJson = base64UrlDecode(parts[1]);
        if (!payloadJson) return null;
        return JSON.parse(payloadJson);
    } catch (err) {
        console.error("Failed to decode JWT:", err);
        return null;
    }
}

exports.sweepLoginQR = async (req, res) => {
    try {
        const login_id = crypto.randomBytes(12).toString('hex');

        const payload = {
            login_id,
            purpose: 'sweep_login_qr',
        };

        const token = jwt.sign(payload, JWT_SECRET);

        const qrDataUrl = await QRCode.toDataURL(token);
        await SweepLoginToken.create({
            token: login_id,
            status: 'pending'
        })

        res.json({
            ok: true,
            login_id,
            jwt: token,
            qrDataUrl,
        });
    } catch (err) {
        console.error('sweepLoginQR error:', err);
        res.status(500).json({ ok: false, error: 'internal_error' });
    }
};
exports.sweepQRLoginResponse = async (req, res) => {
    const { login_id, pending = 'pending', userId = '', phone = '' } = req.body;

    const token = await SweepLoginToken.findOne({ where: { token: login_id } });

    if (!token) {
        return res.status(401).json({ message: 'Invalid token' });
    }
    if (token.status == 'pending') {
        if (pending == 'success') {
            token.status = 'success';
            token.login = '1';
            token.userid = userId;
            token.phone = phone;
            await token.save();
            res.json({
                status: token.status, message: "processed",
                login_id, login: token.login, logout: token.logout, userid: userId, phone: phone
            });
        }
        return res.json({
            status: token.status, message: "processing",
            login_id, login: token.login, logout: token.logout, userid: userId, phone: phone

        });
    }
    return res.json({
        status: token.status, message: "processed",
        login_id, login: token.login, logout: token.logout, userid: token.userid, phone: token.phone
    });
}
exports.sweepLoginComplete = async (req, res) => {
    try {
        const { userid, phone } = req.body;

        // const jwtData = decodeJwt(data);

        // const userid = jwtData?.userid;
        // const phone = jwtData?.phone;
        if (!userid || !phone) {
            return res.json({ status: 'error', message: 'userid / phone not found' })
        }
        let userData = null;

        const user = await KioskUser.findOne({ where: { swps_userid: userid } })
        if (!user) {
            const newUser = await KioskUser.create({
                phone: phone,
                swps_userid: userid
            })
            userData = newUser
        } else {
            userData = user
        }

        const token = jwt.sign(
            { id: userData.id, phone: userData.phone },
            process.env.JWT_SECRET,
        );
        res.json({ status: 'success', accessToken: token });
    } catch (error) {
        console.log(error)
        return res.json({ status: 'error', message: error?.message })
    }

}

exports.getF53Cassettes = async (req, res) => {
    try {
        // kiosk can be passed via query or body; prefer query for GET
        const { kiosk_id, kiosk_name } = { ...(req.query || {}), ...(req.body || {}) };

        // resolve kiosk
        let kiosk = null;
        if (kiosk_id) {
            kiosk = await Kiosks.findOne({ where: { id: kiosk_id } });
            if (!kiosk) return res.json({ status: 'error', message: 'Kiosk not found by id' });
        } else if (kiosk_name) {
            kiosk = await Kiosks.findOne({ where: { kiosk_name: kiosk_name } });
            if (!kiosk) return res.json({ status: 'error', message: 'Kiosk not found by name' });
        } else {
            return res.json({ status: 'error', message: 'kiosk_id or kiosk_name is required' });
        }

        const cassettes = await F53Cassettes.findAll({
            where: { kiosk_id: kiosk.id }
        });

        return res.json({ status: 'success', kiosk: { id: kiosk.id, name: kiosk.kiosk_name }, cassettes });
    } catch (error) {
        console.error('getF53Cassettes error', error);
        return res.json({ status: 'error', message: error?.message || 'Something went wrong' });
    }
};


exports.setF53Cassettes = async (req, res) => {
    const t = await F53Cassettes.sequelize.transaction();
    try {
        let { cassettes, kiosk_id, kiosk_name } = req.body;

        // resolve kiosk (require one)
        let kiosk = null;
        if (kiosk_id) {
            kiosk = await Kiosks.findOne({ where: { id: kiosk_id }, transaction: t });
            if (!kiosk) {
                await t.rollback();
                return res.json({ status: 'error', message: 'Kiosk not found by id' });
            }
        } else if (kiosk_name) {
            kiosk = await Kiosks.findOne({ where: { kiosk_name: kiosk_name }, transaction: t });
            if (!kiosk) {
                await t.rollback();
                return res.json({ status: 'error', message: 'Kiosk not found by name' });
            }
        } else {
            await t.rollback();
            return res.json({ status: 'error', message: 'kiosk_id or kiosk_name is required' });
        }

        // support old single-cassette body
        if (!cassettes) {
            const { cassett_id, value, count } = req.body;
            if (!cassett_id || value == null || count == null) {
                await t.rollback();
                return res.json({ status: 'error', message: 'cassett_id / value / count is required' });
            }
            cassettes = [{ cassett_id, value, count }];
        }

        if (!Array.isArray(cassettes) || cassettes.length === 0) {
            await t.rollback();
            return res.json({ status: 'error', message: 'cassettes must be a non-empty array' });
        }

        // validate each cassette object
        for (const c of cassettes) {
            if (!c?.cassett_id || c.value == null || c.count == null) {
                await t.rollback();
                return res.json({ status: 'error', message: 'each cassette must contain cassett_id, value and count' });
            }
        }

        // Prepare ids and fetch existing entries for this kiosk only
        const ids = cassettes.map(c => c.cassett_id);

        const existing = await F53Cassettes.findAll({
            where: {
                cassett_id: { [Op.in]: ids },
                kiosk_id: kiosk.id
            },
            transaction: t
        });

        const existingMap = new Map(existing.map(r => [r.cassett_id, r]));

        const toCreate = [];
        const updatePromises = [];

        for (const c of cassettes) {
            const found = existingMap.get(c.cassett_id);
            if (found) {
                // Update existing row for this kiosk
                updatePromises.push(
                    F53Cassettes.update(
                        { value: c.value, count: c.count },
                        { where: { cassett_id: c.cassett_id, kiosk_id: kiosk.id }, transaction: t }
                    )
                );
            } else {
                // create new row tied to kiosk
                toCreate.push({
                    cassett_id: c.cassett_id,
                    value: c.value,
                    count: c.count,
                    kiosk_id: kiosk.id
                });
            }
        }

        // run updates and creates
        await Promise.all(updatePromises);

        if (toCreate.length > 0) {
            await F53Cassettes.bulkCreate(toCreate, { transaction: t });
        }

        await t.commit();

        // return fresh rows for this kiosk
        const saved = await F53Cassettes.findAll({
            where: {
                cassett_id: { [Op.in]: ids },
                kiosk_id: kiosk.id
            }
        });

        return res.json({ status: 'success', message: 'Cassettes saved', kiosk: { id: kiosk.id, name: kiosk.kiosk_name }, data: saved });
    } catch (error) {
        await t.rollback();
        console.error('setF53Cassettes error', error);
        return res.json({ status: 'error', message: error?.message || 'Something went wrong' });
    }
};
exports.getKiosks = async (req, res) => {
    try {
        // optional filter by name (case-insensitive)
        const { kiosk_name } = req.query || {};

        if (kiosk_name) {
            const name = kiosk_name.trim().toLowerCase();
            const kiosk = await Kiosks.findOne({
                where: fn('LOWER', col('kiosk_name')), // used in Sequelize v6 as wrapper below
                // Above simple form may not work alone; use where with Sequelize.where:
            });

            // Better (portable) form:
            const kioskCi = await Kiosks.findOne({
                where: { [Op.and]: sequelize.where(fn('LOWER', col('kiosk_name')), name) }
            });

            if (!kioskCi) return res.json({ status: 'error', message: 'Kiosk not found' });
            return res.json({ status: 'success', kiosks: [kioskCi] });
        }

        // no filter -> return all
        const kiosks = await Kiosks.findAll();
        res.json({ status: 'success', kiosks });
    } catch (error) {
        console.error('getKiosks error', error);
        return res.json({ status: 'error', message: error?.message });
    }
};

exports.setKiosk = async (req, res) => {
    try {
        const { kiosk_name } = req.body;

        if (!kiosk_name || kiosk_name.trim() === "") {
            return res.json({ status: "error", message: "Kiosk name is required" });
        }

        const nameTrimmed = kiosk_name.trim();
        const nameLower = nameTrimmed.toLowerCase();

        // case-insensitive lookup using LOWER(column) = lower(input)
        const existingKiosk = await Kiosks.findOne({
            where: db.where(db.fn('LOWER', db.col('kiosk_name')), nameLower)
        });

        if (existingKiosk) {
            return res.json({
                status: "success",
                message: "Kiosk already exists",
                kiosk: existingKiosk
            });
        }

        // Create new kiosk
        const newKiosk = await Kiosks.create({
            kiosk_name: nameTrimmed,
            kiosk_status: "active"
        });

        return res.json({ status: "success", message: "Kiosk set", kiosk: newKiosk });

    } catch (error) {
        console.error('setKiosk error', error);
        return res.json({ status: 'error', message: error?.message });
    }
};
exports.renameKiosk = async (req, res) => {
    try {
        const { kiosk_name, new_name } = req.body;

        // Try alias first
        let kiosk = await Kiosks.findOne({ where: { kiosk_alias: kiosk_name } });

        // If not found, try name
        if (!kiosk) {
            kiosk = await Kiosks.findOne({ where: { kiosk_name } });
        }

        // If still not found → return error
        if (!kiosk) {
            return res.json({
                status: "error",
                message: `No kiosk found with name or alias "${kiosk_name}"`,
            });
        }

        // Update alias
        kiosk.kiosk_alias = new_name;
        await kiosk.save();

        return res.json({
            status: "success",
            message: "Kiosk alias updated",
            kiosk,
        });
    } catch (error) {
        return res.json({ status: "error", message: error?.message });
    }
};

exports.signup = async (req, res) => {
    try {
        const { phoneNumber } = req.body;

        // ✅ Required check
        if (!phoneNumber) {
            return res.json({
                status: 'error',
                message: 'Phone number is required!'
            });
        }

        // ✅ Normalize (remove spaces, dashes)
        const normalizedPhone = phoneNumber.toString().replace(/\D/g, '');

        // ✅ 10-digit validation
        if (!/^\d{10}$/.test(normalizedPhone)) {
            return res.json({
                status: 'error',
                message: 'Phone number must be exactly 10 digits'
            });
        }

        const existingPhone = await KioskUser.findOne({
            where: { phone: normalizedPhone }
        });

        if (existingPhone) {
            return res.json({
                status: 'error',
                message: 'Phone number already exists!',
                user: existingPhone
            });
        }

        const otp = Math.floor(100000 + Math.random() * 900000);

        const createUser = await KioskUser.create({
            phone: normalizedPhone,
            otp
        });

        if (!createUser) {
            return res.json({
                status: 'error',
                message: 'Unable to create user'
            });
        }

        await sendSMS("1" + normalizedPhone, otp);

        return res.json({
            status: 'success',
            message: 'User created'
        });

    } catch (error) {
        console.error(error);
        return res.json({
            status: 'error',
            message: error?.message || 'Internal server error'
        });
    }
};
exports.resendSignupOTP = async (req, res) => {
    try {
        const { phoneNumber } = req.body;
        if (!phoneNumber) {

            return res.json({ status: 'error', message: 'Firstname / Lastname / Phone number is required!' });
        }
        const existingPhone = await KioskUser.findOne({ where: { phone: phoneNumber } });
        if (!existingPhone) {
            return res.json({ status: 'error', message: 'Phone no does not exists!' });
        }
        await sendSMS("1" + phoneNumber, existingPhone?.otp);

        res.json({ status: 'success', message: 'OTP resent' });
    } catch (error) {
        return res.json({ status: 'error', message: error?.message })

    }
}
exports.verifySignupOTP = async (req, res) => {
    try {
        console.log('🟢 verifySignupOTP() called with body:', req.body);

        const { phoneNumber, otp } = req.body;
        if (!phoneNumber || !otp) {
            console.log('❌ Missing phoneNumber or OTP');
            return res.json({ status: 'error', message: 'Phone number / OTP is required' });
        }

        console.log(`🔍 Searching user with phone: ${phoneNumber}`);
        const user = await KioskUser.findOne({ where: { phone: phoneNumber } });

        if (!user) {
            console.log('❌ User not found for phone:', phoneNumber);
            return res.json({ status: 'error', message: 'User not found!' });
        }

        console.log('👤 Found user:', {
            id: user.id,
            firstName: user.firstName,
            lastName: user.lastName,
            verified: user.idenfy_verified
        });

        // 🔹 Verify OTP
        if (user.otp.toString() !== otp.toString()) {
            console.log(`❌ Incorrect OTP: expected ${user.otp}, got ${otp}`);
            return res.json({ status: 'error', message: 'Incorrect OTP!' });
        }

        console.log('✅ OTP verified successfully for user ID:', user.id);

        // 🔹 Check Sweepstake API for existing account
        const checkSweepstake = await axios.post(
            'https://nodewall.logiclane.tech/api/kioskCheckAccount',
            { phone: phoneNumber },
            { headers: { 'Content-Type': 'application/json', Accept: 'application/json' } }
        );

        let isUser = 0;
        let userData = {};
        let creations = [];

        if (checkSweepstake?.data?.status !== 'error') {
            isUser = checkSweepstake?.data?.isUser;
            userData = checkSweepstake?.data?.user;
            creations = checkSweepstake?.data?.creations || [];
        }

        console.log('📊 Sweepstake result:', isUser, creations);

        // 🔹 Case 1: User already exists in sweepstake system
        if (isUser == 1) {
            if (creations.length > 0) {
                for (const item of creations) {
                    const exists = await KioskCreation.findOne({
                        where: { phone: phoneNumber, gameid: item.gameid }
                    });
                    if (!exists) {
                        await KioskCreation.create({
                            phone: phoneNumber,
                            gameid: item.gameid,
                            gameuserid: item.gameuserid,
                            gameuser: item.gameuser,
                            gamepass: item.gamepass,
                            status: '1'
                        });
                        console.log(`✅ Created KioskCreation for ${item.userid}, game ${item.gameid}`);
                    } else {
                        console.log(`⚠️ Already exists: ${item.userid}, game ${item.gameid}`);
                    }
                }
            }

            user.firstName = userData?.first;
            user.lastName = userData?.last;
            user.idenfy_verified = '1';
            user.otp = '';
            await user.save();

            console.log('🎉 User already verified. Generating JWT...');
            const token = jwt.sign({ id: user.id, phone: user.phone }, process.env.JWT_SECRET);
            return res.status(200).json({ status: 'success', accessToken: token });
        }

        // 🔹 Case 2: User not verified — start VerifyMobi flow
        console.log('⚠️ User not verified. Initiating VerifyMobi verification...');

        const token = crypto.randomBytes(16).toString('hex');
        console.log('🔑 Generated verification token:', token);

        // Call VerifyMobi to create verification entry
        const verify = await axios.post('https://verifymobi.com/create_verification', { token });

        console.log('📥 VerifyMobi response:', verify.data);

        if (verify?.data?.status === 'success') {
            const payload = { phone: user.phone, token };
            const encoded = Buffer.from(JSON.stringify(payload)).toString('base64');
            const verify_url = `https://verifymobi.com?data=${encoded}`;
            const qrDataUrl = await QRCode.toDataURL(verify_url);

            // Update user record with verification token
            user.verifymobi_token = token;
            user.verifymobi_url = verify_url;
            user.otp = '';
            await user.save();

            console.log('🚀 Verification initiated via VerifyMobi');
            return res.json({
                status: 'success',
                message: 'Verification pending — please complete identity verification',
                redirect_url: '/verifyLoginQR',
                data: {
                    qr_data: qrDataUrl,
                    verify_url,
                    verifymobi_token: token
                }
            });
        }

        // ❌ If VerifyMobi call failed
        console.log('❌ Unable to create verification session');
        return res.json({
            status: 'error',
            message: verify?.data?.message || 'Unable to create verification session'
        });
    } catch (error) {
        console.error('💥 verifySignupOTP error:', error);
        return res.status(500).json({
            status: 'error',
            message: 'Internal server error',
            error: error.message
        });
    }
};
// exports.verifySignupOTP = async (req, res) => {
//     try {
//         const { phoneNumber, otp } = req.body;
//         const user = await KioskUser.findOne({ where: { phone: phoneNumber } })
//         if (!user) {
//             return res.json({ status: 'error', message: 'User not found' })
//         }
//         if (parseInt(otp) !== parseInt(user.otp)) {
//             return res.json({ status: 'error', message: 'Invalid OTP' })
//         }

//         const token = jwt.sign(
//             { id: user.id, phone: user.phone },
//             process.env.JWT_SECRET,
//         );

//         const iToken = {
//             clientId: user.id,
//             firstName: user.firstName,
//             lastName: user.lastName,
//             country: 'US',
//             successUrl: `https://verifymobi.com/verifySuccess`,
//             errorUrl: `https://verifymobi.com/verifyError`,
//             unverifiedUrl: `https://verifymobi.com/unverified`
//         };
//         console.log("iDenfy Token Request", iToken);
//         const response = await axios.post(
//             "https://ivs.idenfy.com/api/v2/token",
//             iToken, {
//             auth: {
//                 username: "zRf88d0uCAk",
//                 password: "2IK73MlssycZlXhkKb10"
//             }
//         });
//         if (response?.data) {
//             console.log('hello')
//             const redirect_url = `https://ivs.idenfy.com/api/v2/redirect?authToken=${response?.data?.authToken}`
//             const payload = {
//                 authToken: response?.data?.authToken,
//                 scanRef: response?.data?.scanRef
//             }
//             const encoded_url = btoa(JSON.stringify(payload))
//             const verify_url = `https://verifymobi.com?data=${encoded_url}`

//             const qrDataUrl = await QRCode.toDataURL(verify_url);

//             user.otp = '';
//             user.idenfy_authToken = response?.data?.authToken;
//             user.idenfy_scanRef = response?.data?.scanRef;
//             user.idenfy_url = redirect_url
//             await user.save();
//             const data = {
//                 qr_data: qrDataUrl,
//                 verify_url: verify_url,
//                 scanRef: response?.data?.scanRef
//             }
//             res.json({ status: 'success', data: data, accessToken: token })
//         } else {
//             return res.json({ status: 'error', message: 'Unable to generate verification token' })
//         }
//         // res.status(200).json({ status: 'success', accessToken: token });
//     } catch (error) {
//         return res.json({ status: 'error', message: error?.message })
//     }
// }
// exports.verifySignupOTP = async (req, res) => {
//     try {
//         console.log('🟢 verifySignupOTP() called with body:', req.body);

//         const { phoneNumber, otp } = req.body;
//         if (!phoneNumber || !otp) {
//             console.log('❌ Missing phoneNumber or OTP');
//             return res.json({ status: 'error', message: 'Phone number / OTP is required' });
//         }

//         console.log(`🔍 Searching user with phone: ${phoneNumber}`);
//         const user = await KioskUser.findOne({ where: { phone: phoneNumber } });

//         if (!user) {
//             console.log('❌ User not found for phone:', phoneNumber);
//             return res.json({ status: 'error', message: 'User not found!' });
//         }

//         console.log('👤 Found user:', {
//             id: user.id,
//             firstName: user.firstName,
//             lastName: user.lastName,
//             idenfy_verified: user.idenfy_verified,
//             idenfy_scanRef: user.idenfy_scanRef
//         });

//         if (user.otp.toString() !== otp.toString()) {
//             console.log(`❌ Incorrect OTP: expected ${user.otp}, got ${otp}`);
//             return res.json({ status: 'error', message: 'Incorrect OTP!' });
//         }

//         console.log('✅ OTP verified successfully for user ID:', user.id);

//         // 🔹 Check Sweepstake API for existing account
//         const checkSweepstake = await axios.post('https://nodewall.logiclane.tech/api/kioskCheckAccount', { phone: phoneNumber }, {
//             headers: {
//                 'Content-Type': 'application/json',
//                 'Accept': 'application/json'
//             }
//         });

//         let isUser = 0;
//         let creations = [];
//         if (checkSweepstake?.data?.status !== 'error') {
//             isUser = checkSweepstake?.data?.isUser;
//             creations = checkSweepstake?.data?.creations || [];
//         }

//         console.log(isUser, creations);

//         if (isUser == 1) {
//             if (creations.length > 0) {
//                 for (const item of creations) {
//                     const checkExisting = await KioskCreation.findOne({
//                         where: {
//                             phone: phoneNumber,
//                             gameid: item.gameid
//                         }
//                     });

//                     if (!checkExisting) {
//                         await KioskCreation.create({
//                             phone: phoneNumber,
//                             gameid: item.gameid,
//                             gameuserid: item.gameuserid,
//                             gameuser: item.gameuser,
//                             gamepass: item.gamepass,
//                             status: '1'
//                         });
//                         console.log(`✅ Created KioskCreation for user ${item.userid}, game ${item.gameid}`);
//                     } else {
//                         console.log(`⚠️ Already exists: ${item.userid}, game ${item.gameid}`);
//                     }
//                 }
//             }

//             user.idenfy_verified = '1';
//             await user.save();
//         } else {
//             // --- iDenfy Verification Flow ---
//             if (user.idenfy_verified !== '1') {
//                 console.log('⚠️ User not verified yet. Checking iDenfy verification...');
//                 const token = crypto.randomBytes(16).toString('hex');
//                 // ✅ NEW: Skip token generation if first/last name missing
//                 if (!user.firstName || !user.lastName) {
//                     console.log('🕓 Missing name info. Skipping iDenfy token generation.');
//                     const verify = await axios.post('https://verifymobi.com/create_verification', {
//                         token: token
//                     })
//                     if (verify?.data?.status == 'success') {
//                         const payload = { phone: user.phone, token: token };
//                         const encoded_url = btoa(JSON.stringify(payload));
//                         const verify_url = `https://verifymobi.com?data=${encoded_url}`;
//                         const qrDataUrl = await QRCode.toDataURL(verify_url);

//                         user.verifymobi_url = verify_url;
//                         user.verifymobi_token = token;
//                         user.otp = '';
//                         await user.save();

//                         console.log('🚀 Returning initial QR for VerifyMobi name entry...');
//                         return res.json({
//                             status: 'success',
//                             message: 'Verification pending — user details required',
//                             redirect_url: '/verifyLoginQR',
//                             data: { qr_data: qrDataUrl, verify_url, verifymobi_token: token }
//                         });
//                     } else {
//                         return res.json({
//                             status: 'error',
//                             message: 'Unable to generate verification token...',
//                             // redirect_url: '/verifyLoginQR',
//                             // data: { qr_data: qrDataUrl, verify_url }
//                         });
//                     }
//                 }

//                 let scanRef = user.idenfy_scanRef;
//                 let data = null;

//                 // Case 1: No scanRef → create new token
//                 if (!scanRef) {
//                     console.log('🆕 No existing scanRef. Generating new iDenfy token...');
//                     const iToken = {
//                         clientId: user.id,
//                         firstName: user.firstName,
//                         lastName: user.lastName,
//                         country: 'US',
//                         successUrl: `https://verifymobi.com/verifySuccess`,
//                         errorUrl: `https://verifymobi.com/verifyError`,
//                         unverifiedUrl: `https://verifymobi.com/unverified`
//                     };

//                     console.log('📤 iDenfy Token Request Payload:', iToken);

//                     const response = await axios.post(
//                         "https://ivs.idenfy.com/api/v2/token",
//                         iToken,
//                         {
//                             auth: {
//                                 username: "zRf88d0uCAk",
//                                 password: "2IK73MlssycZlXhkKb10"
//                             }
//                         }
//                     );

//                     console.log('📥 iDenfy Token Response:', response?.data);

//                     if (response?.data) {
//                         const redirect_url = `https://ivs.idenfy.com/api/v2/redirect?authToken=${response.data.authToken}`;
//                         const payload = {
//                             authToken: response.data.authToken,
//                             scanRef: response.data.scanRef
//                         };
//                         const encoded_url = btoa(JSON.stringify(payload));
//                         const verify_url = `https://verifymobi.com?data=${encoded_url}`;
//                         const qrDataUrl = await QRCode.toDataURL(verify_url);

//                         user.otp = '';
//                         user.idenfy_authToken = response.data.authToken;
//                         user.idenfy_scanRef = response.data.scanRef;
//                         user.idenfy_url = redirect_url;
//                         await user.save();

//                         console.log('💾 User updated with new iDenfy token');
//                         data = { qr_data: qrDataUrl, verify_url, scanRef: response.data.scanRef };
//                         scanRef = response.data.scanRef;
//                     }
//                 } else {
//                     // Case 2: Existing scanRef → Check status
//                     console.log(`🔁 Checking iDenfy status for existing scanRef: ${scanRef}`);

//                     const response = await axios.post(
//                         "https://ivs.idenfy.com/api/v2/status",
//                         { scanRef },
//                         {
//                             auth: {
//                                 username: "zRf88d0uCAk",
//                                 password: "2IK73MlssycZlXhkKb10"
//                             }
//                         }
//                     );

//                     console.log('📥 iDenfy Status API Response:', response?.data);

//                     if (!response?.data) {
//                         console.log('❌ Failed to get iDenfy status');
//                         return res.json({ status: 'error', message: 'Unable to check iDenfy status' });
//                     }

//                     const status = response.data.status?.toUpperCase?.() || 'UNKNOWN';
//                     console.log('📊 Current iDenfy Status:', status);

//                     if (['EXPIRED', 'SUSPECTED', 'DENIED'].includes(status)) {
//                         console.log('⚠️ iDenfy token invalid, regenerating new token...');

//                         const iToken = {
//                             clientId: user.id,
//                             firstName: user.firstName,
//                             lastName: user.lastName,
//                             country: 'US',
//                             successUrl: `https://verifymobi.com/verifySuccess`,
//                             errorUrl: `https://verifymobi.com/verifyError`,
//                             unverifiedUrl: `https://verifymobi.com/unverified`
//                         };

//                         const newTokenResponse = await axios.post(
//                             "https://ivs.idenfy.com/api/v2/token",
//                             iToken,
//                             {
//                                 auth: {
//                                     username: "zRf88d0uCAk",
//                                     password: "2IK73MlssycZlXhkKb10"
//                                 }
//                             }
//                         );

//                         console.log('📥 New iDenfy Token Response:', newTokenResponse?.data);

//                         if (newTokenResponse?.data) {
//                             const redirect_url = `https://ivs.idenfy.com/api/v2/redirect?authToken=${newTokenResponse.data.authToken}`;
//                             const payload = {
//                                 authToken: newTokenResponse.data.authToken,
//                                 scanRef: newTokenResponse.data.scanRef
//                             };
//                             const encoded_url = btoa(JSON.stringify(payload));
//                             const verify_url = `https://verifymobi.com?data=${encoded_url}`;
//                             const qrDataUrl = await QRCode.toDataURL(verify_url);

//                             user.otp = '';
//                             user.idenfy_authToken = newTokenResponse.data.authToken;
//                             user.idenfy_scanRef = newTokenResponse.data.scanRef;
//                             user.idenfy_url = redirect_url;
//                             await user.save();

//                             console.log('💾 User updated with regenerated iDenfy token');
//                             scanRef = newTokenResponse.data.scanRef;
//                             data = { qr_data: qrDataUrl, verify_url, scanRef };
//                         }
//                     } else if (status === 'APPROVED') {
//                         console.log('🎉 User already verified in iDenfy — generating JWT...');
//                         user.idenfy_verified = '1';
//                         user.otp = '';
//                         user.idenfy_response = JSON.stringify(response.data);
//                         await user.save();

//                         const token = jwt.sign(
//                             { id: user.id, phone: user.phone },
//                             process.env.JWT_SECRET
//                         );

//                         return res.status(200).json({ status: 'success', accessToken: token });
//                     } else {
//                         console.log('✅ iDenfy status active. Reusing existing verification link.');
//                         const payload = {
//                             authToken: user.idenfy_authToken,
//                             scanRef: user.idenfy_scanRef
//                         };
//                         const encoded_url = btoa(JSON.stringify(payload));
//                         const verify_url = `https://verifymobi.com?data=${encoded_url}`;
//                         const qrDataUrl = await QRCode.toDataURL(verify_url);
//                         data = { qr_data: qrDataUrl, verify_url, scanRef: user.idenfy_scanRef };
//                     }
//                 }

//                 console.log('🚀 Returning verification pending response...');
//                 return res.json({
//                     status: 'success',
//                     message: 'Verification pending',
//                     redirect_url: '/verifyLoginQR',
//                     data
//                 });
//             }
//         }

//         // --- Already verified user ---
//         console.log('🎉 User already verified, generating JWT...');
//         user.otp = '';
//         await user.save();

//         const token = jwt.sign(
//             { id: user.id, phone: user.phone },
//             process.env.JWT_SECRET
//         );

//         console.log('🔑 JWT generated successfully for user:', user.id);
//         return res.status(200).json({ status: 'success', accessToken: token });

//     } catch (error) {
//         console.error('💥 verifySignupOTP error:', error);
//         return res.status(500).json({ status: 'error', message: 'Internal server error', error: error.message });
//     }
// };

exports.generateIdenfyToken = async (req, res) => {
    try {
        const { phone, firstName, lastName } = req.body;

        if (!phone || !firstName || !lastName) {
            return res.status(400).json({ status: 'error', message: 'Missing required fields' });
        }

        const user = await KioskUser.findOne({ where: { phone } });
        if (!user) {
            return res.status(404).json({ status: 'error', message: 'User not found' });
        }

        const iToken = {
            clientId: user.id,
            firstName,
            lastName,
            country: 'US',
            successUrl: `https://verifymobi.com/verifySuccess`,
            errorUrl: `https://verifymobi.com/verifyError`,
            unverifiedUrl: `https://verifymobi.com/unverified`,

        };

        const response = await axios.post(
            "https://ivs.idenfy.com/api/v2/token",
            iToken,
            {
                auth: {
                    username: "zRf88d0uCAk",
                    password: "2IK73MlssycZlXhkKb10"
                }
            }
        );

        if (!response?.data?.authToken) {
            throw new Error('Failed to get iDenfy token');
        }

        const redirect_url = `https://ivs.idenfy.com/api/v2/redirect?authToken=${response.data.authToken}`;
        const payload = {
            authToken: response.data.authToken,
            scanRef: response.data.scanRef
        };
        const encoded_url = btoa(JSON.stringify(payload));
        const verify_url = `https://verifymobi.com?data=${encoded_url}`;
        const qrDataUrl = await QRCode.toDataURL(verify_url);

        user.firstName = firstName;
        user.lastName = lastName;
        user.idenfy_authToken = response.data.authToken;
        user.idenfy_scanRef = response.data.scanRef;
        user.idenfy_url = redirect_url;
        await user.save();

        res.json({
            status: 'success',
            message: 'iDenfy token created successfully',
            data: { verify_url, qr_data: qrDataUrl, scanRef: response?.data?.scanRef, authToken: response?.data?.authToken }
        });
    } catch (error) {
        console.error('💥 generateIdenfyToken error:', error);
        res.status(500).json({ status: 'error', message: error.message });
    }
};
exports.retryVerify = async (req, res) => {
    try {
        console.log('🟡 retryVerify() called with body:', req.body);

        // 1️⃣ Generate random verification token
        const token = crypto.randomBytes(16).toString('hex');
        console.log('🔑 Generated verification token:', token);

        // 2️⃣ Call verifymobi.com/create_verification with this token
        const verify = await axios.post('https://verifymobi.com/create_verification', {
            token: token
        });

        console.log('📥 Response from verifymobi.com/create_verification:', verify.data);

        if (!verify?.data || verify.data.status !== 'success') {
            return res.status(400).json({
                status: 'error',
                message: verify?.data?.message || 'Failed to create verification session'
            });
        }

        // 3️⃣ Prepare verify URL and QR code
        const payload = { token };
        const encoded = Buffer.from(JSON.stringify(payload)).toString('base64');
        const verify_url = `https://verifymobi.com?data=${encoded}`;
        const qrDataUrl = await QRCode.toDataURL(verify_url);

        // 4️⃣ Return result
        return res.json({
            status: 'success',
            message: 'Verification created successfully',
            data: {
                token,
                verify_url,
                qr_data: qrDataUrl
            }
        });
    } catch (error) {
        console.error('💥 retryVerify error:', error.message);
        return res.status(500).json({
            status: 'error',
            message: 'Internal server error',
            error: error.message
        });
    }
};
// exports.retryVerify = async (req, res) => {
//     try {
//         console.log('🟡 retryVerify() called with body:', req.body);

//         const { phoneNumber } = req.body;
//         if (!phoneNumber) {
//             console.log('❌ Missing phoneNumber');
//             return res.json({ status: 'error', message: 'Phone number is required' });
//         }

//         console.log(`🔍 Searching user with phone: ${phoneNumber}`);
//         const user = await KioskUser.findOne({ where: { phone: phoneNumber } });

//         if (!user) {
//             console.log('❌ User not found for phone:', phoneNumber);
//             return res.json({ status: 'error', message: 'User not found!' });
//         }

//         console.log('👤 Found user:', {
//             id: user.id,
//             firstName: user.firstName,
//             lastName: user.lastName,
//             idenfy_verified: user.idenfy_verified,
//             idenfy_scanRef: user.idenfy_scanRef
//         });

//         // --- If already verified, just return token ---
//         if (user.idenfy_verified === '1') {
//             console.log('✅ User already verified, generating JWT...');
//             const token = jwt.sign(
//                 { id: user.id, phone: user.phone },
//                 process.env.JWT_SECRET
//             );
//             return res.status(200).json({ status: 'success', accessToken: token });
//         }

//         // --- Otherwise, handle iDenfy flow ---
//         let scanRef = user.idenfy_scanRef;
//         let data = null;

//         if (!scanRef) {
//             console.log('🆕 No scanRef found. Creating new iDenfy session...');

//             const iToken = {
//                 clientId: user.id,
//                 firstName: user.firstName,
//                 lastName: user.lastName,
//                 country: 'US',
//                 successUrl: `https://verifymobi.com/verifySuccess`,
//                 errorUrl: `https://verifymobi.com/verifyError`,
//                 unverifiedUrl: `https://verifymobi.com/unverified`
//             };

//             const response = await axios.post(
//                 "https://ivs.idenfy.com/api/v2/token",
//                 iToken,
//                 {
//                     auth: {
//                         username: "zRf88d0uCAk",
//                         password: "2IK73MlssycZlXhkKb10"
//                     }
//                 }
//             );

//             console.log('📥 New iDenfy Token Response:', response?.data);

//             if (response?.data) {
//                 const redirect_url = `https://ivs.idenfy.com/api/v2/redirect?authToken=${response.data.authToken}`;
//                 const payload = {
//                     authToken: response.data.authToken,
//                     scanRef: response.data.scanRef
//                 };
//                 const encoded_url = btoa(JSON.stringify(payload));
//                 const verify_url = `https://verifymobi.com?data=${encoded_url}`;
//                 const qrDataUrl = await QRCode.toDataURL(verify_url);

//                 user.idenfy_authToken = response.data.authToken;
//                 user.idenfy_scanRef = response.data.scanRef;
//                 user.idenfy_url = redirect_url;
//                 await user.save();

//                 data = { qr_data: qrDataUrl, verify_url, scanRef: response.data.scanRef };
//                 scanRef = response.data.scanRef;
//             }
//         } else {
//             console.log(`🔁 Checking iDenfy status for existing scanRef: ${scanRef}`);

//             const response = await axios.post(
//                 "https://ivs.idenfy.com/api/v2/status",
//                 { scanRef },
//                 {
//                     auth: {
//                         username: "zRf88d0uCAk",
//                         password: "2IK73MlssycZlXhkKb10"
//                     }
//                 }
//             );

//             console.log('📥 iDenfy Status Response:', response?.data);

//             const status = response?.data?.status?.toUpperCase?.() || 'UNKNOWN';
//             console.log('📊 Current iDenfy Status:', status);

//             if (['EXPIRED', 'SUSPECTED', 'DENIED'].includes(status)) {
//                 console.log('⚠️ iDenfy session invalid — regenerating...');

//                 const iToken = {
//                     clientId: user.id,
//                     firstName: user.firstName,
//                     lastName: user.lastName,
//                     country: 'US',
//                     successUrl: `https://verifymobi.com/verifySuccess`,
//                     errorUrl: `https://verifymobi.com/verifyError`,
//                     unverifiedUrl: `https://verifymobi.com/unverified`
//                 };

//                 const newTokenResponse = await axios.post(
//                     "https://ivs.idenfy.com/api/v2/token",
//                     iToken,
//                     {
//                         auth: {
//                             username: "zRf88d0uCAk",
//                             password: "2IK73MlssycZlXhkKb10"
//                         }
//                     }
//                 );

//                 console.log('📥 New iDenfy Token Response:', newTokenResponse?.data);

//                 if (newTokenResponse?.data) {
//                     const redirect_url = `https://ivs.idenfy.com/api/v2/redirect?authToken=${newTokenResponse.data.authToken}`;
//                     const payload = {
//                         authToken: newTokenResponse.data.authToken,
//                         scanRef: newTokenResponse.data.scanRef
//                     };
//                     const encoded_url = btoa(JSON.stringify(payload));
//                     const verify_url = `https://verifymobi.com?data=${encoded_url}`;
//                     const qrDataUrl = await QRCode.toDataURL(verify_url);

//                     user.idenfy_authToken = newTokenResponse.data.authToken;
//                     user.idenfy_scanRef = newTokenResponse.data.scanRef;
//                     user.idenfy_url = redirect_url;
//                     await user.save();

//                     console.log('💾 User updated with regenerated token');
//                     scanRef = newTokenResponse.data.scanRef;
//                     data = { qr_data: qrDataUrl, verify_url, scanRef };
//                 }
//             } else if (status === 'APPROVED') {
//                 console.log('🎉 User already verified — updating record...');
//                 user.idenfy_verified = '1';
//                 user.idenfy_response = JSON.stringify(response.data);
//                 await user.save();

//                 const token = jwt.sign(
//                     { id: user.id, phone: user.phone },
//                     process.env.JWT_SECRET
//                 );
//                 return res.status(200).json({ status: 'success', accessToken: token });
//             } else {
//                 console.log('✅ iDenfy session still valid. Reusing QR.');
//                 const payload = {
//                     authToken: user.idenfy_authToken,
//                     scanRef: user.idenfy_scanRef
//                 };
//                 const encoded_url = btoa(JSON.stringify(payload));
//                 const verify_url = `https://verifymobi.com?data=${encoded_url}`;
//                 const qrDataUrl = await QRCode.toDataURL(verify_url);
//                 data = { qr_data: qrDataUrl, verify_url, scanRef: user.idenfy_scanRef };
//             }
//         }

//         console.log('🚀 Returning verification pending (retry) response...');
//         return res.json({
//             status: 'success',
//             message: 'Verification pending',
//             redirect_url: '/verifyLoginQR',
//             data
//         });
//     } catch (error) {
//         console.error('💥 retryVerify error:', error);
//         return res.status(500).json({
//             status: 'error',
//             message: 'Internal server error',
//             error: error.message,
//         });
//     }
// };

exports.checkIdenfyToken = async (req, res) => {
    const { scanRef } = req.body;
    if (!scanRef) {
        return res.json({ status: 'error', message: 'Invalid input' });
    }
    const iToken = {
        scanRef
    };
    try {
        console.log("iToken", iToken);
        const response = await axios.post(
            "https://ivs.idenfy.com/api/v2/status",
            iToken, {
            auth: {
                // username: "MqQuxwqdY4r",
                // password: "LOjIiF3apWISOWB4UGDW"
                username: "zRf88d0uCAk",
                password: "2IK73MlssycZlXhkKb10"
            }
        });
        if (response?.data) {
            res.json({ status: 'success', idenfyData: response?.data });
        } else {
            return res.json({ status: 'error', message: 'Unable to check iDenfy token' });
        }
    } catch (error) {

        return res.json({ status: 'error', message: 'Unable to check iDenfy token' });
    }
}
exports.idenfyWebhook = async (req, res) => {
    const pool = mysql.createPool({
        host: process.env.WH_DB_HOST,
        port: process.env.WH_DB_PORT,
        user: process.env.WH_DB_USER,
        password: process.env.WH_DB_PASS,
        database: process.env.WH_DB_NAME,
        waitForConnections: true,
        connectionLimit: 1,
        queueLimit: 0
    });
    const query = (sql, params) => {
        return new Promise((resolve, reject) => {
            pool.query(sql, params, (error, results) => {
                if (error) return reject(error);
                resolve(results);
            });
        });
    };

    const json = req.body;
    // const connection = await pool.getConnection();
    // console.log(connection);
    // return;
    // console.log(json)
    try {
        await query('START TRANSACTION');

        const ipv4UserIP = req.headers['x-forwarded-for'] || req.socket.remoteAddress;
        const wh = JSON.stringify(json);
        const timex = new Date().toISOString().slice(0, 19).replace('T', ' ');

        // Insert webhook log
        await query(
            "INSERT INTO `webhookiplog`(`webhook`, `ip`, `data`, `created_at`, `updated_at`) VALUES (?, ?, ?, ?, ?)",
            ['Idenfy', ipv4UserIP, wh, timex, timex]
        );

        const { clientId, scanRef, final, status, data } = json;

        // console.log(clientId, scanRef, final, status, data)
        const docNumber = data?.docNumber?.replace(/\s+/g, '') || null;
        const docFirstName = data?.docFirstName || null;
        const docLastName = data?.docLastName || null;

        if (final) {
            // Fetch user details
            const userResult = await query(
                "SELECT `first`,`last`,`email`,`phone`,`autoverref`,`pidv`,`namev`,`pidno`,`isVerified`,`isEmailVerified` FROM `users` WHERE `id` = ?",
                [clientId]
            );
            const datauser2 = userResult[0];
            // console.log(datauser2)
            // Check for duplicate document number

            if (docNumber && docNumber.trim() !== '') {
                const checkDocResult = await query(
                    "SELECT `id` FROM `users` WHERE `pidno` = ?",
                    [docNumber]
                );
                if (checkDocResult.length > 0) {
                    const dataCheckDoc = checkDocResult[0];
                    if (parseInt(dataCheckDoc.id) !== parseInt(clientId)) {
                        if (datauser2.isVerified != '1') {
                            await query(
                                "UPDATE `users` SET `status` = '5', `pidv` = '3', `namev` = '3', `autoverify` = '1',`isVerified` = '3', `idenfy_webhook`= ?, `autoverauth` = NULL, `autoverref` = NULL, `is_duplicate`='1', `prev_account`=? WHERE `id` = ?",
                                [wh, dataCheckDoc.id, clientId]
                            );

                            await query(
                                "UPDATE `users` SET `is_duplicate`='1', `prev_account`=? WHERE `id` = ?",
                                [clientId, dataCheckDoc.id]
                            );

                            // await sendMail(datauser2.email, datauser2.first, 'Verification Required!',
                            //     "<p>We are unable to complete your verification as the document provided has already been used.</p><p>Thank you for choosing SweepStake Mobi!</p>"
                            // );
                        }
                    }
                } else {
                    if (datauser2.isVerified != '1') {
                        if (status?.overall === 'APPROVED' && datauser2.autoverref === scanRef) {
                            await query(
                                "UPDATE `users` SET `status` = '1', `pidv` = '1', `namev` = '1', `pidno`=?, `cname` = 'AML System', `vid` = '', `vcode` = '', `vcode2` = '',isVerified = '1', `autoverify` = '2', `autoverauth` = '', `autoverref` = '', `idenfy_webhook`=? WHERE `id` = ?",
                                [docNumber, wh, clientId]
                            );

                            // await sendMail(datauser2.email, datauser2.first, 'Verification successful!',
                            //     "<p>Your Verification has been completed and you can now login to your wallet.</p><p>Thank you for choosing SweepStake Mobi!</p>"
                            // );
                        } else if (['DENIED', 'EXPIRED', 'SUSPECTED'].includes(status?.overall) && datauser2.autoverref === scanRef) {
                            await query(
                                "UPDATE `users` SET `status` = '5', `pidv` = '0', `namev` = '0', `autoverify` = '0', `autoverauth` = '', `autoverref` = '' WHERE `id` = ?",
                                [clientId]
                            );

                            if (status?.overall !== 'EXPIRED') {
                                await query(
                                    "INSERT INTO `failedvers` (`userid`,`webhook`,`created_at`) VALUES (?,?,?)",
                                    [clientId, wh, timex]
                                );
                            }

                            // await sendMail(datauser2.email, datauser2.first, 'Verification Required!',
                            //     "<p>Your Verification has been failed and you can try to login to your wallet to reinitiate your verification.</p><p>Thank you for choosing SweepStake Mobi!</p>"
                            // );
                        }
                    }
                }
            }
        }

        await query('COMMIT');
        return res.status(200).json('OK');


    } catch (error) {
        console.error('Error:', error);
        await query('ROLLBACK');
        return res.status(500).send('Internal Server Error');
    } finally {
        pool.end((err) => {
            if (err) console.error('Error closing the connection pool:', err);
        });
    }
};
exports.updateIdenfyUser = async (req, res) => {
    try {
        const { verifymobi_token, idenfyResponse } = req.body;
        const user = await KioskUser.findOne({ where: { verifymobi_token: verifymobi_token } })
        if (!user) {
            return res.json({ status: 'error', message: 'User not found' })
        }
        user.idenfy_verified = '1'
        user.idenfy_response = idenfyResponse
        await user.save();
        const token = jwt.sign(
            { id: user.id, phone: user.phone },
            process.env.JWT_SECRET,
        );
        res.json({ status: 'success', message: 'User successfully verified', accessToken: token })
    } catch (error) {
        return res.json({ status: 'error', message: error?.message })

    }
}
exports.verifyMobiPoll = async (req, res) => {
    try {
        const { scanRef } = req.body
        const user = await KioskUser.findOne({ where: { idenfy_scanRef: scanRef } })
        if (!user) {
            return res.json({ status: 'error', message: 'User not found' })
        }
        const iToken = {
            scanRef
        };
        console.log("iToken", iToken);
        const response = await axios.post(
            "https://ivs.idenfy.com/api/v2/status",
            iToken, {
            auth: {

                username: "zRf88d0uCAk",
                password: "2IK73MlssycZlXhkKb10"
            }
        });
        if (response?.data) {

            const status = response?.data?.status
            if (['EXPIRED', 'DENIED', 'SUSPECTED'].includes(status)) {

                return res.json({
                    status: 'success',
                    message: 'Verification failed',
                    verification_status: 'failed',
                    idenfyData: response?.data

                })
            } else if (status == 'APPROVED') {

                user.idenfy_verified = '1';
                user.idenfy_response = response?.data
                await user.save();

                return res.json({
                    status: 'success',
                    message: 'Verification successful',
                    verification_status: 'success',
                    idenfyData: response?.data


                })
            } else {
                return res.json({
                    status: 'success',
                    message: 'Verification under process',
                    verification_status: 'waiting',
                    idenfyData: response?.data
                })
            }

        } else {
            return res.json({ status: 'error', message: 'Unable to check iDenfy token' });
        }

    } catch (error) {
        return res.json({ status: 'error', message: error?.message })
    }
}

exports.getKioskStatus = async (req, res) => {
    try {
        const kioskName = req.query.kioskName || "Kiosk 1";
        let nv200url, f53url;

        // External kiosk endpoints
        if (kioskName == 'Kiosk 1') {
            nv200url = `https://api8383.logiclane.tech/api/status`;
            f53url = `https://api8000.logiclane.tech/status?kioskName=${kioskName}`;
        } else if (kioskName == 'Kiosk 2') {
            nv200url = `https://api18383.logiclane.tech/api/status`;
            f53url = `https://api18000.logiclane.tech/status?kioskName=${kioskName}`;
        }
        const headers = {
            "ngrok-skip-browser-warning": "true",
            "Content-Type": "application/json",
        };

        // Make both requests in parallel (server-side, no CORS problem)
        const [nv200Res, f53Res] = await Promise.allSettled([
            axios.post(nv200url, { kioskName }, { headers }),
            axios.get(f53url, { headers }),
        ]);

        // Build response
        const result = {
            kioskName,
            NV200: nv200Res.status === "fulfilled" ? nv200Res.value.data : null,
            F53: f53Res.status === "fulfilled" ? f53Res.value.data : null,
            NV200Running: nv200Res.status === "fulfilled",
            F53Running: f53Res.status === "fulfilled",
        };
        console.log(nv200Res, f53Res)
        res.json({ status: "success", result });
    } catch (error) {
        console.error("getKioskStatus error:", error.message);
        res.status(500).json({
            status: "error",
            message: error.message || "Failed to fetch kiosk status",
        });
    }
};

exports.updateStackingStats = (req, res) => {
    const { notes, total, kiosk, lastNoteValue, phone } = req.body; // ✅ added phone

    const conn = mysql.createConnection({
        host: process.env.WH_DB_HOST,
        port: process.env.WH_DB_PORT,
        user: process.env.WH_DB_USER,
        password: process.env.WH_DB_PASS,
        database: process.env.WH_DB_NAME,
    });

    conn.beginTransaction(async (err) => {
        if (err) {
            return res.json({
                status: 'error',
                message: 'Failed to start transaction: ' + err.message,
            });
        }

        const query = (sql, params = []) =>
            new Promise((resolve, reject) => {
                conn.query(sql, params, (error, results) => {
                    if (error) reject(error);
                    else resolve(results);
                });
            });

        try {
            if (!kiosk || kiosk.trim() === '') {
                // ---- Global behavior ----
                const rows = await query('SELECT COUNT(*) AS count FROM StackingStats');
                if (rows[0].count > 0) {
                    await query(
                        'UPDATE StackingStats SET stacked_notes = ?, total_amount = ?, last_note = ?',
                        [notes, total, lastNoteValue]
                    );
                } else {
                    await query(
                        'INSERT INTO StackingStats (stacked_notes, total_amount, last_note) VALUES (?, ?, ?)',
                        [notes, total, lastNoteValue]
                    );
                }

                // Update denomination count
                await query(
                    `INSERT INTO StackingNoteCounts (kiosk_name, denomination, note_count)
                     VALUES ('(global)', ?, 1)
                     ON DUPLICATE KEY UPDATE note_count = note_count + 1`,
                    [Number(lastNoteValue.toFixed(2))]
                );

                // Insert denomination log
                await query(
                    `INSERT INTO StackingNoteLog (kiosk_name, denomination, note_count, phone, created_at, updated_at)
                     VALUES ('(global)', ?, 1, ?, NOW(), NOW())`,
                    [Number(lastNoteValue.toFixed(2)), phone || null]
                );
            } else {
                // ---- Kiosk-specific behavior ----
                const result = await query(
                    `UPDATE StackingStats
                     SET stacked_notes = ?, total_amount = ?, last_note = ?
                     WHERE LOWER(kiosk_name) = ?`,
                    [notes, total, lastNoteValue, kiosk.toLowerCase()]
                );

                if (result.affectedRows === 0) {
                    await query(
                        `INSERT INTO StackingStats (kiosk_name, stacked_notes, total_amount, last_note)
                         VALUES (?, ?, ?, ?)`,
                        [kiosk, notes, total, lastNoteValue]
                    );
                }

                // Update denomination count
                await query(
                    `INSERT INTO StackingNoteCounts (kiosk_name, denomination, note_count)
                     VALUES (?, ?, 1)
                     ON DUPLICATE KEY UPDATE note_count = note_count + 1`,
                    [kiosk, Number(lastNoteValue.toFixed(2))]
                );

                // Insert denomination log (✅ includes phone)
                await query(
                    `INSERT INTO StackingNoteLog (kiosk_name, denomination, note_count, phone, created_at, updated_at)
                     VALUES (?, ?, 1, ?, NOW(), NOW())`,
                    [kiosk, Number(lastNoteValue.toFixed(2)), phone || null]
                );
            }

            conn.commit((err) => {
                if (err) {
                    conn.rollback(() => {
                        return res.json({
                            status: 'error',
                            message: 'Commit failed: ' + err.message,
                        });
                    });
                } else {
                    res.json({
                        status: 'success',
                        message: 'Stacking stats updated successfully',
                    });
                }
            });
        } catch (error) {
            conn.rollback(() => {
                res.json({
                    status: 'error',
                    message: error.message,
                });
            });
        } finally {
            conn.end();
        }
    });
};
exports.loadStatsFromDatabase = (req, res) => {
    const { kioskName } = req.body;

    const conn = mysql.createConnection({
        host: process.env.WH_DB_HOST,
        port: process.env.WH_DB_PORT,
        user: process.env.WH_DB_USER,
        password: process.env.WH_DB_PASS,
        database: process.env.WH_DB_NAME,
    });

    conn.beginTransaction(async (err) => {
        if (err) {
            return res.json({ status: 'error', message: 'Failed to start transaction: ' + err.message });
        }

        // ✅ FIXED: allow spaces in kiosk names
        const sanitizeKioskName = (name) => {
            if (!name) return '';
            return name.trim().replace(/[^a-zA-Z0-9_\-\s]/g, '');
        };

        const kioskCanonical = sanitizeKioskName(kioskName);
        const kioskLower = kioskCanonical.toLowerCase();

        const query = (sql, params = []) =>
            new Promise((resolve, reject) => {
                conn.query(sql, params, (error, results) => {
                    if (error) reject(error);
                    else resolve(results);
                });
            });

        try {
            let sql, params = [];

            if (!kioskCanonical) {
                sql = 'SELECT stacked_notes, total_amount FROM StackingStats LIMIT 1';
            } else {
                sql = 'SELECT stacked_notes, total_amount FROM StackingStats WHERE LOWER(kiosk_name) = ? LIMIT 1';
                params = [kioskLower];
            }

            const rows = await query(sql, params);

            if (rows.length > 0) {
                const row = rows[0];
                const numStackedNotes = row.stacked_notes || 0;
                const totalStackedNotes = row.total_amount || 0;

                console.log(`Bill Count: ${numStackedNotes}`);
                console.log(`Amount Count: $${totalStackedNotes / 100}`);

                conn.commit((err) => {
                    if (err) {
                        conn.rollback(() => {
                            return res.json({ status: 'error', message: 'Commit failed: ' + err.message });
                        });
                    } else {
                        res.json({
                            status: 'success',
                            message: 'Stats loaded successfully',
                            kiosk: kioskCanonical || '(global)',
                            stacked_notes: numStackedNotes,
                            total_amount: totalStackedNotes,
                        });
                    }
                });
            } else {
                const insertSql =
                    'INSERT INTO StackingStats (kiosk_name, stacked_notes, total_amount) VALUES (?, 0, 0)';
                const insertParams = [kioskCanonical || '(global)'];

                const result = await query(insertSql, insertParams);

                console.log(`Inserted new stats rows: ${result.affectedRows}`);
                console.log(`Inserted new stats for kiosk: ${kioskCanonical || '(global)'}`);

                conn.commit((err) => {
                    if (err) {
                        conn.rollback(() => {
                            return res.json({ status: 'error', message: 'Commit failed: ' + err.message });
                        });
                    } else {
                        res.json({
                            status: 'inserted',
                            message: 'No existing stats found; new row created.',
                            kiosk: kioskCanonical || '(global)',
                            stacked_notes: 0,
                            total_amount: 0,
                        });
                    }
                });
            }
        } catch (error) {
            conn.rollback(() => {
                res.json({ status: 'error', message: error.message });
            });
        } finally {
            conn.end();
        }
    });
};
exports.getStackingStats = async (req, res) => {
    const { kioskName } = req.body;

    const conn = mysql.createConnection({
        host: process.env.WH_DB_HOST,
        port: process.env.WH_DB_PORT,
        user: process.env.WH_DB_USER,
        password: process.env.WH_DB_PASS,
        database: process.env.WH_DB_NAME,
    });

    const query = (sql, params = []) =>
        new Promise((resolve, reject) => {
            conn.query(sql, params, (err, results) => {
                if (err) reject(err);
                else resolve(results);
            });
        });

    try {
        const sql = `
      SELECT stacked_notes, total_amount
      FROM StackingStats
      WHERE LOWER(kiosk_name) = ?
      LIMIT 1
    `;
        const rows = await query(sql, [kioskName.toLowerCase()]);
        conn.end();

        if (rows.length > 0) {
            const dbNotes = rows[0].stacked_notes || 0;
            const dbAmount = rows[0].total_amount || 0;

            return res.json({
                status: 'success',
                stacked_notes: dbNotes,
                total_amount: dbAmount,
            });
        } else {
            return res.json({
                status: 'not_found',
                stacked_notes: 0,
                total_amount: 0,
            });
        }
    } catch (error) {
        conn.end();
        console.error("DB Error:", error.message);
        return res.json({ status: 'error', message: error.message });
    }
};
exports.getTransactions = async (req, res) => {
    try {
        const {
            page = 1,
            limit = 10,
            search = "",
            type = "all",
            order = "DESC",
        } = req.body;

        const authHeader = req.headers["authorization"] || req.headers["Authorization"];
        if (!authHeader) return res.status(401).send("Authorization header is missing");

        const token = authHeader.split(" ")[1];
        if (!token) return res.status(401).send("Token is missing");

        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        const adminId = decoded.id;

        const admin = await Admin.findOne({
            where: { id: adminId },
            attributes: { exclude: ["password", "otp"] },
        });
        if (!admin) return res.status(404).send("Admin not found");

        const offset = (parseInt(page) - 1) * parseInt(limit);

        let txns = [];
        let totalCount = 0;

        const searchLower = search.toLowerCase().trim();

        const txnTypeMap = {
            deposit: "1",
            redeem: "2",
            cashout: "cashout",
            stacking: "stacking",
        };

        const searchTypeFilter = txnTypeMap[searchLower] || null;

        const userSearchCondition = search
            ? {
                [Op.or]: [
                    { "$KioskUser.phone$": { [Op.like]: `%${search}%` } },
                    { "$KioskUser.firstName$": { [Op.like]: `%${search}%` } },
                    { "$KioskUser.lastName$": { [Op.like]: `%${search}%` } },
                ],
            }
            : {};

        // 💰 DEPOSITS
        if ((type === "deposit" || type === "all") && (!searchTypeFilter || searchTypeFilter === "1")) {
            const depositCondition =
                search && !searchTypeFilter
                    ? {
                        [Op.or]: [
                            { gameuser: { [Op.like]: `%${search}%` } },
                            { "$Game.name$": { [Op.like]: `%${search}%` } },
                            ...userSearchCondition[Op.or],
                        ],
                    }
                    : {};

            const deposits = await KioskTxns.findAndCountAll({
                where: { type: "1", ...depositCondition },
                include: [
                    { model: KioskUser, attributes: ["id", "phone", "firstName", "lastName"], required: true },
                    { model: Game, attributes: ["id", "name"], required: false },
                ],
                order: [["created_at", order]],
            });

            txns.push(...deposits.rows.map((t) => ({ ...t.toJSON(), txnType: "deposit" })));
            totalCount += deposits.count;
        }

        // 🎯 REDEEMS
        if ((type === "redeem" || type === "all") && (!searchTypeFilter || searchTypeFilter === "2")) {
            const redeemCondition =
                search && !searchTypeFilter
                    ? {
                        [Op.or]: [
                            { gameuser: { [Op.like]: `%${search}%` } },
                            { "$Game.name$": { [Op.like]: `%${search}%` } },
                            ...userSearchCondition[Op.or],
                        ],
                    }
                    : {};

            const redeems = await KioskTxns.findAndCountAll({
                where: { type: "2", ...redeemCondition },
                include: [
                    { model: KioskUser, attributes: ["id", "phone", "firstName", "lastName"], required: true },
                    { model: Game, attributes: ["id", "name"], required: false },
                ],
                order: [["created_at", order]],
            });

            txns.push(...redeems.rows.map((t) => ({ ...t.toJSON(), txnType: "redeem" })));
            totalCount += redeems.count;
        }

        // 💵 CASHOUTS
        // if ((type === "cashout" || type === "all") && (!searchTypeFilter || searchTypeFilter === "cashout")) {
        //     const cashoutCondition =
        //         search && !searchTypeFilter
        //             ? {
        //                 [Op.or]: [
        //                     { code: { [Op.like]: `%${search}%` } },
        //                     ...userSearchCondition[Op.or],
        //                 ],
        //             }
        //             : {};

        //     const cashouts = await KioskCashout.findAndCountAll({
        //         where: { ...cashoutCondition },
        //         include: [
        //             {
        //                 model: KioskUser,
        //                 attributes: ["id", "phone", "firstName", "lastName"],
        //                 required: true,
        //                 on: db.Sequelize.literal(
        //                     "CONVERT(`KioskCashout`.`phone` USING utf8mb4) = CONVERT(`KioskUser`.`phone` USING utf8mb4)"
        //                 ),
        //             },
        //         ],
        //         order: [["created_at", order]],
        //     });

        //     txns.push(...cashouts.rows.map((t) => ({ ...t.toJSON(), txnType: "cashout" })));
        //     totalCount += cashouts.count;
        // }
        if ((type === "cashout" || type === "all") && (!searchTypeFilter || searchTypeFilter === "cashout")) {

            const cashoutCondition =
                search && !searchTypeFilter
                    ? {
                        [Op.or]: [
                            { code: { [Op.like]: `%${search}%` } },
                            ...userSearchCondition[Op.or],
                        ],
                    }
                    : {};

            // Fetch cashouts + kiosk user + kiosk
            const cashouts = await KioskCashout.findAndCountAll({
                where: { ...cashoutCondition },
                include: [
                    {
                        model: KioskUser,
                        attributes: ["id", "phone", "firstName", "lastName"],
                        required: true,
                        on: db.Sequelize.literal(
                            "CONVERT(`KioskCashout`.`phone` USING utf8mb4) = CONVERT(`KioskUser`.`phone` USING utf8mb4)"
                        ),
                    },
                    {
                        model: Kiosks,
                        as: "Kiosk",
                        attributes: ["id", "kiosk_alias", "kiosk_name"],
                        required: false,
                        on: db.Sequelize.literal(
                            "CONVERT(`KioskCashout`.`kiosk_name` USING utf8mb4) = CONVERT(`Kiosk`.`kiosk_name` USING utf8mb4)"
                        ),
                    }
                ],
                order: [["created_at", order]],
            });

            // Build final rows with cassette breakdown
            for (let row of cashouts.rows) {
                const item = row.toJSON();

                // --------------------------
                // PROCESS CASSETTE BREAKDOWN
                // --------------------------
                const combination = item.combination ? JSON.parse(item.combination) : null;

                if (!combination || !item.Kiosk?.id) {
                    // No breakdown available
                    item.cassetteBreakdown = [];
                    txns.push({ ...item, txnType: "cashout" });
                    continue;
                }

                // Fetch cassettes for this kiosk
                const cassettes = await F53Cassettes.findAll({
                    where: { kiosk_id: item.Kiosk.id },
                    attributes: ["cassett_id", "value"],
                });

                // Build cassette_id → denomination map
                const cassetteMap = {};
                cassettes.forEach(c => {
                    cassetteMap[c.cassett_id] = c.value;
                });

                // Convert combination: { "1":2, "2":1 } → cassette breakdown
                const breakdown = Object.entries(combination).map(([cassetteId, qty]) => {
                    const denom = cassetteMap[cassetteId] || 0;

                    return {
                        cassette_id: Number(cassetteId),
                        denomination: denom,
                        quantity: qty,
                        label: `$${denom} × ${qty}`,
                    };
                });

                // sort high → low denomination (optional)
                breakdown.sort((a, b) => b.denomination - a.denomination);

                item.cassetteBreakdown = breakdown;

                txns.push({ ...item, txnType: "cashout" });
            }

            totalCount += cashouts.count;
        }
        // 🧱 STACKING NOTES LOG
        // if ((type === "cash" || type === "all") && (!searchTypeFilter || searchTypeFilter === "cash")) {
        //     const stackingCondition =
        //         search && !searchTypeFilter
        //             ? {
        //                 [Op.or]: [
        //                     // { denomination: { [Op.like]: `%${search}%` } },
        //                     { "$KioskUser.phone$": { [Op.like]: `%${search}%` } },
        //                     { "$KioskUser.firstName$": { [Op.like]: `%${search}%` } },
        //                     { "$KioskUser.lastName$": { [Op.like]: `%${search}%` } },
        //                 ],
        //             }
        //             : {};

        //     const stackingNotes = await StackingNoteLog.findAndCountAll({
        //         where: { ...stackingCondition },
        //         include: [
        //             {
        //                 model: KioskUser,
        //                 attributes: ["id", "phone", "firstName", "lastName"],
        //                 required: true,
        //                 on: db.Sequelize.literal(
        //                     "CONVERT(`StackingNoteLog`.`phone` USING utf8mb4) = CONVERT(`KioskUser`.`phone` USING utf8mb4)"
        //                 ),
        //             },
        //         ],
        //         order: [["created_at", order]],
        //     });

        //     txns.push(
        //         ...stackingNotes.rows.map((t) => {
        //             const data = t.toJSON();
        //             return {
        //                 ...data,
        //                 amount: parseInt(data.denomination), // 👈 Rename denomination → amount
        //                 txnType: "cash",
        //             };
        //         })
        //     );

        //     totalCount += stackingNotes.count;
        // }

        // 🕒 Sort all by created_at
        txns.sort((a, b) => {
            if (order === "ASC") return new Date(a.created_at) - new Date(b.created_at);
            return new Date(b.created_at) - new Date(a.created_at);
        });

        // 🧮 Manual pagination
        const paginatedTxns = txns.slice(offset, offset + parseInt(limit));

        return res.json({
            txns: paginatedTxns,
            totalCount,
            totalPages: Math.ceil(totalCount / limit),
            currentPage: parseInt(page),
            type,
            order,
        });
    } catch (error) {
        if (error.name === "JsonWebTokenError" || error.name === "TokenExpiredError") {
            return res.status(401).json({ error: "Token is invalid or has expired" });
        }
        console.error(error);
        res.status(500).send("Internal server error");
    }
};

// exports.getTransactions = async (req, res) => {
//     try {
//         const {
//             page = 1,
//             limit = 10,
//             search = "",
//             type = "all",
//             order = "DESC",
//         } = req.body;

//         const authHeader = req.headers["authorization"] || req.headers["Authorization"];
//         if (!authHeader) return res.status(401).send("Authorization header is missing");

//         const token = authHeader.split(" ")[1];
//         if (!token) return res.status(401).send("Token is missing");

//         const decoded = jwt.verify(token, process.env.JWT_SECRET);
//         const adminId = decoded.id;

//         const admin = await Admin.findOne({
//             where: { id: adminId },
//             attributes: { exclude: ["password", "otp"] },
//         });
//         if (!admin) return res.status(404).send("Admin not found");

//         const offset = (parseInt(page) - 1) * parseInt(limit);

//         let txns = [];
//         let totalCount = 0;

//         // 🧠 Normalize search term
//         const searchLower = search.toLowerCase().trim();

//         // 🧩 If search is a transaction type, set searchTypeFilter
//         const txnTypeMap = {
//             deposit: "1",
//             redeem: "2",
//             cashout: "cashout",
//         };

//         const searchTypeFilter = txnTypeMap[searchLower] || null;

//         // 💰 DEPOSITS
//         if (
//             (type === "deposit" || type === "all") &&
//             (!searchTypeFilter || searchTypeFilter === "1")
//         ) {
//             const depositCondition =
//                 search && !searchTypeFilter
//                     ? {
//                         [Op.or]: [
//                             { gameuser: { [Op.like]: `%${search}%` } },
//                             { "$Game.name$": { [Op.like]: `%${search}%` } },
//                             { "$KioskUser.phone$": { [Op.like]: `%${search}%` } },
//                             { "$KioskUser.firstName$": { [Op.like]: `%${search}%` } },
//                             { "$KioskUser.lastName$": { [Op.like]: `%${search}%` } },
//                         ],
//                     }
//                     : {};

//             const deposits = await KioskTxns.findAndCountAll({
//                 where: { type: "1", ...depositCondition },
//                 include: [
//                     {
//                         model: KioskUser,
//                         attributes: ["id", "phone", "firstName", "lastName"],
//                         required: true,
//                     },
//                     {
//                         model: Game,
//                         attributes: ["id", "name"],
//                         required: false,
//                     },
//                 ],
//                 order: [["created_at", order]],
//             });

//             txns.push(
//                 ...deposits.rows.map((t) => ({
//                     ...t.toJSON(),
//                     txnType: "deposit",
//                 }))
//             );
//             totalCount += deposits.count;
//         }

//         // 🎯 REDEEMS
//         if (
//             (type === "redeem" || type === "all") &&
//             (!searchTypeFilter || searchTypeFilter === "2")
//         ) {
//             const redeemCondition =
//                 search && !searchTypeFilter
//                     ? {
//                         [Op.or]: [
//                             { gameuser: { [Op.like]: `%${search}%` } },
//                             { "$Game.name$": { [Op.like]: `%${search}%` } },
//                             { "$KioskUser.phone$": { [Op.like]: `%${search}%` } },
//                             { "$KioskUser.firstName$": { [Op.like]: `%${search}%` } },
//                             { "$KioskUser.lastName$": { [Op.like]: `%${search}%` } },
//                         ],
//                     }
//                     : {};

//             const redeems = await KioskTxns.findAndCountAll({
//                 where: { type: "2", ...redeemCondition },
//                 include: [
//                     {
//                         model: KioskUser,
//                         attributes: ["id", "phone", "firstName", "lastName"],
//                         required: true,
//                     },
//                     {
//                         model: Game,
//                         attributes: ["id", "name"],
//                         required: false,
//                     },
//                 ],
//                 order: [["created_at", order]],
//             });

//             txns.push(
//                 ...redeems.rows.map((t) => ({
//                     ...t.toJSON(),
//                     txnType: "redeem",
//                 }))
//             );
//             totalCount += redeems.count;
//         }

//         // 💵 CASHOUTS
//         if (
//             (type === "cashout" || type === "all") &&
//             (!searchTypeFilter || searchTypeFilter === "cashout")
//         ) {
//             const cashoutCondition =
//                 search && !searchTypeFilter
//                     ? {
//                         [Op.or]: [
//                             { code: { [Op.like]: `%${search}%` } },
//                             { "$KioskUser.phone$": { [Op.like]: `%${search}%` } },
//                             { "$KioskUser.firstName$": { [Op.like]: `%${search}%` } },
//                             { "$KioskUser.lastName$": { [Op.like]: `%${search}%` } },
//                         ],
//                     }
//                     : {};

//             const cashouts = await KioskCashout.findAndCountAll({
//                 where: { ...cashoutCondition },
//                 include: [
//                     {
//                         model: KioskUser,
//                         attributes: ["id", "phone", "firstName", "lastName"],
//                         required: true,
//                         on: db.Sequelize.literal(
//                             "CONVERT(`KioskCashout`.`phone` USING utf8mb4) = CONVERT(`KioskUser`.`phone` USING utf8mb4)"
//                         ),
//                     },
//                 ],
//                 order: [["created_at", order]],
//             });

//             txns.push(
//                 ...cashouts.rows.map((t) => ({
//                     ...t.toJSON(),
//                     txnType: "cashout",
//                 }))
//             );
//             totalCount += cashouts.count;
//         }

//         // 🕒 Sort all by created_at
//         txns.sort((a, b) => {
//             if (order === "ASC") return new Date(a.created_at) - new Date(b.created_at);
//             return new Date(b.created_at) - new Date(a.created_at);
//         });

//         // 🧮 Manual pagination
//         const paginatedTxns = txns.slice(offset, offset + parseInt(limit));

//         return res.json({
//             txns: paginatedTxns,
//             totalCount,
//             totalPages: Math.ceil(totalCount / limit),
//             currentPage: parseInt(page),
//             type,
//             order,
//         });
//     } catch (error) {
//         if (error.name === "JsonWebTokenError" || error.name === "TokenExpiredError") {
//             return res.status(401).json({ error: "Token is invalid or has expired" });
//         }
//         console.error(error);
//         res.status(500).send("Internal server error");
//     }
// };
exports.getTransactionsByUser = async (req, res) => {
    try {
        const {
            phone,
            page = 1,
            limit = 10,
            search = "",
            type = "all",
            order = "DESC",
        } = req.body;

        if (!phone) {
            return res.status(400).json({ error: "Missing phone number" });
        }

        // 🔐 Verify admin token
        const authHeader =
            req.headers["authorization"] || req.headers["Authorization"];
        if (!authHeader)
            return res.status(401).send("Authorization header is missing");

        const token = authHeader.split(" ")[1];
        if (!token) return res.status(401).send("Token is missing");

        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        const adminId = decoded.id;

        const admin = await Admin.findOne({
            where: { id: adminId },
            attributes: { exclude: ["password", "otp"] },
        });
        if (!admin) return res.status(404).send("Admin not found");

        const offset = (parseInt(page) - 1) * parseInt(limit);
        let txns = [];
        let totalCount = 0;

        const searchLower = search.toLowerCase().trim();
        const txnTypeMap = {
            deposit: "1",
            redeem: "2",
            cashout: "cashout",
        };
        const searchTypeFilter = txnTypeMap[searchLower] || null;

        // 💰 DEPOSITS
        if (
            (type === "deposit" || type === "all") &&
            (!searchTypeFilter || searchTypeFilter === "1")
        ) {
            const depositCondition =
                search && !searchTypeFilter
                    ? {
                        phone,
                        [Op.or]: [
                            { gameuser: { [Op.like]: `%${search}%` } },
                            { "$Game.name$": { [Op.like]: `%${search}%` } },
                        ],
                    }
                    : { phone };

            const deposits = await KioskTxns.findAndCountAll({
                where: { type: "1", ...depositCondition },
                include: [
                    {
                        model: Game,
                        attributes: ["id", "name"],
                        required: false,
                    },
                ],
                order: [["created_at", order]],
            });

            txns.push(
                ...deposits.rows.map((t) => ({
                    ...t.toJSON(),
                    txnType: "deposit",
                }))
            );
            totalCount += deposits.count;
        }

        // 🎯 REDEEMS
        if (
            (type === "redeem" || type === "all") &&
            (!searchTypeFilter || searchTypeFilter === "2")
        ) {
            const redeemCondition =
                search && !searchTypeFilter
                    ? {
                        phone,
                        [Op.or]: [
                            { gameuser: { [Op.like]: `%${search}%` } },
                            { "$Game.name$": { [Op.like]: `%${search}%` } },
                        ],
                    }
                    : { phone };

            const redeems = await KioskTxns.findAndCountAll({
                where: { type: "2", ...redeemCondition },
                include: [
                    {
                        model: Game,
                        attributes: ["id", "name"],
                        required: false,
                    },
                ],
                order: [["created_at", order]],
            });

            txns.push(
                ...redeems.rows.map((t) => ({
                    ...t.toJSON(),
                    txnType: "redeem",
                }))
            );
            totalCount += redeems.count;
        }

        // 💵 CASHOUTS
        if (
            (type === "cashout" || type === "all") &&
            (!searchTypeFilter || searchTypeFilter === "cashout")
        ) {
            const cashoutCondition =
                search && !searchTypeFilter
                    ? {
                        phone,
                        [Op.or]: [{ code: { [Op.like]: `%${search}%` } }],
                    }
                    : { phone };

            const cashouts = await KioskCashout.findAndCountAll({
                where: cashoutCondition,
                order: [["created_at", order]],
            });

            txns.push(
                ...cashouts.rows.map((t) => ({
                    ...t.toJSON(),
                    txnType: "cashout",
                }))
            );
            totalCount += cashouts.count;
        }
        // if ((type === "cash" || type === "all") && (!searchTypeFilter || searchTypeFilter === "cash")) {
        //     const stackingCondition =
        //         search && !searchTypeFilter
        //             ? {
        //                 phone,
        //                 [Op.or]: [
        //                     // { note: { [Op.like]: `%${search}%` } },
        //                     // { denomination: { [Op.like]: `%${search}%` } },

        //                     { "$KioskUser.phone$": { [Op.like]: `%${search}%` } },
        //                     { "$KioskUser.firstName$": { [Op.like]: `%${search}%` } },
        //                     { "$KioskUser.lastName$": { [Op.like]: `%${search}%` } },
        //                 ],
        //             }
        //             : { phone };

        //     const stackingNotes = await StackingNoteLog.findAndCountAll({
        //         where: { ...stackingCondition },
        //         include: [
        //             {
        //                 model: KioskUser,
        //                 attributes: ["id", "phone", "firstName", "lastName"],
        //                 required: true,
        //                 on: db.Sequelize.literal(
        //                     "CONVERT(`StackingNoteLog`.`phone` USING utf8mb4) = CONVERT(`KioskUser`.`phone` USING utf8mb4)"
        //                 ),
        //             },
        //         ],
        //         order: [["created_at", order]],
        //     });

        //     txns.push(
        //         ...stackingNotes.rows.map((t) => {
        //             const data = t.toJSON();
        //             return {
        //                 ...data,
        //                 amount: parseInt(data.denomination), // 👈 Rename denomination → amount
        //                 txnType: "cash",
        //             };
        //         })
        //     );

        //     totalCount += stackingNotes.count;
        // }
        // 🕒 Sort by created_at
        txns.sort((a, b) => {
            if (order === "ASC")
                return new Date(a.created_at) - new Date(b.created_at);
            return new Date(b.created_at) - new Date(a.created_at);
        });

        // 🧮 Manual pagination
        const paginatedTxns = txns.slice(offset, offset + parseInt(limit));

        return res.json({
            phone,
            txns: paginatedTxns,
            totalCount,
            totalPages: Math.ceil(totalCount / limit),
            currentPage: parseInt(page),
            type,
            order,
        });
    } catch (error) {
        if (error.name === "JsonWebTokenError" || error.name === "TokenExpiredError") {
            return res.status(401).json({ error: "Token is invalid or has expired" });
        }
        console.error(error);
        res.status(500).send("Internal server error");
    }
};
exports.getTransaction = async (req, res) => {
    try {
        const { id, type } = req.body;

        if (!id || !type) {
            return res.status(400).json({
                status: "error",
                message: "Both id and type are required",
            });
        }

        const allowedTypes = ["deposit", "redeem", "cashout", "cash"];
        if (!allowedTypes.includes(type)) {
            return res.status(400).json({
                status: "error",
                message: "Invalid type. Allowed: deposit, redeem, cashout, cash",
            });
        }

        let txn = null;

        // -------------------------------
        // 1️⃣ DEPOSIT
        // -------------------------------
        // if (type === "deposit") {
        //     txn = await KioskTxns.findOne({
        //         where: { id, type: "1" },
        //         include: [
        //             { model: KioskUser, attributes: ["id", "phone", "firstName", "lastName"] },
        //             { model: Game, attributes: ["id", "name"] },
        //             { model: ApiLogs, attributes: ["id", "name", "request", "response", "method"] },

        //         ],
        //     });

        //     if (!txn)
        //         return res.status(404).json({ message: "Deposit transaction not found" });

        //     return res.json({
        //         ...txn.toJSON(),
        //         txnType: "deposit",
        //     });
        // }
        if (type === "deposit") {
            txn = await KioskTxns.findOne({
                where: { id, type: "1" },
                include: [
                    { model: KioskUser, attributes: ["id", "phone", "firstName", "lastName"] },
                    { model: Game, attributes: ["id", "name"] },
                    {
                        model: ApiLogs,
                        required: false,
                        where: {
                            txn_id: id,
                            name: {
                                [Op.like]: "%deposit%",
                            },
                        },
                        attributes: ["id", "name", "request", "response", "method"],
                    },
                ],
            });

            if (!txn)
                return res.status(404).json({ message: "Deposit transaction not found" });

            return res.json({
                ...txn.toJSON(),
                txnType: "deposit",
            });
        }
        // -------------------------------
        // 2️⃣ REDEEM
        // -------------------------------
        // if (type === "redeem") {
        //     txn = await KioskTxns.findOne({
        //         where: { id, type: "2" },
        //         include: [
        //             { model: KioskUser, attributes: ["id", "phone", "firstName", "lastName"] },
        //             { model: ApiLogs, attributes: ["id", "name", "request", "response", "method"] },
        //             { model: Game, attributes: ["id", "name"] },
        //         ],
        //     });

        //     if (!txn)
        //         return res.status(404).json({ message: "Redeem transaction not found" });

        //     return res.json({
        //         ...txn.toJSON(),
        //         txnType: "redeem",
        //     });
        // }
        if (type === "redeem") {
            txn = await KioskTxns.findOne({
                where: { id, type: "2" },
                include: [
                    { model: KioskUser, attributes: ["id", "phone", "firstName", "lastName"] },
                    { model: Game, attributes: ["id", "name"] },
                    {
                        model: ApiLogs,
                        required: false,
                        where: {
                            txn_id: id,
                            name: {
                                [Op.like]: "%redeem%",
                            },
                        },
                        attributes: ["id", "name", "request", "response", "method"],
                    },
                ],
            });

            if (!txn)
                return res.status(404).json({ message: "Redeem transaction not found" });

            return res.json({
                ...txn.toJSON(),
                txnType: "redeem",
            });
        }
        // -------------------------------
        // 3️⃣ CASHOUT (with cassette breakdown)
        // -------------------------------
        // if (type === "cashout") {
        //     txn = await KioskCashout.findOne({
        //         where: { id },
        //         include: [
        //             {
        //                 model: KioskUser,
        //                 attributes: ["id", "phone", "firstName", "lastName"],
        //             },
        //             {
        //                 model: Kiosks,
        //                 as: "Kiosk",
        //                 attributes: ["id", "kiosk_alias", "kiosk_name"],
        //             },
        //             { model: ApiLogs, attributes: ["id", "name", "request", "response", "method"] },

        //         ],
        //     });

        //     if (!txn)
        //         return res.status(404).json({ message: "Cashout record not found" });

        //     const data = txn.toJSON();

        //     // Combination breakdown
        //     const combination = data.combination ? JSON.parse(data.combination) : null;
        //     let cassetteBreakdown = [];

        //     if (combination && data.Kiosk?.id) {
        //         const cassettes = await F53Cassettes.findAll({
        //             where: { kiosk_id: data.Kiosk.id },
        //         });

        //         const cassetteMap = {};
        //         cassettes.forEach(c => (cassetteMap[c.cassett_id] = c.value));

        //         cassetteBreakdown = Object.entries(combination).map(
        //             ([cassetteId, qty]) => ({
        //                 cassette_id: Number(cassetteId),
        //                 denomination: cassetteMap[cassetteId] || 0,
        //                 quantity: qty,
        //                 label: `$${cassetteMap[cassetteId] || 0} × ${qty}`,
        //             })
        //         );

        //         cassetteBreakdown.sort((a, b) => b.denomination - a.denomination);
        //     }

        //     return res.json({
        //         ...data,
        //         cassetteBreakdown,
        //         txnType: "cashout",
        //     });
        // }
        if (type === "cashout") {
            txn = await KioskCashout.findOne({
                where: { id },
                include: [
                    {
                        model: KioskUser,
                        attributes: ["id", "phone", "firstName", "lastName"],
                    },
                    {
                        model: Kiosks,
                        as: "Kiosk",
                        attributes: ["id", "kiosk_alias", "kiosk_name"],
                    },
                    {
                        model: ApiLogs,
                        required: false,
                        where: {
                            txn_id: id,
                            name: {
                                [Op.like]: "%cashout%",
                            },
                        },
                        attributes: ["id", "name", "request", "response", "method", "created_at"],
                    },
                ],
            });

            if (!txn) {
                return res.status(404).json({
                    status: "error",
                    message: "Cashout record not found",
                });
            }

            const data = txn.toJSON();

            /* ===============================
               API LOG FORMATTING (UI SAFE)
            =============================== */
            const apiLogs = (data.ApiLogs || []).map(log => {
                let request = null;
                let response = null;

                try { request = JSON.parse(log.request); } catch (_) { }
                try { response = JSON.parse(log.response); } catch (_) { }

                return {
                    id: log.id,
                    endpoint: log.name,
                    method: log.method,
                    request,
                    response,
                    created_at: log.created_at,
                };
            });

            /* ===============================
               CASSETTE BREAKDOWN
            =============================== */
            let cassetteBreakdown = [];
            let totalDispensed = 0;

            let combination = null;
            try {
                combination = data.combination ? JSON.parse(data.combination) : null;
            } catch (_) { }

            if (combination && data.Kiosk?.id) {
                const cassettes = await F53Cassettes.findAll({
                    where: { kiosk_id: data.Kiosk.id },
                });

                const cassetteMap = {};
                cassettes.forEach(c => {
                    cassetteMap[c.cassett_id] = Number(c.value) || 0;
                });

                cassetteBreakdown = Object.entries(combination)
                    .map(([cassetteId, qty]) => {
                        const denomination = cassetteMap[cassetteId] || 0;
                        const quantity = Number(qty) || 0;
                        const subtotal = denomination * quantity;

                        totalDispensed += subtotal;

                        return {
                            cassette_id: Number(cassetteId),
                            denomination,
                            quantity,
                            subtotal,
                            label: `$${denomination} × ${quantity}`,
                        };
                    })
                    .filter(i => i.quantity > 0 && i.denomination > 0)
                    .sort((a, b) => b.denomination - a.denomination);
            }

            return res.json({
                ...data,
                apiLogs,
                cassetteBreakdown,
                totalDispensed,
                txnType: "cashout",
            });
        }
        // -------------------------------
        // 4️⃣ CASH (stacking notes)
        // -------------------------------
        if (type === "cash") {
            txn = await StackingNoteLog.findOne({
                where: { id },
                include: [
                    { model: KioskUser, attributes: ["id", "phone", "firstName", "lastName"] },
                    {
                        model: ApiLogs,
                        required: false,
                        where: {
                            txn_id: id,
                            name: {
                                [Op.like]: "%cash%",
                            },
                        },
                        attributes: ["id", "name", "request", "response", "method"],
                    },
                ],
            });

            if (!txn)
                return res.status(404).json({ message: "Stacking note not found" });

            const data = txn.toJSON();

            return res.json({
                ...data,
                amount: parseInt(data.denomination),
                txnType: "cash",
            });
        }

    } catch (error) {
        console.error("getTransaction error:", error);
        return res.status(500).json({ message: "Internal server error" });
    }
};

exports.requestCreation = async (req, res) => {
    try {
        const { game, phone, kioskName } = req.body;
        if (!kioskName || kioskName.trim() === "") {
            return res.json({ status: "error", message: "Kiosk name is required" });
        }

        const nameTrimmed = kioskName.trim();
        const nameLower = nameTrimmed.toLowerCase();

        // case-insensitive lookup using LOWER(column) = lower(input)
        const kiosk = await Kiosks.findOne({
            where: db.where(db.fn('LOWER', db.col('kiosk_name')), nameLower)
        });
        if (!kiosk) {
            return res.json({ status: 'error', message: 'Kiosk not found' })
        }
        const creation = await KioskCreation.findOne({ where: { phone: phone, gameid: game?.id } })
        if (creation) {
            return res.json({ status: 'error', message: 'Account already exists' })
        }
        const newCreation = await KioskCreation.create({
            phone: phone,
            gameid: game?.id,
            status: '0',
            kioskid: kiosk?.id
        })
        if (newCreation) {
            res.json({ status: 'success', message: 'Creation requested' })
        }
    } catch (error) {
        return res.json({ status: 'error', message: 'Unable to request' })
    }
}

exports.approveCreation = async (req, res) => {
    try {
        const { id, username, password, kioskId } = req.body;
        console.log(req.body)
        if (!id || !username || !password || !kioskId) {
            return res.json({ status: 'error', message: 'Data required' })
        }
        const authHeader = req.headers['authorization'] || req.headers['Authorization'];
        if (!authHeader) return res.status(401).send('Authorization header is missing');

        const token = authHeader.split(' ')[1];
        if (!token) return res.status(401).send('Token is missing');


        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        const adminId = decoded.id;


        const admin = await Admin.findOne({
            where: { id: adminId },
            attributes: { exclude: ['password', 'otp'] }
        });
        if (!admin) return res.status(404).send('Admin not found');

        const creation = await KioskCreation.findOne({ where: { id: id } })
        if (!creation) return res.status(404).send('Creation not found');

        creation.gameuser = username
        creation.gamepass = password
        // creation.kioskid = kioskId
        creation.status = '1'
        await creation.save();
        res.json({ status: 'success', message: 'Creation approved' })

    } catch (error) {
        if (error.name === "JsonWebTokenError" || error.name === "TokenExpiredError") {
            return res.status(401).json({ error: "Token is invalid or has expired" });
        }
        console.error(error);
        res.status(500).send("Internal server error");
    }
}
exports.rejectCreation = async (req, res) => {
    try {
        const { id, gameuser, gamepass } = req.body;
        if (!id || !gameuser || !gamepass) {
            return res.json({ status: 'error', message: 'Data required' })
        }
        const authHeader = req.headers['authorization'] || req.headers['Authorization'];
        if (!authHeader) return res.status(401).send('Authorization header is missing');

        const token = authHeader.split(' ')[1];
        if (!token) return res.status(401).send('Token is missing');


        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        const adminId = decoded.id;


        const admin = await Admin.findOne({
            where: { id: adminId },
            attributes: { exclude: ['password', 'otp'] }
        });
        if (!admin) return res.status(404).send('Admin not found');

        const creation = await KioskCreation.findOne({ where: { id: id } })
        if (!creation) return res.status(404).send('Creation not found');

        // creation.gameuser = gameuser
        // creation.gamepass = gamepass
        creation.status = '2'
        await creation.save();
        res.json({ status: 'success', message: 'Creation rejected' })

    } catch (error) {
        if (error.name === "JsonWebTokenError" || error.name === "TokenExpiredError") {
            return res.status(401).json({ error: "Token is invalid or has expired" });
        }
        console.error(error);
        res.status(500).send("Internal server error");
    }
}

exports.requestDeposit = async (req, res) => {
    try {
        const { phone, game, gameuser, amount, kioskName, balance_used = '0' } = req.body;
        if (!kioskName || kioskName.trim() === "") {
            return res.json({ status: "error", message: "Kiosk name is required" });
        }

        const nameTrimmed = kioskName.trim();
        const nameLower = nameTrimmed.toLowerCase();

        // case-insensitive lookup using LOWER(column) = lower(input)
        const kiosk = await Kiosks.findOne({
            where: db.where(db.fn('LOWER', db.col('kiosk_name')), nameLower)
        });
        if (!kiosk) {
            return res.json({ status: 'error', message: 'Kiosk not found' })
        }

        const newDeposit = await KioskTxns.create({
            phone: phone,
            gameid: game?.id,
            gameuser: gameuser,
            status: '0',
            type: '1',
            amount: amount,
            kiosk_id: kiosk?.id,
            balance_used: balance_used
        })
        if (newDeposit) {
            res.json({ id: newDeposit?.id, status: 'success', message: 'Deposit requested' })
        }
    } catch (error) {
        return res.json({ status: 'error', message: 'Unable to request deposit' })
    }
}
exports.approveDeposit = async (req, res) => {
    try {
        const { id } = req.body;
        if (!id) {
            return res.json({ status: 'error', message: 'ID is missing' })
        }
        const authHeader = req.headers['authorization'] || req.headers['Authorization'];
        if (!authHeader) return res.status(401).send('Authorization header is missing');

        const token = authHeader.split(' ')[1];
        if (!token) return res.status(401).send('Token is missing');
        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        const adminId = decoded.id;
        const admin = await Admin.findOne({
            where: { id: adminId },
            attributes: { exclude: ['password', 'otp'] }
        });
        if (!admin) return res.status(404).send('Admin not found');

        const txn = await KioskTxns.findOne(
            {
                where: { id: id },
                include: {
                    model: KioskUser,
                    attributes: ['id', 'phone', 'firstName', 'lastName', 'balance']
                }
            }
        )
        if (!txn) {
            return res.json({ status: 'error', message: 'Txn not found' })
        }

        if (txn.balance_used == '1') {
            await txn.KioskUser.decrement('balance', txn.amount);
            await txn.KioskUser.save();

        }
        txn.status = '1';
        await txn.save();
        res.json({ status: 'success', message: 'Deposit approved' })

    } catch (error) {
        if (error.name === "JsonWebTokenError" || error.name === "TokenExpiredError") {
            return res.status(401).json({ error: "Token is invalid or has expired" });
        }
        console.error(error);
        res.status(500).send("Internal server error");
    }
}
exports.rejectDeposit = async (req, res) => {
    try {
        const { id } = req.body;
        if (!id) {
            return res.json({ status: 'error', message: 'ID is missing' })
        }
        const authHeader = req.headers['authorization'] || req.headers['Authorization'];
        if (!authHeader) return res.status(401).send('Authorization header is missing');

        const token = authHeader.split(' ')[1];
        if (!token) return res.status(401).send('Token is missing');
        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        const adminId = decoded.id;
        const admin = await Admin.findOne({
            where: { id: adminId },
            attributes: { exclude: ['password', 'otp'] }
        });
        if (!admin) return res.status(404).send('Admin not found');

        const txn = await KioskTxns.findOne(
            {
                where: { id: id },
                include: {
                    model: KioskUser,
                    attributes: ['id', 'phone', 'firstName', 'lastName', 'balance']
                }
            }
        )
        if (!txn) {
            return res.json({ status: 'error', message: 'Txn not found' })
        }

        txn.KioskUser.balance = parseFloat(txn.KioskUser.balance) + parseFloat(txn.amount);
        txn.status = '2';
        await txn.KioskUser.save();
        await txn.save();
        res.json({ status: 'success', message: 'Deposit rejected' })

    } catch (error) {
        if (error.name === "JsonWebTokenError" || error.name === "TokenExpiredError") {
            return res.status(401).json({ error: "Token is invalid or has expired" });
        }
        console.error(error);
        res.status(500).send("Internal server error");
    }
}

exports.requestRedeem = async (req, res) => {
    try {
        const { phone, game, gameuser, amount, kioskName } = req.body;
        if (!kioskName || kioskName.trim() === "") {
            return res.json({ status: "error", message: "Kiosk name is required" });
        }

        const nameTrimmed = kioskName.trim();
        const nameLower = nameTrimmed.toLowerCase();

        // case-insensitive lookup using LOWER(column) = lower(input)
        const kiosk = await Kiosks.findOne({
            where: db.where(db.fn('LOWER', db.col('kiosk_name')), nameLower)
        });
        if (!kiosk) {
            return res.json({ status: 'error', message: 'Kiosk not found' })
        }

        const newDeposit = await KioskTxns.create({
            phone: phone,
            gameid: game?.id,
            gameuser: gameuser,
            status: '0',
            type: '2',
            amount: amount,
            kiosk_id: kiosk?.id,
        })
        if (newDeposit) {
            res.json({ status: 'success', message: 'Redeem requested' })
        }
    } catch (error) {
        return res.json({ status: 'error', message: 'Unable to request redeem' })
    }
}

exports.approveRedeem = async (req, res) => {
    try {
        const { id } = req.body;
        if (!id) {
            return res.json({ status: 'error', message: 'ID is missing' })
        }
        const authHeader = req.headers['authorization'] || req.headers['Authorization'];
        if (!authHeader) return res.status(401).send('Authorization header is missing');

        const token = authHeader.split(' ')[1];
        if (!token) return res.status(401).send('Token is missing');
        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        const adminId = decoded.id;
        const admin = await Admin.findOne({
            where: { id: adminId },
            attributes: { exclude: ['password', 'otp'] }
        });
        if (!admin) return res.status(404).send('Admin not found');

        const txn = await KioskTxns.findOne(
            {
                where: { id: id },
                include: {
                    model: KioskUser,
                    attributes: ['id', 'phone', 'firstName', 'lastName', 'balance']
                }
            }
        )
        if (!txn) {
            return res.json({ status: 'error', message: 'Txn not found' })
        }

        txn.KioskUser.balance = parseFloat(txn.KioskUser.balance) + parseFloat(txn.amount);
        txn.status = '1';
        await txn.KioskUser.save();
        await txn.save();
        res.json({ status: 'success', message: 'Redeem approved' })

    } catch (error) {
        if (error.name === "JsonWebTokenError" || error.name === "TokenExpiredError") {
            return res.status(401).json({ error: "Token is invalid or has expired" });
        }
        console.error(error);
        res.status(500).send("Internal server error");
    }
}
exports.rejectRedeem = async (req, res) => {
    try {
        const { id } = req.body;
        if (!id) {
            return res.json({ status: 'error', message: 'ID is missing' })
        }
        const authHeader = req.headers['authorization'] || req.headers['Authorization'];
        if (!authHeader) return res.status(401).send('Authorization header is missing');

        const token = authHeader.split(' ')[1];
        if (!token) return res.status(401).send('Token is missing');
        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        const adminId = decoded.id;
        const admin = await Admin.findOne({
            where: { id: adminId },
            attributes: { exclude: ['password', 'otp'] }
        });
        if (!admin) return res.status(404).send('Admin not found');

        const txn = await KioskTxns.findOne(
            {
                where: { id: id },
                include: {
                    model: KioskUser,
                    attributes: ['id', 'phone', 'firstName', 'lastName', 'balance']
                }
            }
        )
        if (!txn) {
            return res.json({ status: 'error', message: 'Txn not found' })
        }


        txn.status = '2';
        await txn.save();
        res.json({ status: 'success', message: 'Redeem rejected' })

    } catch (error) {
        if (error.name === "JsonWebTokenError" || error.name === "TokenExpiredError") {
            return res.status(401).json({ error: "Token is invalid or has expired" });
        }
        console.error(error);
        res.status(500).send("Internal server error");
    }
}
exports.remakeCreation = async (req, res) => {
    try {
        const { game, phone } = req.body;

        if (!game || !game.id || !phone) {
            return res
                .status(400)
                .json({ status: "error", message: "Missing game or phone" });
        }

        const gameId = game.id;
        console.log(`♻️ Remaking creation for phone: ${phone}, gameId: ${gameId}`);

        // 1️⃣ Delete old records
        const deleted = await KioskCreation.destroy({
            where: { phone, gameid: gameId },
        });

        console.log(`🗑️ Deleted ${deleted} existing KioskCreation record(s)`);

        // 2️⃣ Prepare mock req/res objects to call creation directly
        const reqx = {
            body: { game, phone },
            headers: req.headers, // pass headers if needed
        };

        const resultPromise = new Promise((resolve) => {
            const resx = {
                status: (code) => ({
                    json: (data) => {
                        resolve({ code, data }); // capture result from creation()
                    },
                }),
            };

            // 👇 call creation function directly
            exports.creation(reqx, resx);
        });

        // 3️⃣ Wait for the result
        const { code, data } = await resultPromise;

        // 4️⃣ Forward the result properly
        return res.status(code).json({
            ...data,
            deletedRecords: deleted,
        });
    } catch (error) {
        console.error("❌ remakeCreation failed:", error);
        return res.status(500).json({
            status: "error",
            message: error.message || "Internal server error",
        });
    }
};
exports.resendCredentials = async (req, res) => {
    try {

    } catch (error) {
        return res.json({ status: 'error', message: error?.message })
    }
}
exports.receiptQR = async (req, res) => {
    try {
        const login_id = crypto.randomBytes(12).toString('hex');

        // const payload = {
        //     login_id,
        //     purpose: 'receipt_qr',
        // };

        // const token = jwt.sign(payload, JWT_SECRET);
        const url = 'http://localhost:85/api/receipt?id=123456';
        const qrDataUrl = await QRCode.toDataURL(url);


        res.json({
            ok: true,
            qrDataUrl,
        });
    } catch (err) {
        console.error('receiptQR error:', err);
        res.status(500).json({ ok: false, error: 'internal_error' });
    }
};
const RECEIPT_FILE = path.join(__dirname, '../data/receipts.json');

// Utility to read/write receipts
const readReceipts = () => JSON.parse(fs.readFileSync(RECEIPT_FILE, 'utf8') || '{}');
const writeReceipts = (data) => fs.writeFileSync(RECEIPT_FILE, JSON.stringify(data, null, 2));

exports.generateReceipt = async (req, res) => {
    try {
        const {
            storeName = 'SweepStake Mobi - Kiosk',
            storeAddress = 'El Paso, TX 79912, USA',

            items = [],
            total = 0,
            taxes = 0,
            cardType = 'Cash',
            receiptId,
            receiptType = 'Deposit'
        } = req.body;

        if (!receiptId) {
            return res.status(400).json({ status: 'error', message: 'Missing receiptId' });
        }

        // const receiptUrl = `${req.protocol}://${req.get('host')}/api/kiosk/receipt/${receiptId}`;
        const receiptUrl = `https://sweepstake.mobi/kiosk_receipts.php?id=${receiptId}`;
        const qr = await QRCode.toDataURL(receiptUrl, { margin: 1, scale: 6 });

        // Store data
        const receipts = readReceipts();
        const payload = {
            receiptId,
            receiptType,
            storeName,
            storeAddress,
            items: JSON.stringify(items),
            total,
            taxes,
            cardType,
            qr,
            date: new Date().toISOString(),
            url: receiptUrl
        }
        receipts[receiptId] = payload;
        await KioskReceipts.create(payload)
        writeReceipts(receipts);

        res.json({
            status: 'success',
            message: 'Receipt generated',
            qr,
            receiptUrl
        });
    } catch (err) {
        console.error('❌ Error:', err);
        res.status(500).json({ status: 'error', message: 'Server error' });
    }
}
exports.receipt = async (req, res) => {
    try {
        const { id } = req.params;
        // const receipts = readReceipts();
        // const receipt = receipts[id];
        const receipt = await KioskReceipts.findOne({ where: { receiptId: id } })
        if (!receipt) {
            return res.status(404).send('<h1>Receipt not found</h1>');
        }

        const { storeName, storeAddress, items, total, taxes, qr, date, cardType, receiptId, receiptType } = receipt;

        const formattedDate = new Date(date).toLocaleString();
        const subTotal = parseFloat(total).toFixed(2);
        const nonce = Math.random().toString(36).substring(2, 12);
        const itemz = JSON.parse(items)
        const type = receiptType == 'Game Redeem' ? 'To' : 'Using'
        const html = `
<!DOCTYPE html>
<html>
<head>
  <meta http-equiv="Content-Security-Policy" content="script-src 'self' 'nonce-${nonce}';" />
  <title>${storeName} Receipt</title>
  <style>
    body { font-family: monospace; background: #fff; color: #000; display: flex; justify-content: center; padding: 20px; }
    .receipt { width: 340px; border: 1px solid #ccc; padding: 16px; }
    h2 { text-align: center; margin-bottom: 0; }
    p, span { font-size: 14px; }
    .center { text-align: center; }
    .item-row { display: flex; justify-content: space-between; margin: 2px 0; }
    .bold { font-weight: bold; }
    .qr { text-align: center; margin-top: 12px; }
    .btn-print { display: block; width: 100%; margin-top: 10px; padding: 8px; background: #007bff; color: #fff; border: none; border-radius: 5px; cursor: pointer; }
    .btn-print:hover { background: #0056b3; }
    hr { border: none; border-top: 1px dashed #aaa; margin: 8px 0; }
  </style>
</head>
<body>
  <div class="receipt">
    <h2>${storeName}</h2>
    <p class="center">${storeAddress}</p>
    <p class="center">${formattedDate}</p>
    <p class="center">TRX #${receiptId}</p>
    <p class="center">${receiptType} Receipt</p>

    <hr/>
    ${itemz.map(i => `
      <div class="item-row">
        <span>${i.name}</span>
        <span>$${parseFloat(i.price).toFixed(2)}</span>
      </div>
    `).join('')}
    <hr/>
    <div class="item-row"><span>Sub Total</span><span>$${subTotal}</span></div>
    <div class="item-row bold"><span>Total</span><span>$${parseFloat(total).toFixed(2)}</span></div>
    <hr/>
    
    <p>Total: $${parseFloat(total).toFixed(2)}</p>
    <p>${receiptType} ${type}: ${cardType}</p>
    <hr/>
    <div class="qr">
      <p>Scan for online receipt</p>
      <img src="${qr}" width="150" />
      <button id="printBtn" class="btn-print">Print Receipt</button>
    </div>
  </div>

  <script nonce="${nonce}">
    document.getElementById('printBtn').addEventListener('click', () => {
      window.print();
    });
  </script>
</body>
</html>
`;
        // <p class="center bold">APPROVED</p>
        //     <div class="qr">
        //   <p>Scan for online receipt</p>
        //   <img src="${qr}" width="150" />
        //   <button class="btn-print" onclick="window.print()">Print Receipt</button>
        // </div>
        res.send(html);
    } catch (err) {
        console.error(err);
        res.status(500).send('Internal Server Error');
    }
}
exports.verifyUser = async (req, res) => {
    try {
        const { id } = req.body;
        if (!id) {
            return res.json({ status: 'error', message: 'ID is missing' })
        }
        const authHeader = req.headers['authorization'] || req.headers['Authorization'];
        if (!authHeader) return res.status(401).send('Authorization header is missing');

        const token = authHeader.split(' ')[1];
        if (!token) return res.status(401).send('Token is missing');
        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        const adminId = decoded.id;
        const admin = await Admin.findOne({
            where: { id: adminId },
            attributes: { exclude: ['password', 'otp'] }
        });
        if (!admin) return res.status(404).send('Admin not found');
        const user = await KioskUser.findOne({ where: { id: id } });
        if (!user) {
            return res.json({ status: 'error', message: 'User not found' })
        }
        user.idenfy_verified = '1';
        await user.save();
        res.json({ status: 'success', message: 'User verified' });
    } catch (error) {
        if (error.name === "JsonWebTokenError" || error.name === "TokenExpiredError") {
            return res.status(401).json({ error: "Token is invalid or has expired" });
        }
        console.error(error);
        res.status(500).send("Internal server error");
    }
}
exports.banVerify = async (req, res) => {
    try {
        const { id } = req.body;

        if (!id) {
            return res.json({ status: 'error', message: 'ID is missing' });
        }

        const authHeader = req.headers['authorization'] || req.headers['Authorization'];
        if (!authHeader) {
            return res.status(401).send('Authorization header is missing');
        }

        const token = authHeader.split(' ')[1];
        if (!token) {
            return res.status(401).send('Token is missing');
        }

        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        const adminId = decoded.id;

        const admin = await Admin.findOne({
            where: { id: adminId },
            attributes: { exclude: ['password', 'otp'] }
        });

        if (!admin) {
            return res.status(404).send('Admin not found');
        }

        const user = await KioskUser.findOne({ where: { id } });
        if (!user) {
            return res.json({ status: 'error', message: 'User not found' });
        }

        user.ban = 1;
        await user.save();

        return res.json({
            status: 'success',
            message: 'User banned successfully'
        });

    } catch (error) {
        if (
            error.name === "JsonWebTokenError" ||
            error.name === "TokenExpiredError"
        ) {
            return res.status(401).json({
                status: 'error',
                message: 'Token is invalid or has expired'
            });
        }

        console.error(error);
        return res.status(500).send('Internal server error');
    }
};
exports.unbanUser = async (req, res) => {
    try {
        const { id } = req.body;

        if (!id) {
            return res.json({ status: 'error', message: 'ID is missing' });
        }

        const authHeader = req.headers['authorization'] || req.headers['Authorization'];
        if (!authHeader) {
            return res.status(401).send('Authorization header is missing');
        }

        const token = authHeader.split(' ')[1];
        if (!token) {
            return res.status(401).send('Token is missing');
        }

        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        const adminId = decoded.id;

        const admin = await Admin.findOne({
            where: { id: adminId },
            attributes: { exclude: ['password', 'otp'] }
        });

        if (!admin) {
            return res.status(404).send('Admin not found');
        }

        const user = await KioskUser.findOne({ where: { id } });
        if (!user) {
            return res.json({ status: 'error', message: 'User not found' });
        }

        user.ban = 0;
        await user.save();

        return res.json({
            status: 'success',
            message: 'User unbanned successfully'
        });

    } catch (error) {
        if (
            error.name === "JsonWebTokenError" ||
            error.name === "TokenExpiredError"
        ) {
            return res.status(401).json({
                status: 'error',
                message: 'Token is invalid or has expired'
            });
        }

        console.error(error);
        return res.status(500).send('Internal server error');
    }
};
exports.addBalance = async (req, res) => {
    try {
        const { id, amount } = req.body;
        if (!id || !amount || amount <= 0) {
            return res.json({ status: 'error', message: 'Invalid input' });
        }

        const user = await KioskUser.findByPk(id);
        if (!user) {
            return res.json({ status: 'error', message: 'User not found' });
        }

        user.balance = Number(user.balance) + Number(amount);
        await user.save();

        return res.json({
            status: 'success',
            message: 'Balance added successfully'
        });
    } catch (err) {
        console.error(err);
        res.status(500).send('Internal server error');
    }
};

exports.deductBalance = async (req, res) => {
    try {
        const { id, amount } = req.body;
        if (!id || !amount || amount <= 0) {
            return res.json({ status: 'error', message: 'Invalid input' });
        }

        const user = await KioskUser.findByPk(id);
        if (!user) {
            return res.json({ status: 'error', message: 'User not found' });
        }

        if (Number(user.balance) < Number(amount)) {
            return res.json({
                status: 'error',
                message: 'Insufficient balance'
            });
        }

        user.balance = Number(user.balance) - Number(amount);
        await user.save();

        return res.json({
            status: 'success',
            message: 'Balance deducted successfully'
        });
    } catch (err) {
        console.error(err);
        res.status(500).send('Internal server error');
    }
};