const { DataTypes } = require('sequelize');
const bcrypt = require('bcryptjs');
const db = require('../config/db.config');
const StackingNoteLog = db.define('StackingNoteLog', {
    id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
    },
    kiosk_name: {
        type: DataTypes.STRING,
        allowNull: true
    },
    phone: {
        type: DataTypes.STRING,
        allowNull: true
    },
    denomination: {
        type: DataTypes.STRING,
        allowNull: true
    },
    note_count: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    status: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    createdAt: {                           // 👈 map attribute to snake_case column
        type: DataTypes.DATE,
        field: 'created_at'
    },
    updatedAt: {                           // 👈 map attribute to snake_case column
        type: DataTypes.DATE,
        field: 'updated_at'
    }
}, {
    tableName: 'StackingNoteLog',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at'
});



module.exports = StackingNoteLog;