const express = require('express');
const router = express.Router();
const multer = require('multer');


const rateLimit = require('express-rate-limit');
const upload = multer();

const kiosk = require('../controllers/Kiosk');
const mobile = require('../controllers/App');
const ipLock = require('../middleware/ipLockMiddleware');
const ipLockWare = ipLock.ipLockMiddleware;

const apiLogger = require('../middleware/apiLogger');

//mobile
router.post('/mobile/login', mobile.login);
router.post('/mobile/resendLoginOTP', mobile.resendLoginOTP);
router.post('/mobile/verifyLoginOTP', mobile.verifyLoginOTP);
router.get('/mobile/getUser', mobile.getUser);
router.post('/mobile/getDeposits', mobile.getDeposits);
router.post('/mobile/getRedeems', mobile.getRedeems);
router.post('/mobile/getCashouts', mobile.getCashouts);
router.post('/mobile/getTransactions', mobile.getTransactions);
router.post('/mobile/getTransactionsByUser', mobile.getTransactionsByUser);
router.post('/mobile/viewUser', mobile.viewUser);
router.post('/mobile/getTransaction', mobile.getTransaction);

router.post('/mobile/deposit', mobile.deposit);
router.post('/mobile/redeem', mobile.redeem);
router.post('/mobile/creation', mobile.creation);
router.post('/mobile/banVerify', mobile.banVerify);
router.post('/mobile/unbanUser', mobile.unbanUser);
router.post('/mobile/addBalance', mobile.addBalance);
router.post('/mobile/deductBalance', mobile.deductBalance);
router.post('/mobile/verifyUser', mobile.verifyUser);


router.post('/mobile/approveDeposit', mobile.approveDeposit);
router.post('/mobile/rejectDeposit', mobile.rejectDeposit);
router.post('/mobile/approveRedeem', mobile.approveRedeem);
router.post('/mobile/rejectRedeem', mobile.rejectRedeem);
router.post('/mobile/approveCreation', mobile.approveCreation);
router.post('/mobile/rejectCreation', mobile.rejectCreation);
router.post('/mobile/rejectCreation', mobile.rejectCreation);
router.post('/mobile/getCreationsByGame', mobile.getCreationsByGame);
router.post('/mobile/getPendingCreationsByGame', mobile.getPendingCreationsByGame);
router.post('/mobile/getAutoGameLists', mobile.getAutoGameLists);

router.get('/mobile/getKioskStatus', mobile.getKioskStatus);
router.get('/mobile/getDashboardData', mobile.getDashboardData);

router.get('/mobile/getTodayDeposits', mobile.getTodayDeposits);
router.get('/mobile/getDayWiseDeposits', mobile.getDayWiseDeposits);

router.get('/mobile/getTodayCashouts', mobile.getTodayCashouts);
router.get('/mobile/getDayWiseCashouts', mobile.getDayWiseCashouts);
router.post('/mobile/getUsers', mobile.getUsers);
router.get('/mobile/getF53Cassettes', mobile.getF53Cassettes);
router.post('/mobile/setF53Cassettes', mobile.setF53Cassettes);

router.get('/mobile/getKioskNotes', mobile.getKioskNotes);
router.post('/mobile/setKioskNotes', mobile.setKioskNotes);
router.post('/mobile/resetKioskNotes', mobile.resetKioskNotes);
router.get('/mobile/getKiosks', mobile.getKiosks);
router.post('/mobile/setKiosk', mobile.setKiosk);
router.post('/mobile/renameKiosk', mobile.renameKiosk);

router.post('/mobile/requestCreation', mobile.requestCreation);
router.post('/mobile/approveCreation', mobile.approveCreation);
router.post('/mobile/rejectCreation', mobile.rejectCreation);

router.post('/mobile/requestDeposit', mobile.requestDeposit);
router.post('/mobile/approveDeposit', mobile.approveDeposit);
router.post('/mobile/rejectDeposit', mobile.rejectDeposit);

router.post('/mobile/requestRedeem', mobile.requestRedeem);
router.post('/mobile/approveRedeem', mobile.approveRedeem);
router.post('/mobile/rejectRedeem', mobile.rejectRedeem);

// 🔹 Apply logger to all /kiosk routes handled by this router
router.use('/kiosk', apiLogger);

router.get('/kiosk/getUser', kiosk.getUser);

router.get('/kiosk/getAutoGameList', kiosk.getAutoGameList);
router.post('/kiosk/getAutoGameLists', kiosk.getAutoGameLists);

router.post('/kiosk/getCreationsByGame', kiosk.getCreationsByGame);

router.post('/kiosk/getPendingCreationsByGame', kiosk.getPendingCreationsByGame);
router.post('/kiosk/getDeposits', kiosk.getDeposits);
router.post('/kiosk/getRedeems', kiosk.getRedeems);
router.post('/kiosk/getCashouts', kiosk.getCashouts);
router.post('/kiosk/getUsers', kiosk.getUsers);
router.post('/kiosk/viewUser', kiosk.viewUser);

router.post('/kiosk/deposit', kiosk.deposit);
router.post('/kiosk/redeem', kiosk.redeem);
router.post('/kiosk/creation', kiosk.creation);
router.post('/kiosk/cashout', kiosk.cashout);

router.post('/kiosk/login', kiosk.login);
router.post('/kiosk/resendLoginOTP', kiosk.resendLoginOTP);

router.post('/kiosk/verifyOTP', kiosk.verifyOTP);

router.post('/kiosk/adminLogin', kiosk.adminLogin);
router.get('/kiosk/getAdmin', kiosk.getAdmin);
router.get('/kiosk/getDashboardData', kiosk.getDashboardData);
router.get('/kiosk/getKioskNotes', kiosk.getKioskNotes);
router.post('/kiosk/setKioskNotes', kiosk.setKioskNotes);
router.post('/kiosk/resetKioskNotes', kiosk.resetKioskNotes);

router.get('/kiosk/cashDepositQR', kiosk.cashDepositQR);
router.post('/kiosk/renameKiosk', kiosk.renameKiosk);

router.post('/kiosk/QRLoginResponse', kiosk.QRLoginResponse);
router.post('/kiosk/depositCash', kiosk.depositCash);
router.post('/kiosk/depositDone', kiosk.depositDone);

router.get('/kiosk/cashDepositWebhook', kiosk.cashDepositWebhook);

router.get('/kiosk/sweepLoginQR', kiosk.sweepLoginQR);
router.post('/kiosk/sweepQRLoginResponse', kiosk.sweepQRLoginResponse);
router.post('/kiosk/sweepLoginComplete', kiosk.sweepLoginComplete);
router.get('/kiosk/getF53Cassettes', kiosk.getF53Cassettes);
router.post('/kiosk/setF53Cassettes', kiosk.setF53Cassettes);

router.get('/kiosk/getKiosks', kiosk.getKiosks);
router.post('/kiosk/setKiosk', kiosk.setKiosk);

router.get('/kiosk/getTodayDeposits', kiosk.getTodayDeposits);
router.get('/kiosk/getDayWiseDeposits', kiosk.getDayWiseDeposits);

router.get('/kiosk/getTodayCashouts', kiosk.getTodayCashouts);
router.get('/kiosk/getDayWiseCashouts', kiosk.getDayWiseCashouts);

router.post('/kiosk/cashWithdraw', kiosk.cashWithdraw);

router.post('/kiosk/signup', kiosk.signup)
router.post('/kiosk/resendSignupOTP', kiosk.resendSignupOTP)

router.post('/kiosk/verifySignupOTP', kiosk.verifySignupOTP)
router.post('/kiosk/retryVerify', kiosk.retryVerify)

router.post('/kiosk/checkIdenfyToken', kiosk.checkIdenfyToken)

router.post('/kiosk/idenfyWebhook', kiosk.idenfyWebhook);

router.post('/kiosk/updateIdenfyUser', kiosk.updateIdenfyUser);
router.post('/kiosk/verifyMobiPoll', kiosk.verifyMobiPoll);

router.get('/kiosk/getKioskStatus', kiosk.getKioskStatus);

router.post('/kiosk/updateStackingStats', kiosk.updateStackingStats);
router.post('/kiosk/loadStatsFromDatabase', kiosk.loadStatsFromDatabase);
router.post('/kiosk/getStackingStats', kiosk.getStackingStats);

router.post('/kiosk/getTransactions', kiosk.getTransactions);
router.post('/kiosk/getTransactionsByUser', kiosk.getTransactionsByUser);
router.post('/kiosk/getTransaction', kiosk.getTransaction);

router.post('/kiosk/requestCreation', kiosk.requestCreation);
router.post('/kiosk/approveCreation', kiosk.approveCreation);
router.post('/kiosk/rejectCreation', kiosk.rejectCreation);

router.post('/kiosk/requestDeposit', kiosk.requestDeposit);
router.post('/kiosk/approveDeposit', kiosk.approveDeposit);
router.post('/kiosk/rejectDeposit', kiosk.rejectDeposit);

router.post('/kiosk/requestRedeem', kiosk.requestRedeem);
router.post('/kiosk/approveRedeem', kiosk.approveRedeem);
router.post('/kiosk/rejectRedeem', kiosk.rejectRedeem);
router.post('/kiosk/verifyUser', kiosk.verifyUser);
router.post('/kiosk/banVerify', kiosk.banVerify);
router.post('/kiosk/unbanUser', kiosk.unbanUser);
router.post('/kiosk/addBalance', kiosk.addBalance);
router.post('/kiosk/deductBalance', kiosk.deductBalance);

router.post('/kiosk/generateIdenfyToken', kiosk.generateIdenfyToken);


router.post('/kiosk/remakeCreation', kiosk.remakeCreation);
router.get('/kiosk/receiptQR', kiosk.receiptQR);
router.post('/kiosk/generateReceipt', kiosk.generateReceipt);
router.get('/kiosk/receipt/:id', kiosk.receipt);

const otpLoginLimiter = rateLimit({
    windowMs: 1 * 60 * 1000, // 1 minutes
    max: 5, // Limit each IP to 1 requests per windowMs
    message: 'Too many requests from this IP, please try again later.',
});
// Route to get all admins
// router.get('/admins', authController.getAllAdmins);


module.exports = router;