"use client";

import Image from "next/image";
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Phone, MapPin } from "lucide-react";

import {
    Carousel,
    CarouselContent,
    CarouselItem,
} from "@/components/ui/carousel";

import Autoplay from "embla-carousel-autoplay";

import Header from "@/app/components/layout/header";
import Footer from "@/app/components/layout/footer";

export default function AdoptionDetail() {
    return (
        <div className="min-h-screen flex flex-col bg-[#FFF6ED]">
            {/* Header */}
            <Header />

            <main className="flex-1">
                {/* Breadcrumb */}
                {/* <div className="px-4 py-3 text-sm text-gray-600">
                    Homepage › Listing page ›{" "}
                    <span className="font-medium">Adoption page</span>
                </div> */}
                <br /><br />

                {/* Hero Carousel */}
                <div className="w-full">
                    <Carousel
                        plugins={[
                            Autoplay({
                                delay: 3000, // auto slide every 3s
                            }),
                        ]}
                        className="w-full"
                    >
                        <CarouselContent>
                            {["addopDog.png", "addopDog2.jpg", "addopDog3.jpg"].map(
                                (img, i) => (
                                    <CarouselItem key={i}>
                                        <div className="relative w-full h-[220px] sm:h-[400px] lg:h-[764px]">
                                            <Image
                                                src={`/assets/pngs/${img}`}
                                                alt={`Adoption dog ${i + 1}`}
                                                fill
                                                className="object-cover"
                                                priority={i === 0}
                                            />
                                        </div>
                                    </CarouselItem>
                                )
                            )}
                        </CarouselContent>
                    </Carousel>
                </div>
                <br /><br /><br />
                {/* Info Section */}
                <div className="max-w-7xl mx-auto grid grid-cols-1 md:grid-cols-2 gap-4 px-4 lg:px-20 py-8">
                    {/* Dog Info */}
                    <Card className="shadow-md rounded-2xl">
                        <CardHeader>
                            <CardTitle className="text-xl font-semibold">Jully</CardTitle>
                        </CardHeader>
                        <CardContent className="space-y-3">
                            <p className="text-gray-600">Adult • Female • 3 km away</p>
                            <div>
                                <h4 className="font-medium">About</h4>
                                <p className="text-gray-600 text-sm">
                                    Vaccination up to date, spayed / neutered.
                                </p>
                            </div>
                            <Button className="w-full bg-orange-500 hover:bg-orange-600 text-white rounded-lg">
                                Adopt Now
                            </Button>
                        </CardContent>
                    </Card>

                    {/* Location Info */}
                    <Card className="shadow-md rounded-2xl">
                        <CardHeader>
                            <CardTitle className="text-xl font-semibold">
                                Kohinoor Palace
                            </CardTitle>
                        </CardHeader>
                        <CardContent className="space-y-3">
                            <div className="flex items-center gap-2 text-gray-700">
                                <MapPin className="w-4 h-4" />
                                <span>Kohinoor place, Kurla West, Mumbai</span>
                            </div>
                            <div className="flex items-center gap-2 text-gray-700">
                                <Phone className="w-4 h-4" />
                                <span>9100008912</span>
                            </div>
                            <Button
                                variant="outline"
                                className="w-full border-orange-500 text-orange-500 hover:bg-orange-50 rounded-lg"
                            >
                                More About Us
                            </Button>
                        </CardContent>
                    </Card>

                    <br /><br /><br />
                </div>
            </main>

            {/* Footer */}
            <Footer />
        </div>
    );
}
