"use client";

import Image from "next/image";
import { useState } from "react";
import { Input } from "@/components/ui/input";
import { Select, SelectContent, SelectItem, SelectTrigger, SelectValue } from "@/components/ui/select";
import { Accordion, AccordionContent, AccordionItem, AccordionTrigger } from "@/components/ui/accordion";
import Header from "@/app/components/layout/header";
import Footer from "@/app/components/layout/footer";

const dogs = [
  { id: 1, name: "Jonson", gender: "Male", age: "Puppy", distance: "1.5 km", img: "/assets/pngs/dog2.png" },
  { id: 2, name: "Jully", gender: "Female", age: "Puppy", distance: "3 km", img: "/assets/pngs/dog3.png" },
  { id: 3, name: "Shonty", gender: "Male", age: "Puppy", distance: "5 km", img: "/assets/pngs/blackdog.png" },
  { id: 4, name: "Shonty", gender: "Male", age: "Puppy", distance: "5 km", img: "/assets/pngs/blackdog.png" },
  { id: 5, name: "Jonson", gender: "Male", age: "Puppy", distance: "1.5 km", img: "/assets/pngs/dogAdop1.png" },
  { id: 6, name: "Jully", gender: "Female", age: "Puppy", distance: "3 km", img: "/assets/pngs/dogAdop2.png" },
];


export default function ListingPage() {
  const [search, setSearch] = useState("");

  return (
    <div className="min-h-screen flex flex-col">
      <Header />

      <main className="flex-1 bg-[#FAF6F1]">
        <div className="max-w-7xl mx-auto px-4 md:px-8 py-8">
          {/* Breadcrumb */}
          <p className="text-sm text-gray-500 mb-2">Homepage &gt; Listing page</p>

          {/* Title */}
          <h1 className="text-2xl md:text-3xl font-semibold mb-6">Near By Dog</h1>

          <div className="grid grid-cols-1 md:grid-cols-4 gap-8">
            {/* Sidebar Filters */}
            <aside className="md:col-span-1">
              <h2 className="text-lg font-medium mb-4">FILTER PRODUCT BY</h2>
              <Accordion type="multiple" className="space-y-2">
                <AccordionItem value="location">
                  <AccordionTrigger>LOCATION</AccordionTrigger>
                  <AccordionContent>
                    <Select defaultValue="Nearby">
                      <SelectTrigger className="w-full">
                        <SelectValue placeholder="Nearby" />
                      </SelectTrigger>
                      <SelectContent>
                        <SelectItem value="Nearby">Nearby</SelectItem>
                        <SelectItem value="Far">Far</SelectItem>
                      </SelectContent>
                    </Select>
                  </AccordionContent>
                </AccordionItem>

                <AccordionItem value="breed">
                  <AccordionTrigger>BREED</AccordionTrigger>
                  <AccordionContent>
                    <Select defaultValue="Any">
                      <SelectTrigger className="w-full">
                        <SelectValue placeholder="Any" />
                      </SelectTrigger>
                      <SelectContent>
                        <SelectItem value="Any">Any</SelectItem>
                        <SelectItem value="Labrador">Labrador</SelectItem>
                        <SelectItem value="Beagle">Beagle</SelectItem>
                      </SelectContent>
                    </Select>
                  </AccordionContent>
                </AccordionItem>

                <AccordionItem value="age">
                  <AccordionTrigger>AGE</AccordionTrigger>
                  <AccordionContent>
                    <Select defaultValue="Any">
                      <SelectTrigger className="w-full">
                        <SelectValue placeholder="Any" />
                      </SelectTrigger>
                      <SelectContent>
                        <SelectItem value="Any">Any</SelectItem>
                        <SelectItem value="Puppy">Puppy</SelectItem>
                        <SelectItem value="Adult">Adult</SelectItem>
                      </SelectContent>
                    </Select>
                  </AccordionContent>
                </AccordionItem>

                <AccordionItem value="size">
                  <AccordionTrigger>SIZE</AccordionTrigger>
                  <AccordionContent>
                    <Select defaultValue="Any">
                      <SelectTrigger className="w-full">
                        <SelectValue placeholder="Any" />
                      </SelectTrigger>
                      <SelectContent>
                        <SelectItem value="Any">Any</SelectItem>
                        <SelectItem value="Small">Small</SelectItem>
                        <SelectItem value="Medium">Medium</SelectItem>
                        <SelectItem value="Large">Large</SelectItem>
                      </SelectContent>
                    </Select>
                  </AccordionContent>
                </AccordionItem>

                <AccordionItem value="gender">
                  <AccordionTrigger>GENDER</AccordionTrigger>
                  <AccordionContent>
                    <Select defaultValue="Any">
                      <SelectTrigger className="w-full">
                        <SelectValue placeholder="Any" />
                      </SelectTrigger>
                      <SelectContent>
                        <SelectItem value="Any">Any</SelectItem>
                        <SelectItem value="Male">Male</SelectItem>
                        <SelectItem value="Female">Female</SelectItem>
                      </SelectContent>
                    </Select>
                  </AccordionContent>
                </AccordionItem>
              </Accordion>
            </aside>

            {/* Main Content */}
            <section className="md:col-span-3">
              {/* Search + Sort */}
              <div className="flex flex-col md:flex-row items-center justify-between gap-4 mb-6">
                <Input
                  type="text"
                  placeholder="Search..."
                  value={search}
                  onChange={(e) => setSearch(e.target.value)}
                  className="w-full md:w-1/3"
                />

                <div className="flex items-center gap-2">
                  <span className="text-sm text-gray-600">Sort by:</span>
                  <Select defaultValue="Newest">
                    <SelectTrigger className="w-32">
                      <SelectValue placeholder="Newest" />
                    </SelectTrigger>
                    <SelectContent>
                      <SelectItem value="Newest">Newest</SelectItem>
                      <SelectItem value="Oldest">Oldest</SelectItem>
                    </SelectContent>
                  </Select>
                </div>
              </div>

              {/* Active Filters */}
              <div className="flex flex-wrap items-center gap-2 mb-4 text-sm">
                <span className="text-gray-500">Active Filters:</span>
                <span className="bg-gray-200 px-2 py-1 rounded">Nearby ×</span>
                <span className="bg-gray-200 px-2 py-1 rounded">Any ×</span>
                <span className="bg-gray-200 px-2 py-1 rounded">Any ×</span>
                <span className="bg-gray-200 px-2 py-1 rounded">Any ×</span>
              </div>

              {/* Results Count */}
              <p className="text-sm text-gray-500 mb-4">{dogs.length} Results found.</p>

              {/* Dog Cards */}
              <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
                {dogs.map((dog) => (
                  <div
                    key={dog.id}
                    className="bg-white rounded-xl shadow p-3 flex flex-col items-center"
                  >
                    <Image
                      src={dog.img}
                      alt={dog.name}
                      width={300}
                      height={200}
                      className="rounded-lg object-cover w-full h-[200px]"
                    />
                    <h3 className="mt-3 font-semibold text-lg">{dog.name}</h3>
                    <p className="text-sm text-gray-500">
                      {dog.age} • {dog.gender} • {dog.distance} away
                    </p>
                  </div>
                ))}
              </div>
            </section>
          </div>
        </div>
      </main>

      <Footer />
    </div>
  );
}
