'use client';
import * as React from 'react';
// import Accordion from '@mui/material/Accordion';
import AccordionDetails from '@mui/material/AccordionDetails';
import AccordionSummary from '@mui/material/AccordionSummary';
import Typography from '@mui/material/Typography';
import ExpandMoreIcon from '@mui/icons-material/ExpandMore';
import { Accordion, AccordionContent, AccordionItem, AccordionTrigger } from "@/components/ui/accordion";
import Link from "next/link";
import Image from "next/image";
import HeroDog from "@/public/assets/pngs/herodogs.png";
import Dog1 from "@/public/assets/pngs/blackdog.png";
import Dog2 from "@/public/assets/pngs/dog2.png";
import Dog3 from "@/public/assets/pngs/dog3.png";
import Dog4 from "@/public/assets/pngs/welcomedog.png";
import Adop1 from "@/public/assets/pngs/dogAdop1.png";
import Adop2 from "@/public/assets/pngs/dogAdop2.png";
import Adop3 from "@/public/assets/pngs/dogAdop3.png";
import Poster from "@/public/assets/pngs/posterAdopDog.png";
import faqDog from "@/public/assets/pngs/faqDog.png";
import support1 from "@/public/assets/pngs/support1.png";
import support2 from "@/public/assets/pngs/support2.png";
import support3 from "@/public/assets/pngs/support3.png";

import { Button } from "@mui/material";
import { FaEnvelope, FaMapMarkerAlt, FaPhoneAlt } from "react-icons/fa";
import Footer from "@/app/components/layout/footer";
import Header from "@/app/components/layout/header";

export default function Home() {
  // const [expanded, setExpanded] = React.useState<string | false>(false);
  const [expanded, setExpanded] = React.useState<string | false>("panel1");
  // "panel1" makes it open by default


  const handleChange =
    (panel: string) => (event: React.SyntheticEvent, isExpanded: boolean) => {
      setExpanded(isExpanded ? panel : false);
    };

  return (
    <main >
      <div className="bg-[#FFE5CA] min-h-md" style={{ borderRadius: "0% 0% 10% 10%;" }}>
        {/* NAVBAR */}
        <Header />

        {/* HERO */}
        <section className="max-w-7xl mx-auto grid md:grid-cols-2 gap-22 items-center px-4 pb-16">
          {/* LEFT */}
          <div className="px-2">
            <h1 className="text-5xl font-bold leading-snug text-[#2E1F1C]">
              Join Us in <span className="text-[#FF4B2B]">Giving Strays a Second Chance.</span>
            </h1>
            <p className="mt-4 text-lg text-[#5C4A46] max-w-md">
              Help us turn lonely streets into loving homes through rescue, care & adoption.
            </p>
            <button className="mt-6 bg-[#FF4B2B] text-white px-6 py-3 rounded-lg font-medium shadow hover:bg-[#e34426]">
              Donate Now
            </button>
          </div>

          {/* RIGHT */}
          <div className=" rounded-3xl p-6 flex justify-center">
            <Image
              src={HeroDog}
              alt="Dogs"
              width={600}
              height={600}
              className="rounded-2xl object-cover"
            />
          </div>
        </section>
      </div>
      {/* ABOUT SECTION */}
      <section className="max-w-7xl mx-auto grid md:grid-cols-2 gap-22 items-center px-4 pb-20 mt-[78px]">
        {/* LEFT: IMAGES */}
        <div className="grid grid-cols-2 gap-4">
          <div>

            <Image
              src={Dog1}
              alt="Dog 1"
              width={400}
              height={400}
              className="rounded-2xl object-cover col-span-2 h-[404px]"
            />
          </div>
          <div className="flex flex-col gap-2 max-h-[404px]">
            <Image
              src={Dog2}
              alt="Dog 2"
              width={200}
              height={200}
              className="rounded-2xl object-cover h-full"
            />
            <Image
              src={Dog3}
              alt="Dog 3"
              width={200}
              height={200}
              className="rounded-2xl object-cover h-full"
            />
          </div>
        </div>

        {/* RIGHT: TEXT */}
        <div className="bg-[#FFEEDB] p-8 rounded-3xl min-h-[404] flex flex-col gap-6">
          <p className="text-[#FF4B2B] font-medium uppercase md:text-[16px] text-sm">About Us</p>
          <h2 className="text-3xl font-bold text-[#2E1F1C] leading-snug ">
            We Stand for the Strays Because They Can’t Stand Alone
          </h2>
          <p className=" font-light text-[#666666] leading-relaxed text-[18px]">
            We are a group of passionate animal lovers committed to making the world safer for
            stray and abandoned dogs. Every day, we work to rescue those in need, provide medical
            care, food, and shelter, and help them find the loving homes they deserve.
            With every life we save, we make one step closer to a world where no dog is left behind.
          </p>
        </div>
      </section>

      <section className="max-w-7xl mx-auto grid md:grid-cols-2 gap-22 items-center px-4 pb-20 mt-[78px]">
        {/* LEFT: IMAGES */}


        {/* RIGHT: TEXT */}
        <div className=" p-8 rounded-3xl min-h-[404] flex flex-col gap-6">
          <p className="text-[#FF4B2B] font-medium uppercase md:text-[16px] text-sm">Welcome to </p>
          <h2 className="text-3xl font-bold text-[#2E1F1C] leading-snug ">
            Animal Rescue and care
          </h2>
          <p className=" font-light text-[#666666] leading-relaxed text-[18px]">
            We are a group of passionate animal lover committed to making the world safer for stray and abandoned dogs. Every day, we work to rescue those in need, provide medical care, food, and shelter, and help them find the loving homes they deserve.With every life we save, we move one step closer to a world where no dog is left behind. We are a group of passionate animal lover committed to making the world safer for stray and abandoned dogs.
          </p>
        </div>
        <div className="grid grid-cols-2 gap-4">

          <Image
            src={Dog4}
            alt="Dog 1"
            width={575}
            height={404}
            className="rounded-2xl object-cover col-span-2 h-[404px]"
          />
        </div>
      </section>

      <section className="max-w-7xl mx-auto gap-22 items-center px-4 pb-20 mt-[78px]">
        <p className="text-[#F05A33] text-center text-[48px] font-semibold ">Pets Available for adoption Nearby</p>
        <div className="flex md:flex-row flex-col justify-center my-6">
          <Image
            src={Adop1}
            alt="Dogs"
            width={384}
            height={447}
            className="rounded-2xl object-cover"
          />
          <Image
            src={Adop2}
            alt="Dogs"
            width={384}
            height={447}
            className="rounded-2xl object-cover p-4"
          />
          <Image
            src={Adop3}
            alt="Dogs"
            width={384}
            height={447}
            className="rounded-2xl object-cover p-4"
          />
        </div>
        <div className='flex justify-center'>

          <Link href="/nearbyDogs" className="text-[#F05A33] text-[24px] font-semibold text-center"> See more</Link>
        </div>
      </section>

      <section>
        <Image
          src={Poster}
          alt="Dogs"
          width={1440}
          height={521}
          className=" object-cover w-full h-max"
        />
      </section>

      <section className="max-w-7xl mx-auto px-4 md:px-8 pb-20 mt-[78px]">
        {/* Title */}
        <p className="text-[#F05A33] text-[32px] md:text-[48px] font-semibold text-center mb-10">
          What we do
        </p>

        {/* Grid Layout */}
        <div className="grid grid-cols-1 md:grid-cols-2 gap-10 items-center">
          {/* Accordion */}
          <div className="space-y-4">
            <Accordion type="single" collapsible className="w-full"
              defaultValue="item-1"
            >
              <AccordionItem value="item-1">
                <AccordionTrigger className='text-[24px] font-[500]' >Mass sterilization</AccordionTrigger>
                <AccordionContent className='text-[18px] font-[300]'>
                  We are a group of passionate animal lover committed to making the world safer for stray and abandoned dogs.
                  Every day, we work to rescue those in need, provide medical care, food, and shelter, and help them find the loving
                  homes they deserve. We are a group of passionate animal lover committed to making the world safer for stray and abandoned dogs.
                  Every day, we work to rescue those in need, provide medical care, food, and shelter, and help them find the loving homes they deserve.
                </AccordionContent>
              </AccordionItem>

              <AccordionItem value="item-2">
                <AccordionTrigger className='text-[24px] font-[500]'>Rabies vaccination</AccordionTrigger>
                <AccordionContent className='text-[18px] font-[300]'>
                  Timely rabies vaccinations are essential to protect both animals and humans.
                  Our team organizes free vaccination drives to ensure stray dogs remain safe and healthy.
                </AccordionContent>
              </AccordionItem>

              <AccordionItem value="item-3">
                <AccordionTrigger className='text-[24px] font-[500]'>Rescue & Rehabilitation</AccordionTrigger>
                <AccordionContent className='text-[18px] font-[300]'>
                  Injured, abandoned, or abused dogs are rescued and provided with medical treatment, shelter, and
                  emotional care until they are ready for adoption.
                </AccordionContent>
              </AccordionItem>

              <AccordionItem value="item-4">
                <AccordionTrigger className='text-[24px] font-[500]'>Adoption Programs</AccordionTrigger>
                <AccordionContent className='text-[18px] font-[300]'>
                  We connect rescued dogs with loving families through adoption camps and community outreach,
                  ensuring every dog finds a permanent home.
                </AccordionContent>
              </AccordionItem>

              <AccordionItem value="item-5">
                <AccordionTrigger className='text-[24px] font-[500]'>Awareness Campaigns</AccordionTrigger>
                <AccordionContent className='text-[18px] font-[300]'>
                  Educating communities about responsible pet ownership, animal rights, and compassionate treatment
                  helps reduce cruelty and abandonment.
                </AccordionContent>
              </AccordionItem>
            </Accordion>
          </div>

          {/* Image */}
          <div className="flex justify-center">
            <Image
              src={faqDog}
              alt="Dogs"
              width={490}
              height={576}
              className="rounded-3xl object-cover w-full max-w-md"
            />
          </div>
        </div>
      </section>

      <section className="max-w-7xl mx-auto gap-22 items-center px-4 pb-20 mt-[78px]">
        <p className="text-[#F05A33] text-[48px] font-semibold text-center">Support Us</p>
        <div className="flex md:flex-row flex-col justify-center my-6">
          <Image
            src={support1}
            alt="Dogs"
            width={384}
            height={447}
            className="rounded-2xl object-cover p-3"
          />
          <Image
            src={support2}
            alt="Dogs"
            width={384}
            height={447}
            className="rounded-2xl object-cover p-3"
          />
          <Image
            src={support3}
            alt="Dogs"
            width={384}
            height={447}
            className="rounded-2xl object-cover p-3"
          />
        </div>
      </section>

      <section className="max-w-7xl mx-auto gap-22 items-center px-4 pb-20 mt-[78px]">
        <div style={{ position: "relative", paddingBottom: "56.25%", height: 0 }}>
          <iframe
            src="https://www.youtube.com/embed/oW_IqB4UgYg?start=35"
            title="YouTube video"
            frameBorder="0"
            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
            allowFullScreen
            style={{
              position: "absolute",
              top: 0,
              left: 0,
              width: "100%",
              height: "100%",
              borderRadius: "8px",
            }}
          ></iframe>
        </div>
      </section>

      <section className="max-w-7xl mx-auto gap-22 items-center px-4 pb-20 mt-[78px]">


        <section className="bg-[#F15A29] rounded-[40px] py-16 px-6 text-center text-white">
          <h2 className="text-4xl md:text-5xl font-extrabold mb-6">
            DONATE TO SAVE A LIFE
          </h2>
          <p className="max-w-4xl mx-auto text-lg md:text-xl leading-relaxed mb-8">
            We Are A Group Of Passionate Animal Lover Committed To Making The World
            Safer For Stray And Abandoned Dogs. Every Day, We Work To Rescue Those
            In Need, Provide Medical Care, Food, And Shelter, And Help Them Find
            The Loving Homes They Deserve.
          </p>
          <button className="bg-white text-[#F15A29] font-bold py-3 px-8 rounded-full text-lg shadow hover:scale-105 transition-transform">
            Donate Now
          </button>
        </section>
      </section>

      <section className="max-w-7xl mx-auto gap-22 items-center px-4 pb-20 mt-[78px]">
        <section className="bg-white rounded-[40px] py-12 px-6 md:px-12">
          <div className="grid md:grid-cols-2 gap-12 items-start">

            {/* Left Side - Contact Info */}
            <div>
              <h2 className="text-3xl md:text-4xl font-bold mb-3 text-black">
                Get In Touch With Us
              </h2>
              <p className="text-gray-500 mb-8">
                We’d Love To Hear From You!
              </p>

              <div className="flex items-center mb-6">
                <FaEnvelope className="text-[#F15A29] text-xl mr-3" />
                <span className='text-gray-700'>example@teampetcare.com</span>
              </div>

              <div className="flex items-center mb-6">
                <FaMapMarkerAlt className="text-[#F15A29] text-xl mr-3" />
                <span className='text-gray-700'>
                  226 Example Street, Near By Example Building, Maharashtra, India.
                </span>
              </div>

              <div className="flex items-center">
                <FaPhoneAlt className="text-[#F15A29] text-xl mr-3" />
                <span className='text-gray-700'>+91 00000 00000</span>
              </div>
            </div>

            {/* Right Side - Contact Form */}
            <form className="space-y-4">
              <input
                type="text"
                placeholder="Name"
                className="w-full border border-gray-300 rounded-lg px-4 py-3 text-gray-900 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-[#F15A29]"
              />
              <input
                type="email"
                placeholder="Email"
                className="w-full border border-gray-300 rounded-lg px-4 py-3 text-gray-900 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-[#F15A29]"
              />
              <input
                type="text"
                placeholder="Website"
                className="w-full border border-gray-300 rounded-lg px-4 py-3 text-gray-900 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-[#F15A29]"
              />
              <textarea
                placeholder="Message"
                rows={4}
                className="w-full border border-gray-300 rounded-lg px-4 py-3 text-gray-900 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-[#F15A29]"
              ></textarea>
              <button
                type="submit"
                className="bg-[#F15A29] text-white font-semibold px-8 py-3 rounded-lg hover:scale-105 transition-transform"
              >
                Submit
              </button>
            </form>

          </div>
        </section>
      </section>

      <Footer />
    </main>
  );
}
